package com.sap.caf.km.ejb.svc.idxsearch.common;

import java.util.Date;

/**
 * TODO There are hardcoded constants for special folders. The
 * special folders names should be got from "SpecialFolder" class
 * but it present only on KM side.
 * 
 * The class presents KM taxonomy information
 */
public interface ITaxonomy extends IClassifyFolder {


	/** 
	 * The method returns the complete KM path to the special folder 
	 * like /taxonomy/indexID/taxName/<special folder name>.
	 * You can use <i>IKMTaxonomy</i> class constants as names 
	 * of special folder.
	 * 
	 * @param specialFolder The name of special folder
	 * @return The complete KM path to the special folder 
	 */
	public String getSpecialFolderRID(int folderType);
	
	public void setSpecialFolderRID(int folderType, String folderRid);
	 
	public static final int FOLDER_TO_CLASSIFY = 0;
	public static final	int FOLDER_NEVER_TO_CLASSIFY = 1;
	
}
