package com.sap.caf.km.ejb.svc.idxsearch.common;

/**
 * This class provides KM search functionality for CAF side. 
 *
 * @version 1.0
 * @author joerg.schleiwies@sap.com
 * @author viachaslau_kudzinau@epam.com 
 * @author aliaksandr_pranko@epam.com
 */
public interface IIndexSearchSearchSvc {
			
	/**
	 * The method performs search for documents or tasks in the global index and
	 * returns a result array containing RID´s of tasks or documents.
	 * The differentiation between task and document has to be done before hand on KM side.
	 * 
	 * @param queryEntryArray		The array of search entries, defining the search properties and values
	 * @param indexIdArray			The array of indexes's RIDs for search
	 * @param maxResults			Maximum number of search results  
	 * @return						The array of search result objects
	 * @throws SearchException 
	 */
	public ISearchResult[] searchForGlobalResource(ISearchEntry[] queryEntryArray, String[] indexIdArray, int maxResults) throws SearchException;
	
	/**
	 * The method performs search for documents or tasks in the global index and
	 * returns a result array containing RID´s of tasks or documents.
	 * The differentiation between task and document has to be done before hand on KM side. 
	 * 
	 * @param queryEntryArray		The array of search entries
	 * @param indexIdArray			The array of indexes's RIDs for search
	 * @param searchStartFolders	The starting point of search. Search will be carried out
	 * 								only in children of this collection.
	 * @param maxResults			Maximum number of search results 
	 * @return						The array of search result objects
	 * @throws SearchException
	 */
	public ISearchResult[] searchForGlobalResource(ISearchEntry[] queryEntryArray, String[] indexIdArray, String searchStartFolder, int maxResults) throws SearchException;
	
	/**
	 * The method performs search for BO in one or more indexes
	 * and returns a result array containing RID´s of BO´s
	 * 
	 * @param queryEntryArray		The collection of search query entries
	 * @param indexIdArray			The array of indexes's RIDs for search
	 * @param maxResults			Maximum number of search results  
	 * @return						The array of search result objects
	 */
	public ISearchResult[] searchForBO(ISearchEntry[] queryEntryArray, String[] indexIdArray, int maxResults) throws SearchException;

	/**
	 * The method performs search for similar resources depends on the “root-resource” 
	 * and returns a result collection containing RIDs of similar resources 
	 * 
	 * @param resourceRid	The resource for which the similar resources should be searched
	 * @param indexIdArray	The array of indexes's RIDs for search
	 * @param maxResults			Maximum number of search results 
	 * @return				The array of resources' RIDs
	 */
	public ISearchResult[] searchForSimilar(String resourceRid, String[] indexIdArray, int maxResults) throws SearchException;


	/**
	 * The method performs search in index created for BO related resources.
	 * The method has been added for sepration of logic on methods level.
	 * 
	 * @param queryEntryArray		The collection of search query entries
	 * @param indexIdArray			The array of indexes's RIDs for search 
	 * @param resultType				The type of resource for search. The valid values is:
	 * 													<code>IKMIndexSearchSearchSvc.SEARCH_RESULT_TASK, 
	 * 													IKMIndexSearchSearchSvc.SEARCH_RESULT_DOCUMENT, 
	 * 													IKMIndexSearchSearchSvc.SEARCH_RESULT_CAFBO, IKMIndexSearchSearchSvc.SEARCH_RESULT_UNDEFINED</code>		
	 * @param maxResults			Maximum number of search results
	 * @return						The array of search result objects
	 * @throws SearchException
	 */
	public ISearchResult[] searchForRelatedResource(ISearchEntry[] queryEntryArray, String[] indexIdArray, int resultType, int maxResults) throws SearchException;
		

	/**
	 * The method look for the free text in all attributes and in the content of the documents 
	 * in the related index the relations are checked from the found documents, which links to the certain BO
	 * these BO instances are returned
	 * 
	 * @param queryEntryArray		The collection of search query entries
	 * @param indexIdArray			The array of indexes's RIDs for search 
	 * @param maxResults			Maximum number of search results
	 * @return						The array of search result objects
	 * @throws SearchException
	 */
	public ISearchResult[] searchForBOInRelatedIndex(ISearchEntry[] queryEntryArray, String[] indexIdArray, int maxResults) throws SearchException;

	
	public static final int SEARCH_RESULT_TASK = ISearchResult.TYPE_TASK;
	public static final int SEARCH_RESULT_DOCUMENT = ISearchResult.TYPE_DOCUMENT;
	public static final int SEARCH_RESULT_CAFBO = ISearchResult.TYPE_CAF_BO;
	public static final int SEARCH_RESULT_UNDEFINED	= ISearchResult.TYPE_UNDEFINED;
}