package com.sap.caf.km.ejb.svc.idxsearch.common;

import java.util.Date;

/**
 * The class represent KM classification folder. 
 * 
 * @see com.sap.caf.km.idxsearch.IKMCategory
 * @see com.sap.caf.km.idxsearch.IKMTaxonomy
 * @author viachaslau_kudzinau@epam.com
 */
public interface IClassifyFolder {

	/**
	 * The method set up the folder name.
	 * 
	 * @return
	 */
	public void setName(String name);
	
	/**
	 * The method gets the folder name.
	 * 
	 * @see #setName(java.lang.String)
	 * @return		The folder name
	 */
	public String getName();

	/**
	 * The method set up the folder RID
	 * 
	 * @param rid
	 */
	public void setRID(String rid);
	
	/**
	 * The method gets the folder RID
	 *
	 * @see #setRID(java.lang.String) 
	 * @return
	 */
	public String getRID();

	/**
	 * The method set up the creation date.
	 * 
	 * @param date		The creation date
	 */
	public void setCreationDate(Date date);
	
	/**
	 * The method gets the folder creation date
	 * 
	 * @see #setCreationDate(java.util.Date)
	 * @return		The folder creation date
	 */
	public Date getCreationDate();

	/**
	 * The method gets the parent index Id.
	 * 
	 * @return		The parent index id.
	 */
	public String getIndexId();

	public static final char NAME_DELIMETER = '/'; 
}
