package com.sap.caf.km.ejb.svc.idxsearch.common;

/**
 * The class presents KM classification category.
 */
public interface ICategory extends IClassifyFolder {
		
	/**
	 * The method returns a category path. 
	 * The path includes: "taxonomy_name\...parent categories...\category_name"
	 * 
	 * @return The category path.
	 */
	public String getCategoryPath();

	/**
	 * The method returns the KM category description.
	 *  
	 * @return		The category description.
	 */ 
	public String getDescription();
	
	/**
	 * The method set up the KM category description.
	 *  
	 * @param descr		The category description.
	 */ 	
	public void setDescription(String descr);
	
	/**
	 * The method returns parent taxonomy name.
	 * 
	 * @return		The parent taxonomy name
	 */
	public String getTaxonomyName();
	
	/**
	 * The method set up the parent taxonomy name
	 *
	 * @param taxonomyName		The parent taxonomy name.
	 */
	public void setTaxonomyName(String taxonomyName);
}
