package com.sap.caf.km.ejb.svc.idxsearch.common;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.ArrayList;

/**
 * The class represent KM classification folder 
 * 
 * @see com.sap.caf.km.idxsearch.IKMCategory
 * @see com.sap.caf.km.idxsearch.IKMTaxonomy
 * @author viachaslau_kudzinau@epam.com
 */
public class ClassifyFolder implements IClassifyFolder, Serializable {

	public ClassifyFolder() {
	}

	/**
	 * @param name	The classification folder name
	 * @param created	The creation date
	 */
	public ClassifyFolder(String name, Date created) {
		m_sName = name;
		m_dCreated = created;
	}
	
	/**  
	 * @param sRid	 The classification folder RID
	 */
	public ClassifyFolder(String sRid) {
		setRID(sRid);
	}	

	/** 
	 * @see com.sap.caf.km.idxsearch.IKMClassifyFolder#getName()
	 */
	public String getName() {
		if (m_sName == null && m_folderPath!=null && m_folderPath.size()>TAXONOMY_NAME_POSITION) {
			m_sName = (String)m_folderPath.get(m_folderPath.size()-1);
		}
		return m_sName;
	}

	/** @see com.sap.caf.km.idxsearch.IKMClassifyFolder#setName(java.lang.String)
	 */
	public void setName(String name) {
		m_sName = name;
	}

	/** @see com.sap.caf.km.idxsearch.IKMClassifyFolder#getRID()
	 */
	public String getRID() {
		return m_sRID;
	}

	/** @see com.sap.caf.km.idxsearch.IKMClassifyFolder#setRID(java.lang.String)
	 */
	public void setRID(String sRid) {
		m_sRID = sRid;
		m_folderPath = split(sRid, NAME_DELIMETER);
	}

	/** 
	 * @see com.sap.caf.km.idxsearch.IKMClassifyFolder#getCreationDate()
	 */
	public Date getCreationDate() {
		return m_dCreated;
	}

	/** 
	 * @see com.sap.caf.km.idxsearch.IKMClassifyFolder#setCreationDate(java.util.Date)
	 */
	public void setCreationDate(Date date) {
		m_dCreated = date;
	}

	/** 
	 * @see com.sap.caf.km.idxsearch.IKMClassifyFolder#getIndexId()
	 */	
	public String getIndexId() {
		if (m_folderPath!=null && m_folderPath.size()>INDEX_ID_POSITION) {
				return (String)m_folderPath.get(INDEX_ID_POSITION); 
		}
		return null;
	}

	/**
	 * The method splits string using specified separator
	 * 
	 * @param path	The category path
	 * @return	The splited category path
	 */
	public static List split(String path, char separator) {
			if (path==null || path.length() == 0) {
				  return null;
			} 
	  
			int length = path.length();
			List words = new ArrayList();

			int i = (path.charAt(0) == separator) ? 1 : 0;
			int last = i;
			for (; i < length; ++i) {
				  if (path.charAt(i) == separator) {
					  words.add(path.substring(last, i));
					last = i+1;
				  }
			}

			if (last < i) {
				words.add(path.substring(last));
			}
			return words;	
	}

	protected String m_sName;
	protected String m_sDescr;
	protected String m_sRID;
	protected Date m_dCreated;
	
	protected List m_folderPath;
	
	protected static int INDEX_ID_POSITION = 1;
	protected static int TAXONOMY_NAME_POSITION = 2; 
	protected static int REPOSITORY_PREFIX_POSITION = 0;
}
