package com.sap.caf.km.ejb.svc.idxsearch.common;

import java.util.Date;
import java.io.Serializable;

/**
 * The class presents KM classification category.
 * 
 * @author viachaslau_kudzinau@epam.com
 */
public class Category extends ClassifyFolder implements ICategory, Serializable {
	
	public Category() {
		super();
	}

	/** 
	 * @param name		The category name
	 * @param descr		The category description
	 * @param created	The category creation date
	 */
	public Category(String name, String descr, Date created) {
		super(name, created);
		m_sDescr = descr;
	}
	
	/**
	 * The category name, category path, parent index id and taxonomy name 
	 * will be extracted from category RID. 
	 *  
	 * @param rid	The category RID
	 */
	public Category(String rid) {
		super(rid);
	}	

	/** 
	 * @see com.sap.caf.km.idxsearch.IKMCategory#getDescription()
	 */
	public String getDescription() {
		return m_sDescr;
	}

	/** 
	 * @see com.sap.caf.km.idxsearch.IKMCategory#setDescription(java.lang.String)
	 */
	public void setDescription(String descr) {
		m_sDescr = descr;
	}
	
	/**
	 * @see com.sap.caf.km.idxsearch.IKMCategory#setTaxonomyName(java.lang.String) 
	 */
	public void setTaxonomyName(String taxonomyName) {
		m_sTaxonomyName = taxonomyName;
	}

	/**
	 * @see com.sap.caf.km.idxsearch.IKMCategory#getTaxonomyName() 
	 */
	public String getTaxonomyName() {
		if (m_sTaxonomyName==null 
			&& m_folderPath!=null
			&& m_folderPath.size()>INDEX_ID_POSITION) {
				m_sTaxonomyName = (String)m_folderPath.get(TAXONOMY_NAME_POSITION);
		}
		return m_sTaxonomyName;
	}
	

	/** 
	 * @see com.sap.caf.km.idxsearch.IKMCategory#getCategoryPath()
	 */
	public String getCategoryPath() {
		if (m_sPath==null 
			&& m_folderPath!=null
			&& m_folderPath.size()>TAXONOMY_NAME_POSITION) {
				StringBuffer sb = new StringBuffer(64);
				for (int i=2; i<m_folderPath.size()-1; i++) {
					sb.append(NAME_DELIMETER).append(m_folderPath.get(i));
				}
				m_sPath = sb.toString();
		}
		return m_sPath;
	}
	
	/** 
	 * The method set up the category path. 
	 * @see com.sap.caf.km.idxsearch.IKMCategory#getCategoryPath()
	 * 
	 * @param path		The category path 
	 */
	public void setCategoryPath(String path) {
		m_sPath = path; 
	}
	
	protected String m_sDescr;
	protected String m_sTaxonomyName;
	protected String m_sPath;
}
