/*
 * Created on Jul 28, 2003
 *
 */
package com.sap.caf.km.ejb.svc.idxsearch.classify;

import com.sap.caf.km.ejb.svc.idxsearch.common.IIndexSearchClassifySvc;
import com.sap.caf.km.ejb.svc.idxsearch.kmproxy.KMIndexSearchSvcProxyFactory;
import com.sap.caf.km.ejb.svc.idxsearch.util.ConfigException;
import com.sap.caf.km.ejb.svc.idxsearch.util.ConfigProps;
import com.sap.caf.km.ejb.svc.idxsearch.util.IConfigProps;

/**
 * @author viachaslau_kudzinau@epam.com
 */
public class KMIndexSearchClassifySvcFactory extends KMIndexSearchSvcProxyFactory
	implements IKMIndexSearchClassifySvcFactory {

	protected KMIndexSearchClassifySvcFactory(ConfigProps props) {
		super(props);
	}

	public static IKMIndexSearchClassifySvcFactory getInstance() throws ConfigException {
		return new KMIndexSearchClassifySvcFactory(ConfigProps.getInstance());
	}
	
	/** @see com.sap.caf.km.ejb.svc.idxsearch.classify.IKMIndexSearchClassifySvcFactory#getService()
	 */
	public IIndexSearchClassifySvc getClassifyService() throws ConfigException {
		return (IIndexSearchClassifySvc)getService();
	}

	protected String getLookupName() throws ConfigException {
		return m_props.getNotNullProperty(IConfigProps.SERVICE_LOOKUP_NAME);
	}

	protected String getServiceClass() throws ConfigException {
		return m_props.getNotNullProperty(IConfigProps.SERVICE_CLASS_CLASSIFY);
	}

}
