/*
 * Created on Jul 28, 2003
 *
 */
package com.sap.caf.km.ejb.svc.idxsearch.classify;

import com.sap.caf.km.ejb.svc.idxsearch.common.ClassifyException;
import com.sap.caf.km.ejb.svc.idxsearch.common.ICategory;
import com.sap.caf.km.ejb.svc.idxsearch.common.IIndexSearchClassifySvc;
import com.sap.caf.km.ejb.svc.idxsearch.common.IIndexSearchResourceKeys;
import com.sap.caf.km.ejb.svc.idxsearch.common.ITaxonomy;
import com.sap.caf.km.ejb.svc.idxsearch.common.IndexSearchException;
import com.sap.caf.km.ejb.svc.idxsearch.kmproxy.KMIndexSearchSvcProxy;
 
/**
 * @author viachaslau_kudzinau@epam.com
 */
public class KMIndexSearchClassifySvc extends KMIndexSearchSvcProxy implements IIndexSearchClassifySvc, IIndexSearchResourceKeys {

	public KMIndexSearchClassifySvc() throws IndexSearchException {
		super();
	}
	
	/** @see com.sap.caf.km.idxsearch.IKMIndexSearchClassifySvc#addTaxonomy(java.lang.String, java.lang.String)
	 */
	public void addTaxonomy(String indexID, String taxName) throws ClassifyException {
		try {
			m_port.addTaxonomy(indexID, taxName);
		} catch (Exception e) {
			throw new ClassifyException(ERR_CAT_TAXONOMY_ASSIGN, e);
		}
	}

	/** @see com.sap.caf.km.idxsearch.IKMIndexSearchClassifySvc#removeTaxonomy(java.lang.String, java.lang.String)
	 */
	public void removeTaxonomy(String indexID, String taxName) throws ClassifyException {
		try {
			m_port.removeTaxonomy(indexID, taxName);
		} catch (Exception e) {
			throw new ClassifyException(ERR_CAT_TAXONOMY_UNASSIGN,  e);
		}
	}

	/** @see com.sap.caf.km.idxsearch.IKMIndexSearchClassifySvc#classifyResources(java.lang.String[], java.lang.String)
	 */
	public void classifyResources(String[] resourceRIDList, String categoryRID) throws ClassifyException {
		try {
			m_port.classifyResources(resourceRIDList, categoryRID);
		} catch (Exception e) {
			throw new ClassifyException(ERR_CAT_CLASSIFY_MANY,  e);
		}
	}

	/** @see com.sap.caf.km.idxsearch.IKMIndexSearchClassifySvc#classifyResource(java.lang.String, java.lang.String)
	 */
	public void classifyResource(String resourceRID, String categoryRID) throws ClassifyException {
		try {
			m_port.classifyResource(resourceRID, categoryRID); 
		} catch (Exception e) {
			throw new ClassifyException(ERR_CAT_CLASSIFY,  e);
		}		
	}

	/** @see com.sap.caf.km.idxsearch.IKMIndexSearchClassifySvc#classifyResource(java.lang.String, java.lang.String[])
	 */
	public void classifyResource(String resourceRID, String[] categoryRIDList) throws ClassifyException {
		try {
			m_port.classifyResource(resourceRID, categoryRIDList);
		} catch (Exception e) {
			throw new ClassifyException(ERR_CAT_CLASSIFY,  e);
		}
	}
	
	public void createCategories (String[] categoryRIDList) throws ClassifyException {
		try {
			m_port.createCategories(categoryRIDList);
		} catch (Exception e) {
			throw new ClassifyException(ERR_CAT_CREATE_MANY,  e);
		}
	}

	public void deleteCategories (String[] categoryRIDList) throws ClassifyException {
		try {
			m_port.deleteCategories(categoryRIDList);
		} catch (Exception e) {
			throw new ClassifyException(ERR_CAT_DELETE_MANY,  e);
		}
	}
	
	public void setCategoryDescription(String newDescription, String[] categoryRIDList) throws ClassifyException {
	try {
		m_port.setCategoryDescription(newDescription, categoryRIDList);
	} catch (Exception e) {
		throw new ClassifyException(ERR_CAT_UPDATE_MANY,  e);
	}
	}
	
	public String[] getChildren(String categoryRid, boolean includeOnlyFolders) throws ClassifyException {
		try {
			return m_port.getChildren(categoryRid, includeOnlyFolders);
		} catch (Exception e) {
			throw new ClassifyException(ERR_CAT_GET_CHIDREN,  e);
		}
	}

	public boolean hasChildren(String categoryRid) throws ClassifyException {
		try {
			return m_port.hasChildren(categoryRid);
		} catch (Exception e) {
			throw new ClassifyException(ERR_CAT_CHECK_CHIDREN,  e);
		}
	}


	/** @see com.sap.caf.km.idxsearch.IKMIndexSearchClassifySvc#getTaxonomyRepositoryPrefix()
	 */
	public String getTaxonomyRepositoryPrefix() throws ClassifyException {
		try {
		return m_port.getTaxonomyRepositoryPrefix();
		} catch (Exception e) {
			throw new ClassifyException(ERR_CAT_TAXONOMY_PREFIX,  e);
		}
	}

	/* (non-Javadoc)
	 * @see com.sap.caf.km.idxsearch.IKMIndexSearchClassifySvc#removeFromCategories(java.lang.String[], java.lang.String)
	 */
	public void removeFromCategories(String[] categoryRIDList, String resourceRID) throws ClassifyException {
		// TODO Auto-generated method stub
		
	}

	/* (non-Javadoc)
	 * @see com.sap.caf.km.idxsearch.IKMIndexSearchClassifySvc#getObjectClassification(java.lang.String, java.lang.String)
	 */
	public ICategory[] getObjectClassification(String taxName, String resourceRID) throws ClassifyException {
		// TODO Auto-generated method stub
		return null;
	}

	/* (non-Javadoc)
	 * @see com.sap.caf.km.idxsearch.IKMIndexSearchClassifySvc#getObjectClassification(java.lang.String)
	 */
	public ICategory[] getObjectClassification(String resourceRID) throws ClassifyException {
		// TODO Auto-generated method stub
		return null;
	}

	/* (non-Javadoc)
	 * @see com.sap.caf.km.idxsearch.IKMIndexSearchClassifySvc#getSpecialFolderName(int)
	 */
	public String getSpecialFolderName(int folderId) throws ClassifyException {
		// TODO Auto-generated method stub
		return null;
	}

	/* (non-Javadoc)
	 * @see com.sap.caf.km.idxsearch.IKMIndexSearchClassifySvc#getObjectTaxonomy(java.lang.String)
	 */
	public ITaxonomy[] getObjectTaxonomy(String resourceRid) throws ClassifyException {
		try {
			//return m_port.getObjectTaxonomy(resourceRid);
			return null;
		} catch (Exception e) {
			throw new ClassifyException(ERR_CAT_CLASSIFY,  e);
		}		
	} 
	
	public String[] getUnclassifiedObjects(String taxonomyRID) throws ClassifyException {
		try {
			return m_port.getUnclassifiedObjects(taxonomyRID);
		} catch (Exception e) {
			throw new ClassifyException(ERR_CAT_GET_UNCLASSIFIED,  e);
		}		
	}

}
