/*
 * Created on Jul 30, 2003
 *
 */
package com.sap.caf.km.ejb.svc.idxsearch.classify;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;


import com.sap.caf.km.ejb.svc.idxsearch.bo.BODbHelper;
import com.sap.caf.km.ejb.svc.idxsearch.util.ConnectionManager;
import com.sap.caf.km.ejb.svc.idxsearch.util.IDbConst;
import com.sap.caf.rt.metamodel.MetaModel;


/**
 * @author viachaslau_kudzinau@epam.com
 */
public class KMClassifyHelper extends BODbHelper {
	public KMClassifyHelper(ConnectionManager manager) {
		super(manager);
	}

	// - Category methods --- //
	/**
	 * Assigns category to business object.
	 * @param catGUID The category GUID
	 * @param BOName	The business object name
	 * @throws SQLException
	 */
	public void assignCategory(Collection catGUIDs, String BOName) throws SQLException {
		Connection conn = m_manager.getConnection();
		try {
			BigDecimal boId = getBusinessObjectId(conn, BOName);
			String catGUID;
			BigDecimal catId;
			for (Iterator i = catGUIDs.iterator(); i.hasNext();) {
				catGUID = (String) i.next();
				PreparedStatement pstmt = conn.prepareStatement(IDbConst.BO_CAT_INSERT);
				try {
					pstmt.setBigDecimal(1, boId);
					pstmt.setString(2, catGUID);
					pstmt.execute();
				}
				finally {
					pstmt.close();
				}
			}
		}
		catch (SQLException e) {
			throw e;
		}
		finally {
			conn.close();
		}
	}

	public void deassignCategory(Collection catGUIDs, String BOName) throws SQLException {
		Connection conn = m_manager.getConnection();
		try {
			String catGUID;
			for (Iterator i = catGUIDs.iterator(); i.hasNext();) {
				catGUID = (String) i.next();
				deassignCategory(conn, catGUID, BOName);
				deleteCategory(conn, catGUID, BOName);
				deleteBusinessObject(conn, BOName);
			}
		}
		catch (SQLException e) {
			throw e;
		}
		finally {
			conn.close();
		}
	}

	public void deassignCategory(String catGUID) throws SQLException {
		Connection conn = m_manager.getConnection();
		try {
			deassignCategory(conn, catGUID);
			deleteCategory(conn, catGUID);
			deleteBusinessObjects(conn);
		}
		catch (SQLException e) {
			throw e;
		}
		finally {
			conn.close();
		}
	}

	protected void deassignCategory(Connection conn, String catGUID) throws SQLException {
		PreparedStatement pstmt = conn.prepareStatement(IDbConst.BO_CAT_DELETE_BY_ALL_BO);
		try {
			pstmt.setString(1, catGUID);
			pstmt.execute();
		}
		finally {
			pstmt.close();
		}
	}

	protected void deassignCategory(Connection conn, String catGUID, String BOName) throws SQLException {
		PreparedStatement pstmt = conn.prepareStatement(IDbConst.BO_CAT_DELETE);
		try {
			pstmt.setString(1, BOName);
			pstmt.setString(2, catGUID);
			pstmt.execute();
		}
		finally {
			pstmt.close();
		}
	}

	protected void deleteCategory(Connection conn, String catGUID, String BOName) throws SQLException {
		try {
			String sBoGuidsFilter = getBOGuidsByBONameSQL(BOName);
			if (sBoGuidsFilter == null) {
				return;
			}
			PreparedStatement pstmt = conn.prepareStatement(IDbConst.BO_CAT_DELETE);
			try {
				pstmt.setString(1, BOName);
				pstmt.setString(2, catGUID);
				pstmt.execute();
			}
			finally {
				pstmt.close();
			}
			// ap: delete all category values; 
			// sk: assigned values should be deleted only for BOs having type BOName
			String sCatValsDelStmt =
				new StringBuffer(256)
					.append(IDbConst.CAT_VAL_DELETE_BY_CAT_GUID_AND_BO_GUID)
					.append('(')
					.append(sBoGuidsFilter)
					.append(')')
					.toString();
			pstmt = conn.prepareStatement(sCatValsDelStmt);
			try {
				pstmt.setString(1, catGUID);
				pstmt.execute();
			}
			finally {
				pstmt.close();
			}
		}
		catch (Exception e) {
			throw new SQLException("Could not delete category");
		}
	}

	protected String getBOGuidsByBONameSQL(String BOName) throws Exception {
		MetaModel mmr = new MetaModel();
		// @TODO fix the code
//		ShareableObject shObj = null; //mmr.getShareableObject(BOName);
//		if (shObj == null) {
//			throw new NullPointerException("Could not find shareable object for BO:[" + BOName + "]");
//		}
		//			// get information for an atrribute with name "key"   
		//			List list = shObj.getKeys();
		//			if (list==null || list.isEmpty()) {
		//				logger.warningT("List of primary keys is empty!");
		//				return null;
		//			}
		//			Attribute attr = null;
		//			if (list.size()==1) {
		//				attr = (Attribute)list.get(0);				 
		//			}
		//			else {
		//				for(int i=0; i<list.size(); i++) {
		//					attr = (Attribute)list.get(i);
		//					if ("key".equals(attr.getAttributeName())) {
		//						break;
		//					}
		//					attr = null;
		//				}
		//				if (attr==null) {
		//					logger.warningT("Attribute named as 'key' was not found!");
		//					return null;
		//				}
		//			}
		// warning! due to metadata feature, key field has wrong DB field name, so we use hardcoded value
//		String sKeyField = IDbConst.OBJECTKEY; //attr.getDbFieldName();
//		String sTableName = shObj.getDbTableName();
//		StringBuffer result = new StringBuffer(128);
//		result.append("SELECT ").append(sKeyField).append(" FROM ").append(sTableName);
//		return result.toString();
		return null;
	}

	protected void deleteCategory(Connection conn, String catGUID) throws SQLException {
		PreparedStatement pstmt = conn.prepareStatement(IDbConst.BO_CAT_DELETE_BY_ALL_BO);
		try {
			pstmt.setString(1, catGUID);
			pstmt.execute();
		}
		finally {
			pstmt.close();
		}
		//ap: delete all category values
		pstmt = conn.prepareStatement(IDbConst.CAT_VAL_DELETE_BY_CAT_GUID);
		try {
			pstmt.setString(1, catGUID);
			pstmt.execute();
		}
		finally {
			pstmt.close();
		}
	}

	public Collection getCategories(String BOName) throws SQLException {
		Connection conn = m_manager.getConnection();
		try {
			Collection guids = new ArrayList();
			PreparedStatement pstmt = conn.prepareStatement(IDbConst.BO_CAT_SELECT_BY_NAME);
			try {
				pstmt.setString(1, BOName);
				ResultSet rs = pstmt.executeQuery();
				if (!rs.next()) {
					return guids;
				}
				int iColCatGUID = rs.findColumn(IDbConst.CAT_GUID);
				do {
					guids.add(rs.getString(iColCatGUID));
				}
				while (rs.next());
				return guids;
			}
			finally {
				pstmt.close();
			}
		}
		finally {
			conn.close();
		}
	}

	/**
	 * Gets internal db category id by category GUID
	 * @param conn	A DB connection
	 * @param catGUID	The category GUID
	 * @return internal db category id 
	 * @throws SQLException
	 */
	//	protected BigDecimal getCategoryId(Connection conn, String catGUID) throws SQLException {
	//		PreparedStatement pstmt = conn.prepareStatement(IDbConst.CAT_SELECT_BY_GUID);
	//		try {	
	//			pstmt.setString(1, catGUID);
	//			ResultSet rs = pstmt.executeQuery();
	//			if (rs.next()) {
	//				return rs.getBigDecimal(1);
	//			}	
	//		}
	//		finally {
	//			pstmt.close();
	//		}
	//		return createCategory(conn, catGUID);
	//	}

	/**
	 * Creates category record in DB.
	 * @param conn	A DB connection
	 * @param catGUID	A new category GUID
	 * @return	Internal DB id of newly created category record
	 * @throws SQLException
	 */
	//	protected BigDecimal createCategory(Connection conn, String catGUID) throws SQLException {		
	//		PreparedStatement pstmt = conn.prepareStatement(IDbConst.CAT_INSERT);
	//		try {	
	//			BigDecimal key = getNextInSequence(conn, IDbConst.CAF_RT_KEY_SEQUENCE);
	//			pstmt.setBigDecimal(1, key);
	//			pstmt.setString(2, catGUID);
	//			pstmt.execute();
	//			return key;
	//		}
	//		finally {
	//			pstmt.close();
	//		}
	//	}

	//	- Business Object instances methods --- //

	public void addClassification(Collection valueGUIDs, String BOGUID, String categoryGUID)
		throws SQLException {
		Connection conn = m_manager.getConnection();
		try {
			PreparedStatement pstmt = conn.prepareStatement(IDbConst.CAT_VAL_BO_INSERT);
			pstmt.setString(1, BOGUID);
			pstmt.setString(3, categoryGUID);
			String valueGUID;
			for (Iterator i = valueGUIDs.iterator(); i.hasNext();) {
				valueGUID = (String) i.next();
				pstmt.setString(2, valueGUID);
				pstmt.execute();
			}
		}
		catch (SQLException e) {
			throw e;
		}
		finally {
			conn.close();
		}
	}

	public void removeClassification(Collection valueGUIDs, String BOGUID) throws SQLException {
		Connection conn = m_manager.getConnection();
		try {
			PreparedStatement pstmt = conn.prepareStatement(IDbConst.CAT_VAL_BO_DELETE);
			pstmt.setString(1, BOGUID);
			String valueGUID;
			for (Iterator i = valueGUIDs.iterator(); i.hasNext();) {
				valueGUID = (String) i.next();
				pstmt.setString(2, valueGUID);
				pstmt.execute();
			}
		}
		catch (SQLException e) {
			throw e;
		}
		finally {
			conn.close();
		}
	}

	public Collection getClassification(String BOGUID) throws SQLException {
		Connection conn = m_manager.getConnection();
		try {
			PreparedStatement pstmt = conn.prepareStatement(IDbConst.CAT_VAL_BO_SELECT);
			pstmt.setString(1, BOGUID);
			ResultSet rs = pstmt.executeQuery();
			if (!rs.next()) {
				return new ArrayList();
			}
			Collection guids = new ArrayList();
			do {
				guids.add(rs.getString(1));
			}
			while (rs.next());
			return guids;
		}
		finally {
			conn.close();
		}
	}

	public Collection getClassification(String BOGUID, String categoryGUID) throws SQLException {
		Connection conn = m_manager.getConnection();
		try {
			PreparedStatement pstmt = conn.prepareStatement(IDbConst.CAT_VAL_BO_SELECT_BY_CAT);
			pstmt.setString(1, BOGUID);
			pstmt.setString(2, categoryGUID);
			ResultSet rs = pstmt.executeQuery();
			if (!rs.next()) {
				return new ArrayList();
			}
			Collection guids = new ArrayList();
			do {
				guids.add(rs.getString(1));
			}
			while (rs.next());
			return guids;
		}
		finally {
			conn.close();
		}
	}

	public Collection getAssignedClassification(String beMasterTable) throws SQLException {
		Connection conn = m_manager.getConnection();
		
		try {
			PreparedStatement pstmt ;
			if (beMasterTable == null){
				pstmt = conn.prepareStatement(IDbConst.CAT_VAL_BO_ALL);
			}else{
				pstmt = conn.prepareStatement(IDbConst.CAT_VAL_BO_BY_BE + beMasterTable + ")");
			}

			ResultSet rs = pstmt.executeQuery();

			if (!rs.next()) {
				return new ArrayList() ;
			}

			Collection assignmentGuids = new ArrayList();

			int iColBOGUID = rs.findColumn(IDbConst.BO_GUID);
			int iColCatValGUID = rs.findColumn(IDbConst.CAT_VAL_GUID);
			int iColCatGUID = rs.findColumn(IDbConst.CAT_GUID);

			do {
				String[]  assignment = new String[]{rs.getString(iColBOGUID), rs.getString(iColCatValGUID), rs.getString(iColCatGUID) } ;
				assignmentGuids.add(assignment);
			}
			while (rs.next());
			return assignmentGuids;
		}
		finally {
			conn.close();
		}
	}

	public boolean isUsedInClassification(String valueGUID) throws SQLException {
		Connection conn = m_manager.getConnection();
		try {
			PreparedStatement pstmt = conn.prepareStatement(IDbConst.CAT_VAL_BO_EXIST);
			try {
				pstmt.setString(1, valueGUID);
				ResultSet rs = pstmt.executeQuery();
				return (rs.next() ? rs.getInt(1) > 0 : false);
			}
			finally {
				pstmt.close();
			}
		}
		finally {
			conn.close();
		}
	}

	public void removeClassification(Collection valueGUIDs) throws Throwable {
		Connection conn = m_manager.getConnection();
		try {
			PreparedStatement pstmt = conn.prepareStatement(IDbConst.CAT_VAL_BO_DEL_BY_CAT_VAL);
			try {
				String valueGUID;
				for (Iterator i = valueGUIDs.iterator(); i.hasNext();) {
					valueGUID = (String) i.next();
					pstmt.setString(1, valueGUID);
					pstmt.execute();
				}
			}
			finally {
				pstmt.close();
			}
		}
		catch (Throwable e) {
			throw e;
		}
		finally {
			conn.close();
		}
	}
}
