/* Created on Sep 3, 2003
 */
package com.sap.caf.km.ejb.svc.idxsearch.bo;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import com.sap.caf.km.ejb.svc.idxsearch.util.ConnectionManager;
import com.sap.caf.km.ejb.svc.idxsearch.util.DbHelper;
import com.sap.caf.km.ejb.svc.idxsearch.util.IDbConst;

/**
 * @author viachaslau_kudzinau
 */
public class BODbHelper extends DbHelper {

	public BODbHelper(ConnectionManager manager) {
		super(manager);
	}

//	- Business Object types methods --- //
	/**
	 * Gets internal db id of business object by its name. If the business object 
	 * does not exist it will be created.
	 * @param conn	A DB connection
	 * @param BOName The business object name
	 * @return	internal db id of business object
	 * @throws SQLException
	 */	
	protected BigDecimal getBusinessObjectId(Connection conn, String BOName) throws SQLException {
		PreparedStatement pstmt = conn.prepareStatement(IDbConst.BO_SELECT_BY_NAME);
		try {
			pstmt.setString(1, BOName);
			ResultSet rs = pstmt.executeQuery();
			if (rs.next()) {
				return rs.getBigDecimal(1);
			}
		}
		finally {
			pstmt.close();
		}
		return createBusinessObject(conn, BOName);
	}

	protected BigDecimal createBusinessObject(Connection conn, String BOName) throws SQLException {
		BigDecimal key = getNextInSequence(conn, IDbConst.CAF_RT_KEY_SEQUENCE);
		PreparedStatement pstmt = conn.prepareStatement(IDbConst.BO_INSERT);
		try {
			pstmt.setBigDecimal(1, key);
			pstmt.setString(2, BOName);
			pstmt.execute();
			return key;
		}
		finally {
			pstmt.close();
		}
	}
	
	protected void deleteBusinessObject(Connection conn, String BOName) throws SQLException {
		PreparedStatement pstmt = conn.prepareStatement(IDbConst.BO_DELETE_BY_NAME);
		try {
			pstmt.setString(1, BOName);
			pstmt.execute();
		}
		finally {
			pstmt.close();
		}
	}

	protected void deleteBusinessObjects(Connection conn) throws SQLException {
		PreparedStatement pstmt = conn.prepareStatement(IDbConst.BO_DELETE);
		try {
			pstmt.execute();
		}
		finally {
			pstmt.close();
		}
	}
	
	
}
