/*
 * Created on Jul 1, 2003
 *
 */
package com.sap.caf.km.ejb.svc.idxsearch.bo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import com.sap.caf.km.ejb.svc.idxsearch.util.ConfigException;
import com.sap.caf.km.ejb.svc.idxsearch.util.ConfigProps;
import com.sap.caf.km.ejb.svc.idxsearch.util.IConfigProps;
import com.sap.caf.metamodel.Application;
import com.sap.caf.metamodel.BaseObject;
import com.sap.caf.metamodel.DataObject;
import com.sap.caf.metamodel.BusinessEntityInterface;
import com.sap.caf.rt.exception.DataAccessException;
import com.sap.caf.rt.metamodel.MetaModel;

/**
 * @author viachaslau_kudzinau@epam.com
 */
public class BOAccessor implements IBOAccessor, IConfigProps {
	
	protected BOAccessor(ConfigProps props) {
		m_props = props;
	}

	public synchronized static BOAccessor getInstance() throws ConfigException, BOAccessException {
		if (s_accessor == null) {
			s_accessor = new BOAccessor(ConfigProps.getInstance());
			MetaModel mm;
			try {
				mm = new MetaModel();
			}
			catch (DataAccessException e) {
				throw new ConfigException("Could not get MetaModel, cause:[" + e.getMessage() + "]");
			}
			s_accessor.setMetaModel(mm);
			s_accessor.init();
		}
		return s_accessor;
	}

	private void setMetaModel(MetaModel model) {
		m_model = model;
	}

	/** @see com.sap.caf.km.ejb.svc.idxsearch.IBOAccessor#getBONames()
	 */
	public String[] getBONames() throws BOAccessException {
		return m_names;
	}
	
	/** @see com.sap.caf.km.ejb.svc.idxsearch.IBOAccessor#isBOKM(java.lang.String)
	 */
	public boolean isBOKM(String BOName) throws BOAccessException {
		return isBOKMDocument(BOName) || isBOKMTask(BOName);
	}

	/** @see com.sap.caf.km.ejb.svc.idxsearch.IBOAccessor#isBOCAF(java.lang.String)
	 */
	public boolean isBOCAF(String BOName) throws BOAccessException {
		return !isBOKM(BOName);
	}

	/** @see com.sap.caf.km.ejb.svc.idxsearch.IBOAccessor#isBOKMDocument(java.lang.String)
	 */
	public boolean isBOKMDocument(String BOName) throws BOAccessException {
		return isBOTypeOf(KMBO_DOCUMENT_NAME, BOName);
	}

	/** @see com.sap.caf.km.ejb.svc.idxsearch.IBOAccessor#isBOKMTask(java.lang.String)
	 */
	public boolean isBOKMTask(String BOName) throws BOAccessException {
		return isBOTypeOf(KMBO_TASK_NAME, BOName);
	}

	protected boolean isBOTypeOf(String propName, String BOName) throws BOAccessException {
		try {
			return m_props.getNotNullProperty(propName).equals(BOName);
		}
		catch (ConfigException e) {
			throw new BOAccessException("Could not compare BO Names:[" + propName + "," + BOName + "], cause:[" + e.toString() + "]");
		}
	}

	public String getGUID(String BOName) throws BOAccessException {
		try {
			BaseObject bo = (BaseObject)m_bo.get(BOName);
			return bo.getObjectId();
		}
		catch (Throwable e) {
			//$JL-EXC$ ignore JLin warning
			throw new BOAccessException("Could not get GUID for BO:[" + BOName + "], cause:[" + e.toString() + "]");
		}
	}
	
	public Collection getClassifables() throws BOAccessException
	{
		if(m_classifables == null)
		{
			Collection classifables = new ArrayList();
			int ln = m_names.length;
			for(int i = 0; i < ln; i++)
			{
				DataObject bo = (DataObject)m_bo.get(m_names[i]);
				Boolean res = bo.getBusinessEntityInterface().isClassifiable();  
				if( (res != null) && (res.booleanValue()) )
				{
					classifables.add(m_names[i]);
				}
			}
			m_classifables = classifables;
		}
		return m_classifables;
	}

	public Collection getSearchAndRetrieval() throws BOAccessException
	{
		if(m_searchables == null)
		{
			Collection searchables = new ArrayList();
			int ln = m_names.length;
			for(int i = 0; i < ln; i++)
			{
				DataObject bo = (DataObject)m_bo.get(m_names[i]);
				Boolean res = bo.getBusinessEntityInterface().isSearchAndRetrieval();  
				if( (res != null) && (res.booleanValue()) )
				{
					searchables.add(m_names[i]);
				}
			}
			m_searchables = searchables;
		}
		return m_searchables;
	}

	public String[] getKMBONames() throws BOAccessException {
		try {
			return m_KMNames;
		}
		catch (Throwable e) {
			//$JL-EXC$ ignore JLin warning
			throw new BOAccessException("Could not get KMBO names");
		}
	}
	
	public Collection getCAFBONames() {
		return m_CAFNames;
	}

	public String getKMBODocumentName() throws BOAccessException {
		return getKMBOName(KMBO_DOCUMENT_NAME);
	}

	public String getKMBOTaskName() throws BOAccessException {
		return getKMBOName(KMBO_TASK_NAME);
	}

	protected String getKMBOName(String propName) throws BOAccessException {
		try {
			String sName = m_props.getNotNullProperty(propName);
			return sName;
		}
		catch (ConfigException e) {
			throw new BOAccessException("Could not get BO Name, cause:[" + e.toString() + "]");
		}
	}

	protected void init() throws BOAccessException {
		try {
			parseExcludedBOList();
			Collection coll = m_model.getAllBusinessEntityInterfaces();
			m_bo = new HashMap();
			List names = new ArrayList();
			DataObject obj;
			BusinessEntityInterface service;
			int i = 0;
			String name;
			Application app;
			for (Iterator iter = coll.iterator(); iter.hasNext(); i++) {
				service = (BusinessEntityInterface) iter.next(); 
				obj = service.getBusinessEntity();
				app = service.getApplication();
				if (app == null || !isObjectKMExposed(service)) {
					continue;
				}
				name = app.getProviderName() + BO_NAME_SEPARATOR + app.getObjectName() + BO_NAME_SEPARATOR + obj.getObjectName();
				if (isBOExcluded(name)) {
					m_excludedBO.put(name, obj);
					continue;
				}
				names.add(name);
				m_bo.put(name, obj);
			}
			m_names = (String[]) names.toArray(new String[names.size()]);
			// fill km names
			m_KMNames = new String[2];
			m_KMNames[0] = m_props.getNotNullProperty(KMBO_DOCUMENT_NAME);
			m_KMNames[1] = m_props.getNotNullProperty(KMBO_TASK_NAME);
			// fill caf names
			m_CAFNames = new ArrayList();
			for (i = 0; i < m_names.length; i++) {
				name = m_names[i];
				if (isBOCAF(name)) {
					m_CAFNames.add(name);
				}
			}
		}
		catch (Exception e) {
			throw new BOAccessException("Could not get BO types, cause:[" + e + "]");
		}
	}
	
	protected boolean isObjectKMExposed(BusinessEntityInterface obj) {
		int type = obj.getBackend().intValue();
		return type == BO_STORE_TYPE_JDO || type == BO_STORE_TYPE_KM;
	}

	protected boolean isBOExcluded(String BOName) {
		return m_excludedBO.get(BOName) != null;
	}

	protected void parseExcludedBOList() throws BOAccessException {
		m_excludedBO = new HashMap();
		try {
			String list = m_props.getNotNullProperty(CAFBO_IDX_EXCLUDED_LIST);
			if (list != null && (list = list.trim()).length() > 0) {
				int i = 0;
				int j;
				int len = list.length();
				String name;
				do {
					j = list.indexOf(',', i);
					if (j == -1) {
						j = len;
					}
					name = list.substring(i, j);
					if (name != null && (name = name.trim()).length() > 0) {
						m_excludedBO.put(name, name);
					}
					i = j + 1;
				}
				while (i < len);
			}
		}
		catch (Throwable e) {
			//$JL-EXC$ ignore JLin warning
			throw new BOAccessException("Could not parse parameter:[" + CAFBO_IDX_EXCLUDED_LIST + "], cause:[" + e + "]");
		}
	}

	protected static BOAccessor s_accessor;
	protected ConfigProps m_props;
	protected MetaModel m_model;
	protected Map m_bo;
	protected Map m_excludedBO;
	protected String[] m_names;
	protected String[] m_KMNames;
	protected List m_CAFNames;
	protected Collection m_classifables = null;
	protected Collection m_searchables = null;
}
