package com.sap.caf.km.ejb.svc.idxsearch.bean;

import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;

import javax.ejb.CreateException;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;

import com.sap.caf.km.da.KMDataAccessBean;
import com.sap.caf.km.ejb.svc.idxsearch.bo.BOAccessException;
import com.sap.caf.km.ejb.svc.idxsearch.bo.BOAccessor;
import com.sap.caf.km.ejb.svc.idxsearch.classify.IKMIndexSearchClassifySvcFactory;
import com.sap.caf.km.ejb.svc.idxsearch.classify.KMClassifyHelper;
import com.sap.caf.km.ejb.svc.idxsearch.classify.KMIndexSearchClassifySvcFactory;
import com.sap.caf.km.ejb.svc.idxsearch.common.ClassifyException;
import com.sap.caf.km.ejb.svc.idxsearch.common.IIndex;
import com.sap.caf.km.ejb.svc.idxsearch.common.IIndexSearchClassifySvc;
import com.sap.caf.km.ejb.svc.idxsearch.common.IIndexSearchIndexSvc;
import com.sap.caf.km.ejb.svc.idxsearch.common.IIndexSearchResourceKeys;
import com.sap.caf.km.ejb.svc.idxsearch.common.IIndexSearchSearchSvc;
import com.sap.caf.km.ejb.svc.idxsearch.common.ISearchEntry;
import com.sap.caf.km.ejb.svc.idxsearch.common.ISearchResult;
import com.sap.caf.km.ejb.svc.idxsearch.common.IndexException;
import com.sap.caf.km.ejb.svc.idxsearch.common.IndexSearchException;
import com.sap.caf.km.ejb.svc.idxsearch.common.SearchEntry;
import com.sap.caf.km.ejb.svc.idxsearch.common.SearchException;
import com.sap.caf.km.ejb.svc.idxsearch.index.IKMIndexSearchIndexSvcFactory;
import com.sap.caf.km.ejb.svc.idxsearch.index.KMIndexHelper;
import com.sap.caf.km.ejb.svc.idxsearch.index.KMIndexSearchIndexSvcFactory;
import com.sap.caf.km.ejb.svc.idxsearch.index.KMIndexUtil;
import com.sap.caf.km.ejb.svc.idxsearch.search.IKMIndexSearchSearchSvcFactory;
import com.sap.caf.km.ejb.svc.idxsearch.search.KMIndexSearchSearchSvcFactory;
import com.sap.caf.km.ejb.svc.idxsearch.search.KMSearchHelper;
import com.sap.caf.km.ejb.svc.idxsearch.search.KMSearchResultLocal;
import com.sap.caf.km.ejb.svc.idxsearch.util.ConfigProps;
import com.sap.caf.km.ejb.svc.idxsearch.util.ConnectionManager;
import com.sap.caf.km.ejb.svc.idxsearch.util.IConfigProps;
import com.sap.caf.km.ejb.svc.idxsearch.util.IndexCache;
import com.sap.caf.metamodel.BusinessEntityInterface;
import com.sap.caf.metamodel.DataObject;
import com.sap.caf.metamodel.Table;
import com.sap.caf.rt.bol.IKMExt;
import com.sap.caf.rt.bol.context.CAFContext;
import com.sap.caf.rt.bol.util.QueryFilter;
import com.sap.caf.rt.exception.DataAccessException;
import com.sap.caf.rt.metamodel.MetaModel;
import com.sap.tc.logging.Location;

/**
 * @ejbHome <{com.sap.caf.km.ejb.svc.idxsearch.IndexSearchHome}>
 * @ejbLocal <{com.sap.caf.km.ejb.svc.idxsearch.IndexSearchLocal}>
 * @ejbLocalHome <{com.sap.caf.km.ejb.svc.idxsearch.IndexSearchLocalHome}>
 * @ejbRemote <{com.sap.caf.km.ejb.svc.idxsearch.IndexSearch}>
 * @stateless
 */
public class IndexSearchBean extends KMDataAccessBean implements IIndexSearchResourceKeys {

	private static final String APPLICATION = IndexSearchBean.class.getName();
	private static final String jARMReqPrefix = "CAF:RT:oal:"; 
	private static final String JARM_REQUEST =  jARMReqPrefix + APPLICATION;		
	private static final Location location = Location.getLocation(APPLICATION);

	private static final Collection EMPTY_SEARCH_RESULT = Arrays.asList(new ISearchResult[0]);
	private transient SessionContext m_sessionContext;
	private transient IIndexSearchIndexSvc m_indexSvc;
	private transient IIndexSearchClassifySvc m_classifySvc;
	private transient IIndexSearchSearchSvc m_searchSvc;
	private transient KMIndexHelper m_idxHelper;
	private transient KMClassifyHelper m_clsHelper;
	private transient KMSearchHelper m_searchHelper;
	private transient BOAccessor m_accessor;
	private transient IndexCache m_cache;
	private String m_sTaxonomyPrefix;
	private int m_max_search_results;

	public void ejbCreate() throws CreateException {
		final String method = JARM_REQUEST + ":ejbCreate()";
		enter(method, null);
		try {
			IKMIndexSearchIndexSvcFactory svcIdxFactory = KMIndexSearchIndexSvcFactory.getInstance();
			m_indexSvc = svcIdxFactory.getIndexService();

			IKMIndexSearchClassifySvcFactory svcClsFactory = KMIndexSearchClassifySvcFactory.getInstance();
			m_classifySvc = svcClsFactory.getClassifyService();

			IKMIndexSearchSearchSvcFactory svcSearchFactory = KMIndexSearchSearchSvcFactory.getInstance();
			m_searchSvc = svcSearchFactory.getSearchService();
			m_max_search_results = svcSearchFactory.getMaxSearchResults();

			m_cache = IndexCache.getInstance();

			m_idxHelper = new KMIndexHelper(ConnectionManager.getInstance());

			m_clsHelper = new KMClassifyHelper(ConnectionManager.getInstance());

			m_accessor = BOAccessor.getInstance();
		}
		catch (Exception e) {
			IndexSearchException indexSearchEx = new IndexSearchException(ERR_EJB_CREATE, e);
			log(indexSearchEx, method, null);
			throw new CreateException(indexSearchEx.getLocalizedMessage());
		}
		finally {
			exit(method, null);
		}
	}

	/** business-specific methods */

	/** @see com.sap.caf.km.ejb.svc.idxsearch.IIndexSearchIndex#createIndexForCAFBO(java.lang.String)
	 */
	public IIndex createIndexForCAFBO(String BOName) throws IndexException {
		final String method = JARM_REQUEST + ":createIndexForCAFBO(String)";
		enter(method, new Object[] { BOName });
		try {
			String sIndexId = KMIndexUtil.getIndexId(BOName);
			m_indexSvc.createFolderIndex(sIndexId, new String[] { KMIndexUtil.getFolderRID(BOName)});
			m_cache.invalidate();
			m_idxHelper.assignIndex(BOName, sIndexId, IIndex.TYPE_CAF_BO_OWN);
			return m_indexSvc.getIndex(sIndexId);
		}
		catch (Exception e) {
			IndexException indexEx = new IndexException(ERR_IDX_PROPER_CREATE, new Object[] { BOName }, e);
			log(indexEx, method, null);
			throw indexEx;
		}
		finally {
			exit(method, null);
		}
	}

	/** @see com.sap.caf.km.ejb.svc.idxsearch.IIndexSearchIndex#deleteIndexForCAFBO(java.lang.String)
	 */
	public void deleteIndexForCAFBO(String BOName) throws IndexException {
		final String method = JARM_REQUEST + ":deleteIndexForCAFBO(String)";
		enter(method, new Object[] { BOName });
		try {
			m_indexSvc.deleteIndex(KMIndexUtil.getIndexId(BOName));
			m_cache.invalidate();
			m_idxHelper.unassignIndex(BOName, IIndex.TYPE_CAF_BO_OWN);
		}
		catch (Exception e) {
			IndexException indexEx = new IndexException(ERR_IDX_PROPER_DELETE, new Object[] { BOName }, e);
			log(indexEx, method, null);
			throw indexEx;
		}
		finally {
			exit(method, null);
		}
	}

	/** @see com.sap.caf.km.ejb.svc.idxsearch.IIndexSearchIndex#createRelatedIndexForCAFBO(java.lang.String)
	 */
	public IIndex createRelatedIndexForCAFBO(String BOName) throws IndexException {
		final String method = JARM_REQUEST + ":createRelatedIndexForCAFBO(String)";
		enter(method, new Object[] { BOName });
		try {
			String sIndexId = KMIndexUtil.getRelatedIndexId(BOName);
			m_indexSvc.createRelatedIndex(sIndexId, KMIndexUtil.getFolderRID(BOName));
			m_cache.invalidate();
			m_idxHelper.assignIndex(BOName, sIndexId, IIndex.TYPE_CAF_BO_RELATED);
			return m_indexSvc.getIndex(sIndexId);
		}
		catch (Exception e) {
			IndexException indexEx = new IndexException(ERR_IDX_RELATED_CREATE, new Object[] { BOName }, e);
			log(indexEx, method, null);
			throw indexEx;
		}
		finally {
			exit(method, null);
		}
	}

	/** @see com.sap.caf.km.ejb.svc.idxsearch.IIndexSearchIndex#deleterelatedIndexForCAFBO(java.lang.String)
	 */
	public void deleteRelatedIndexForCAFBO(String BOName) throws IndexException {
		final String method = JARM_REQUEST + ":deleteRelatedIndexForCAFBO(String)";
		enter(method, new Object[] { BOName });
		try {
			m_indexSvc.deleteIndex(KMIndexUtil.getRelatedIndexId(BOName));
			m_idxHelper.unassignIndex(BOName, IIndex.TYPE_CAF_BO_RELATED);
			m_cache.invalidate();
		}
		catch (Exception e) {
			IndexException indexEx = new IndexException(ERR_IDX_RELATED_DELETE, new Object[] { BOName }, e);
			log(indexEx, method, null);
			throw indexEx;
		}
		finally {
			exit(method, null);
		}
	}

	/** @see com.sap.caf.km.ejb.svc.idxsearch.IIndexSearchIndex#invalidateIndexCache()
	 */
	public void invalidateIndexCache() {
		final String method = JARM_REQUEST + ":invalidateIndexCache()";
		enter(method, null);

		m_cache.invalidate();

		exit(method, null);
	}

	/** @see com.sap.caf.km.ejb.svc.idxsearch.IIndexSearchIndex#getAllIndexes()
	 */
	public IIndex[] getAllIndexes() throws IndexException {
		final String method = JARM_REQUEST + ":getAllIndexes()";
		enter(method, null);
		try {
			synchronized(m_cache) {
				if (!m_cache.isValid()) {
					info(method, "Index Cache is not valid, collect indexes", null);
					IIndex[] remoteIdxs = m_indexSvc.getAllIndexes();
					info(method, "Remote indexes count: {0}", new Object[] { new Integer(remoteIdxs.length)});
					IIndex[] localIdxs = m_idxHelper.getAllIndexes();
					info(method, "Local indexes count: {0}", new Object[] { new Integer(localIdxs.length)});
					m_cache.setIndexes(m_idxHelper.merge(remoteIdxs, localIdxs));
				}
			}
			return m_cache.getIndexes();
		}
		catch (Exception e) {
			IndexException indexEx = new IndexException(ERR_IDX_GET_ALL, e);
			log(indexEx, method, null);
			throw indexEx;
		}
		finally {
			exit(method, null);
		}

	}

	/** @see com.sap.caf.km.ejb.svc.idxsearch.IIndexSearchIndex#getIndex(java.lang.String)
	 */
	public IIndex getIndex(String indexId) throws IndexException {
		final String method = JARM_REQUEST + ":getIndex(String)";
		enter(method, new Object[] { indexId });
		try {
			IIndex remote = m_indexSvc.getIndex(indexId);
			return m_idxHelper.bless(remote);
		}
		catch (Exception e) {
			IndexException indexEx = new IndexException(ERR_IDX_GET, new Object[] { indexId }, e);
			log(indexEx, method, null);
			throw indexEx;
		}
		finally {
			exit(method, null);
		}
	}

	/** @see com.sap.caf.km.ejb.svc.idxsearch.IIndexSearchIndex#getIndex(java.lang.String)
	 */
	public void clearIndex(String indexId) throws IndexException {
		final String method = JARM_REQUEST + ":clearIndex(String)";
		enter(method, new Object[] { indexId });
		try {
			m_indexSvc.clearIndex(indexId);
		}
		catch (Exception e) {
			IndexException indexEx = new IndexException(ERR_IDX_CLEAR, new Object[] { indexId }, e);
			log(indexEx, method, null);
			throw indexEx;
		}
		finally {
			exit(method, null);
		}
	}

	/** @see com.sap.caf.km.ejb.svc.idxsearch.IIndexSearchIndex#assignGlobalIndexToKMBO(java.lang.String, java.lang.String)
	 */
	public void assignGlobalIndexToKMBO(String indexId, String BOName) throws IndexException {
		final String method = JARM_REQUEST + ":assignGlobalIndexToKMBO(String, String)";
		enter(method, new Object[] { indexId, BOName });
		try {
			m_idxHelper.assignIndex(BOName, indexId, IIndex.TYPE_KM_BO_GLOBAL);
			m_cache.invalidate();
		}
		catch (SQLException e) {
			IndexException indexEx = new IndexException(ERR_IDX_GLOBAL_ASSIGN, new Object[] { indexId, BOName }, e);
			log(indexEx, method, null);
			throw indexEx;
		}
		finally {
			exit(method, null);
		}
	}

	/** @see com.sap.caf.km.ejb.svc.idxsearch.IIndexSearchIndex#unassignGlobalIndexFromKMBO(java.lang.String)
	 */
	public void unassignGlobalIndexFromKMBO(String indexId, String BOName) throws IndexException {
		final String method = JARM_REQUEST + ":unassignGlobalIndexFromKMBO(String, String)";
		enter(method, new Object[] { indexId, BOName });
		try {
			m_idxHelper.unassignIndex(BOName, indexId, IIndex.TYPE_KM_BO_GLOBAL);
			m_cache.invalidate();
		}
		catch (SQLException e) {
			IndexException indexEx = new IndexException(ERR_IDX_GLOBAL_UNASSIGN, new Object[] { indexId, BOName }, e);
			log(indexEx, method, null);
			throw indexEx;
		}
		finally {
			exit(method, null);
		}
	}

	/** @see com.sap.caf.km.ejb.svc.idxsearch.IIndexSearchIndex#deleteGlobalIndex(java.lang.String)
	 */
	public void deleteGlobalIndex(String indexId, String BOName) throws IndexException {
		final String method = JARM_REQUEST + ":deleteGlobalIndex(String, String)";
		enter(method, new Object[] { indexId, BOName });
		try {
			if (BOName != null) {
				unassignGlobalIndexFromKMBO(indexId, BOName);
			}
			m_indexSvc.deleteIndex(indexId);
			m_cache.invalidate();
		}
		catch (IndexException e) {
			IndexException indexEx = new IndexException(ERR_IDX_GLOBAL_DELETE, new Object[] { indexId, BOName }, e);
			log(indexEx, method, null);
			throw indexEx;
		}
		finally {
			exit(method, null);
		}
	}

	/** @see com.sap.caf.km.ejb.svc.idxsearch.IIndexSearchIndex#indexObject(java.lang.String, java.lang.String)
	 */
	public void indexObject(String BOName, String objectRid) throws IndexException {
		String method = JARM_REQUEST + ":indexObject(String, String )";
		enter(method, new Object[] { BOName, objectRid });
		try {
			indexObject(BOName, new String[] { objectRid }, IIndex.TYPE_CAF_BO_OWN);
		}
		finally {
			exit(method, null);
		}
	}

	/** @see com.sap.caf.km.ejb.svc.idxsearch.IIndexSearchIndex#indexObject(java.lang.String, java.lang.String)
	 */
	public void indexRelatedObject(String BOName, String objectRid) throws IndexException {
		String method = JARM_REQUEST + ":indexRelatedObject(String, String)";
		enter(method, new Object[] { BOName, objectRid });
		try {
			indexObject(BOName, new String[] { objectRid }, IIndex.TYPE_CAF_BO_RELATED);
		}
		finally {
			exit(method, null);
		}
	}

	/** @see com.sap.caf.km.ejb.svc.idxsearch.IIndexSearchIndex#indexObject(java.lang.String, java.lang.String)
	 */
	protected void indexObject(String BOName, String[] objectRid, int indexType) throws IndexException {
		final String method = JARM_REQUEST + ":indexObject(String, String[], int)";
		enter(method, new Object[] { BOName, objectRid, new Integer(indexType)});
		try {
			if (indexType != IIndex.TYPE_CAF_BO_OWN && indexType != IIndex.TYPE_CAF_BO_RELATED) {
				IndexException ex = new IndexException(ERR_IDX_TYPE, new Object[] { new Integer(indexType)});
			}
			if (m_idxHelper.checkIndexExist(BOName, indexType)) {
				m_indexSvc.indexObjects(
					indexType == IIndex.TYPE_CAF_BO_OWN ? KMIndexUtil.getIndexId(BOName) : KMIndexUtil.getRelatedIndexId(BOName),
					objectRid);
				m_cache.invalidate();
			}
		}
		catch (Exception e) {
			IndexException indexEx = new IndexException(ERR_IDX_BO_CREATE, new Object[] { BOName }, e);
			log(indexEx, method, null);
			throw indexEx;
		}
		finally {
			exit(method, null);
		}
	}

	/** @see com.sap.caf.km.ejb.svc.idxsearch.IIndexSearchIndex#deindexObject(java.lang.String, java.lang.String)
	 */
	public void deindexObject(String BOName, String objectRid) throws IndexException {
		final String method = JARM_REQUEST + ":deindexObject(String, String)";
		enter(method, new Object[] { BOName, objectRid });
		try {
			deindexObject(BOName, objectRid, IIndex.TYPE_CAF_BO_OWN);
		}
		finally {
			exit(method, null);
		}
	}

	/** @see com.sap.caf.km.ejb.svc.idxsearch.IIndexSearchIndex#deindexRelatedObject(java.lang.String, java.lang.String)
	 */
	public void deindexRelatedObject(String BOName, String objectRid) throws IndexException {
		final String method = JARM_REQUEST + ":deindexRelatedObject(String, String)";
		enter(method, new Object[] { BOName, objectRid });
		try {
			deindexObject(BOName, objectRid, IIndex.TYPE_CAF_BO_RELATED);
		}
		finally {
			exit(method, null);
		}
	}

	protected void deindexObject(String BOName, String objectRid, int indexType) throws IndexException {
		final String method = JARM_REQUEST + ":deindexObject(String, String, int)";
		enter(method, new Object[] { BOName, objectRid, new Integer(indexType)});
		try {
			if (indexType != IIndex.TYPE_CAF_BO_OWN && indexType != IIndex.TYPE_CAF_BO_RELATED) {
				IndexException ex = new IndexException(ERR_IDX_TYPE, new Object[] { new Integer(indexType)});
			}
			if (m_idxHelper.checkIndexExist(BOName, indexType)) {
				m_indexSvc.deindexObjects(
					indexType == IIndex.TYPE_CAF_BO_OWN ? KMIndexUtil.getIndexId(BOName) : KMIndexUtil.getRelatedIndexId(BOName),
					new String[] { objectRid });
				m_cache.invalidate();
			}
		}
		catch (Exception e) {
			IndexException indexEx = new IndexException(ERR_IDX_BO_DELETE, new Object[] { BOName }, e);
			log(indexEx, method, null);
			throw indexEx;
		}
		finally {
			exit(method, null);
		}
	}

	/** @see com.sap.caf.km.ejb.svc.idxsearch.IIndexSearchIndex#reindexIndex(java.lang.String)
	 */
	public void reindexProperIndex(String BOName) throws IndexException {
		final String method = JARM_REQUEST + ":reindexProperIndex(String)";
		enter(method, new Object[] { BOName });
		try {
			String sIndexId = KMIndexUtil.getIndexId(BOName);
			m_indexSvc.reindex(sIndexId);
			m_idxHelper.assignIndex(BOName, sIndexId, IIndex.TYPE_CAF_BO_OWN);
			m_cache.invalidate();
		}
		catch (Exception e) {
			IndexException indexEx = new IndexException(ERR_IDX_PROPER_REINDEX, new Object[] { BOName }, e);
			log(indexEx, method, null);
			throw indexEx;
		}
		finally {
			exit(method, null);
		}
	}

	/** @see com.sap.caf.km.ejb.svc.idxsearch.IIndexSearchIndex#reindexRelatedIndex(java.lang.String)
	 */
	public void reindexRelatedIndex(String BOName) throws IndexException {
		final String method = JARM_REQUEST + ":reindexRelatedIndex(String)";
		enter(method, new Object[] { BOName });
		try {
			// get related index id
			List indices = getIndices(BOName, IIndex.TYPE_CAF_BO_RELATED);
			if (indices == null || indices.size() != 1) {
				return;
			}
			String sIndexId = (String) indices.get(0);
			// clear old index entries
			clearIndex(sIndexId);
			// get new index entries (rids)
			KMSearchHelper helper = getSearchHelper();
			String[] relRids = helper.getRelatedKMInstancesRids(BOName);
			if (relRids != null && relRids.length > 0) {
				// index related objects
				indexObject(BOName, relRids, IIndex.TYPE_CAF_BO_RELATED);
			}
			m_idxHelper.updateIndexDate(BOName, IIndex.TYPE_CAF_BO_RELATED);
			m_cache.invalidate();

		}
		catch (Exception e) {
			IndexException indexEx = new IndexException(ERR_IDX_RELATED_REINDEX, new Object[] { BOName }, e);
			log(indexEx, method, null);
			throw indexEx;
		}
		finally {
			exit(method, null);
		}
	}

	/** @see com.sap.caf.km.ejb.svc.idxsearch.IIndexSearchIndex#reindexGlobalIndex(java.lang.String)
	 */
	public void reindexGlobalIndex(String indexId, String BOName) throws IndexException {
		final String method = JARM_REQUEST + ":reindexGlobalIndex(String, String)";
		enter(method, new Object[] { indexId, BOName });
		try {
			m_indexSvc.reindex(indexId);
			m_cache.invalidate();
		}
		catch (Exception e) {
			IndexException indexEx = new IndexException(ERR_IDX_GLOBAL_REINDEX, new Object[] { indexId, BOName }, e);
			log(indexEx, method, null);
			throw indexEx;
		}
		finally {
			exit(method, null);
		}
	}

	/** @see com.sap.caf.km.ejb.svc.idxsearch.IIndexSearchIndex#deltaReindex(java.lang.String)
	 */
	public void deltaReindex(String BOName) throws IndexException {
		final String method = JARM_REQUEST + ":deltaReindex(String)";
		enter(method, new Object[] { BOName });
		try {
			m_indexSvc.deltaReindex(KMIndexUtil.getIndexId(BOName));
			m_cache.invalidate();
		}
		catch (Exception e) {
			IndexException indexEx = new IndexException(ERR_IDX_DELTA_REINDEX, new Object[] { BOName }, e);
			log(indexEx, method, null);
			throw indexEx;
		}
		finally {
			exit(method, null);
		}
	}

	// BO accessor methods
	public boolean isBOKM(String BOName) throws BOAccessException {
		return m_accessor.isBOKM(BOName);
	}

	public boolean isBOCAF(String BOName) throws BOAccessException {
		return m_accessor.isBOCAF(BOName);
	}

	public boolean isBOKMDocument(String BOName) throws BOAccessException {
		return m_accessor.isBOKMDocument(BOName);
	}

	public boolean isBOKMTask(String BOName) throws BOAccessException {
		return m_accessor.isBOKMTask(BOName);
	}

	public String[] getBONames() throws BOAccessException {
		return m_accessor.getBONames();
	}
	
	public Collection getClassifables()throws BOAccessException {
		return m_accessor.getClassifables();
	}

	public Collection getSearchAndRetrieval() throws BOAccessException {
		return m_accessor.getSearchAndRetrieval();
	}

	public String[] getKMBONames() throws BOAccessException {
		return m_accessor.getKMBONames();
	}

	// IIndexSearchClassify methods

	/** @see com.sap.caf.km.ejb.svc.idxsearch.IIndexSearchClassify#assignTaxonomy(java.lang.String, java.lang.String)
	 */
	public void assignCategory(String catGUID, String BOName) throws ClassifyException {
		final String method = JARM_REQUEST + ":assignCategory(String, String)";
		enter(method, new Object[] { catGUID, BOName });
		try {
			// update database
			Collection coll = new ArrayList();
			coll.add(catGUID);
			m_clsHelper.assignCategory(coll, BOName);

		}
		catch (Exception e) {
			ClassifyException classifyEx = new ClassifyException(ERR_CAT_ASSIGN, new Object[] { catGUID, BOName }, e);
			log(classifyEx, method, null);
			throw classifyEx;
		}
		finally {
			exit(method, null);
		}
	}

	/** @see com.sap.caf.km.ejb.svc.idxsearch.IIndexSearchClassify#assignCategory(java.util.Collection, java.lang.String)
	 */
	public void assignCategory(Collection catGUIDs, String BOName) throws ClassifyException {
		final String method = JARM_REQUEST + ":assignCategory(Collection, String)";
		enter(method, new Object[] { catGUIDs, BOName });
		try {
			// update database
			m_clsHelper.assignCategory(catGUIDs, BOName);
		}
		catch (Exception e) {
			ClassifyException classifyEx = new ClassifyException(ERR_CAT_ASSIGN_MANY, new Object[] { BOName }, e);
			log(classifyEx, method, null);
			throw classifyEx;
		}
		finally {
			exit(method, null);
		}
	}

	/** @see com.sap.caf.km.ejb.svc.idxsearch.IIndexSearchClassify#deassignCategory(java.lang.String, java.lang.String)
	 */
	public void deassignCategory(String catGUID, String BOName) throws ClassifyException {
		final String method = JARM_REQUEST + ":deassignCategory(String, String)";
		enter(method, new Object[] { catGUID, BOName });
		try {
			Collection catGUIDs = new ArrayList();
			catGUIDs.add(catGUID);
			// update database
			m_clsHelper.deassignCategory(catGUIDs, BOName);
		}
		catch (Exception e) {
			ClassifyException classifyEx = new ClassifyException(ERR_CAT_UNASSIGN, new Object[] { catGUID, BOName }, e);
			log(classifyEx, method, null);
			throw classifyEx;
		}
		finally {
			exit(method, null);
		}
	}

	/** @see com.sap.caf.km.ejb.svc.idxsearch.IIndexSearchClassify#deassignCategory(java.lang.String)
		 */
	public void deassignCategory(String catGUID) throws ClassifyException {
		final String method = JARM_REQUEST + ":deassignCategory(String)";
		enter(method, new Object[] { catGUID });
		try {
			// update database
			m_clsHelper.deassignCategory(catGUID);
		}
		catch (Exception e) {
			ClassifyException classifyEx = new ClassifyException(ERR_CAT_UNASSIGN_ALL, new Object[] { catGUID }, e);
			log(classifyEx, method, null);
			throw classifyEx;
		}
		finally {
			exit(method, null);
		}
	}

	/** @see com.sap.caf.km.ejb.svc.idxsearch.IIndexSearchClassify#deassignCategory(java.util.Collection, java.lang.String)
	 */
	public void deassignCategory(Collection catGUIDs, String BOName) throws ClassifyException {
		final String method = JARM_REQUEST + ":deassignCategory(Collection, String)";
		enter(method, new Object[] { catGUIDs, BOName });
		try {
			// update database
			m_clsHelper.deassignCategory(catGUIDs, BOName);
		}
		catch (Exception e) {
			ClassifyException classifyEx = new ClassifyException(ERR_CAT_UNASSIGN_MANY, new Object[] { BOName }, e);
			log(classifyEx, method, null);
			throw classifyEx;
		}
		finally {
			exit(method, null);
		}
	}

	/** @see com.sap.caf.km.ejb.svc.idxsearch.IIndexSearchClassify#getCategories(java.lang.String)
	 */
	public Collection getCategories(String BOName) throws ClassifyException {
		final String method = JARM_REQUEST + ":getCategories(String)";
		enter(method, new Object[] { BOName });
		try {
			return m_clsHelper.getCategories(BOName);
		}
		catch (Exception e) {
			ClassifyException classifyEx = new ClassifyException(ERR_CAT_GET, new Object[] { BOName }, e);
			log(classifyEx, method, null);
			throw classifyEx;
		}
		finally {
			exit(method, null);
		}
	}

	/** @see com.sap.caf.km.ejb.svc.idxsearch.IIndexSearchClassify#addClassification(java.lang.String, java.lang.String)
	 */
	public void addClassification(String valueGUID, String BOGUID, String categoryGUID) throws ClassifyException {
		final String method = JARM_REQUEST + ":addClassification(String, String, String)";
		enter(method, new Object[] { valueGUID, BOGUID, categoryGUID });
		try {
			Collection coll = new ArrayList();
			coll.add(valueGUID);
			m_clsHelper.addClassification(coll, BOGUID, categoryGUID);
		}
		catch (Exception e) {
			ClassifyException classifyEx = new ClassifyException(ERR_CAT_VALUE_ASSIGN, e);
			log(classifyEx, method, null);
			throw classifyEx;
		}
		finally {
			exit(method, null);
		}
	}

	/** @see com.sap.caf.km.ejb.svc.idxsearch.IIndexSearchClassify#addClassification(java.util.Collection, java.lang.String)
	 */
	public void addClassification(Collection valueGUIDs, String BOGUID, String categoryGUID) throws ClassifyException {
		final String method = JARM_REQUEST + ":addClassification(Collection, String, String)";
		enter(method, new Object[] { valueGUIDs, BOGUID, categoryGUID });
		try {
			m_clsHelper.addClassification(valueGUIDs, BOGUID, categoryGUID);
		}
		catch (Exception e) {
			ClassifyException classifyEx = new ClassifyException(ERR_CAT_VALUE_ASSIGN_MANY, e);
			log(classifyEx, method, null);
			throw classifyEx;
		}
		finally {
			exit(method, null);
		}
	}

	/** @see com.sap.caf.km.ejb.svc.idxsearch.IIndexSearchClassify#removeClassification(java.lang.String, java.lang.String)
	 */
	public void removeClassification(String valueGUID, String BOGUID) throws ClassifyException {
		final String method = JARM_REQUEST + ":removeClassification(String, String)";
		enter(method, new Object[] { valueGUID, BOGUID });
		try {
			Collection valueGUIDs = new ArrayList();
			valueGUIDs.add(valueGUID);
			m_clsHelper.removeClassification(valueGUIDs, BOGUID);
		}
		catch (Exception e) {
			ClassifyException classifyEx = new ClassifyException(ERR_CAT_VALUE_UNASSIGN, e);
			log(classifyEx, method, null);
			throw classifyEx;
		}
		finally {
			exit(method, null);
		}
	}

	/** @see com.sap.caf.km.ejb.svc.idxsearch.IIndexSearchClassify#removeClassification(java.util.Collection, java.lang.String)
	 */
	public void removeClassification(Collection valueGUIDs, String BOGUID) throws ClassifyException {
		final String method = JARM_REQUEST + ":removeClassification(Collection, String)";
		enter(method, new Object[] { valueGUIDs, BOGUID });
		try {
			m_clsHelper.removeClassification(valueGUIDs, BOGUID);
		}
		catch (Exception e) {
			ClassifyException classifyEx = new ClassifyException(ERR_CAT_VALUE_UNASSIGN_MANY, e);
			log(classifyEx, method, null);
			throw classifyEx;
		}
		finally {
			exit(method, null);
		}
	}

	/** @see com.sap.caf.km.ejb.svc.idxsearch.IIndexSearchClassify#getClassification(java.lang.String)
	 */
	public Collection getClassification(String BOGUID) throws ClassifyException {
		final String method = JARM_REQUEST + ":getClassification(String)";
		enter(method, new Object[] { BOGUID });
		try {
			Collection keys = m_clsHelper.getClassification(BOGUID);
			return keys;
		}
		catch (Exception e) {
			ClassifyException classifyEx = new ClassifyException(ERR_CAT_GET_VALUES, e);
			log(classifyEx, method, null);
			throw classifyEx;
		}
		finally {
			exit(method, null);
		}
	}

	/** @see com.sap.caf.km.ejb.svc.idxsearch.IIndexSearchClassify#getClassification(java.lang.String)
	 */
	public Collection getClassification(String BOGUID, String categoryGUID) throws ClassifyException {
		final String method = JARM_REQUEST + ":getClassification(String, String)";
		enter(method, new Object[] { BOGUID, categoryGUID });
		try {
			Collection keys = m_clsHelper.getClassification(BOGUID, categoryGUID);
			return keys;
		}
		catch (Exception e) {
			ClassifyException classifyEx = new ClassifyException(ERR_CAT_GET_VALUES, e);
			log(classifyEx, method, null);
			throw classifyEx;
		}
		finally {
			exit(method, null);
		}
	}

	public Collection getAssignedClassification(String BOName) throws ClassifyException {
			final String method = JARM_REQUEST + ":getAssignedClassification(String)";
			enter(method, new Object[] { BOName});
		
			try {
				if (BOName == null){
					return m_clsHelper.getAssignedClassification(null) ;
				}else{
					String masterTable = getTableByBOName(BOName) ;
					Collection coll = m_clsHelper.getAssignedClassification(masterTable) ;			
					return coll ;
				}
			}
			catch (Exception e) {
				ClassifyException classifyEx = new ClassifyException(ERR_CAT_GET_VALUES, e);
				log(classifyEx, method, null);
				throw classifyEx;
			}
			finally {
				exit(method, null);
			}
		}
	
	/** @see com.sap.caf.km.ejb.svc.idxsearch.IIndexSearchClassify#isUsedInClassification(java.lang.String)
	 */
	public boolean isUsedInClassification(String valueGUID) throws ClassifyException {
		final String method = JARM_REQUEST + ":isUsedInClassification(String)";
		enter(method, new Object[] { valueGUID });
		try {
			return m_clsHelper.isUsedInClassification(valueGUID);
		}
		catch (Exception e) {
			ClassifyException classifyEx = new ClassifyException(ERR_CAT_VALUE_CHECK, e);
			log(classifyEx, method, null);
			throw classifyEx;
		}
		finally {
			exit(method, null);
		}
	}

	/** @see com.sap.caf.km.ejb.svc.idxsearch.IIndexSearchClassify#removeClassification(java.lang.String)
	 */
	public void removeClassification(String valueGUID) throws ClassifyException {
		final String method = JARM_REQUEST + ":removeClassification(String)";
		enter(method, new Object[] { valueGUID });
		try {
			Collection valueGUIDs = new ArrayList();
			valueGUIDs.add(valueGUID);
			m_clsHelper.removeClassification(valueGUIDs);
		}
		catch (Throwable e) {
			//$JL-EXC$ ignore JLin warning
			ClassifyException classifyEx = new ClassifyException(ERR_CAT_VALUE_DELETE, e);
			log(classifyEx, method, null);
			throw classifyEx;
		}
		finally {
			exit(method, null);
		}
	}

	/** @see com.sap.caf.km.ejb.svc.idxsearch.IIndexSearchClassify#removeClassification(java.util.Collection)
	 */
	public void removeClassification(Collection valueGUIDs) throws ClassifyException {
		final String method = JARM_REQUEST + ":removeClassification(Collection)";
		enter(method, new Object[] { valueGUIDs });
		try {
			m_clsHelper.removeClassification(valueGUIDs);
		}
		catch (Throwable e) {
			//$JL-EXC$ ignore JLin warning
			ClassifyException classifyEx = new ClassifyException(ERR_CAT_VALUE_DELETE_MANY, e);
			log(classifyEx, method, null);
			throw classifyEx;
		}
		finally {
			exit(method, null);
		}
	}

	/** @see com.sap.caf.km.ejb.svc.idxsearch.IIndexSearchClassify#getTaxonomyRepositoryPrefix()
	 */
	public String getTaxonomyRepositoryPrefix() throws ClassifyException {
		synchronized (this) {
			final String method = JARM_REQUEST + ":getTaxonomyRepositoryPrefix()";
			enter(method, null);
			try {
				if (m_sTaxonomyPrefix == null) {
					m_sTaxonomyPrefix = m_classifySvc.getTaxonomyRepositoryPrefix();
				}
				return m_sTaxonomyPrefix;
			}
			finally {
				exit(method, null);
			}
		}
	}

	// --- IIndexSearchSearch methods ---

	/**
	 * @see com.sap.caf.km.ejb.svc.idxsearch.IIndexSearchSearch#searchForGlobalDoc(java.util.Collection)
	 */
	public Collection searchForGlobalDoc(Collection queryEntryCollection) throws SearchException {
		final String method = JARM_REQUEST + ":searchForGlobalDoc(Collection)";
		enter(method, new Object[] { queryEntryCollection });
		try {
			if (queryEntryCollection == null || queryEntryCollection.size() == 0) {
				SearchException searchEx = new SearchException(ERR_SEARCH_PARAMS);
				log(searchEx, method, null);
				throw searchEx;
			}
			List globalIndeces = getIndices(m_accessor.getKMBODocumentName(), IIndex.TYPE_KM_BO_GLOBAL);
			if (globalIndeces == null || globalIndeces.size() == 0) {
				return EMPTY_SEARCH_RESULT;
			}
			ISearchResult[] found =
				m_searchSvc.searchForGlobalResource(
					(ISearchEntry[]) queryEntryCollection.toArray(new SearchEntry[0]),
					(String[]) globalIndeces.toArray(new String[0]),
					m_max_search_results);
			return Arrays.asList(found);
		}
		catch (Exception e) {
			SearchException searchEx = new SearchException(ERR_SEARCH_GLOBAL_DOCUMENTS, e);
			log(searchEx, method, null);
			throw searchEx;
		}
		finally {
			exit(method, null);
		}
	}

	/**
	 * @see com.sap.caf.km.ejb.svc.idxsearch.IIndexSearchSearch#searchForGlobalDoc(java.util.Collection, java.lang.String)
	 */
	public Collection searchForGlobalDoc(Collection queryEntryCollection, String startFolderRIDForSearch)
		throws SearchException {

		final String method = JARM_REQUEST + ":searchForGlobalDoc(Collection, String)";
		enter(method, new Object[] { queryEntryCollection, startFolderRIDForSearch });
		try {
			if (queryEntryCollection == null || queryEntryCollection.size() == 0) {
				SearchException searchEx = new SearchException(ERR_SEARCH_PARAMS);
				log(searchEx, method, null);
				throw searchEx;
			}
			List globalIndeces = getIndices(m_accessor.getKMBODocumentName(), IIndex.TYPE_KM_BO_GLOBAL);
			if (globalIndeces == null || globalIndeces.size() == 0) {
				return EMPTY_SEARCH_RESULT;
			}
			ISearchResult[] found =
				m_searchSvc.searchForGlobalResource(
					(ISearchEntry[]) queryEntryCollection.toArray(new SearchEntry[0]),
					(String[]) globalIndeces.toArray(new String[0]),
					startFolderRIDForSearch,
					m_max_search_results);
			return Arrays.asList(found);
		}
		catch (Exception e) {
			SearchException searchEx = new SearchException(ERR_SEARCH_GLOBAL_DOCUMENTS, e);
			log(searchEx, method, null);
			throw searchEx;
		}
		finally {
			exit(method, null);
		}
	}

	/**
	 * @see com.sap.caf.km.ejb.svc.idxsearch.IIndexSearchSearch#searchForGlobalTasks(java.util.Collection)
	 */
	public Collection searchForGlobalTasks(Collection queryEntryCollection) throws SearchException {
		final String method = JARM_REQUEST + ":searchForGlobalTasks(Collection)";
		enter(method, new Object[] { queryEntryCollection });
		try {
			if (queryEntryCollection == null || queryEntryCollection.size() == 0) {
				SearchException searchEx = new SearchException(ERR_SEARCH_PARAMS);
				log(searchEx, method, null);
				throw searchEx;
			}
			List globalIndeces = getIndices(m_accessor.getKMBOTaskName(), IIndex.TYPE_KM_BO_GLOBAL);
			if (globalIndeces == null || globalIndeces.size() == 0) {
				return EMPTY_SEARCH_RESULT;
			}
			ISearchResult[] found =
				m_searchSvc.searchForGlobalResource(
					(ISearchEntry[]) queryEntryCollection.toArray(new SearchEntry[0]),
					(String[]) globalIndeces.toArray(new String[0]),
					m_max_search_results);
			return Arrays.asList(found);
		}
		catch (Exception e) {
			SearchException searchEx = new SearchException(ERR_SEARCH_GLOBAL_TASKS, e);
			log(searchEx, method, null);
			throw searchEx;
		}
		finally {
			exit(method, null);
		}
	}

	/**
	 * @see com.sap.caf.km.ejb.svc.idxsearch.IIndexSearchSearch#searchForGlobalTasks(java.util.Collection, java.lang.String)
	 */
	public Collection searchForGlobalTasks(Collection queryEntryCollection, String startFolderRIDForSearch)
		throws SearchException {
		final String method = JARM_REQUEST + ":searchForGlobalTasks(Collection, String)";
		enter(method, new Object[] { queryEntryCollection, startFolderRIDForSearch });
		try {
			if (queryEntryCollection == null || queryEntryCollection.size() == 0) {
				SearchException searchEx = new SearchException(ERR_SEARCH_PARAMS);
				log(searchEx, method, null);
				throw searchEx;
			}
			List globalIndeces = getIndices(m_accessor.getKMBOTaskName(), IIndex.TYPE_KM_BO_GLOBAL);
			if (globalIndeces == null || globalIndeces.size() == 0) {
				return EMPTY_SEARCH_RESULT;
			}
			ISearchResult[] found =
				m_searchSvc.searchForGlobalResource(
					(ISearchEntry[]) queryEntryCollection.toArray(new SearchEntry[0]),
					(String[]) globalIndeces.toArray(new String[0]),
					startFolderRIDForSearch,
					m_max_search_results);
			return Arrays.asList(found);
		}
		catch (Exception e) {
			SearchException searchEx = new SearchException(ERR_SEARCH_GLOBAL_TASKS, e);
			log(searchEx, method, null);
			throw searchEx;
		}
		finally {
			exit(method, null);
		}
	}

	/**
	 * @see com.sap.caf.km.ejb.svc.idxsearch.IIndexSearchSearch#searchForCAFBO(java.util.Collection, java.util.Collection)
	 */
	public Collection searchForCAFBO(Collection queryEntryCollection, Collection BONames) throws SearchException {
		final String method = JARM_REQUEST + ":searchForCAFBO(Collection, Collection)";
		enter(method, new Object[] { queryEntryCollection, BONames });
		try {
			if (queryEntryCollection == null || queryEntryCollection.size() == 0 || BONames == null || BONames.size() == 0) {
				SearchException searchEx = new SearchException(ERR_SEARCH_PARAMS);
				log(searchEx, method, null);
				throw searchEx;
			}
			List ownIndeces = getIndeces(BONames, IIndex.TYPE_CAF_BO_OWN);
			if (ownIndeces == null || ownIndeces.size() == 0) {
				return EMPTY_SEARCH_RESULT;
			}
			ISearchResult[] found =
				m_searchSvc.searchForBO(
					(ISearchEntry[]) queryEntryCollection.toArray(new SearchEntry[0]),
					(String[]) ownIndeces.toArray(new String[0]),
					m_max_search_results);
			return Arrays.asList(found);
		}
		catch (Exception e) {
			SearchException searchEx = new SearchException(ERR_SEARCH_CAF_BO, e);
			log(searchEx, method, null);
			throw searchEx;
		}
		finally {
			exit(method, null);
		}
	}

	/**
	 * @see com.sap.caf.km.ejb.svc.idxsearch.IIndexSearchSearch#searchForRelatedDocument(java.util.Collection, java.util.Collection)
	 */
	public Collection searchForRelatedDocument(Collection queryEntryCollection, Collection BONames) throws SearchException {
		final String method = JARM_REQUEST + ":searchForRelatedDocument(Collection, Collection)";
		enter(method, new Object[] { queryEntryCollection, BONames });
		try {
			if (queryEntryCollection == null || queryEntryCollection.size() == 0 || BONames == null || BONames.size() == 0) {
				SearchException searchEx = new SearchException(ERR_SEARCH_PARAMS);
				log(searchEx, method, null);
				throw searchEx;
			}
			List relatedIndeces = getIndeces(BONames, IIndex.TYPE_CAF_BO_RELATED);
			if (relatedIndeces == null || relatedIndeces.size() == 0) {
				return EMPTY_SEARCH_RESULT;
			}
			ISearchResult[] found =
				m_searchSvc.searchForRelatedResource(
					(ISearchEntry[]) queryEntryCollection.toArray(new SearchEntry[0]),
					(String[]) relatedIndeces.toArray(new String[0]),
					IIndexSearchSearchSvc.SEARCH_RESULT_DOCUMENT,
					m_max_search_results);
			return Arrays.asList(found);
		}
		catch (Exception e) {
			SearchException searchEx = new SearchException(ERR_SEARCH_RELATED_DOCUMENTS, e);
			log(searchEx, method, null);
			throw searchEx;
		}
		finally {
			exit(method, null);
		}
	}

	/**
	 * @see com.sap.caf.km.ejb.svc.idxsearch.IIndexSearchSearch#searchForCAFBOAndRelatedRes(java.util.Collection, java.util.Collection, java.util.Collection, int)
	 */
	public Collection searchForCAFBOAndRelatedRes(
		Collection queryEntryCollectionCAF,
		Collection queryEntryCollectionKM,
		Collection BONames,
		int searchKMType)
		throws SearchException {
		final String method = JARM_REQUEST + ":searchForCAFBOAndRelatedRes(Collection, Collection, Collection, int)";
		enter(method, new Object[] { queryEntryCollectionCAF, queryEntryCollectionKM, BONames, new Integer(searchKMType)});
		try {
			if (queryEntryCollectionCAF == null
				|| queryEntryCollectionCAF.size() == 0
				|| queryEntryCollectionKM == null
				|| queryEntryCollectionKM.size() == 0
				|| BONames == null
				|| BONames.size() == 0) {
				SearchException searchEx = new SearchException(ERR_SEARCH_PARAMS);
				log(searchEx, method, null);
				throw searchEx;
			}
			// search in own indeces
			ISearchResult[] foundInOwn = null;
			List ownIndeces = getIndeces(BONames, IIndex.TYPE_CAF_BO_OWN);
			if (ownIndeces != null && ownIndeces.size() > 0) {
				foundInOwn =
					m_searchSvc.searchForBO(
						(ISearchEntry[]) queryEntryCollectionCAF.toArray(new SearchEntry[0]),
						(String[]) ownIndeces.toArray(new String[0]),
						m_max_search_results);
			}

			// search in related indeces
			ISearchResult[] foundInRelated = null;
			List relatedIndeces = getIndeces(BONames, IIndex.TYPE_CAF_BO_RELATED);
			if (relatedIndeces != null && relatedIndeces.size() > 0) {
				foundInRelated =
					m_searchSvc.searchForRelatedResource(
						(ISearchEntry[]) queryEntryCollectionKM.toArray(new SearchEntry[0]),
						(String[]) relatedIndeces.toArray(new String[0]),
						searchKMType,
						m_max_search_results);
			}

			return mergeToList(foundInOwn, foundInRelated);
		}
		catch (Exception e) {
			SearchException searchEx = new SearchException(ERR_SEARCH_CAF_BO_AND_RELATED, e);
			log(searchEx, method, null);
			throw searchEx;
		}
		finally {
			exit(method, null);
		}
	}

	/**
	 * @see com.sap.caf.km.ejb.svc.idxsearch.IIndexSearchSearch#searchForRelatedTask(java.util.Collection, java.util.Collection)
	 */
	public Collection searchForRelatedTask(Collection queryEntryCollection, Collection BONames) throws SearchException {
		final String method = JARM_REQUEST + ":searchForRelatedTask(Collection, Collection)";
		enter(method, new Object[] { queryEntryCollection, BONames });
		try {
			if (queryEntryCollection == null || queryEntryCollection.size() == 0 || BONames == null || BONames.size() == 0) {
				SearchException searchEx = new SearchException(ERR_SEARCH_PARAMS);
				log(searchEx, method, null);
				throw searchEx;
			}
			List relatedIndeces = getIndeces(BONames, IIndex.TYPE_CAF_BO_RELATED);
			if (relatedIndeces == null || relatedIndeces.size() == 0) {
				return EMPTY_SEARCH_RESULT;
			}
			ISearchResult[] results =
				m_searchSvc.searchForRelatedResource(
					(ISearchEntry[]) queryEntryCollection.toArray(new SearchEntry[0]),
					(String[]) relatedIndeces.toArray(new String[0]),
					IIndexSearchSearchSvc.SEARCH_RESULT_TASK,
					m_max_search_results);
			return Arrays.asList(results);
		}
		catch (Exception e) {
			SearchException searchEx = new SearchException(ERR_SEARCH_RELATED_TASKS, e);
			log(searchEx, method, null);
			throw searchEx;
		}
		finally {
			exit(method, null);
		}
	}

	/**
	 * @see com.sap.caf.km.ejb.svc.idxsearch.IIndexSearchSearch#searchForAllCAFBO(java.util.Collection)
	 */
	public Collection searchForAllCAFBO(Collection queryEntryCollection) throws SearchException {
		final String method = JARM_REQUEST + ":searchForAllCAFBO(Collection)";
		enter(method, new Object[] { queryEntryCollection });
		try {
			if (queryEntryCollection == null || queryEntryCollection.size() == 0) {
				SearchException searchEx = new SearchException(ERR_SEARCH_PARAMS);
				log(searchEx, method, null);
				throw searchEx;
			}
			List ownIndeces = getIndeces(m_accessor.getCAFBONames(), IIndex.TYPE_CAF_BO_OWN);
			if (ownIndeces == null || ownIndeces.size() == 0) {
				return EMPTY_SEARCH_RESULT;
			}
			ISearchResult[] results =
				m_searchSvc.searchForBO(
					(ISearchEntry[]) queryEntryCollection.toArray(new SearchEntry[0]),
					(String[]) ownIndeces.toArray(new String[0]),
					m_max_search_results);
			return Arrays.asList(results);
		}
		catch (Exception e) {
			SearchException searchEx = new SearchException(ERR_SEARCH_CAF_BO, e);
			log(searchEx, method, null);
			throw searchEx;
		}
		finally {
			exit(method, null);
		}
	}

	/**
	 * @see com.sap.caf.km.ejb.svc.idxsearch.IIndexSearchSearch#searchForAllKMBO(java.util.Collection)
	 */
	public Collection searchForAllKMBO(Collection queryEntryCollection) throws SearchException {
		final String method = JARM_REQUEST + ":searchForAllKMBO(Collection)";
		enter(method, new Object[] { queryEntryCollection });
		try {
			if (queryEntryCollection == null || queryEntryCollection.size() == 0) {
				SearchException searchEx = new SearchException(ERR_SEARCH_PARAMS);
				log(searchEx, method, null);
				throw searchEx;
			}
			List globalIndeces = getIndeces(Arrays.asList(m_accessor.getKMBONames()), IIndex.TYPE_KM_BO_GLOBAL);
			if (globalIndeces == null || globalIndeces.size() == 0) {
				return EMPTY_SEARCH_RESULT;
			}
			ISearchResult[] results =
				m_searchSvc.searchForGlobalResource(
					(ISearchEntry[]) queryEntryCollection.toArray(new SearchEntry[0]),
					(String[]) globalIndeces.toArray(new String[0]),
					m_max_search_results);
			return Arrays.asList(results);
		}
		catch (Exception e) {
			SearchException searchEx = new SearchException(ERR_SEARCH_KM_BO, e);
			log(searchEx, method, null);
			throw searchEx;
		}
		finally {
			exit(method, null);
		}
	}

	/**
	 * @see com.sap.caf.km.ejb.svc.idxsearch.IIndexSearchSearch#searchForAllBO(java.util.Collection)
	 */
	public Collection searchForAllBO(Collection queryEntryCollection) throws SearchException {
		final String method = JARM_REQUEST + ":searchForAllBO(queryEntryCollection)";
		enter(method, new Object[] { queryEntryCollection });
		try {
			if (queryEntryCollection == null || queryEntryCollection.size() == 0) {
				SearchException searchEx = new SearchException(ERR_SEARCH_PARAMS);
				log(searchEx, method, null);
				throw searchEx;
			}
			ISearchEntry[] searchEntries = (ISearchEntry[]) queryEntryCollection.toArray(new SearchEntry[0]);
			// search for all KM BOs
			ISearchResult[] foundInGlobal = null;
			List globalIndeces = getIndeces(Arrays.asList(m_accessor.getKMBONames()), IIndex.TYPE_KM_BO_GLOBAL);
			if (globalIndeces != null && globalIndeces.size() > 0) {
				foundInGlobal =
					m_searchSvc.searchForGlobalResource(
						searchEntries,
						(String[]) globalIndeces.toArray(new String[0]),
						m_max_search_results);
			}
			// search for all CAF BOs
			ISearchResult[] foundInOwn = null;
			List ownIndeces = getIndeces(m_accessor.getCAFBONames(), IIndex.TYPE_CAF_BO_OWN);
			if (ownIndeces != null && ownIndeces.size() > 0) {
				foundInOwn = m_searchSvc.searchForBO(searchEntries, (String[]) ownIndeces.toArray(new String[0]), m_max_search_results);
			}
			return mergeToList(foundInGlobal, foundInOwn);
		}
		catch (Exception e) {
			SearchException searchEx = new SearchException(ERR_SEARCH_ALL_BO, e);
			log(searchEx, method, null);
			throw searchEx;
		}
		finally {
			exit(method, null);
		}
	}

	/**
	 * @see com.sap.caf.km.ejb.svc.idxsearch.IIndexSearchSearch#searchForSimilarCAF(java.lang.String, int)
	 */
	public Collection searchForSimilarCAF(String resourceRid, int maxResults) throws SearchException {
		final String method = JARM_REQUEST + ":searchForSimilarCAF(String, int)";
		enter(method, new Object[] { resourceRid, new Integer(maxResults)});
		try {
			if (resourceRid == null) {
				SearchException searchEx = new SearchException(ERR_SEARCH_PARAMS);
				log(searchEx, method, null);
				throw searchEx;
			}
			List ownIndeces = getIndeces(m_accessor.getCAFBONames(), IIndex.TYPE_CAF_BO_OWN);
			if (ownIndeces == null || ownIndeces.size() == 0) {
				return EMPTY_SEARCH_RESULT;
			}
			ISearchResult[] results =
				m_searchSvc.searchForSimilar(resourceRid, (String[]) ownIndeces.toArray(new String[0]), maxResults);
			return Arrays.asList(results);
		}
		catch (Exception e) {
			SearchException searchEx = new SearchException(ERR_SEARCH_CAF_BO_SIMILAR, e);
			log(searchEx, method, null);
			throw searchEx;
		}
		finally {
			exit(method, null);
		}
	}

	/**
	 * @see com.sap.caf.km.ejb.svc.idxsearch.IIndexSearchSearch#searchForSimilarKM(java.lang.String, boolean)
	 */
	public Collection searchForSimilarKM(String resourceRid, boolean useGlobalIndex) throws SearchException {
		final String method = JARM_REQUEST + ":searchForSimilarKM(String, boolean)";
		enter(method, new Object[] { resourceRid, new Boolean(useGlobalIndex)});
		try {
			if (resourceRid == null) {
				SearchException searchEx = new SearchException(ERR_SEARCH_PARAMS);
				log(searchEx, method, null);
				throw searchEx;
			}
			List globalIndeces = getIndeces(Arrays.asList(m_accessor.getKMBONames()), IIndex.TYPE_KM_BO_GLOBAL);
			if (globalIndeces == null || globalIndeces.size() == 0) {
				return EMPTY_SEARCH_RESULT;
			}
			ISearchResult[] results =
				m_searchSvc.searchForSimilar(resourceRid, (String[]) globalIndeces.toArray(new String[0]), m_max_search_results);
			return Arrays.asList(results);
		}
		catch (Exception e) {
			SearchException searchEx = new SearchException(ERR_SEARCH_KM_BO_SIMILAR, e);
			log(searchEx, method, null);
			throw searchEx;
		}
		finally {
			exit(method, null);
		}
	}

	public Collection searchForBO(String attribute, String freeText, String BOName, boolean isAttribute) throws SearchException {
		final String method = JARM_REQUEST + ":searchForBO(String, String, String, boolean)";
		enter(method, new Object[] { attribute, freeText, BOName, new Boolean(isAttribute)});
		try {
			if (BOName == null || (attribute == null && freeText == null)) {
				SearchException searchEx = new SearchException(ERR_SEARCH_PARAMS);
				log(searchEx, method, null);
				throw searchEx;
			}
			boolean isBOKM = m_accessor.isBOKM(BOName);
			List indeces = getIndices(BOName, isBOKM ? IIndex.TYPE_KM_BO_GLOBAL : IIndex.TYPE_CAF_BO_OWN);
			if (indeces == null || indeces.size() == 0) {
				return EMPTY_SEARCH_RESULT;
			}

			ISearchEntry searchEntry = new SearchEntry();
			String[] result = convertAttribute(attribute, isAttribute);
			searchEntry.setPropertyNamespace(result[0]);
			searchEntry.setPropertyName(result[1]);
			searchEntry.setValueAsString(freeText);
			searchEntry.setValueType(ISearchEntry.VALUE_TYPE_STRING);
			searchEntry.setTermAction(ISearchEntry.TERM_ACTION_LINGUISTIC);
			searchEntry.setTermWeight(1.0F);
			searchEntry.setRowType(ISearchEntry.ROW_TYPE_ATTRIBUTE);
			ISearchEntry[] searchEntries = new ISearchEntry[1];
			searchEntries[0] = searchEntry;

			ISearchResult[] found =
				isBOKM
					? m_searchSvc.searchForGlobalResource(searchEntries, (String[]) indeces.toArray(new String[0]), m_max_search_results)
					: m_searchSvc.searchForBO(searchEntries, (String[]) indeces.toArray(new String[0]), m_max_search_results);
			return Arrays.asList(found);
		}
		catch (Exception e) {
			SearchException searchEx = new SearchException(ERR_SEARCH_BO, e);
			log(searchEx, method, null);
			throw searchEx;
		}
		finally {
			exit(method, null);
		}
	}

	public Collection searchForBO(
		Collection collAttributesAsString,
		Collection collCategoriesAsString,
		String freeText,
		String BOName)
		throws SearchException {
		final String method = JARM_REQUEST + ":searchForBO(Collection, Collection, String, String)";
		enter(method, new Object[] { collAttributesAsString, collAttributesAsString, freeText, BOName });
		try {
			if (BOName == null) {
				SearchException searchEx = new SearchException(ERR_SEARCH_PARAMS);
				log(searchEx, method, null);
				throw searchEx;
			}

			if (collAttributesAsString == null)
				collAttributesAsString = new ArrayList();

			if (collCategoriesAsString == null)
				collCategoriesAsString = new ArrayList();

			if (collAttributesAsString.size() == 0 && collCategoriesAsString.size() == 0) {
				SearchException searchEx = new SearchException(ERR_SEARCH_PARAMS);
				log(searchEx, method, null);
				throw searchEx;
			}

			boolean isBOKM = m_accessor.isBOKM(BOName);
			List indeces = getIndices(BOName, isBOKM ? IIndex.TYPE_KM_BO_GLOBAL : IIndex.TYPE_CAF_BO_OWN);
			if (indeces == null || indeces.size() == 0) {
				return EMPTY_SEARCH_RESULT;
			}
			ISearchEntry[] searchEntries = createSearchEntries(collAttributesAsString, freeText, true);
			ISearchEntry[] searchEntries2 = createSearchEntries(collCategoriesAsString, freeText, false);
			ISearchEntry[] result = new SearchEntry[searchEntries.length + searchEntries2.length];
			System.arraycopy(searchEntries, 0, result, 0, searchEntries.length);
			System.arraycopy(searchEntries2, 0, result, searchEntries.length, searchEntries2.length);

			ISearchResult[] found =
				isBOKM
					? m_searchSvc.searchForGlobalResource(searchEntries, (String[]) indeces.toArray(new String[0]), m_max_search_results)
					: m_searchSvc.searchForBO(result, (String[]) indeces.toArray(new String[0]), m_max_search_results);
			return Arrays.asList(found);
		}
		catch (Exception e) {
			SearchException searchEx = new SearchException(ERR_SEARCH_BO, e);
			log(searchEx, method, null);
			throw searchEx;
		}
		finally {
			exit(method, null);
		}
	}

	public Collection searchForBO(
		Map hashMapofAttributesAsStringAndfreeText,
		Map hashMapofCategoriesAsStringAndfreeText,
		String BOName)
		throws SearchException {
		final String method = JARM_REQUEST + ":searchForBO(Map, Map, String)";
		enter(method, new Object[] { hashMapofAttributesAsStringAndfreeText, hashMapofCategoriesAsStringAndfreeText, BOName });
		try {
			if (BOName == null) {
				SearchException searchEx = new SearchException(ERR_SEARCH_PARAMS);
				log(searchEx, method, null);
				throw searchEx;
			}

			if (hashMapofAttributesAsStringAndfreeText == null)
				hashMapofAttributesAsStringAndfreeText = new HashMap();

			if (hashMapofCategoriesAsStringAndfreeText == null)
				hashMapofCategoriesAsStringAndfreeText = new HashMap();

			if (hashMapofAttributesAsStringAndfreeText.size() == 0 && hashMapofCategoriesAsStringAndfreeText.size() == 0) {
				SearchException searchEx = new SearchException(ERR_SEARCH_PARAMS);
				log(searchEx, method, null);
				throw searchEx;
			}

			boolean isBOKM = m_accessor.isBOKM(BOName);
			List indeces = getIndices(BOName, isBOKM ? IIndex.TYPE_KM_BO_GLOBAL : IIndex.TYPE_CAF_BO_OWN);
			if (indeces == null || indeces.size() == 0) {
				return EMPTY_SEARCH_RESULT;
			}

			ISearchEntry[] searchEntries = createSearchEntries(hashMapofAttributesAsStringAndfreeText, true);
			ISearchEntry[] searchEntries2 = createSearchEntries(hashMapofCategoriesAsStringAndfreeText, false);
			ISearchEntry[] result = new SearchEntry[searchEntries.length + searchEntries2.length];
			System.arraycopy(searchEntries, 0, result, 0, searchEntries.length);
			System.arraycopy(searchEntries2, 0, result, searchEntries.length, searchEntries2.length);

			ISearchResult[] found =
				isBOKM
					? m_searchSvc.searchForGlobalResource(searchEntries, (String[]) indeces.toArray(new String[0]), m_max_search_results)
					: m_searchSvc.searchForBO(result, (String[]) indeces.toArray(new String[0]), m_max_search_results);
			return Arrays.asList(found);
		}
		catch (Exception e) {
			SearchException searchEx = new SearchException(ERR_SEARCH_BO, e);
			log(searchEx, method, null);
			throw searchEx;
		}
		finally {
			exit(method, null);
		}
	}

	public Collection searchForRelatedDoc(Collection collAttributesAsString, String freeText, String BOName)
		throws SearchException {
		final String method = JARM_REQUEST + ":searchForRelatedDoc(Collection, String, String)";
		enter(method, new Object[] { collAttributesAsString, freeText, BOName });
		try {
			if (BOName == null || ((collAttributesAsString == null || collAttributesAsString.size() == 0) && freeText == null)) {
				SearchException searchEx = new SearchException(ERR_SEARCH_PARAMS);
				log(searchEx, method, null);
				throw searchEx;
			}
			List relatedIndeces = getIndices(BOName, IIndex.TYPE_CAF_BO_RELATED);
			if (relatedIndeces == null || relatedIndeces.size() == 0) {
				return EMPTY_SEARCH_RESULT;
			}
			ISearchResult[] found =
				m_searchSvc.searchForRelatedResource(
					createSearchEntries(collAttributesAsString, freeText, true),
					(String[]) relatedIndeces.toArray(new String[relatedIndeces.size()]),
					IIndexSearchSearchSvc.SEARCH_RESULT_DOCUMENT,
					m_max_search_results);
			return Arrays.asList(found);
		}
		catch (Exception e) {
			SearchException searchEx = new SearchException(ERR_SEARCH_RELATED_DOCUMENTS, e);
			log(searchEx, method, null);
			throw searchEx;
		}
		finally {
			exit(method, null);
		}
	}

	public Collection searchForBOInRelatedDoc(Collection collAttributesAsString, String freeText, String BOName)
		throws SearchException {
		final String method = JARM_REQUEST + ":searchForBOInRelatedDoc(Collection, String, String)";
		enter(method, new Object[] { collAttributesAsString, freeText, BOName });
		try {
			if (BOName == null || ((collAttributesAsString == null || collAttributesAsString.size() == 0) && freeText == null)) {
				SearchException searchEx = new SearchException(ERR_SEARCH_PARAMS);
				log(searchEx, method, null);
				throw searchEx;
			}
			String prefix = CAFContext.KM_REPOSITORY;
			List relatedIndeces = getIndices(BOName, IIndex.TYPE_CAF_BO_RELATED);
			if (relatedIndeces == null || relatedIndeces.size() == 0) {
				return EMPTY_SEARCH_RESULT;
			}

			// get collection of related documents
			Collection docs = this.searchForRelatedDoc(collAttributesAsString, freeText, BOName);
			if (docs == null || docs.isEmpty()) {
				return EMPTY_SEARCH_RESULT;
			}
			// get MOfId (BO type GUID)
			String sBOTypeGuid = m_accessor.getGUID(BOName);
			if (sBOTypeGuid == null) {
				throw new NullPointerException("MofId of [" + BOName + "] could not be found in cache!");
			}
			// iterated thru found documents
			KMSearchResultLocal result;
			Collection results = new ArrayList();
			for (Iterator it = docs.iterator(); it.hasNext();) {
				ISearchResult searchRes = (ISearchResult) it.next();
				String sRid = searchRes.getRid();
				String sBOGuid = searchRes.getBOGuid();
				String sType = searchRes.getBOName();
//				filter related object rid by object type
				if (sBOTypeGuid.equals(sType)) { 				
					result = new KMSearchResultLocal();
					result.setRid(sRid);
					result.setBOGuid(sBOGuid);
					results.add(result);
				}
			}
			return results;
		}
		catch (Exception e) {
			SearchException searchEx = new SearchException(ERR_SEARCH_RELATED_BO, e);
			log(searchEx, method, null);
			throw searchEx;
		}
		finally {
			exit(method, null);
		}
	}

	// Protected utility methods
	protected List getIndeces(Collection BONames, int indexType) throws IndexException, SQLException {
		final String method = JARM_REQUEST + ":getIndeces(Collection, int)";
		enter(method, new Object[] { BONames, new Integer(indexType)});
		try {
			if (!m_idxHelper.checkAtLeastOneIndexExist(BONames, indexType)) {
				return null;
			}
			// determine required indexeses
			IIndex index;
			IIndex[] allIndeces = getAllIndexes();
			List boIndeces = new ArrayList();
			String BOName;
			String indexName;
			for (Iterator j = BONames.iterator(); j.hasNext();) {
				BOName = (String) j.next();
				for (int i = 0; i < allIndeces.length; i++) {
					index = allIndeces[i];
					if (index.getType() == indexType && BOName.equals(index.getBOName())) {
						indexName = index.getName();
						boIndeces.add(indexName);
						info(method, "index name:[{0}]", new Object[] { indexName });
					}
				}
			}
			return boIndeces;
		}
		finally {
			exit(method, null);
		}
	}

	protected List getIndices(String BOName, int indexType) throws IndexException, SQLException {
		final String method = JARM_REQUEST + ":getIndeces(String, int)";
		enter(method, new Object[] { BOName, new Integer(indexType)});
		try {
			if (!m_idxHelper.checkIndexExist(BOName, indexType)) {
				return null;
			}
			// determine required indexeses
			IIndex index;
			IIndex[] allIndeces = getAllIndexes();
			List boIndeces = new ArrayList();
			for (int i = 0; i < allIndeces.length; i++) {
				index = allIndeces[i];
				if (index.getType() == indexType && BOName.equals(index.getBOName())) {
					boIndeces.add(index.getName());
				}
			}
			return boIndeces;
		}
		finally {
			exit(method, null);
		}
	}

	protected ISearchEntry[] createSearchEntries(Collection attributes, String text, boolean isAttribute) {
		final String method = JARM_REQUEST + ":createSearchEntries(Collection, String)";
		enter(method, new Object[] { attributes, text, new Boolean(isAttribute)});
		try {
			StringTokenizer strTokenizer = new StringTokenizer(text);

			//caclulate result array size
			//take into account AND operator before each attribute
			int size = strTokenizer.countTokens() * 2 - 1 + attributes.size() * 2;

			ISearchEntry[] searchEntries = new ISearchEntry[size];
			ISearchEntry searchEntry;

			//add each token as SearchEntry 
			int entryNumber = -1;
			while (strTokenizer.hasMoreTokens()) {
				// generate entry for every token
				searchEntry = buildStringSearchEntry(strTokenizer.nextToken());
				searchEntries[++entryNumber] = searchEntry;

				if (strTokenizer.hasMoreTokens()) {
					// generate AND operator if more token exists
					searchEntry = buildOperatorSearchEntry(ISearchEntry.OPERATOR_AND);
					searchEntries[++entryNumber] = searchEntry;
				}
			}

			// add other attributes
			for (Iterator i = attributes.iterator(); i.hasNext();) {
				// generate AND operator			
				searchEntry = buildOperatorSearchEntry(ISearchEntry.OPERATOR_AND);
				searchEntries[++entryNumber] = searchEntry;
				// generate entry for an attribute
				searchEntry = buildPropertySearchEntry((String) i.next(), text, isAttribute);
				searchEntries[++entryNumber] = searchEntry;
			}
			return searchEntries;
		}
		finally {
			exit(method, null);
		}
	}

	protected ISearchEntry[] createSearchEntries(Map attributesAndTexts, boolean isAttribute) {
		final String method = JARM_REQUEST + ":createSearchEntries(Map, boolean)";
		enter(method, new Object[] { attributesAndTexts, new Boolean(isAttribute)});
		try {
			String attribute;
			String text;

			StringTokenizer strTokenizer;

			Collection searchEntries = new ArrayList();
			ISearchEntry searchEntry;

			Iterator i = attributesAndTexts.entrySet().iterator();
			while (i.hasNext()) {
				Map.Entry entry = (Map.Entry) i.next();
				attribute = (String) entry.getKey();
				text = (String) entry.getValue();

				strTokenizer = new StringTokenizer(text);
				//add each token as SearchEntry 
				while (strTokenizer.hasMoreTokens()) {
					// generate entry for every token
					searchEntry = buildPropertySearchEntry(attribute, strTokenizer.nextToken(), isAttribute);
					searchEntries.add(searchEntry);

					if (strTokenizer.hasMoreTokens()) {
						// generate AND operator if more token exists
						searchEntry = buildOperatorSearchEntry(ISearchEntry.OPERATOR_AND);
						searchEntries.add(searchEntry);
					}
				}

				if (i.hasNext()) {
					// generate AND operator if more attribute exists
					searchEntry = buildOperatorSearchEntry(ISearchEntry.OPERATOR_AND);
					searchEntries.add(searchEntry);
				}
			}
			ISearchEntry[] result = (ISearchEntry[]) searchEntries.toArray(new SearchEntry[0]);
			return result;
		}
		finally {
			exit(method, null);
		}
	}

	protected List mergeToList(Object[] a, Object[] b) {
		int lenA = (a != null ? a.length : 0);
		int lenB = (b != null ? b.length : 0);
		List res = new ArrayList(lenA + lenB);
		if (lenA > 0) {
			res.addAll(Arrays.asList(a));
		}
		if (lenB > 0) {
			res.addAll(Arrays.asList(b));
		}
		return res;
	}

	/**
	 * The method builds operator query entry such as AND or OR
	 *  
	 * @param operator	The operator value
	 * @return
	 */
	protected ISearchEntry buildOperatorSearchEntry(String operator) {
		ISearchEntry searchEntry = new SearchEntry();
		searchEntry.setRowType(ISearchEntry.ROW_TYPE_OPERATOR);
		searchEntry.setValueAsString(operator);
		searchEntry.setValueType(ISearchEntry.VALUE_TYPE_STRING);

		return searchEntry;
	}

	/**
	 * The method builds string query entry
	 *  
	 * @param operator	The Search value
	 * @return
	 */
	protected ISearchEntry buildStringSearchEntry(String value) {
		ISearchEntry searchEntry = new SearchEntry();
		searchEntry.setValueAsString(value);
		searchEntry.setValueType(ISearchEntry.VALUE_TYPE_STRING);
		searchEntry.setTermAction(ISearchEntry.TERM_ACTION_LINGUISTIC);
		searchEntry.setTermWeight(1.0F);
		searchEntry.setRowType(ISearchEntry.ROW_TYPE_TERM);

		return searchEntry;
	}

	/**
	 * The method builds property query entry
	 *  
	 * @param propertyName	The property name
	 * @param value			The search string
	 * @param isAttribute	Indicates if propertyName is an attribute or a category
	 * @return
	 */
	protected ISearchEntry buildPropertySearchEntry(String propertyName, String value, boolean isAttribute) {
		ISearchEntry searchEntry = new SearchEntry();

		String[] result = convertAttribute(propertyName, isAttribute);
		searchEntry.setPropertyNamespace(result[0]);
		searchEntry.setPropertyName(result[1]);
		searchEntry.setValueAsString(value);
		searchEntry.setValueType(ISearchEntry.VALUE_TYPE_STRING);
		searchEntry.setTermAction(ISearchEntry.TERM_ACTION_LINGUISTIC);
		searchEntry.setTermWeight(1.0F);
		searchEntry.setRowType(ISearchEntry.ROW_TYPE_ATTRIBUTE);

		return searchEntry;
	}

	protected KMSearchHelper getSearchHelper() {
		if (m_searchHelper == null) {
			m_searchHelper = new KMSearchHelper();
		}
		return m_searchHelper;
	}

	/**
	 * This methods converts a caf attribute or category into the corresponding km property. It converts
	 * the attribute name and creates the namespace in which the property is displayed in km. 
	 * @param propertyName Name of the property or category
	 * @param isAttribute true if propertyName is an attribute, false if it is a category
	 * @return
	 */
	private String[] convertAttribute(String propertyName, boolean isAttribute) {

		String[] result = new String[2];

		//categories are registered in a different namespace than attributes
		if (isAttribute) {
			//some attributes are mapped to predefined properties in km
			if (propertyName.equals("createdBy")) {
				result[0] = "http://sapportals.com/xmlns/cm";
				result[1] = "createdby";
			}
			else if (propertyName.equals("createdAt")) {
				result[0] = "http://sapportals.com/xmlns/cm";
				result[1] = "created";
			}
			else if (propertyName.equals("lastChangedBy")) {
				result[0] = "http://sapportals.com/xmlns/cm";
				result[1] = "modifiedby";
			}
			else if (propertyName.equals("lastChangedAt")) {
				result[0] = "http://sapportals.com/xmlns/cm";
				result[1] = "modified";
			}
			//the others get it own namespace
			else {
				result[0] = "http://sap.com/caf/attributes";
				result[1] = propertyName;
			}
		}
		else {
			result[0] = "http://sap.com/caf/categories";
			result[1] = propertyName;
		}

		return result;
	}

	private String getTableByBOName(String fullBOName) throws SearchException{
		final String method = JARM_REQUEST + ":getTableByBOName(String)";
		enter(method, new Object[] { fullBOName });
		
		try{
			
			MetaModel mmr = new MetaModel();
			DataObject dataObject = mmr.getDataObject(fullBOName) ;
	
			if (dataObject == null){
				SearchException searchEx = new SearchException("No corresponding data object for {0} bo name", new String[]{fullBOName});
				log(searchEx, method, null);
				throw searchEx;
			}
			
			BusinessEntityInterface be = dataObject.getBusinessEntityInterface() ;

			Table table = be.getBusinessEntity().getMasterTable() ; 			
	
			if (table == null){
				SearchException searchEx = new SearchException("No master table for business entity {0}", new String[]{fullBOName});
				log(searchEx, method, null);
				throw searchEx;
			}
			
			String sMasterTable =	table.getTableName();
			
			return sMasterTable ;
		}catch(Exception e){
			SearchException searchEx = new SearchException(e.getMessage());
			log(searchEx, method, null);
			throw searchEx;
		}finally{
			exit(method, null);
		}
	}

	public Collection searchForBO(Collection filter, String BOName) throws SearchException {
		final String method = JARM_REQUEST + ":searchForBO(Collection, String)";
		enter(method, new Object[] { filter, BOName });
		try {
			if (BOName == null) {
				SearchException searchEx = new SearchException(ERR_SEARCH_PARAMS);
				log(searchEx, method, null);
				throw searchEx;
			}
			Collection col = null;
			ISearchEntry[] entries = null;

			if (filter == null)
				filter = new ArrayList();

			boolean isBOKM = m_accessor.isBOKM(BOName);
			List indeces = getIndices(BOName, isBOKM ? IIndex.TYPE_KM_BO_GLOBAL : IIndex.TYPE_CAF_BO_OWN);
			if (indeces == null || indeces.size() == 0) {
				return EMPTY_SEARCH_RESULT;
			}

			Vector vec = new Vector(); //= new ISearchEntry[filter.size()]; 
			Iterator it = filter.iterator();

			while (it.hasNext()) {
				Object obj = it.next();
				if (!(obj instanceof QueryFilter))
					throw new SearchException("Search query contains a wrong type of filter", new Object[0]);

				QueryFilter tmpFilter = (QueryFilter) obj;
				vec.addAll(SearchEntry.createSearchEntry(tmpFilter, BOName));
			}
			entries = (SearchEntry[]) vec.toArray(new SearchEntry[0]);

			ISearchResult[] found =
				isBOKM
					? m_searchSvc.searchForGlobalResource(entries, (String[]) indeces.toArray(new String[0]), m_max_search_results)
					: m_searchSvc.searchForBO(entries, (String[]) indeces.toArray(new String[0]), m_max_search_results);
			return Arrays.asList(found);
		}
		catch (Exception e) {
			SearchException searchEx = new SearchException(ERR_SEARCH_BO, e);
			log(searchEx, method, null);
			throw searchEx;
		}
		finally {
			exit(method, null);
		}
	}

	//	TODO: Remove the next three methods if business object template has been updated to the new search method signatures
	public Collection searchForBO(String attribute, String freeText, String BOName) throws SearchException {
		return null;
	}
	public Collection searchForBO(Collection collAttributesAsString, String freeText, String BOName) throws SearchException {
		return null;
	}
	public Collection searchForBO(Map hashMapofAttributesAsStringAndfreeText, String BOName) throws SearchException {
		return null;
	}

	protected Location getLocation() {
		return location;
	}

	protected String getJARMRequest() {
		return JARM_REQUEST;
	}

}