package com.sap.caf.km.ejb.svc.idxsearch.bean;

import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Map;

import javax.ejb.EJBObject;

import com.sap.caf.km.ejb.svc.idxsearch.bo.BOAccessException;
import com.sap.caf.km.ejb.svc.idxsearch.common.ClassifyException;
import com.sap.caf.km.ejb.svc.idxsearch.common.IIndex;
import com.sap.caf.km.ejb.svc.idxsearch.common.IndexException;
import com.sap.caf.km.ejb.svc.idxsearch.common.SearchException;


public interface IndexSearch extends EJBObject {

	// IIndexSearchIndex
	public void assignGlobalIndexToKMBO(String indexId, String BOName) throws RemoteException, IndexException;
	public IIndex createIndexForCAFBO(String BOName) throws RemoteException, IndexException;
	public IIndex createRelatedIndexForCAFBO(String BOName) throws RemoteException, IndexException;
	public void deindexObject(String BOName, String objectRid) throws RemoteException, IndexException;
	public void deindexRelatedObject(String BOName, String objectRid) throws RemoteException, IndexException;
	public void deleteIndexForCAFBO(String BOName) throws RemoteException, IndexException;
	public void deleteRelatedIndexForCAFBO(String BOName) throws RemoteException, IndexException;
	public void deltaReindex(String BOName) throws RemoteException, IndexException;
	public IIndex[] getAllIndexes() throws RemoteException, IndexException;
	public IIndex getIndex(String indexId) throws RemoteException, IndexException;
	public void indexObject(String BOName, String objectRid) throws RemoteException, IndexException;
	public void indexRelatedObject(String BOName, String objectRid) throws RemoteException, IndexException;
	public void reindexProperIndex(String BOName) throws RemoteException, IndexException;
	public void reindexRelatedIndex(String BOName) throws RemoteException, IndexException;
	public void reindexGlobalIndex(String indexId, String BOName) throws RemoteException, IndexException;
	public void unassignGlobalIndexFromKMBO(String indexId, String BOName) throws RemoteException, IndexException;
	public void deleteGlobalIndex(String indexId, String BOName) throws RemoteException, IndexException;

	// IBOAccessor
	public boolean isBOKM(String BOName) throws RemoteException, BOAccessException;
	public boolean isBOCAF(String BOName) throws RemoteException, BOAccessException;
	public boolean isBOKMDocument(String BOName) throws RemoteException, BOAccessException;
	public boolean isBOKMTask(String BOName) throws RemoteException, BOAccessException;
	public String[] getBONames() throws RemoteException, BOAccessException;
	public String[] getKMBONames() throws RemoteException, BOAccessException;
	public Collection getClassifables()  throws RemoteException, BOAccessException;
	public Collection getSearchAndRetrieval() throws RemoteException, BOAccessException;

	// IIndexSearchClassify
	public void addClassification(String valueGUID, String BOGUID, String categoryGUID) throws RemoteException, ClassifyException;
	public void addClassification(Collection valueGUIDs, String BOGUID, String categoryGUID) throws RemoteException, ClassifyException;
	public void assignCategory(String catGUID, String BOName) throws RemoteException, ClassifyException;
	public void assignCategory(Collection catGUIDs, String BOName) throws RemoteException, ClassifyException;
	public void deassignCategory(String catGUID, String BOName) throws RemoteException, ClassifyException;
	public void deassignCategory(String catGUID) throws RemoteException, ClassifyException;
	public void deassignCategory(Collection catGUIDs, String BOName) throws RemoteException, ClassifyException;
	public Collection getCategories(String BOName) throws RemoteException, ClassifyException;
	public Collection getClassification(String BOGUID) throws RemoteException, ClassifyException;	
	public Collection getClassification(String BOGUID, String categoryGUID) throws RemoteException, ClassifyException;
	public Collection getAssignedClassification(String BOName) throws RemoteException, ClassifyException;
	public String getTaxonomyRepositoryPrefix() throws RemoteException, ClassifyException;
	public void removeClassification(String valueGUID, String BOGUID) throws RemoteException, ClassifyException;
	public void removeClassification(Collection valueGUIDs, String BOGUID) throws RemoteException, ClassifyException;
	public boolean isUsedInClassification(String valueGUID) throws RemoteException, ClassifyException;
	public void removeClassification(String valueGUID) throws RemoteException, ClassifyException;
	public void removeClassification(Collection valueGUIDs) throws RemoteException, ClassifyException;

	// IIndexSearchSearch
	public Collection searchForAllBO(Collection queryEntryCollection) throws RemoteException, SearchException;
	public Collection searchForAllCAFBO(Collection queryEntryCollection) throws RemoteException, SearchException;
	public Collection searchForAllKMBO(Collection queryEntryCollection) throws RemoteException, SearchException;
	public Collection searchForCAFBO(Collection queryEntryCollection, Collection BONames)
		throws RemoteException, SearchException;
	public Collection searchForCAFBOAndRelatedRes(
		Collection queryEntryCollectionCAF,
		Collection queryEntryCollectionKM,
		Collection BONames,
		int searchKMType)
		throws RemoteException, SearchException;
	public Collection searchForGlobalDoc(Collection queryEntryCollection) throws RemoteException, SearchException;
	public Collection searchForGlobalDoc(Collection queryEntryCollection, String startFolderRIDForSearch)	throws RemoteException, SearchException;
	public Collection searchForGlobalTasks(Collection queryEntryCollection) throws RemoteException, SearchException;
	public Collection searchForGlobalTasks(Collection queryEntryCollection, String startFolderRIDForSearch)	throws RemoteException, SearchException;
	public Collection searchForRelatedDocument(Collection queryEntryCollection, Collection BONames)	throws RemoteException, SearchException;
	public Collection searchForRelatedTask(Collection queryEntryCollection, Collection BONames)	throws RemoteException, SearchException;
	public Collection searchForSimilarCAF(String resourceRid, int maxResults) throws RemoteException, SearchException;
	public Collection searchForSimilarKM(String resourceRid, boolean useGlobalIndex) throws RemoteException, SearchException;
	public Collection searchForBO(String attribute, String freeText, String BOName) throws  RemoteException, SearchException;
	public Collection searchForBO(Collection collAttributesAsString, String freeText, String BOName) throws RemoteException, SearchException;
	public Collection searchForBO(Map hashMapofAttributesAsStringAndfreeText, String BOName) throws  RemoteException, SearchException;
	public Collection searchForRelatedDoc(Collection collAttributesAsString, String freeText, String BOName) throws RemoteException, SearchException;
	public Collection searchForBOInRelatedDoc(Collection collAttributesAsString, String freeText, String BOName) throws RemoteException, SearchException;
	public Collection searchForBO(Collection filter, String BOName) throws RemoteException, SearchException;

}
