package com.sap.caf.km.ejb.svc.cleanjob;

import java.util.Set;
import java.util.HashSet;

import javax.naming.InitialContext;
import javax.ejb.CreateException;


import com.sap.tc.logging.Location;

import com.sap.caf.km.da.KMDataAccessBean;
import com.sap.caf.km.da.KMDataAccessHelper;
import com.sap.caf.km.da.RidUtils;
import com.sap.caf.km.proxies.svc.kmcleanjob.*;
import com.sap.caf.km.ejb.data.util.ProxyHelper;
import com.sap.caf.rt.bol.context.CAFContext;

import com.sap.caf.km.ejb.svc.idxsearch.bean.IndexSearchLocal;
import com.sap.caf.km.ejb.svc.idxsearch.bean.IndexSearchLocalHome;


/**
 * @ejbHome <{none}>
 * @ejbLocal <{com.sap.caf.km.ejb.svc.cleanjob.CleanJobProxyEJBLocal}>
 * @ejbLocalHome <{com.sap.caf.km.ejb.svc.cleanjob.CleanJobProxyEJBLocalHome}>
 * @ejbRemote <{none}>
 * @stateful
 */
public class CleanJobProxyEJBBean extends KMDataAccessBean implements ICleanJobExceptionResourceKeys {

	private static final String APPLICATION = CleanJobProxyEJBBean.class.getName();
	private static final String JARM_REQUEST =  "CAF:RT:oal:" + APPLICATION;		
	private static final Location location = Location.getLocation(APPLICATION);

	private final static String JNDI_NAME = "wsclients/proxies/sap.com/caf~km.proxies/KMCleanJobJNDI";
	private final static String JNDI_INDEX_SEARCH_BEAN = "localejbs/sap.com/caf~com.sap.caf.runtime/IndexSearchBean";

	protected  transient CleanJobSvc m_proxy;
	private transient String[] m_folderRids;
	
	public void ejbCreate() throws CreateException {
		final String method = JARM_REQUEST + ":ejbCreate()";
		enter(method, null);
		try {
			InitialContext context = new InitialContext();
			CleanJobSvcService service = (CleanJobSvcService) context.lookup(JNDI_NAME);
			m_proxy = (CleanJobSvc) service.getLogicalPort(CleanJobSvc.class);

			// substitute real host:port instead of template names
			String url = ProxyHelper.getActualUrl((String) m_proxy._getProperty(javax.xml.rpc.Stub.ENDPOINT_ADDRESS_PROPERTY));
			m_proxy._setProperty(javax.xml.rpc.Stub.ENDPOINT_ADDRESS_PROPERTY, url);

			m_folderRids = getKMFolderRIDsForCleanup();
		}
		catch (Exception ex) {
			CleanJobException cleanJobEx = new CleanJobException(RES_CANT_CREATE_EJB, ex); 
			log(cleanJobEx, method, null);
			throw new CreateException(cleanJobEx.getLocalizedMessage());
		}
		finally {
			exit(method, null);
		}
	}
	
	
	private String[] getKMFolderRIDsForCleanup() throws Exception {
		Set cleanRids = new HashSet();

		// get temp rids
		cleanRids.add(KMDataAccessHelper.getTempFolderRid());
		cleanRids.add(KMDataAccessHelper.getTemplateFolderRid());
			
		// get BO home folders
		String[] boNames = getBONames();
		for (int i = 0; i < boNames.length; i++) {
			cleanRids.add(KMDataAccessHelper.getBORootFolderRid(boNames[i]) );
		}

		return (String[]) cleanRids.toArray(new String[cleanRids.size()]);
	}

	private String[] getBONames() throws Exception {
		InitialContext context = new InitialContext();
		IndexSearchLocalHome home = (IndexSearchLocalHome) context.lookup(JNDI_INDEX_SEARCH_BEAN);
		IndexSearchLocal indexSearch = home.create();
		return indexSearch.getBONames();
	}
	
	

	public ICleanJobSchedule getCleanJobSchedule() throws CleanJobException {
		final String method = JARM_REQUEST + ":getCleanJobSchedule()";
		enter(method, null);
		try {
			return new CleanJobSchedule(m_proxy.getCleanJobSchedule());
		}
		catch (Exception ex) {
			CleanJobException cleanJobEx = new CleanJobException(RES_CANT_GET_SCHEDULE, ex); 
			log(cleanJobEx, method, null);
			throw cleanJobEx;
		}
		finally {
			exit(method, null);
		}
	}

	public void setCleanJobSchedule(ICleanJobSchedule schedule) throws CleanJobException {
		final String method = JARM_REQUEST + ":setCleanJobSchedule(ICleanJobSchedule)";
		final Object[] args = {schedule};
		enter(method, args);
		try {
			m_proxy.setCleanJobFolderRids(m_folderRids);

			com.sap.caf.km.proxies.svc.kmcleanjob.types.CleanJobSchedule proxyShedule =
				new com.sap.caf.km.proxies.svc.kmcleanjob.types.CleanJobSchedule();
			proxyShedule.setHours(schedule.getHours());
			proxyShedule.setMinutes(schedule.getMinutes());
			proxyShedule.setWeekDays(schedule.getWeekDays());

			m_proxy.setCleanJobSchedule(proxyShedule);
		}
		catch (Exception ex) {
			CleanJobException cleanJobEx = new CleanJobException(RES_CANT_SET_SCHEDULE, ex); 
			log(cleanJobEx, method, args);
			throw cleanJobEx;
		}
		finally {
			exit(method, null);
		}
	} 

	public boolean isCleanJobRunning() throws CleanJobException {
		final String method = JARM_REQUEST + ":isCleanJobRunning()";
		enter(method, null);
		try {
			return m_proxy.isCleanJobRunning();
		}
		catch (Exception ex) {
			CleanJobException cleanJobEx = new CleanJobException(RES_CANT_TEST_RUNNING, ex); 
			log(cleanJobEx, method, null);
			throw cleanJobEx;
		}
		finally {
			exit(method, null);
		}
	}
	
	public void setCleanJobEnabled(boolean bEnabled) throws CleanJobException {
		final String method = JARM_REQUEST + ":setCleanJobEnabled(boolean)";
		final Object[] args = {Boolean.valueOf(bEnabled)};
		enter(method, args);
		try {
			m_proxy.setCleanJobFolderRids(m_folderRids);
			m_proxy.setCleanJobEnabled(bEnabled);
		}
		catch (Exception ex) {
			CleanJobException cleanJobEx = new CleanJobException(RES_CANT_SET_ENABLED, ex); 
			log(cleanJobEx, method, args);
			throw cleanJobEx;
		}
		finally {
			exit(method, null);
		}
	}
	
	public boolean getCleanJobEnabled() throws CleanJobException {
		final String method = JARM_REQUEST + ":getCleanJobEnabled()";
		enter(method, null);
		try {
			return m_proxy.getCleanJobEnabled();
		}
		catch (Exception ex) {
			CleanJobException cleanJobEx = new CleanJobException(RES_CANT_GET_ENABLED, ex); 
			log(cleanJobEx, method, null);
			throw cleanJobEx;
		}
		finally {
			exit(method, null);
		}
	}
	


	public void setCleanDocuments(boolean bEnabled) throws CleanJobException {
		final String method = JARM_REQUEST + ":setCleanDocuments(boolean)";
		final Object[] args = {Boolean.valueOf(bEnabled)};
		enter(method, args);
		try {
			m_proxy.setCleanDocuments(bEnabled);
		}
		catch (Exception ex) {
			CleanJobException cleanJobEx = new CleanJobException(RES_CANT_SET_ENABLED, ex); 
			log(cleanJobEx, method, args);
			throw cleanJobEx;
		}
		finally {
			exit(method, null);
		}
	}
	
	public boolean getCleanDocuments() throws CleanJobException {
		final String method = JARM_REQUEST + ":getCleanDocuments()";
		enter(method, null);
		try {
			return m_proxy.getCleanDocuments();
		}
		catch (Exception ex) {
			CleanJobException cleanJobEx = new CleanJobException(RES_CANT_GET_ENABLED, ex); 
			log(cleanJobEx, method, null);
			throw cleanJobEx;
		}
		finally {
			exit(method, null);
		}
	}



	public void setCleanUnlinkedDiscussionRooms(boolean bEnabled) throws CleanJobException {
		final String method = JARM_REQUEST + ":setCleanUnlinkedDiscussionRooms(boolean)";
		final Object[] args = {Boolean.valueOf(bEnabled)};
		enter(method, args);
		try {
			m_proxy.setCleanUnlinkedDiscussionRooms(bEnabled);
		}
		catch (Exception ex) {
			CleanJobException cleanJobEx = new CleanJobException(RES_CANT_SET_ENABLED, ex); 
			log(cleanJobEx, method, args);
			throw cleanJobEx;
		}
		finally {
			exit(method, null);
		}
	}
	
	public boolean getCleanUnlinkedDiscussionRooms() throws CleanJobException {
		final String method = JARM_REQUEST + ":getCleanDocuments()";
		enter(method, null);
		try {
			return m_proxy.getCleanUnlinkedDiscussionRooms();
		}
		catch (Exception ex) {
			CleanJobException cleanJobEx = new CleanJobException(RES_CANT_GET_ENABLED, ex); 
			log(cleanJobEx, method, null);
			throw cleanJobEx;
		}
		finally {
			exit(method, null);
		}
	}



	public void cleanTempFolders() throws CleanJobException {
		final String method = JARM_REQUEST + ":cleanTempFolders()";
		enter(method, null);
		try {
			m_proxy.setCleanJobFolderRids(m_folderRids);
			m_proxy.cleanTempFolders();
		}
		catch (Exception ex) {
			CleanJobException cleanJobEx = new CleanJobException(RES_CANT_CLEAN_TEMP_FOLDERS, ex);  
			log(cleanJobEx, method, null);
			throw cleanJobEx;
		}
		finally {
			exit(method, null);
		}
	}

	protected Location getLocation() {
		return location;
	}

	protected String getJARMRequest() {
		return JARM_REQUEST;
	}
}
