package com.sap.caf.km.ejb.data.task;
import java.util.ArrayList;

import javax.ejb.CreateException;
import javax.naming.InitialContext;

import com.sap.caf.km.da.KMDataAccessBean;
import com.sap.caf.km.ejb.data.util.IKMTaskExceptionResourceKeys;
import com.sap.caf.km.ejb.data.util.ITaskContent;
import com.sap.caf.km.ejb.data.util.ITaskHeader;
import com.sap.caf.km.ejb.data.util.KMTaskConstants;
import com.sap.caf.km.ejb.data.util.KMTaskException;
import com.sap.caf.km.ejb.data.util.TaskContent;
import com.sap.caf.km.ejb.data.util.TaskHeader;
import com.sap.caf.km.proxies.data.task.types.IKMTaskAttribute;
import com.sap.caf.km.proxies.data.task.types.IKMTaskHeader;
import com.sap.caf.km.proxies.data.task.types.IKMTaskList;
import com.sap.caf.km.proxies.data.task.types.IKMTaskContent;
import com.sap.caf.km.proxies.data.task.types.IKMUserContextExt;
import com.sap.caf.km.proxies.data.task.KMTaskService;
import com.sap.caf.km.proxies.data.task.WSProxyException;
import com.sap.caf.km.proxies.data.task.KMTaskServiceService;
import com.sap.tc.logging.Location;

/**
 * @ejbHome <{com.sap.test.ZB4Home}>
 * @ejbLocal <{com.sap.test.ZB4Local}>
 * @ejbLocalHome <{com.sap.test.ZB4LocalHome}>
 * @ejbRemote <{com.sap.test.ZB4}>
 * @stateless 
 */
public class TaskServiceBean extends KMDataAccessBean implements IKMTaskExceptionResourceKeys {

	private static final String APPLICATION = TaskServiceBean.class.getName();
	private static final String jARMReqPrefix = "CAF:RT:oal:"; 
	private static final String JARM_REQUEST =  jARMReqPrefix + APPLICATION;		
	private static final Location location = Location.getLocation(APPLICATION);
		
	private transient KMTaskService ws = null;

	/**
	 * Create Method.
	 */
	public void ejbCreate() throws CreateException {
		final String method = JARM_REQUEST + ":ejbCreate()";
		enter(method, null);
		try {
			InitialContext ictxt = new InitialContext();
			Object obj = ictxt.lookup("java:comp/env/KMTaskService");
			if (obj != null) {
				ws = (KMTaskService) ((KMTaskServiceService) obj).getLogicalPort(KMTaskService.class);
			}
		}
		catch (Exception ex) {
			KMTaskException taskEx = new KMTaskException(RES_CANT_CREATE_EJB, ex);
			log(taskEx, method, null);
			throw new CreateException(taskEx.getLocalizedMessage());
		}
		finally {
			exit(method, null);
		}
	}

	public void createTask(ITaskHeader taskheader, ITaskContent content, IKMUserContextExt kmuserctxt) throws KMTaskException {
		final String method = JARM_REQUEST + ":createTask(ITaskHeader, ITaskContent, IKMUserContextExt)";
		enter(method, new Object[] { taskheader, content, kmuserctxt });
		try {
			IKMTaskAttribute[] kmattribute = getKMTaskAttribute(taskheader);
			IKMTaskContent kmcontent = getKMContent(content);
			ws.createTask(kmattribute, kmcontent, kmuserctxt);
		}
		catch (Exception ex) {
			KMTaskException taskEx = new KMTaskException(ex);
			log(taskEx, method, null);
			throw taskEx;
		}
		finally {
			exit(method, null);
		}
	}

	public void createRelResourceTask(
		String relResourceRid,
		ITaskHeader taskheader,
		ITaskContent content,
		IKMUserContextExt kmuserctxt)
		throws KMTaskException {
		final String method = JARM_REQUEST + ":createRelResourceTask(String, ITaskHeader, ITaskContent, IKMUserContextExt)";
		enter(method, new Object[] { relResourceRid, taskheader, content, kmuserctxt });
		try {
			IKMTaskAttribute[] kmattribute = getKMTaskAttribute(taskheader);
			IKMTaskContent kmcontent = getKMContent(content);
			ws.createRelResourceTask(relResourceRid, kmattribute, kmcontent, kmuserctxt);
		}
		catch (Exception ex) {
			KMTaskException taskEx = new KMTaskException(ex);
			log(taskEx, method, null);
			throw taskEx;
		}
		finally {
			exit(method, null);
		}
	}

	public void createRelAppTask(String relAppId, ITaskHeader taskheader, ITaskContent content, IKMUserContextExt kmuserctxt)
		throws KMTaskException {
		final String method = JARM_REQUEST + ":createRelAppTask(String, ITaskHeader, ITaskContent, IKMUserContextExt)";
		enter(method, new Object[] { relAppId, taskheader, content, kmuserctxt });
		try {
			IKMTaskAttribute[] kmattribute = getKMTaskAttribute(taskheader);
			IKMTaskContent kmcontent = getKMContent(content);
			ws.createRelAppTask(relAppId, kmattribute, kmcontent, kmuserctxt);
		}
		catch (Exception ex) {
			KMTaskException taskEx = new KMTaskException(ex);
			log(taskEx, method, null);
			throw taskEx;
		}
		finally {
			exit(method, null);
		}
	}

	public void deleteTask(String rid, IKMUserContextExt kmuserctxt) throws KMTaskException {
		final String method = JARM_REQUEST + ":deleteTask(String, IKMUserContextExt)";
		enter(method, new Object[] { rid, kmuserctxt });
		try {
			ws.deleteTask(rid, kmuserctxt);
		}
		catch (Exception ex) {
			KMTaskException taskEx = new KMTaskException(ex);
			log(taskEx, method, null);
			throw taskEx;
		}
		finally {
			exit(method, null);
		}
	}

	public ArrayList getTasks(IKMUserContextExt foruserctxt, String role, IKMUserContextExt kmuserctxt) throws KMTaskException {
		final String method = JARM_REQUEST + ":getTasks(IKMUserContextExt, String, IKMUserContextExt)";
		enter(method, new Object[] { foruserctxt, role, kmuserctxt });
		try {
			ArrayList result = new ArrayList();
			IKMTaskList taskList = ws.getTasks(foruserctxt, role, kmuserctxt);
			IKMTaskHeader[] headerlist = taskList.getTasks();
			if (headerlist == null)
				return null;
			for (int i = 0; i < headerlist.length; i++) {
				ITaskHeader taskheader = setExplicitAttributes(headerlist[i]);
				result.add(taskheader);
			}
			return result;
		}
		catch (Exception ex) {
			KMTaskException taskEx = new KMTaskException(ex);
			log(taskEx, method, null);
			throw taskEx;
		}
		finally {
			exit(method, null);
		}
	}

	public ArrayList getRelResourceTasks(String relResourceRid, String role, IKMUserContextExt kmuserctxt)
		throws KMTaskException {
		final String method = JARM_REQUEST + ":getRelResourceTasks(String, String, IKMUserContextExt)";
		enter(method, new Object[] { relResourceRid, role, kmuserctxt });
		try {
			ArrayList result = new ArrayList();
			IKMTaskList taskList = ws.getRelResourceTasks(relResourceRid, role, kmuserctxt);
			IKMTaskHeader[] headerlist = taskList.getTasks();
			if (headerlist == null)
				return null;
			for (int i = 0; i < headerlist.length; i++) {
				ITaskHeader taskheader = setExplicitAttributes(headerlist[i]);
				result.add(taskheader);
			}
			return result;
		}
		catch (Exception ex) {
			KMTaskException taskEx = new KMTaskException(ex);
			log(taskEx, method, null);
			throw taskEx;
		}
		finally {
			exit(method, null);
		}
	}

	public ArrayList getRelAppTasks(String relAppId, String role, IKMUserContextExt kmuserctxt) throws KMTaskException {
		final String method = JARM_REQUEST + ":getRelAppTasks(String, String, IKMUserContextExt)";
		enter(method, new Object[] { relAppId, role, kmuserctxt });
		try {
			ArrayList result = new ArrayList();
			IKMTaskList taskList = ws.getRelAppTasks(relAppId, role, kmuserctxt);
			IKMTaskHeader[] headerlist = taskList.getTasks();
			if (headerlist == null)
				return null;
			for (int i = 0; i < headerlist.length; i++) {
				ITaskHeader taskheader = setExplicitAttributes(headerlist[i]);
				result.add(taskheader);
			}
			return result;
		}
		catch (Exception ex) {
			KMTaskException taskEx = new KMTaskException(ex);
			log(taskEx, method, null);
			throw taskEx;
		}
		finally {
			exit(method, null);
		}
	}

	public ITaskContent getTaskContent(String rid, IKMUserContextExt kmuserctxt, int sizeLimitBytes) throws KMTaskException {
		final String method = JARM_REQUEST + ":getTaskContent(String, IKMUserContextExt, int)";
		enter(method, new Object[] { rid, kmuserctxt, new Integer(sizeLimitBytes)});
		try {
			IKMTaskContent kmcontent = ws.getTaskContent(rid, kmuserctxt, sizeLimitBytes);
			ITaskContent result = setExplicitContentAttributes(kmcontent);
			return result;
		}
		catch (Exception ex) {
			KMTaskException taskEx = new KMTaskException(ex);
			log(taskEx, method, null);
			throw taskEx;
		}
		finally {
			exit(method, null);
		}
	}

	public void updateTaskContent(String rid, ITaskContent content, IKMUserContextExt kmuserctxt) throws KMTaskException {
		final String method = JARM_REQUEST + ":updateTaskContent(String, ITaskContent, IKMUserContextExt)";
		enter(method, new Object[] { rid, content, kmuserctxt });
		try {
			IKMTaskContent kmcontent = getKMContent(content);
			ws.updateTaskContent(rid, kmcontent, kmuserctxt);
		}
		catch (Exception ex) {
			KMTaskException taskEx = new KMTaskException(ex);
			log(taskEx, method, null);
			throw taskEx;
		}
		finally {
			exit(method, null);
		}
	}

	public void updateTaskHeader(String rid, ITaskHeader header, IKMUserContextExt kmuserctxt) throws KMTaskException {
		final String method = JARM_REQUEST + ":updateTaskContent(String, ITaskHeader, IKMUserContextExt)";
		enter(method, new Object[] { rid, header, kmuserctxt });
		try {
			IKMTaskAttribute[] kmattribute = getKMTaskAttribute(header);
			ws.updateTaskHeader(rid, kmattribute, kmuserctxt);
		}
		catch (Exception ex) {
			KMTaskException taskEx = new KMTaskException(ex);
			log(taskEx, method, null);
			throw taskEx;
		}
		finally {
			exit(method, null);
		}
	}

	public ITaskHeader readTaskHeader(String rid, IKMUserContextExt kmuserctxt) throws KMTaskException {
		final String method = JARM_REQUEST + ":readTaskHeader(String, IKMUserContextExt)";
		enter(method, new Object[] { rid, kmuserctxt });
		try {
			IKMTaskHeader taskHeader = null;
			ITaskHeader result;
			taskHeader = ws.readTaskHeader(rid, kmuserctxt);
			result = setExplicitAttributes(taskHeader);
			return result;
		}
		catch (Exception ex) {
			KMTaskException taskEx = new KMTaskException(ex);
			log(taskEx, method, null);
			throw taskEx;
		}
		finally {
			exit(method, null);
		}
	}

	public String testlocal(String param) throws KMTaskException {
		final String method = JARM_REQUEST + ":testlocal(String)";
		enter(method, new Object[] { param });
		try {
			return "testlocal success";
		}
		catch (Exception ex) {
			KMTaskException taskEx = new KMTaskException(ex);
			log(taskEx, method, null);
			throw taskEx;
		}
		finally {
			exit(method, null);
		}
	}

	public String testws(String param) throws KMTaskException {
		final String method = JARM_REQUEST + ":testws(String)";
		enter(method, new Object[] { param });
		try {
			String result = "";
			result = ws.test2("hello");

			return result;
		}
		catch (Exception ex) {
			KMTaskException taskEx = new KMTaskException(ex);
			log(taskEx, method, null);
			throw taskEx;
		}
		finally {
			exit(method, null);
		}
	}

	public String readTaskHeader(String param) throws KMTaskException {
		final String method = JARM_REQUEST + ":readTaskHeader(String)";
		enter(method, new Object[] { param });
		try {
			IKMTaskHeader taskHeader = null;
			/*try
			{
				KMTaskServiceService service = new KMTaskServiceServiceImpl();
				KMTaskService ws = (KMTaskService)service.getLogicalPort("KMTaskService", com.sap.task.webservice.proxy.KMTaskService.class);
				String rid = "/tasks/78814bfc-f500-0010-0aae-b33a955c7536";
				IKMUserContextExt kmuserctxt = new IKMUserContextExt();
				kmuserctxt.setCountryCode("US");
				kmuserctxt.setLanguageCode("en");
				taskHeader = ws.readTaskHeader(rid, kmuserctxt);
			}
			catch (Exception ex)
			{
				ex.printStackTrace();
			}*/
			if (taskHeader != null)
				return taskHeader.getRid();
			else
				return "failed";
		}
		catch (Exception ex) {
			KMTaskException taskEx = new KMTaskException(ex);
			log(taskEx, method, null);
			throw taskEx;
		}
		finally {
			exit(method, null);
		}
	}

	private IKMTaskAttribute getAttribute(String attributeName, IKMTaskAttribute[] attributes) {
		String namespace = KMTaskConstants.PROP_NAMESPACE;
		if (attributeName.equalsIgnoreCase(KMTaskConstants.PROP_DISPLAYNAME))
			namespace = KMTaskConstants.PROP_NAMESPACE_WCM;
		for (int i = 0; i < attributes.length; i++) {
			if (attributes[i].getName() != null
				&& attributes[i].getNamespace() != null
				&& attributes[i].getName().equalsIgnoreCase(attributeName)
				&& attributes[i].getNamespace().equalsIgnoreCase(namespace)) {
				return attributes[i];
			}
		}
		return null;
	}

	private ITaskHeader setExplicitAttributes(IKMTaskHeader kmtaskheader) throws WSProxyException {

		ITaskHeader attributeHeader = new TaskHeader();
		String Rid = kmtaskheader.getRid();
		if (Rid == null)
			throw new WSProxyException();
		IKMTaskAttribute attr;

		attributeHeader.setRid(Rid);
		if ((attr = this.getAttribute(KMTaskConstants.PROP_DISPLAYNAME, kmtaskheader.getAttributes())) != null)
			attributeHeader.setDisplayName(attr.getStringValue());
		if ((attr = this.getAttribute(KMTaskConstants.PROP_APPLICATIONID, kmtaskheader.getAttributes())) != null)
			attributeHeader.setApplicationId(attr.getStringValue());
		if ((attr = this.getAttribute(KMTaskConstants.PROP_ASAP, kmtaskheader.getAttributes())) != null)
			attributeHeader.setAsap(attr.getBooleanValue());
		if ((attr = this.getAttribute(KMTaskConstants.PROP_ASSIGNEE, kmtaskheader.getAttributes())) != null)
			attributeHeader.setAssignee(attr.getListValue());
		if ((attr = this.getAttribute(KMTaskConstants.PROP_DUEDATE, kmtaskheader.getAttributes())) != null)
			attributeHeader.setDueDate(attr.getDateValue());
		if ((attr = this.getAttribute(KMTaskConstants.PROP_ESCALATION, kmtaskheader.getAttributes())) != null)
			attributeHeader.setEscalated(attr.getBooleanValue());
		if ((attr = this.getAttribute(KMTaskConstants.PROP_NOTIFY, kmtaskheader.getAttributes())) != null)
			attributeHeader.setNotify(attr.getBooleanValue());
		if ((attr = this.getAttribute(KMTaskConstants.PROP_PRIORITY, kmtaskheader.getAttributes())) != null)
			attributeHeader.setPriority(attr.getIntValue());
		if ((attr = this.getAttribute(KMTaskConstants.PROP_PROGRESSINDICATOR, kmtaskheader.getAttributes())) != null)
			attributeHeader.setProgress(attr.getIntValue());
		if ((attr = this.getAttribute(KMTaskConstants.PROP_RESOURCERID, kmtaskheader.getAttributes())) != null)
			attributeHeader.setResourceRid(attr.getStringValue());
		if ((attr = this.getAttribute(KMTaskConstants.PROP_STATUS, kmtaskheader.getAttributes())) != null)
			attributeHeader.setStatus(attr.getIntValue());
		if ((attr = this.getAttribute(KMTaskConstants.PROP_RESPONSIBLE, kmtaskheader.getAttributes())) != null)
			attributeHeader.setTrackedBy(attr.getListValue());

		return attributeHeader;
	}

	private ITaskContent setExplicitContentAttributes(IKMTaskContent kmtaskcontent) throws WSProxyException {
		ITaskContent taskcontent = new TaskContent();

		taskcontent.setContent(kmtaskcontent.getContent());
		taskcontent.setContentEncoding(kmtaskcontent.getContentEncoding());
		taskcontent.setContentLength(kmtaskcontent.getContentLength());
		taskcontent.setContentType(kmtaskcontent.getContentType());
		return taskcontent;
	}

	private IKMTaskContent getKMContent(ITaskContent taskcontent) {
		IKMTaskContent kmtaskcontent = new IKMTaskContent();
		kmtaskcontent.setContent(taskcontent.getContent());
		kmtaskcontent.setContentEncoding(taskcontent.getContentEncoding());
		kmtaskcontent.setContentLength(taskcontent.getContentLength());
		kmtaskcontent.setContentType(taskcontent.getContentType());
		return kmtaskcontent;
	}

	private IKMTaskAttribute[] getKMTaskAttribute(ITaskHeader taskheader) {
		IKMTaskAttribute[] m_attrs = new IKMTaskAttribute[12];
		IKMTaskAttribute attribute;

		attribute = new IKMTaskAttribute();
		attribute.setName(KMTaskConstants.PROP_DISPLAYNAME);
		attribute.setNamespace(KMTaskConstants.PROP_NAMESPACE_WCM);
		attribute.setAttributeType(KMTaskConstants.ATTRIBUTE_TYPE_STRING);
		attribute.setStringValue(taskheader.getDisplayName());
		m_attrs[0] = attribute;

		attribute = new IKMTaskAttribute();
		attribute.setName(KMTaskConstants.PROP_PRIORITY);
		attribute.setNamespace(KMTaskConstants.PROP_NAMESPACE);
		attribute.setAttributeType(KMTaskConstants.ATTRIBUTE_TYPE_INTEGER);
		attribute.setIntValue(taskheader.getPriority());
		m_attrs[1] = attribute;

		//Calendar cal = Calendar.getInstance();
		//SimpleDateFormat dateFormatter = new SimpleDateFormat(DATE_FORMAT, Locale.US);
		//java.util.Date formattedDate = dateFormatter.parse(datestring);					
		//cal.setTime(formattedDate);
		attribute = new IKMTaskAttribute();
		attribute.setName(KMTaskConstants.PROP_DUEDATE);
		attribute.setNamespace(KMTaskConstants.PROP_NAMESPACE);
		attribute.setAttributeType(KMTaskConstants.ATTRIBUTE_TYPE_DATE);
		attribute.setDateValue(taskheader.getDueDate());
		m_attrs[2] = attribute;

		attribute = new IKMTaskAttribute();
		attribute.setName(KMTaskConstants.PROP_ASAP);
		attribute.setNamespace(KMTaskConstants.PROP_NAMESPACE);
		attribute.setAttributeType(KMTaskConstants.ATTRIBUTE_TYPE_BOOLEAN);
		attribute.setBooleanValue(taskheader.getAsap());
		m_attrs[3] = attribute;

		//ArrayList assigneesArray = new ArrayList();
		//assigneesArray.add("USER.PRIVATE_DATASOURCE.b9fa88b99111987a5fed0cf690950bb50141");
		//assigneesArray.add("USER.PRIVATE_DATASOURCE.f52485e2bf146228471918f6504c225c0008");		
		attribute = new IKMTaskAttribute();
		attribute.setName(KMTaskConstants.PROP_ASSIGNEE);
		attribute.setNamespace(KMTaskConstants.PROP_NAMESPACE);
		attribute.setAttributeType(KMTaskConstants.ATTRIBUTE_TYPE_LIST);
		attribute.setListValue(taskheader.getAssignee());
		m_attrs[4] = attribute;

		//ArrayList trackedByArray = new ArrayList();
		//trackedByArray.add("USER.PRIVATE_DATASOURCE.f52485e2bf146228471918f6504c225c0008");		
		attribute = new IKMTaskAttribute();
		attribute.setName(KMTaskConstants.PROP_RESPONSIBLE);
		attribute.setNamespace(KMTaskConstants.PROP_NAMESPACE);
		attribute.setAttributeType(KMTaskConstants.ATTRIBUTE_TYPE_LIST);
		attribute.setListValue(taskheader.getTrackedBy());
		m_attrs[5] = attribute;

		attribute = new IKMTaskAttribute();
		attribute.setName(KMTaskConstants.PROP_NOTIFY);
		attribute.setNamespace(KMTaskConstants.PROP_NAMESPACE);
		attribute.setAttributeType(KMTaskConstants.ATTRIBUTE_TYPE_BOOLEAN);
		attribute.setBooleanValue(taskheader.getNotify());
		m_attrs[6] = attribute;

		attribute = new IKMTaskAttribute();
		attribute.setName(KMTaskConstants.PROP_PROGRESSINDICATOR);
		attribute.setNamespace(KMTaskConstants.PROP_NAMESPACE);
		attribute.setAttributeType(KMTaskConstants.ATTRIBUTE_TYPE_INTEGER);
		attribute.setIntValue(taskheader.getProgress());
		m_attrs[7] = attribute;

		attribute = new IKMTaskAttribute();
		attribute.setName(KMTaskConstants.PROP_STATUS);
		attribute.setNamespace(KMTaskConstants.PROP_NAMESPACE);
		attribute.setAttributeType(KMTaskConstants.ATTRIBUTE_TYPE_INTEGER);
		attribute.setIntValue(taskheader.getStatus());
		m_attrs[8] = attribute;

		attribute = new IKMTaskAttribute();
		attribute.setName(KMTaskConstants.PROP_ESCALATION);
		attribute.setNamespace(KMTaskConstants.PROP_NAMESPACE);
		attribute.setAttributeType(KMTaskConstants.ATTRIBUTE_TYPE_BOOLEAN);
		attribute.setBooleanValue(taskheader.getEscalated());
		m_attrs[9] = attribute;

		attribute = new IKMTaskAttribute();
		attribute.setName(KMTaskConstants.PROP_RESOURCERID);
		attribute.setNamespace(KMTaskConstants.PROP_NAMESPACE);
		attribute.setAttributeType(KMTaskConstants.ATTRIBUTE_TYPE_STRING);
		attribute.setStringValue(taskheader.getResourceRid());
		m_attrs[10] = attribute;

		attribute = new IKMTaskAttribute();
		attribute.setName(KMTaskConstants.PROP_APPLICATIONID);
		attribute.setNamespace(KMTaskConstants.PROP_NAMESPACE);
		attribute.setAttributeType(KMTaskConstants.ATTRIBUTE_TYPE_STRING);
		attribute.setStringValue(taskheader.getApplicationId());
		m_attrs[11] = attribute;

		return m_attrs;
	}

	protected Location getLocation() {
		return location;
	}

	protected String getJARMRequest() {
		return JARM_REQUEST;
	}
}
