package com.sap.caf.km.ejb.data.folder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;

import javax.ejb.CreateException;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;

import com.sap.caf.km.da.KMDataAccessBean;
import com.sap.caf.km.ejb.data.util.IKMNodeExceptionResourceKeys;
import com.sap.caf.km.ejb.data.util.INodeContent;
import com.sap.caf.km.ejb.data.util.INodeHeader;
import com.sap.caf.km.ejb.data.util.KMNodeConstants;
import com.sap.caf.km.ejb.data.util.KMNodeException;
import com.sap.caf.km.ejb.data.util.NodeChildren;
import com.sap.caf.km.ejb.data.util.NodeContent;
import com.sap.caf.km.ejb.data.util.NodeHeader;
import com.sap.caf.km.ejb.data.util.ProxyHelper;
import com.sap.caf.km.proxies.data.kmnode.KMNodeService;
import com.sap.caf.km.proxies.data.kmnode.KMNodeServiceService;
import com.sap.caf.km.proxies.data.kmnode.types.KMNodeAttribute;
import com.sap.caf.km.proxies.data.kmnode.types.KMNodeContent;
import com.sap.caf.km.proxies.data.kmnode.types.KMNodeHeader;
import com.sap.caf.km.proxies.data.kmnode.types.KMNodePermission;
import com.sap.caf.km.proxies.data.kmnode.types.KMUserContext;
import com.sap.caf.km.proxies.svc.kmrelation.KMRelationSvc;
import com.sap.caf.km.proxies.svc.kmrelation.KMRelationSvcService;
import com.sap.security.api.IUser;
import com.sap.security.api.IUserFactory;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import com.sap.tc.logging.Location;

/**
 * @ejbHome <{none}>
 * @ejbLocal <{com.sap.caf.km.folder.FolderProxyEJBLocal}>
 * @ejbLocalHome <{com.sap.caf.km.folder.FolderProxyEJBLocalHome}>
 * @ejbRemote <{none}>
 * @stateless 
 */
public class FolderProxyEJBBean extends KMDataAccessBean implements IKMNodeExceptionResourceKeys {
	
	private static final String APPLICATION = FolderProxyEJBBean.class.getName();
	private static final String jARMReqPrefix = "CAF:RT:oal:"; 
	private static final String JARM_REQUEST =  jARMReqPrefix + APPLICATION;		
	private static final Location location = Location.getLocation(APPLICATION);
	
	private final String separator = "/";

	transient InitialContext JNDIcontext = null;
	transient KMNodeService WS = null;
	transient KMNodeServiceService WSService = null;
	
	transient KMRelationSvc WSRelation = null;
	transient KMRelationSvcService WSRelationService = null;
	
	//  KMUserContext userContext = null;

	String userId = null;
	IUser user = null;
	transient IUserFactory userFactory = UMFactory.getInstance().getUserFactory();

	public void ejbRemove() {
	}

	public void ejbActivate() {
	}

	public void ejbPassivate() {
	}

	public void setSessionContext(SessionContext context) {
		myContext = context;
	}

	private transient SessionContext myContext;

	/**
	 * Create Method.
	 */
	public void ejbCreate() throws CreateException {
		final String method = JARM_REQUEST + ":ejbCreate()";
		enter(method, null);
		try {
			// instantiate JNDI lookup
			if (JNDIcontext == null) {
				JNDIcontext = new InitialContext();
				WSService = (KMNodeServiceService) JNDIcontext.lookup("wsclients/proxies/sap.com/caf~km.proxies/KMNodeJNDI");
				WS = (KMNodeService) WSService.getLogicalPort(KMNodeService.class);

				String url =
					ProxyHelper.getActualUrl((String) WS._getProperty(KMNodeService.ENDPOINT_ADDRESS_PROPERTY));
				if (!url.equals(WS._getProperty(KMNodeService.ENDPOINT_ADDRESS_PROPERTY))) {
					WS._setProperty(KMNodeService.ENDPOINT_ADDRESS_PROPERTY, url);
				}

				//				instantiate JNDI lookup for relation handling						
				WSRelationService = (KMRelationSvcService) JNDIcontext.lookup("wsclients/proxies/sap.com/caf~km.proxies/KMRelationJNDI");
				WSRelation = (KMRelationSvc) WSRelationService.getLogicalPort(KMRelationSvc.class);

				url =
					ProxyHelper.getActualUrl((String) WSRelation._getProperty(KMNodeService.ENDPOINT_ADDRESS_PROPERTY));
				if (!url.equals(WSRelation._getProperty(KMNodeService.ENDPOINT_ADDRESS_PROPERTY))) {
					WSRelation._setProperty(KMNodeService.ENDPOINT_ADDRESS_PROPERTY, url);
				}
			}
		} 
		catch (Throwable e) {
			//$JL-EXC$ ignore JLin warning
			KMNodeException nodeEx = new KMNodeException(RES_CANT_CREATE_EJB, e); 
			log(nodeEx, method, null);
			throw new CreateException(nodeEx.getLocalizedMessage());
		}
		finally {
			exit(method, null);
		}

		/* TODO next release - first release: service user
		//get the userId from EJB context, transfer it to user of UM
		userId = myContext.getCallerPrincipal().getName();
		try {
			user = userFactory.getUser(userId);
		} catch (UMException umE) {
			throw new CreateException(
				"User " + userId + " does not exist in UM");
		}
		userContext = new KMUserContext();
		userContext.setCountryCode(user.getLocale().getCountry());
		userContext.setLanguageCode(user.getLocale().getLanguage());
		*/
	}

	public void move(String sourceRid, String targetRid) throws KMNodeException {
		final String method = JARM_REQUEST + ":move(String, String)";
		final Object[] args = {sourceRid, targetRid};
		enter(method, args);
		try {
			if (sourceRid == null || targetRid == null)
				throw new KMNodeException(RES_NULLINPUT);
			KMUserContext userContext = getUserContext();				
			WS.moveNode(userContext, sourceRid, targetRid);
		}
		catch (Throwable e) {
			//$JL-EXC$ ignore JLin warning
			KMNodeException nodeEx = new KMNodeException(RES_CANT_MOVE_NODE, args, e);
			log(nodeEx, method, args);
			throw nodeEx;
		}
		finally {
			exit(method, null);
		}
	}

	public boolean exists(String folderRid) throws KMNodeException {
		final String method = JARM_REQUEST + ":exists(String)";
		final Object[] args = {folderRid};
		enter(method, args);
		try {
			if (folderRid==null)
				throw new KMNodeException(RES_NULLINPUT);
			return WS.exists(getUserContext(), folderRid);
		}
		catch (Throwable e) {
			//$JL-EXC$ ignore JLin warning
			KMNodeException nodeEx = new KMNodeException(RES_CANT_CHECK_EXIST, args, e);
			log(nodeEx, method, args);
			throw nodeEx;
		}
		finally {
			exit(method, null);
		}
	}

	public void createFolderHeader(String name, String parentRid, String displayName, 
		String description, Collection relations)	throws KMNodeException 
	{
		final String method = JARM_REQUEST + ":createFolderHeader(String, String, String, String, Collection)";
		final Object[] args = new Object[]{name, parentRid, displayName, description, relations}; 
		enter(method, args);
		try {
			if (parentRid == null || name == null)
				throw new KMNodeException(RES_NULLINPUT);
			String userId = getContextUserId();
			KMUserContext	userContext = getUserContext();
			
			if (displayName == null)
				displayName = name;
			if (description == null)
				description = "";

			KMNodeHeader header = new KMNodeHeader();
			boolean isFolder = true;
			KMNodeAttribute[] attributes = setAttributesCreateHeader(userId, displayName, description);
			KMNodePermission[] permissions = setPermissions(userId); 

			WS.createNode(userContext, parentRid, name, isFolder, null, attributes, permissions, 
				(String[])relations.toArray(new String[relations.size()]));
		} 
		catch (Exception e) {
			//$JL-EXC$ ignore JLin warning
			KMNodeException nodeEx = new KMNodeException(RES_CANT_CREATE_FOLDER_HEADER, args, e);
			log(nodeEx, method, args);
			throw nodeEx;
		}
		finally {
			exit(method, null);
		}
	}

	public NodeHeader readFolderHeader(String name, String parentRid) throws KMNodeException {
		final String method = JARM_REQUEST + ":readFolderHeader(String, String)";
		final Object[] args = new Object[]{name, parentRid}; 
		enter(method, args);
		try {
			if (parentRid == null || name == null)
				throw new KMNodeException(RES_NULLINPUT);
			String rid = getRid(name, parentRid);
			KMNodeHeader kmHeader = WS.readNodeHeader(getUserContext(), rid, true, true, true);
			return createNodeHeader(kmHeader); 
		} 
		catch (Throwable e) {
			//$JL-EXC$ ignore JLin warning
			KMNodeException nodeEx = new KMNodeException(RES_CANT_READ_FOLDER_HEADER, args, e);
			log(nodeEx, method, args);
			throw nodeEx;
		}
		finally {
			exit(method, null);
		}
	}

	public NodeContent readFolderContent(String name, String parentRid) throws KMNodeException {
		final String method = JARM_REQUEST + ":readFolderContent(String, String)";
		final Object[] args = new Object[]{name, parentRid}; 
		enter(method, args);
		try {		
			if (parentRid == null || name == null)
				throw new KMNodeException(RES_NULLINPUT);
				
			String rid = getRid(name, parentRid);
			KMUserContext userContext = getUserContext();			
			KMNodeContent content = WS.readContent(userContext, rid, KMNodeConstants.defaultSizeLimitBytes);
			
			INodeContent resultContent = new NodeContent();
			resultContent.setName(name);
			resultContent.setParentRid(parentRid);
			resultContent.setContentLength(content.getContentLength());
			resultContent.setContentType(content.getContentType());
			resultContent.setContentEncoding(content.getContentEncoding());
			resultContent.setContent(content.getContent());
			return (NodeContent) resultContent;
		}
		catch (Throwable e) {
			//$JL-EXC$ ignore JLin warning
			KMNodeException nodeEx = new KMNodeException(RES_CANT_READ_FOLDER_CONTENT, args, e);
			log(nodeEx, method, args);
			throw nodeEx;
		}
		finally {
			exit(method, null);
		}
	}

	public void deleteFolder(String name, String parentRid) throws KMNodeException {
		final String method = JARM_REQUEST + ":deleteFolder(String, String)";
		final Object[] args = new Object[]{name, parentRid}; 
		enter(method, args);
		try {
			if (parentRid == null || name == null)
				throw new KMNodeException(RES_NULLINPUT);
			String rid = getRid(name, parentRid);
			WS.deleteNode(getUserContext(), rid);
		}
		catch (Throwable e) {
			//$JL-EXC$ ignore JLin warning
			KMNodeException nodeEx = new KMNodeException(RES_CANT_DELETE_FOLDER, args, e);
			log(nodeEx, method, args);
			throw nodeEx;
		}
		finally {
			exit(method, null);
		}
	}

	public void deleteEmptyFolders(String name, String parentRid) throws KMNodeException {
		final String method = JARM_REQUEST + ":deleteEmptyFolders(String, String)";
		final Object[] args = new Object[]{name, parentRid}; 
		enter(method, args);
		try {
			if (parentRid == null || name == null)
				throw new KMNodeException(RES_NULLINPUT, args);
			String rid = getRid(name, parentRid);
			KMUserContext userContext = getUserContext();			
			WS.deleteEmptyFolders(userContext, rid);
		}
		catch (Throwable e) {
			//$JL-EXC$ ignore JLin warning
			KMNodeException nodeEx = new KMNodeException(RES_CANT_DELETE_EMPTY_FOLDERS, args, e);
			log(nodeEx, method, args);
			throw nodeEx;
		}
		finally {
			exit(method, null);
		}
	}
	
	/**
	 * Business Method.
	 */
	public void saveFolderHeader(String name, String parentRid, String displayName, String description, Collection relations)
		throws KMNodeException {
		final String method = JARM_REQUEST + ":saveFolderHeader(String, String, String, String, Collection)";
		final Object[] args = new Object[]{name, parentRid}; 
		enter(method, args);
		try {
			if (name == null || parentRid == null)
				throw new KMNodeException(RES_NULLINPUT);
				
			if (displayName == null)
				displayName = name;
			if (description == null)
				description = "";
	
			String userId = getContextUserId();
			KMUserContext userContext = this.getUserContext();
	
			String rid = this.getRid(name, parentRid);
	
			KMNodeHeader header = new KMNodeHeader();
			KMNodeAttribute[] attributes = this.setAttributesSaveHeader(userId, displayName, description);
			KMNodePermission[] permissions = this.setPermissions(userId);
	
			WS.saveNodeHeader(userContext, rid, null, attributes, permissions, 
					(String[])relations.toArray(new String[relations.size()]));
		}
		catch (Throwable e) {
			//$JL-EXC$ ignore JLin warning
			KMNodeException nodeEx = new KMNodeException(RES_CANT_SAVE_FODLER_HEADER, args, e);
			log(nodeEx, method, args);
			throw nodeEx;
		}
		finally {
			exit(method, null);
		}
	}

	/**
	 * Business Method.
	 */
	public void saveFolderContent(String name, String parentRid, 
		long contentLength, String contentType,	String contentEncoding,	byte[] content)	throws KMNodeException 
	{
		final String method = JARM_REQUEST + ":saveFolderContent(String, String, long, String, String, byte[])";
		final Object[] args = new Object[]{name, parentRid, new Long(contentLength), contentType, contentEncoding, content}; 
		enter(method, args);
		try {		
			if (name == null || parentRid == null || content == null)
				throw new KMNodeException(RES_NULLINPUT);
			String rid = getRid(name, parentRid);
			//		long contentLength = content.length;
			//		String contentType = DocumentConstants.contentTypeText;
			//		String contentEncoding = DocumentConstants.contentEncodingNone;
	
			KMUserContext userContext = getUserContext();			
			WS.saveNodeContent(userContext, rid, content, contentType, contentEncoding, contentLength);
		}
		catch (Throwable e) {
			//$JL-EXC$ ignore JLin warning
			KMNodeException nodeEx = new KMNodeException(RES_CANT_SAVE_FOLDER_CONTENT, args, e);
			log(nodeEx, method, args);
			throw nodeEx;
		}
		finally {
			exit(method, null);
		}
	}

	/**
	 * Business Method.
	 */
	public Collection findFolder(String searchString, String startSearchRid) throws KMNodeException {
		final String method = JARM_REQUEST + ":findFolder(String, String)";
		final Object[] args = new Object[]{searchString, startSearchRid}; 
		enter(method, args);
		try {		
			if (searchString == null || startSearchRid == null )
				throw new KMNodeException(RES_NULLINPUT);
	
			KMNodeHeader[] proxyHeaders = null;
			LinkedList nodeHeaders = new LinkedList();
	
			KMUserContext userContext = getUserContext();
			proxyHeaders = WS.findNodeByDisplayName(userContext, searchString, startSearchRid);
			if (proxyHeaders != null) { 
				for ( int i = 0; i < proxyHeaders.length; i++ ) {
					nodeHeaders.add(proxyHeaders[i]);
				}
			}
			return nodeHeaders;
		}
		catch (Throwable e) {
			//$JL-EXC$ ignore JLin warning
			KMNodeException nodeEx = new KMNodeException(RES_CANT_FIND_FOLDER, args, e);
			log(nodeEx, method, args);
			throw nodeEx;
		}
		finally {
			exit(method, null);
		}
	}


	public NodeHeader[] getChildren(String name, String parentRid) throws KMNodeException {
		final String method = JARM_REQUEST + ":getChildren(String, String)";
		final Object[] args = new Object[]{name, parentRid}; 
		enter(method, args);
		try {		
			if (name == null || parentRid == null)
				throw new KMNodeException(RES_NULLINPUT);
	
			String rid = getRid(name, parentRid);
			rid = (rid.length() == 0) ? separator : rid;
	
			KMUserContext userContext = getUserContext();			
			KMNodeHeader[] proxyHeaders = WS.readChildren(userContext, rid, true, true, true);
	
			if (proxyHeaders.length == 0)
				return null;
			NodeHeader[] nodeHeaders = new NodeHeader[proxyHeaders.length];
	
			for (int i = 0; i < proxyHeaders.length; i++) {
				nodeHeaders[i] = createNodeHeader(proxyHeaders[i]);
			}
			return nodeHeaders;
		}
		catch (Throwable e) {
			//$JL-EXC$ ignore JLin warning
			KMNodeException nodeEx = new KMNodeException(RES_CANT_GET_CHILDERN, args, e);
			log(nodeEx, method, args);
			throw nodeEx;
		}
		finally {
			exit(method, null);
		}
	}
	
	public NodeChildren getNodeChildren(String name, String parentRid) throws KMNodeException {
		Collection documents = new ArrayList();
		Collection folder = new ArrayList();		
		NodeChildren children = new NodeChildren();		

		children.setName(name);
		children.setParentRid(parentRid);

		NodeHeader[] tmp = getChildren(name, parentRid);
		if(tmp!=null) {		
			for (int i = 0; i < tmp.length; i++) {
				if(tmp[i].isFolder())
					folder.add(tmp[i].getParentRid() + "/" + tmp[i].getName());
				else
				documents.add(tmp[i].getParentRid() + "/" + tmp[i].getName());			
			}				
		}
		children.setDocuments(documents);
		children.setFolder(folder);
		
		return children;
	}

	private NodeHeader createNodeHeader(KMNodeHeader kmHeader) throws KMNodeException {
		NodeHeader cafHeader = (NodeHeader)setExplicitAttributes(kmHeader);
		String[] relations = kmHeader.getRelations();
		cafHeader.setRelationRids(Arrays.asList(relations));		
		return cafHeader;
	}

	private KMNodeAttribute[] setAttributesCreateHeader(String userId, String displayName, String description) {

		KMNodeAttribute[] attributes = new KMNodeAttribute[2];
		java.util.Calendar currentDate = java.util.Calendar.getInstance();

		// Creation Date
		/*KMNodeAttribute attributeCreationdate = new KMNodeAttribute();
		attributeCreationdate.setNamespace(KMNodeConstants.namespace);
		attributeCreationdate.setName(KMNodeConstants.PROP_CREATIONDATE);
		attributeCreationdate.setDateValue(java.util.Calendar.getInstance());
		attributes[0] = attributeCreationdate;

		// Created By
		KMNodeAttribute attributeCreatedBy = new KMNodeAttribute();
		attributeCreatedBy.setNamespace(KMNodeConstants.namespace);
		attributeCreatedBy.setName(KMNodeConstants.PROP_CREATEDBY);
		attributeCreatedBy.setStringValue(userId);
		attributeCreatedBy.setDateValue(currentDate);
		attributes[1] = attributeCreatedBy;

		// Last Modified At
		KMNodeAttribute attributeLastmodified = new KMNodeAttribute();
		attributeLastmodified.setNamespace(KMNodeConstants.namespace);
		attributeLastmodified.setName(KMNodeConstants.PROP_LASTMODIFIED);
		attributeLastmodified.setDateValue(currentDate);
		attributes[2] = attributeLastmodified;

		// Last Modified By
		KMNodeAttribute attributeLastmodifiedby = new KMNodeAttribute();
		attributeLastmodifiedby.setNamespace(KMNodeConstants.namespace);
		attributeLastmodifiedby.setName(KMNodeConstants.PROP_LASTMODIFIEDBY);
		attributeLastmodifiedby.setStringValue(userId);
		attributes[3] = attributeLastmodifiedby;*/

		// Description
		KMNodeAttribute attributeDescription = new KMNodeAttribute();
		attributeDescription.setNamespace(KMNodeConstants.namespace);
		attributeDescription.setName(KMNodeConstants.PROP_DESCRIPTION);
		attributeDescription.setStringValue(description);
		attributes[0] = attributeDescription;

		// Display Name
		KMNodeAttribute attributeDisplayname = new KMNodeAttribute();
		attributeDisplayname.setNamespace(KMNodeConstants.namespace);
		attributeDisplayname.setName(KMNodeConstants.PROP_DISPLAYNAME);
		attributeDisplayname.setStringValue(displayName);
		attributes[1] = attributeDisplayname;

		return attributes;

	}

	private KMNodeAttribute[] setAttributesSaveHeader(String userId, String displayName, String description) {

		KMNodeAttribute[] attributes = new KMNodeAttribute[2];
		java.util.Calendar currentDate = java.util.Calendar.getInstance();

		// Last Modified At
		/*KMNodeAttribute attributeLastmodified = new KMNodeAttribute();
		attributeLastmodified.setNamespace(KMNodeConstants.namespace);
		attributeLastmodified.setName(KMNodeConstants.PROP_LASTMODIFIED);
		attributeLastmodified.setDateValue(currentDate);
		attributes[0] = attributeLastmodified;

		// Last Modified By
		KMNodeAttribute attributeLastmodifiedby = new KMNodeAttribute();
		attributeLastmodifiedby.setNamespace(KMNodeConstants.namespace);
		attributeLastmodifiedby.setName(KMNodeConstants.PROP_LASTMODIFIEDBY);
		attributeLastmodifiedby.setStringValue(userId);
		attributes[1] = attributeLastmodifiedby;*/

		// Description
		KMNodeAttribute attributeDescription = new KMNodeAttribute();
		attributeDescription.setNamespace(KMNodeConstants.namespace);
		attributeDescription.setName(KMNodeConstants.PROP_DESCRIPTION);
		attributeDescription.setStringValue(description);
		attributes[0] = attributeDescription;

		// Display Name
		KMNodeAttribute attributeDisplayname = new KMNodeAttribute();
		attributeDisplayname.setNamespace(KMNodeConstants.namespace);
		attributeDisplayname.setName(KMNodeConstants.PROP_DISPLAYNAME);
		attributeDisplayname.setStringValue(displayName);
		attributes[1] = attributeDisplayname;

		return attributes;

	}

	private KMNodeAttribute[] setAttributesSaveContent(String userId, long contentLength) {

		KMNodeAttribute[] attributes = new KMNodeAttribute[2];
		java.util.Calendar currentDate = java.util.Calendar.getInstance();

		// Content Type
		KMNodeAttribute attributeContentType = new KMNodeAttribute();
		attributeContentType.setNamespace(KMNodeConstants.namespace);
		attributeContentType.setName(KMNodeConstants.PROP_CONTENTTYPE);
		attributeContentType.setStringValue(KMNodeConstants.contentTypeText);
		attributes[0] = attributeContentType;

		// Content Length
		KMNodeAttribute attributeContentLength = new KMNodeAttribute();
		attributeContentLength.setNamespace(KMNodeConstants.namespace);
		attributeContentLength.setName(KMNodeConstants.PROP_CONTENTLENGTH);
		attributeContentLength.setLongIntValue(contentLength);
		attributes[1] = attributeContentLength;

		// Last Modified At
		/*KMNodeAttribute attributeLastmodified = new KMNodeAttribute();
		attributeLastmodified.setNamespace(KMNodeConstants.namespace);
		attributeLastmodified.setName(KMNodeConstants.PROP_LASTMODIFIED);
		attributeLastmodified.setDateValue(currentDate);
		attributes[2] = attributeLastmodified;

		// Last Modified By
		KMNodeAttribute attributeLastmodifiedby = new KMNodeAttribute();
		attributeLastmodifiedby.setNamespace(KMNodeConstants.namespace);
		attributeLastmodifiedby.setName(KMNodeConstants.PROP_LASTMODIFIEDBY);
		attributeLastmodifiedby.setStringValue(userId);
		attributes[3] = attributeLastmodifiedby;*/

		return attributes;

	}

	private KMNodePermission[] setPermissions(String userId) {

		KMNodePermission[] permissions = new KMNodePermission[1];

		KMNodePermission permission = new KMNodePermission();
		permission.setPrincipalId(userId);
		permission.setPrincipalType(0);
		permission.setPermission("fullcontrol");
		permissions[0] = permission;

		return permissions;
	}

	/*
	
	private IKMDocument setDocument(String name, String parentRid, KMNodeAttribute[] attributes, KMNodePermission[] permissions, KMNodeContent content) {
		
		IKMDocument document = new KMDocument();
		
		// name
		document.setName(name);
		
		// Rid
		document.setParentRid(parentRid);
		
			
		// Creation Date
		document.setCreationdate(this.getAttribute(DocumentConstants.PROP_CREATIONDATE, attributes).getDateValue());
				
		// Created By
		document.setCreatedBy(this.getAttribute(DocumentConstants.PROP_CREATEDBY, attributes).getStringValue());				
	
		// Last Modified At
		document.setLastmodifieddate(this.getAttribute(DocumentConstants.PROP_LASTMODIFIED, attributes).getDateValue());	
			
		// Last Modified By
		document.setLastmodifiedBy(this.getAttribute(DocumentConstants.PROP_LASTMODIFIEDBY, attributes).getStringValue());	
		
		// Description
		document.setDescription(this.getAttribute(DocumentConstants.PROP_DESCRIPTION, attributes).getStringValue());	
		
		// Display Name
		document.setDisplayName(this.getAttribute(DocumentConstants.PROP_DISPLAYNAME, attributes).getStringValue());
		
		// Permissions
		document.setPermissions(permissions);
		
		// Content
		document.setContent(content.getContent());		
		
		return document;
	}
	
	*/

	private KMNodeAttribute getAttribute(String attributeName, KMNodeAttribute[] attributes) {

		for (int i = 0; i < attributes.length; i++) {
			if (attributes[i].getName().equalsIgnoreCase(attributeName)
				&& attributes[i].getNamespace().equalsIgnoreCase(KMNodeConstants.namespace)) {
				return attributes[i];
			}
		}
		return null;
	}

	private String getName(String Rid) {

		int keyLength = 0;
		int keyLastSeparator = 0;
		keyLength = Rid.length();
		if (keyLength == 0) {
			return null;
		} else {
			keyLastSeparator = Rid.lastIndexOf(separator);
			//RID ends with "/"?			
			if (keyLastSeparator == keyLength - 1) {
				keyLastSeparator = Rid.lastIndexOf(separator, keyLength - 1);
			}
			return Rid.substring(keyLastSeparator + 1);
		}
	}

	private String getRid(String name, String parentRid) {

		int keyLength = 0;
		int keyLastSeparator = 0;
		keyLength = parentRid.length();
		keyLastSeparator = parentRid.lastIndexOf(separator);
		//RID ends with "/"?			
		if (keyLastSeparator == keyLength - 1)
			return parentRid + name;
		else
			return parentRid + separator + name;
	}

	private String getParentRid(String Rid) {
		if (Rid == null)
			return null;

		int keyLength = 0;
		int keyLastSeparator = 0;
		keyLength = Rid.length();
		if (keyLength == 0) {
			return "";
		} else {
			keyLastSeparator = Rid.lastIndexOf(separator);
			//RID ends with "/"?			
			if (keyLastSeparator == keyLength - 1) {
				keyLastSeparator = Rid.lastIndexOf(separator, keyLength - 1);
			}
			return Rid.substring(0, keyLastSeparator);
		}
	}

	private INodeHeader setExplicitAttributes(KMNodeHeader listHeader) {

		INodeHeader attributeHeader = new NodeHeader();
		String rid = listHeader.getRid();
		
		attributeHeader.setName(this.getName(rid));
		attributeHeader.setParentRid(this.getParentRid(rid));
		attributeHeader.setIsFolder(listHeader.getFolder());
		attributeHeader.setSize(listHeader.getNodeSize());

		KMNodeAttribute[] attrs = listHeader.getAttributes();
		KMNodeAttribute attr;

		if (attrs != null) {
			attr = this.getAttribute(KMNodeConstants.PROP_CREATIONDATE, attrs);
			if (attr != null) {
				attributeHeader.setCreationdate(attr.getDateValue());
			}
			attr = this.getAttribute(KMNodeConstants.PROP_CREATEDBY, attrs);
			if (attr != null) {
				attributeHeader.setCreatedBy(attr.getStringValue());
			}
			attr = this.getAttribute(KMNodeConstants.PROP_LASTMODIFIED, attrs);
			if (attr != null) {
				attributeHeader.setLastmodifieddate(attr.getDateValue());
			}
			attr = this.getAttribute(KMNodeConstants.PROP_LASTMODIFIEDBY, attrs);
			if (attr != null) {
				attributeHeader.setLastmodifiedBy(attr.getStringValue());
			}
			attr = this.getAttribute(KMNodeConstants.PROP_DISPLAYNAME, attrs);
			if (attr != null) {
				attributeHeader.setDisplayName(attr.getStringValue());
			}
			attr = this.getAttribute(KMNodeConstants.PROP_DESCRIPTION, attrs);
			if (attr != null) {
				attributeHeader.setDescription(attr.getStringValue());
			}

			attr = this.getAttribute(KMNodeConstants.PROP_HIDDEN, attrs);
			if (attr != null) {
				attributeHeader.setIsHidden(attr.getBooleanValue());
			}
		}
		attributeHeader.setPermissions(listHeader.getPermissions());

		return attributeHeader;

	}
	
	private KMUserContext getUserContext() throws UMException {

		KMUserContext userContext = null;
		//	TODO: temporary change due to failure to map UME and J2EE users 	
		//		IUser user = null;
		//	
		//	
		//			//get the userId from EJB context, transfer it to user of UM
		//	String userId = myContext.getCallerPrincipal().getName();
		//
		//	try {
		// 		user = userFactory.getUser(userId);
		//	} catch (UMException umE) {
		//		throw new UMException(
		//			"User " + userId + " does not exist in UM");
		//	}
		//	userContext = new KMUserContext();
		//	userContext.setCountryCode(user.getLocale().getCountry());
		//	userContext.setLanguageCode(user.getLocale().getLanguage());
		//	return userContext;

		userContext = new KMUserContext();
		userContext.setCountryCode(java.util.Locale.US.getCountry());
		userContext.setLanguageCode(java.util.Locale.US.getLanguage());
		return userContext;

	}	

	private String getContextUserId() throws UMException {

		//TODO: temporary change due to failure to map UME and J2EE users 	
		return "admin";
		//		IUser user = null;
		//	
		//			//get the userId from EJB context, transfer it to user of UM
		//	String userId = myContext.getCallerPrincipal().getName();
		//
		//	try {
		//		user = userFactory.getUser(userId);
		//	} catch (UMException umE) {
		//		throw new UMException(
		//			"User " + userId + " does not exist in UM");
		//	}
		//	
		//	return userId;
	}

	protected Location getLocation() {
		return location;
	}

	protected String getJARMRequest() {
		return JARM_REQUEST;
	}

}
