package com.sap.caf.km.ejb.data.document;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;

import javax.ejb.CreateException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.rpc.ServiceException;

import com.sap.caf.km.da.KMDataAccessBean;
import com.sap.caf.km.da.KMDataAccessHelper;
import com.sap.caf.km.da.RidUtils;
import com.sap.caf.km.ejb.data.folder.FolderProxyEJBLocal;
import com.sap.caf.km.ejb.data.util.IKMNodeExceptionResourceKeys;
import com.sap.caf.km.ejb.data.util.INodeHeader;
import com.sap.caf.km.ejb.data.util.KMNodeConstants;
import com.sap.caf.km.ejb.data.util.KMNodeException;
import com.sap.caf.km.ejb.data.util.NodeContent;
import com.sap.caf.km.ejb.data.util.NodeHeader;
import com.sap.caf.km.ejb.data.util.ProxyHelper;
import com.sap.caf.km.proxies.data.kmnode.KMNodeService;
import com.sap.caf.km.proxies.data.kmnode.KMNodeServiceService;
import com.sap.caf.km.proxies.data.kmnode.types.KMNodeAttribute;
import com.sap.caf.km.proxies.data.kmnode.types.KMNodeHeader;
import com.sap.caf.km.proxies.data.kmnode.types.KMNodePermission;
import com.sap.caf.km.proxies.data.kmnode.types.KMUserContext;
import com.sap.caf.km.proxies.data.kmnodecontent.NodeContentSvc;
import com.sap.caf.km.proxies.data.kmnodecontent.NodeContentSvcViRpcEnc;
import com.sap.caf.km.proxies.data.kmnodecontent.types.NodeContentStruct;
import com.sap.caf.km.proxies.svc.kmbasesvc.KMBasesvc;
import com.sap.caf.km.proxies.svc.kmbasesvc.KMBasesvcService;
import com.sap.caf.km.proxies.svc.kmrelation.KMRelationSvc;
import com.sap.caf.km.proxies.svc.kmrelation.KMRelationSvcService;
import com.sap.caf.rt.bol.context.CAFProperties;
import com.sap.caf.rt.exception.DataAccessException;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.security.api.IUser;
import com.sap.security.api.IUserFactory;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import com.sap.tc.logging.Location;


/**
 * @ejbHome <{none}>
 * @ejbLocal <{com.sap.caf.km.document.DocumentProxyEJBLocal}>
 * @ejbLocalHome <{com.sap.caf.km.document.DocumentProxyEJBLocalHome}>
 * @ejbRemote <{none}>
 * @stateless 
 */
public class DocumentProxyEJBBean extends KMDataAccessBean implements IKMNodeExceptionResourceKeys {
			
	private static final String APPLICATION = DocumentProxyEJBBean.class.getName();
	private static final String jARMReqPrefix = "CAF:RT:oal:"; 
	private static final String JARM_REQUEST =  jARMReqPrefix + APPLICATION;		
	private static final Location location = Location.getLocation(APPLICATION);
	
	private final String separator = "/";

	transient InitialContext JNDIcontext = null;
	transient KMNodeService WS = null;
	transient KMNodeServiceService WSService = null;
	transient KMRelationSvc WSRelation = null;
	transient KMRelationSvcService WSRelationService = null;
	transient NodeContentSvcViRpcEnc WSNodeContentSvc = null;
	transient KMBasesvcService WSBaseService = null;
	transient KMBasesvc WSBase = null;
	
	KMUserContext userContext = null;

	String userId = null;
	IUser user = null;
	transient IUserFactory userFactory = UMFactory.getUserFactory();
 
	public void ejbCreate() throws CreateException {
		final String method = JARM_REQUEST + ":ejbCreate()";
		enter(method, null);
		try {
			// instantiate JNDI lookup
			if (JNDIcontext == null) {
				try {
					JNDIcontext = new InitialContext();
					WSService = (KMNodeServiceService) JNDIcontext.lookup("wsclients/proxies/sap.com/caf~km.proxies/KMNodeJNDI");
		 			WS = (KMNodeService) WSService.getLogicalPort(KMNodeService.class);

					String url =
						ProxyHelper.getActualUrl((String) WS._getProperty(KMNodeService.ENDPOINT_ADDRESS_PROPERTY));
					if (!url.equals(WS._getProperty(KMNodeService.ENDPOINT_ADDRESS_PROPERTY))) {
						WS._setProperty(KMNodeService.ENDPOINT_ADDRESS_PROPERTY, url);
						
						String str = (String)WS._getProperty(KMNodeService.ENDPOINT_ADDRESS_PROPERTY);
						CAFPublicLogger.LOC_CAF.infoT("Portal KMNodeService URL=" + str);
					}

					// instantiate JNDI lookup for relation handling						
					WSRelationService = (KMRelationSvcService) JNDIcontext.lookup("wsclients/proxies/sap.com/caf~km.proxies/KMRelationJNDI");
					WSRelation = (KMRelationSvc) WSRelationService.getLogicalPort(KMRelationSvc.class);

					url = ProxyHelper.getActualUrl((String) WSRelation._getProperty(KMNodeService.ENDPOINT_ADDRESS_PROPERTY));
					if (!url.equals(WSRelation._getProperty(KMNodeService.ENDPOINT_ADDRESS_PROPERTY))) {
						WSRelation._setProperty(KMNodeService.ENDPOINT_ADDRESS_PROPERTY, url);
					}

					// instantinate KMBase service					
					WSBaseService = (KMBasesvcService) JNDIcontext.lookup("wsclients/proxies/sap.com/caf~km.proxies/KMBasesvcJNDI");
					WSBase = (KMBasesvc)WSBaseService.getLogicalPort(KMBasesvc.class);

					url = ProxyHelper.getActualUrl((String) WSBase._getProperty(KMBasesvc.ENDPOINT_ADDRESS_PROPERTY));
					if (!url.equals(WSBase._getProperty(KMBasesvc.ENDPOINT_ADDRESS_PROPERTY))) {
						WSBase._setProperty(KMBasesvc.ENDPOINT_ADDRESS_PROPERTY, url);
					}
					
//					NodeContentSvc svc = (NodeContentSvc)JNDIcontext.lookup("wsclients/proxies/sap.com/caf~km.proxies/KMNodeContentSvcProxy");
//					WSNodeContentSvc = svc.getConfig1PortMime();
				} catch (Throwable e) {
					//	$JL-EXC$ 
					KMNodeException nodeEx = new KMNodeException(RES_CANT_CREATE_EJB, e); 
					log(nodeEx, method, null);
					throw new CreateException(nodeEx.getLocalizedMessage());
				}
			}
				/* TODO next release - first release: service user
				//get the userId from EJB context, transfer it to user of UM
				userId = myContext.getCallerPrincipal().getName();
				try {
					user = userFactory.getUser(userId);
				} catch (UMException umE) {
					throw new CreateException(
						"User " + userId + " does not exist in UM");
				}
				userContext = new KMUserContext();
				userContext.setCountryCode(user.getLocale().getCountry());
				userContext.setLanguageCode(user.getLocale().getLanguage());
				*/
		}
		finally {
			exit(method, null);
		}
	}

	public void move(String sourceRid, String targetRid) throws KMNodeException {
		final String method = JARM_REQUEST + ":move(String, String)";
		final Object[] args = {sourceRid, targetRid};
		enter(method, args);
		try {
			if (sourceRid == null || targetRid == null) {
				throw new KMNodeException(RES_NULLINPUT);
			}
			KMUserContext userContext = this.getUserContext();
			WS.moveNode(userContext, sourceRid, targetRid);
		} 
		catch (Throwable e) {
			//$JL-EXC$ ignore JLin warning
			KMNodeException nodeEx = new KMNodeException(RES_CANT_MOVE_NODE, args, e);
			log(nodeEx, method, args);
			throw nodeEx;
		}
		finally {
			exit(method, null);
		}
	}

	public String copyToFolder(String srcResRid, String dstDirRid) throws KMNodeException {
		final String method = JARM_REQUEST + ":moveToFolder(String, String)";
		final Object[] args = {srcResRid, dstDirRid};
		enter(method, args);
		try {
			if (srcResRid == null || dstDirRid == null)
				throw new KMNodeException(RES_NULLINPUT);
			return WS.copyNodeToFolder(getUserContext(), srcResRid, dstDirRid);
		}
		catch (Throwable e) {
			//$JL-EXC$ ignore JLin warning
			KMNodeException nodeEx = new KMNodeException(RES_CANT_MOVE_NODE_TO_FOLDER, args, e); 
			log(nodeEx, method, args);
			throw nodeEx;
		}
		finally {
			exit(method, null);
		}
	}
	
	public void copy(String sourceRid, String targetRid) throws KMNodeException {
		final String method = JARM_REQUEST + ":copy(String, String)";
		final Object[] args = {sourceRid, targetRid};
		enter(method, args);
		try {
			if (sourceRid == null || targetRid == null)
				throw new KMNodeException(RES_NULLINPUT);
			KMUserContext userContext = this.getUserContext();
			WS.copyNode(userContext, sourceRid, targetRid);
		}
		catch (Throwable e) {
			//$JL-EXC$ ignore JLin warning
			KMNodeException nodeEx = new KMNodeException(RES_CANT_COPY_NODE, args, e);
			log(nodeEx, method, args);
			throw nodeEx;
		}
		finally {
			exit(method, null);
		}
	}

	public void link(String sourceRid, String targetRid) throws KMNodeException {
		final String method = JARM_REQUEST + ":link(String, String)";
		final Object[] args = {sourceRid, targetRid};
		enter(method, args);
		try {
			if (sourceRid == null || targetRid == null)
				throw new KMNodeException(RES_NULLINPUT);
			KMUserContext userContext = this.getUserContext();
			WS.linkNode(userContext, sourceRid, targetRid);
		}
		catch (Throwable e) {
			//$JL-EXC$ ignore JLin warning
			KMNodeException nodeEx = new KMNodeException(RES_CANT_LINK_NODE, args, e);
			log(nodeEx, method, args);
			throw nodeEx;
		}
		finally {
			exit(method, null);
		}
	}

	public boolean exists(String documentRid) throws KMNodeException {
		final String method = JARM_REQUEST + ":exists(String)";
		final Object[] args = {documentRid};
		enter(method, args);
		try {
			if (documentRid==null)
				throw new KMNodeException(RES_NULLINPUT);
			return WS.exists(getUserContext(), documentRid);
		}
		catch (Throwable e) {
			//$JL-EXC$ ignore JLin warning
			KMNodeException nodeEx = new KMNodeException(RES_CANT_CHECK_EXIST, args, e);
			log(nodeEx, method, args);
			throw nodeEx;
		}
		finally {
			exit(method, null);
		}
	}

	public void createDocumentHeader(String name,	String parentRid,	String displayName,
		String description,	String link,	Collection relations)	throws KMNodeException 
	{
		final String method = JARM_REQUEST + ":createDocumentHeader(String, String, String, String, String, Collection)";
		final Object[] args = new Object[]{name, parentRid, displayName, description, link, relations}; 
		enter(method, args);
		try {
			if (parentRid == null || name == null)
				throw new KMNodeException(RES_NULLINPUT);
			String userId = this.getContextUserId();
			KMUserContext userContext = this.getUserContext();
			
			if (displayName == null)
				displayName = name;
			if (description == null)
				description = "";
	
			KMNodeHeader header = new KMNodeHeader();
			boolean isFolder = false;
			KMNodeAttribute[] attributes;
			KMNodePermission[] permissions;
			attributes = this.setAttributesCreateHeader(userId, displayName, description);
			permissions = this.setPermissions(userId);
			
			String[] aRelations;
			if (relations!=null) {
				aRelations = (String[]) relations.toArray(new String[relations.size()]);
			} else {
				aRelations = new String[0];
			}	
			
			WS.createNode(userContext, parentRid, name, isFolder, link, attributes, permissions, aRelations);
		} 
		catch (Exception e) {
			//$JL-EXC$ ignore JLin warning
			KMNodeException nodeEx = new KMNodeException(RES_CANT_CREATE_DOC_HEADER, args, e);
			log(nodeEx, method, args);
			throw nodeEx;
		}
		finally {
			exit(method, null);
		}
	}

	public NodeHeader readDocumentHeader(String name, String parentRid) throws KMNodeException {
		final String method = JARM_REQUEST + ":readDocumentHeader(String, String)";
		final Object[] args = new Object[]{name, parentRid}; 
		enter(method, args);
		try {
			if (parentRid == null || name == null)
				throw new KMNodeException(RES_NULLINPUT);
			String Rid = this.getRid(name, parentRid);
			return createNodeHeader(WS.readNodeHeader(getUserContext(), Rid, true, true, true));
		} 
		catch (Throwable e) {
			//$JL-EXC$ ignore JLin warning
			KMNodeException nodeEx = new KMNodeException(RES_CANT_READ_DOC_HEADER, args, e);
			log(nodeEx, method, args);
			throw nodeEx;
		}
		finally {
			exit(method, null);
		}
	}
	
	public NodeHeader[] readDocumentHeaders(String[] rids) throws KMNodeException {
		final String method = JARM_REQUEST + ":readDocumentHeaders(String[])";
		final Object[] args = new Object[]{rids}; 
		enter(method, args);
		try {
			if (rids == null || rids.length == 0) {
				return null;
			}
			KMUserContext userContext = this.getUserContext();
			KMNodeHeader[] kmHeaders = WS.readNodeHeader(userContext, rids, true, true, true);
			NodeHeader[] cafHeaders = new NodeHeader[kmHeaders.length];
			for(int i=kmHeaders.length-1; i>=0; i--) {
				cafHeaders[i] = (kmHeaders[i]!=null? createNodeHeader(kmHeaders[i]): null);
			}
			return cafHeaders;
		} 
		catch (Exception e) {
			//$JL-EXC$ ignore JLin warning
			KMNodeException nodeEx = new KMNodeException(RES_CANT_READ_DOC_HEADER_BUNCH, args, e);
			log(nodeEx, method, args);
			throw nodeEx;
		}
		finally {
			exit(method, null);
		}
	}
	
	private NodeHeader createNodeHeader(KMNodeHeader kmHeader) throws KMNodeException {
		NodeHeader cafHeader = (NodeHeader)setExplicitAttributes(kmHeader);
		String[] relations = kmHeader.getRelations();
		cafHeader.setRelationRids(Arrays.asList(relations));		
		return cafHeader;
	}
	
	public Collection getDocumentRelations(String docRid) throws KMNodeException {
		final String method = JARM_REQUEST + ":getDocumentRelations(String)";
		final Object[] args = new Object[]{docRid}; 
		enter(method, args);
		try {
			String[] resultRelations = WSRelation.getRelatedRIDs(docRid);
			return (Collection)Arrays.asList(resultRelations);
		} 
		catch (Throwable e) {
			//$JL-EXC$ ignore JLin warning
			KMNodeException nodeEx = new KMNodeException(RES_CANT_GET_DOC_RELATIONS, args, e);
			log(nodeEx, method, args);
			throw nodeEx;
		}
		finally {
			exit(method, null);
		}
	}
	
	public void updateDocumentRelations(String docRid, Collection boRids) throws KMNodeException {
		final String method = JARM_REQUEST + ":updateDocumentRelations(String, Collection)";
		final Object[] args = new Object[]{docRid, boRids}; 
		enter(method, args);
		try {
			WSRelation.updateRelations(docRid, (String[])boRids.toArray(new String[boRids.size()]));
		}
		catch (Throwable e) {
			//$JL-EXC$ ignore JLin warning
			KMNodeException nodeEx = new KMNodeException(RES_CANT_UPDATE_DOC_RELATIONS, args, e);
			log(nodeEx, method, args);
			throw nodeEx;
		}
		finally {
			exit(method, null);
		}
	}	
		
	public NodeContent readDocumentContent(String name, String parentRid) throws KMNodeException {
		final String method = JARM_REQUEST + ":readDocumentContent(String, String)";
		final Object[] args = new Object[]{name, parentRid}; 
		enter(method, args);
		try {		
			if (parentRid == null || name == null)
				throw new KMNodeException(RES_NULLINPUT);
			String Rid = getRid(name, parentRid);
			KMUserContext userContext = getUserContext();
			return readNodeContent(userContext, name, parentRid, KMNodeConstants.defaultSizeLimitBytes);
		}
		catch (Throwable e) {
			//$JL-EXC$ ignore JLin warning
			KMNodeException nodeEx = new KMNodeException(RES_CANT_READ_DOC_CONTENT, args, e);
			log(nodeEx, method, args);
			throw nodeEx;
		}
		finally {
			exit(method, null);
		}
	}

	public void deleteDocument(String name, String parentRid) throws KMNodeException {
		final String method = JARM_REQUEST + ":deleteDocument(String, String)";
		final Object[] args = new Object[]{name, parentRid}; 
		enter(method, args);
		try {		
			if (parentRid == null || name == null)
				throw new KMNodeException(RES_NULLINPUT);
			String Rid = getRid(name, parentRid);
			KMUserContext userContext = getUserContext();
			WS.deleteNode(userContext, Rid);
		}
		catch (Throwable e) {
			//$JL-EXC$ ignore JLin warning
			KMNodeException nodeEx = new KMNodeException(RES_CANT_DELETE_DOC, args, e);
			log(nodeEx, method, args);
			throw nodeEx;
		}
		finally {
			exit(method, null);
		}
	}

	public void saveDocumentHeader(String name, String parentRid, String displayName,
		String description,	String link,	Collection relations)	throws KMNodeException 
	{
		final String method = JARM_REQUEST + ":saveDocumentHeader(String, String, String, String, String, Collection)";
		final Object[] args = new Object[]{name, parentRid}; 
		enter(method, args);
		try {		
			if (name == null || parentRid == null)
				throw new KMNodeException(RES_NULLINPUT);
			String userId = getContextUserId();
			KMUserContext userContext = getUserContext();
			String rid = getRid(name, parentRid);
			KMNodeHeader header = new KMNodeHeader();
			KMNodeAttribute[] attributes = setAttributesSaveHeader(userId, displayName, description);
			KMNodePermission[] permissions = setPermissions(userId);
			String[] sRelations = null;
			if (relations!=null) {
				sRelations = (String[])relations.toArray(new String[relations.size()]);
			} else {
				sRelations = new String[0];
			}
 			WS.saveNodeHeader(userContext, rid, link, attributes, permissions, sRelations);
		}
		catch (Throwable e) {
			//$JL-EXC$ ignore JLin warning
			KMNodeException nodeEx = new KMNodeException(RES_CANT_SAVE_DOC_HEADER, args, e);
			log(nodeEx, method, args);
			throw nodeEx;
		}
		finally {
			exit(method, null);
		}
	}

	public void saveDocumentContent(String name, String parentRid, long contentLength,
		String contentType,	String contentEncoding,	byte[] content)	throws KMNodeException 
	{
		final String method = JARM_REQUEST + ":saveDocumentContent(String, String, long, String, String, byte[])";
		final Object[] args = new Object[]{name, parentRid, new Long(contentLength), contentType, contentEncoding, content}; 
		enter(method, args);
		try {		
			if (name == null || parentRid == null || content == null)
				throw new KMNodeException(RES_NULLINPUT);
			KMUserContext userContext = getUserContext();
			getNodeContentSvc().saveNodeContent(getRid(name, parentRid), content, contentType, contentEncoding, contentLength);
		}
		catch (Throwable e) {
			//$JL-EXC$ ignore JLin warning
			KMNodeException nodeEx = new KMNodeException(RES_CANT_SAVE_DOC_CONTENT, args, e);
			log(nodeEx, method, args);
			throw nodeEx;
		}
		finally {
			exit(method, null);
		}
	}

	public Collection findDocument(String searchString, String startSearchRid) throws KMNodeException {
		final String method = JARM_REQUEST + ":findDocument(String, String)";
		final Object[] args = new Object[]{searchString, startSearchRid}; 
		enter(method, args);
		try {		
			if (searchString == null || startSearchRid == null )
				throw new KMNodeException(RES_NULLINPUT);
			KMUserContext userContext = getUserContext();
			KMNodeHeader[] resultArray = WS.findNodeByDisplayName(userContext, searchString, startSearchRid);
			LinkedList result = new LinkedList();
			if (resultArray != null) { 
				for ( int i = 0; i < resultArray.length; i++ ) {
					result.add(resultArray[i]);
				}
			}
			return result;
		}
		catch (Throwable e) {
			//$JL-EXC$ ignore JLin warning
			KMNodeException nodeEx = new KMNodeException(RES_CANT_FIND_DOC, args, e);
			log(nodeEx, method, args);
			throw nodeEx;
		}
		finally {
			exit(method, null);
		}
	}

	private KMNodeAttribute[] setAttributesCreateHeader(String userId, String displayName, String description) {

		KMNodeAttribute[] attributes = new KMNodeAttribute[2];
		java.util.Calendar currentDate = java.util.Calendar.getInstance();
		//
		//		// Creation Date
		//		KMNodeAttribute attributeCreationdate = new KMNodeAttribute();
		//		attributeCreationdate.setNamespace(KMNodeConstants.namespace);
		//		attributeCreationdate.setName(KMNodeConstants.PROP_CREATIONDATE);
		//		attributeCreationdate.setDateValue(java.util.Calendar.getInstance());
		//		attributes[0] = attributeCreationdate;
		//
		//		// Created By
		//		KMNodeAttribute attributeCreatedBy = new KMNodeAttribute();
		//		attributeCreatedBy.setNamespace(KMNodeConstants.namespace);
		//		attributeCreatedBy.setName(KMNodeConstants.PROP_CREATEDBY);
		//		attributeCreatedBy.setStringValue(userId);
		//		attributeCreatedBy.setDateValue(currentDate);
		//		attributes[1] = attributeCreatedBy;
		//
		//		// Last Modified At
		//		KMNodeAttribute attributeLastmodified = new KMNodeAttribute();
		//		attributeLastmodified.setNamespace(KMNodeConstants.namespace);
		//		attributeLastmodified.setName(KMNodeConstants.PROP_LASTMODIFIED);
		//		attributeLastmodified.setDateValue(currentDate);
		//		attributes[2] = attributeLastmodified;
		//
		//		// Last Modified By
		//		KMNodeAttribute attributeLastmodifiedby = new KMNodeAttribute();
		//		attributeLastmodifiedby.setNamespace(KMNodeConstants.namespace);
		//		attributeLastmodifiedby.setName(KMNodeConstants.PROP_LASTMODIFIEDBY);
		//		attributeLastmodifiedby.setStringValue(userId);
		//		attributes[3] = attributeLastmodifiedby;

		// Description
		KMNodeAttribute attributeDescription = new KMNodeAttribute();
		attributeDescription.setNamespace(KMNodeConstants.namespace);
		attributeDescription.setName(KMNodeConstants.PROP_DESCRIPTION);
		attributeDescription.setStringValue(description);
		attributes[0] = attributeDescription;

		// Display Name
		KMNodeAttribute attributeDisplayname = new KMNodeAttribute();
		attributeDisplayname.setNamespace(KMNodeConstants.namespace);
		attributeDisplayname.setName(KMNodeConstants.PROP_DISPLAYNAME);
		attributeDisplayname.setStringValue(displayName);
		attributes[1] = attributeDisplayname;

		return attributes;

	}

	private KMNodeAttribute[] setAttributesSaveHeader(String userId, String displayName, String description) {

//		KMNodeAttribute[] attributes = new KMNodeAttribute[2];
//		java.util.Calendar currentDate = java.util.Calendar.getInstance();

		//		// Last Modified At
		//		KMNodeAttribute attributeLastmodified = new KMNodeAttribute();
		//		attributeLastmodified.setNamespace(KMNodeConstants.namespace);
		//		attributeLastmodified.setName(KMNodeConstants.PROP_LASTMODIFIED);
		//		attributeLastmodified.setDateValue(currentDate);
		//		attributes[0] = attributeLastmodified;
		//
		//		// Last Modified By
		//		KMNodeAttribute attributeLastmodifiedby = new KMNodeAttribute();
		//		attributeLastmodifiedby.setNamespace(KMNodeConstants.namespace);
		//		attributeLastmodifiedby.setName(KMNodeConstants.PROP_LASTMODIFIEDBY);
		//		attributeLastmodifiedby.setStringValue(userId);
		//		attributes[1] = attributeLastmodifiedby;

		ArrayList attributes = new ArrayList();
		// Description
		if (description!=null && description.length()>0) {
			KMNodeAttribute attributeDescription = new KMNodeAttribute();
			attributeDescription.setNamespace(KMNodeConstants.namespace);
			attributeDescription.setName(KMNodeConstants.PROP_DESCRIPTION);
			attributeDescription.setStringValue(description);
			attributes.add(attributeDescription);
		}

		// Display Name
		if (displayName!=null && displayName.length()>0) {
			KMNodeAttribute attributeDisplayname = new KMNodeAttribute();
			attributeDisplayname.setNamespace(KMNodeConstants.namespace);
			attributeDisplayname.setName(KMNodeConstants.PROP_DISPLAYNAME);
			attributeDisplayname.setStringValue(displayName);
			attributes.add(attributeDisplayname);
		}

		return (KMNodeAttribute[])attributes.toArray(new KMNodeAttribute[attributes.size()]);
	}

	private KMNodeAttribute[] setAttributesSaveContent(String userId, long contentLength) {

		KMNodeAttribute[] attributes = new KMNodeAttribute[2];
		java.util.Calendar currentDate = java.util.Calendar.getInstance();

		// Content Type
		KMNodeAttribute attributeContentType = new KMNodeAttribute();
		attributeContentType.setNamespace(KMNodeConstants.namespace);
		attributeContentType.setName(KMNodeConstants.PROP_CONTENTTYPE);
		attributeContentType.setStringValue(KMNodeConstants.contentTypeText);
		attributes[0] = attributeContentType;

		// Content Length
		KMNodeAttribute attributeContentLength = new KMNodeAttribute();
		attributeContentLength.setNamespace(KMNodeConstants.namespace);
		attributeContentLength.setName(KMNodeConstants.PROP_CONTENTLENGTH);
		attributeContentLength.setLongIntValue(contentLength);
		attributes[1] = attributeContentLength;

		//		// Last Modified At
		//		KMNodeAttribute attributeLastmodified = new KMNodeAttribute();
		//		attributeLastmodified.setNamespace(KMNodeConstants.namespace);
		//		attributeLastmodified.setName(KMNodeConstants.PROP_LASTMODIFIED);
		//		attributeLastmodified.setDateValue(currentDate);
		//		attributes[2] = attributeLastmodified;
		//
		//		// Last Modified By
		//		KMNodeAttribute attributeLastmodifiedby = new KMNodeAttribute();
		//		attributeLastmodifiedby.setNamespace(KMNodeConstants.namespace);
		//		attributeLastmodifiedby.setName(KMNodeConstants.PROP_LASTMODIFIEDBY);
		//		attributeLastmodifiedby.setStringValue(userId);
		//		attributes[3] = attributeLastmodifiedby;

		return attributes;

	}

	private KMNodePermission[] setPermissions(String userId) {
		KMNodePermission[] permissions = new KMNodePermission[1];
		KMNodePermission permission = new KMNodePermission();
		permission.setPrincipalId(userId);
		permission.setPrincipalType(0);
		permission.setPermission("fullcontrol");
		permissions[0] = permission;
		return permissions;
	}

	/*
	
	private IKMDocument setDocument(String name, String parentRid, KMNodeAttribute[] attributes, KMNodePermission[] permissions, KMNodeContent content) {
		
		IKMDocument document = new KMDocument();
		
		// name
		document.setName(name);
		
		// Rid
		document.setParentRid(parentRid);
		
			
		// Creation Date
		document.setCreationdate(this.getAttribute(DocumentConstants.PROP_CREATIONDATE, attributes).getDateValue());
				
		// Created By
		document.setCreatedBy(this.getAttribute(DocumentConstants.PROP_CREATEDBY, attributes).getStringValue());				
	
		// Last Modified At
		document.setLastmodifieddate(this.getAttribute(DocumentConstants.PROP_LASTMODIFIED, attributes).getDateValue());	
			
		// Last Modified By
		document.setLastmodifiedBy(this.getAttribute(DocumentConstants.PROP_LASTMODIFIEDBY, attributes).getStringValue());	
		
		// Description
		document.setDescription(this.getAttribute(DocumentConstants.PROP_DESCRIPTION, attributes).getStringValue());	
		
		// Display Name
		document.setDisplayName(this.getAttribute(DocumentConstants.PROP_DISPLAYNAME, attributes).getStringValue());
		
		// Permissions
		document.setPermissions(permissions);
		
		// Content
		document.setContent(content.getContent());		
		
		return document;
	}
	
	*/

	private KMNodeAttribute getAttribute(String attributeName, KMNodeAttribute[] attributes) {
		for (int i = 0; i < attributes.length; i++) {
			if (attributes[i].getName().equalsIgnoreCase(attributeName)
				&& attributes[i].getNamespace().equalsIgnoreCase(KMNodeConstants.namespace)) {
				return attributes[i];
			}
		}
		return null;
	}

	private String getName(String Rid) {
		int keyLength = 0;
		int keyLastSeparator = 0;
		keyLength = Rid.length();
		if (keyLength == 0) {
			return null;
		} else {
			keyLastSeparator = Rid.lastIndexOf(separator);
			//RID ends with "/"?			
			if (keyLastSeparator == keyLength - 1) {
				keyLastSeparator = Rid.lastIndexOf(separator, keyLength - 1);
			}
			return Rid.substring(keyLastSeparator + 1);
		}
	}

	private String getRid(String name, String parentRid) {
		int keyLength = 0;
		int keyLastSeparator = 0;
		keyLength = parentRid.length();
		keyLastSeparator = parentRid.lastIndexOf(separator);
		//RID ends with "/"?			
		if (keyLastSeparator == keyLength - 1)
			return parentRid + name;
		else
			return parentRid + separator + name;
	}

	private String getParentRid(String Rid) {
		if (Rid == null)
			return null;

		int keyLength = 0;
		int keyLastSeparator = 0;
		keyLength = Rid.length();
		if (keyLength == 0) {
			return "";
		} else {
			keyLastSeparator = Rid.lastIndexOf(separator);
			//RID ends with "/"?			
			if (keyLastSeparator == keyLength - 1) {
				keyLastSeparator = Rid.lastIndexOf(separator, keyLength - 1);
			}
			return Rid.substring(0, keyLastSeparator);
		}
	}

	private INodeHeader setExplicitAttributes(KMNodeHeader listHeader) {
		INodeHeader attributeHeader = new NodeHeader();
		String rid = listHeader.getRid();
		KMNodeAttribute displayNameAttribute = null;
		KMNodeAttribute descriptionAttribute = null;
		KMNodeAttribute permissionsAttribute = null;

		//name			
		attributeHeader.setName(this.getName(rid));
		//parentRID
		attributeHeader.setParentRid(this.getParentRid(rid));
		//Creation date
		KMNodeAttribute attribute = this.getAttribute(KMNodeConstants.PROP_CREATIONDATE, listHeader.getAttributes());
		if (attribute != null) {
			attributeHeader.setCreationdate(attribute.getDateValue());
		}
		//CreatedBy
		attribute = this.getAttribute(KMNodeConstants.PROP_CREATEDBY, listHeader.getAttributes());
		if (attribute != null) {
			attributeHeader.setCreatedBy(attribute.getStringValue());
		}
		//LastModifiedDate
		attribute = this.getAttribute(KMNodeConstants.PROP_LASTMODIFIED, listHeader.getAttributes());
		if (attribute != null) {
			attributeHeader.setLastmodifieddate(attribute.getDateValue()); 
		}
		//LastModifiedBy
		attribute = this.getAttribute(KMNodeConstants.PROP_LASTMODIFIEDBY, listHeader.getAttributes());
		if (attribute != null) {
			attributeHeader.setLastmodifiedBy(attribute.getStringValue());
		}
		
		String linkAttribute = listHeader.getLink();
		attributeHeader.setLink(linkAttribute == null ? "" : linkAttribute);
		
		displayNameAttribute = this.getAttribute(KMNodeConstants.PROP_DISPLAYNAME, listHeader.getAttributes());
		if (displayNameAttribute == null)
			attributeHeader.setDisplayName("");
		else
			attributeHeader.setDisplayName(displayNameAttribute.getStringValue());

		descriptionAttribute = this.getAttribute(KMNodeConstants.PROP_DESCRIPTION, listHeader.getAttributes());
		if (descriptionAttribute == null)
			attributeHeader.setDescription("");
		else
			attributeHeader.setDescription(descriptionAttribute.getStringValue());

		attributeHeader.setSize(listHeader.getNodeSize());		

		if (listHeader.getPermissions() == null)
			attributeHeader.setPermissions(new KMNodePermission[0]);
		else
			attributeHeader.setPermissions(listHeader.getPermissions());

		return attributeHeader;

	}

	private KMUserContext getUserContext() throws UMException {

		KMUserContext userContext = null;
		//	TODO: temporary change due to failure to map UME and J2EE users 	
		//		IUser user = null;
		//	
		//	
		//			//get the userId from EJB context, transfer it to user of UM
		//	String userId = myContext.getCallerPrincipal().getName();
		//
		//	try {
		// 		user = userFactory.getUser(userId);
		//	} catch (UMException umE) {
		//		throw new UMException(
		//			"User " + userId + " does not exist in UM");
		//	}
		//	userContext = new KMUserContext();
		//	userContext.setCountryCode(user.getLocale().getCountry());
		//	userContext.setLanguageCode(user.getLocale().getLanguage());
		//	return userContext;

		userContext = new KMUserContext();
		userContext.setCountryCode(java.util.Locale.US.getCountry());
		userContext.setLanguageCode(java.util.Locale.US.getLanguage());
		return userContext;

	}

	private String getContextUserId() throws UMException {

		//TODO: temporary change due to failure to map UME and J2EE users 	
		return "admin";
		//		IUser user = null;
		//	
		//			//get the userId from EJB context, transfer it to user of UM
		//	String userId = myContext.getCallerPrincipal().getName();
		//
		//	try {
		//		user = userFactory.getUser(userId);
		//	} catch (UMException umE) {
		//		throw new UMException(
		//			"User " + userId + " does not exist in UM");
		//	}
		//	
		//	return userId;

	}

	private NodeContent readNodeContent(KMUserContext userContext, String name, String parentRid, int sizeLimit) 
		throws KMNodeException, RemoteException, NamingException, ServiceException 
	{
		String sRid = getRid(name, parentRid);
		NodeContentSvcViRpcEnc svc = getNodeContentSvc();
		byte[] contentBytes = svc.readContent(sRid, sizeLimit);
		NodeContentStruct contentParams = svc.readContentParams(sRid);
		NodeContent content = new NodeContent();
		content.setName(name);
		content.setParentRid(parentRid);
		content.setContentLength(contentParams.getContentLength()); 
		content.setContentType(contentParams.getContentType()); 
		content.setContentEncoding(contentParams.getContentEncoding());
		content.setContent(contentBytes);
		return content; 
	}
	
	/** @see com.sap.caf.km.ejb.data.document.DocumentProxyEJBLocal#getDocumentURLforPreview(java.lang.String)
	 */
	public String getDocumentURLforPreview(String rid) throws KMNodeException {
		return getNotNullProperty(KM_URL_PREVIEW) + rid;
	}

	/** @see com.sap.caf.km.ejb.data.document.DocumentProxyEJBLocal#getDocumentURLforPreview(java.util.Collection)
	 */
	public Collection getDocumentURLforPreview(Collection rids) throws KMNodeException {
		if (rids == null) {
			return null;
		}
		Collection urls = new ArrayList();
		for (Iterator i = rids.iterator(); i.hasNext();) {
			urls.add(getDocumentURLforPreview((String) i.next()));
		}
		return urls;
	}

	/** @see com.sap.caf.km.ejb.data.document.DocumentProxyEJBLocal#getDocumentURLforEdit(java.lang.String)
	 */
	public String getDocumentURLforEdit(String rid) throws KMNodeException {
		return getNotNullProperty(KM_URL_EDIT) + rid;
	}

	/** @see com.sap.caf.km.ejb.data.document.DocumentProxyEJBLocal#getDocumentURLforEdit(java.util.Collection)
	 */
	public Collection getDocumentURLforEdit(Collection rids) throws KMNodeException {
		if (rids == null) {
			return null;
		}
		Collection urls = new ArrayList();
		for (Iterator i = rids.iterator(); i.hasNext();) {
			urls.add(getDocumentURLforEdit((String) i.next()));
		}
		return urls;
	}

	private String getNotNullProperty(String name) throws KMNodeException {
		synchronized (m_props) {
			if (!CAFProperties.class.equals(m_props.get(CAF_PROPS_CLASS))) {
				CAFProperties props = new CAFProperties();
				try {
					props.loadApplicationProperties();
				} catch (DataAccessException e) {
					throw new KMNodeException(RES_CANT_READ_PROPS, e);
				}
				m_props.clear();
				m_props.put(CAF_PROPS_CLASS, props.getClass());
				m_props.put(
					KM_URL_PREVIEW,
					ProxyHelper.getActualUrl(props.getProperty(KM_URL_PREVIEW, KM_URL_PREVIEW_DEF_VAL)));
				m_props.put(KM_URL_EDIT, ProxyHelper.getActualUrl(props.getProperty(KM_URL_EDIT, KM_URL_EDIT_DEF_VAL)));
			}
			String value = (String) m_props.get(name);
			if (value == null) {
				throw new KMNodeException(RES_NO_PROP_DEFINED, new Object[] { name });
			}
			return value;
		}
	}

	private NodeContentSvcViRpcEnc getNodeContentSvc() throws NamingException, ServiceException {
		if (WSNodeContentSvc==null) {
			NodeContentSvc svc = (NodeContentSvc) JNDIcontext.lookup(
					"wsclients/proxies/sap.com/caf~km.proxies/KMNodeContentSvcProxy");
			WSNodeContentSvc = svc.getConfig1PortMime();
			String url = ProxyHelper.getActualUrl(
					(String) WSNodeContentSvc._getProperty(KMNodeService.ENDPOINT_ADDRESS_PROPERTY));
			WSNodeContentSvc._setProperty(KMNodeService.ENDPOINT_ADDRESS_PROPERTY, url);
		}
		return WSNodeContentSvc;
	}
	
	protected Location getLocation() {
		return location;
	}

	protected String getJARMRequest() {
		return JARM_REQUEST;	
	}


	public boolean isDocumentLocked(String documentRid) throws KMNodeException {
		final String method=JARM_REQUEST + ":isDocumentLocked(String)";
		final Object[] args = {documentRid};
		enter(method, args);		
		try {
			return WSBase.isDocumentLocked(documentRid);
		}
		catch (Exception e) {
			//$JL-EXC$ ignore JLin warning
			KMNodeException nodeEx = new KMNodeException(RES_CANT_CHECK_LOCK, args, e);
			log(nodeEx, method, args);
			throw nodeEx;
		}
		finally {
			exit(method, null);
		}
	}
	
	public boolean unlockDocument(String documentRid) throws KMNodeException {
		final String method=JARM_REQUEST + ":unlockDocument(String)";
		final Object[] args = {documentRid};
		enter(method, args);		
		try {
			return WSBase.unlockDocument(documentRid);
		}
		catch (Exception e) {
			//$JL-EXC$ ignore JLin warning
			KMNodeException nodeEx = new KMNodeException(RES_CANT_UNLOCK_DOCUMENT, args, e);
			log(nodeEx, method, args);
			throw nodeEx;
		}
		finally {
			exit(method, null);
		}
	}

	public String getLockOwner(String documentRid) throws KMNodeException {
		final String method=JARM_REQUEST + ":getLockOwner(String)";
		final Object[] args = {documentRid};
		enter(method, args);		
		try {
			return WSBase.getLockOwner(documentRid);
		}
		catch (Exception e) {
			//$JL-EXC$ ignore JLin warning
			KMNodeException nodeEx = new KMNodeException(RES_CANT_GET_LOCK_OWNER, args, e);
			log(nodeEx, method, args);
			throw nodeEx;
		}
		finally {
			exit(method, null);
		}
	}

	public void enableDocumentVersioning(String rid) throws KMNodeException {
		final String method=JARM_REQUEST + ":enableDocumentVersioning(String)";
		final Object[] args = {rid};
		enter(method, args);
		try {
			WSBase.enableDocumentVersioning(rid);
		}
		catch (Exception e) {
			//$JL-EXC$ ignore JLin warning
			KMNodeException nodeEx = new KMNodeException(RES_CANT_ENABLE_VERSIONING, args, e);
			log(nodeEx, method, args);
			throw nodeEx;
		}
		finally {
			exit(method, null);
		}
	}
	
	public boolean isDocumentVersioned (String rid) throws KMNodeException {
		final String method=JARM_REQUEST + ":isDocumentVersioned(String)";
		final Object[] args = {rid};
		enter(method, args);		
		try {
			return WSBase.isDocumentVersioned(rid);
		}
		catch (Exception e) {
			//$JL-EXC$ ignore JLin warning
			KMNodeException nodeEx = new KMNodeException(RES_CANT_CHECK_DOCUMENT_VERSIONING, args, e);
			log(nodeEx, method, args);
			throw nodeEx;
		}
		finally {
			exit(method, null);
		}
	}
	
	public String[] getVersionHistory(String rid) throws KMNodeException {
		final String method=JARM_REQUEST + ":getVersionHistory(String)";
		final Object[] args = {rid};
		enter(method, args);		
		try {
			return WSBase.getVersionHistory(rid);
		}
		catch (Exception e) {
			//$JL-EXC$ ignore JLin warning
			KMNodeException nodeEx = new KMNodeException(RES_CANT_GET_VERSION_HISTORY, args, e);
			log(nodeEx, method, args);
			throw nodeEx;
		}
		finally {
			exit(method, null);
		}
	}
	
	public void setAsCurrentVersion (String historyRid, String rid) throws KMNodeException {
		final String method=JARM_REQUEST + ":setAsCurrentVersion(String, String)";
		final Object[] args = {historyRid, rid};
		enter(method, args);		
		try {
			WSBase.setAsCurrentVersion(historyRid, rid);
		}
		catch (Exception e) {
			//$JL-EXC$ ignore JLin warning
			KMNodeException nodeEx = new KMNodeException(RES_CANT_SET_CURRENT_VERSION, args, e);
			log(nodeEx, method, args);
			throw nodeEx;
		}
		finally {
			exit(method, null);
		}
	}
	
	public void deleteVersion (String historyRid) throws KMNodeException {
		final String method=JARM_REQUEST + ":deleteVersion(String)";
		final Object[] args = {historyRid};
		enter(method, args);		
		try {
			WSBase.deleteVersion(historyRid);
		}
		catch (Exception e) {
			//$JL-EXC$ ignore JLin warning
			KMNodeException nodeEx = new KMNodeException(RES_CANT_DELETE_VERSION, args, e);
			log(nodeEx, method, args);
			throw nodeEx;
		}
		finally {
			exit(method, null);
		}
	}
	
	public void disableDocumentVersioning(String rid) throws KMNodeException{
		final String method=JARM_REQUEST + ":disableDocumentVersioning(String)";
		final Object[] args = {rid};
		enter(method, args);		
		try {
			WSBase.disableDocumentVersioning(rid);
		}
		catch (Exception e) {
			//$JL-EXC$ ignore JLin warning
			KMNodeException nodeEx = new KMNodeException(RES_CANT_DISABLE_VERSIONING, args, e);
			log(nodeEx, method, args);
			throw nodeEx;
		}
		finally {
			exit(method, null);
		}
	}

	public String getCurrentVersion(String rid) throws KMNodeException {
		final String method=JARM_REQUEST + ":getCurrentVersion(String)";
		final Object[] args = {rid};
		enter(method, args);		
		try {
			return WSBase.getCurrentVersion(rid);
		}
		catch (Exception e) {
			//$JL-EXC$ ignore JLin warning
			KMNodeException nodeEx = new KMNodeException(RES_CANT_GET_VERSION, args, e);
			log(nodeEx, method, args);
			throw nodeEx;
		}
		finally {
			exit(method, null);
		}
	}
	
	public boolean authorizationCheck(String documentRid) throws KMNodeException {
		final String method=JARM_REQUEST + ":authorizationCheck(String)";
		final Object[] args = {documentRid};
		enter(method, args);		
		try {
			return WSBase.authorizationCheck(documentRid);
		}
		catch (Exception e) {
			//$JL-EXC$ ignore JLin warning
			KMNodeException nodeEx = new KMNodeException(RES_CANT_AUTH_CHECK, args, e);
			log(nodeEx, method, args);
			throw nodeEx;
		}
		finally {
			exit(method, null);
		}
	}
	
	
	
	public String relateKMDocument(String boID, String boGUID, String kmRID) throws KMNodeException {
		final String method = JARM_REQUEST + ":relateKMDocument(String, String, String)";
		enter(method, new Object[] {boID, boGUID, kmRID});

		try {
//					checkDocumentParameters(params);
//			
//					String docName = extractName(kmRID);
//					String[] docRid = normalizePathname(
//							getTempKMFolderRID(), // source root folder
//							docName // source pathname probably containing extra path info
//						);
//			
//					checkAndCreateFolder(docRid[0]);
//					String linkName = generateUniqueUploadName(docRid[0], docRid[1]);
//					String fixedDocName = docRid[0] + STR_DIVIDER + linkName;		
//						
//					try {
//						DocumentProxyEJBLocal documentProxy = getDocumentProxy();
//						documentProxy.link(kmRID, fixedDocName);
//					} catch (Exception e) {
//						logger.catching(e);
//						throw new KMNodeException(e);
//					}
//					logger.exiting((Object) fixedDocName);
//					return fixedDocName;
			return kmRID;
		}
		catch (Exception e) {
			//$JL-EXC$ ignore JLin warning
			KMNodeException uploadEx = new KMNodeException("", e);
			log(uploadEx, method, null);
			throw uploadEx;
		}
		finally {
			exit(method, null);
		}
	}


	public String copyBODocument(String fullBOName, String boGuid, String kmRid) throws KMNodeException {
		final String method =  JARM_REQUEST + ":copyBODocument(String, String, String)";
		enter(method, new Object[] {fullBOName, boGuid, kmRid});
		try {
			//return result will be stored here
			String result = kmRid;
			String dstFolder = KMDataAccessHelper.getBORootFolderRid(fullBOName, boGuid);
			checkAndCreateFolder(dstFolder);
			result = copyDocument(kmRid, dstFolder);
			return result;
		}
		catch (Exception e) {
			//$JL-EXC$ ignore JLin warning
			KMNodeException uploadEx = new KMNodeException(RES_CANT_COPY_BO_DOCUMENT, e);
			log(uploadEx, method, null);
			throw uploadEx;
		}
		finally {
			exit(method, null);
		}
	}
	
	
	private void checkAndCreateFolder(String folderRID) throws Exception {
		boolean bExists = false;
		FolderProxyEJBLocal folderProxy = KMDataAccessHelper.getFolderProxyService();
		bExists = folderProxy.exists(folderRID);
		if (bExists == false) {
			Collection coll = new ArrayList();
			StringTokenizer tkz = new StringTokenizer(folderRID, STR_DIVIDER);
			while (tkz.hasMoreElements()) {
				String token = tkz.nextToken();
				if (token.length() > 0) {
					coll.add(token);
				}
			}
			Iterator iterator = coll.iterator();
			String parent = STR_DIVIDER + (String) iterator.next();
			while (iterator.hasNext()) {
				String folder = (String) iterator.next();
				String parentFolder = parent;
				parent = parent + STR_DIVIDER + folder;
				boolean bool = folderProxy.exists(parent);
				if (bool == false) {
					folderProxy.createFolderHeader(folder, parentFolder, "", "", new ArrayList());
				}
			}
		}
	}
	


	private String copyDocument(String rid, String dstFolder) throws KMNodeException {
		final String method =  JARM_REQUEST + ":copyDocument(String, String)";
		enter(method, new Object[] {rid,dstFolder});
		try {
			String newRid = rid;
			DocumentProxyEJBLocal documentProxy = KMDataAccessHelper.getDocumentProxyService();
			newRid = dstFolder + STR_DIVIDER + generateUniqueUploadName(dstFolder, RidUtils.getName(rid));
			documentProxy.copy(rid, newRid);
			return newRid;
		}
			catch (Exception e) {
				//$JL-EXC$ ignore JLin warning
			KMNodeException uploadEx = new KMNodeException(RES_CANT_COPY_DOCUMENT, e);
			log(uploadEx, method, null);
			throw uploadEx;
		}
		finally {
			exit(method, null);
		}
	}
	
	
	/** Upload name needs to be changed for already existing resources
	 * @param uploadName
	 * @return unique upload name 
	 */
	private String generateUniqueUploadName(String folder, String uploadName) throws KMNodeException {
		final String method =  JARM_REQUEST + ":generateUniqueUploadName(String, String)";
		enter(method, new Object[] {folder,uploadName});

		//TODO: review and optimize it
		try {
			folder = folder.endsWith("/") ? folder : folder + STR_DIVIDER;
			DocumentProxyEJBLocal documentProxy = KMDataAccessHelper.getDocumentProxyService();
			int dotIndex = uploadName.lastIndexOf('.');
			String name = (dotIndex == -1) ? uploadName : uploadName.substring(0, dotIndex);
			String ext = (dotIndex == -1) ? "" : uploadName.substring(dotIndex);
			int modifier = 0;
			while (documentProxy.exists(folder + uploadName)) {
				uploadName = name + "(" + (++modifier) + ")" + ext;
			}
			return uploadName;
		}
		catch (Exception e) {
			//$JL-EXC$ ignore JLin warning
			KMNodeException uploadEx = new KMNodeException(RES_CANT_GENERATE_UNIQUE_NAME, e);
			log(uploadEx, method, null);
			throw uploadEx;
		}
		finally {
			exit(method, null);
		}
	}
	
		

	public Collection copyAttachedKMDocuments(String fullBOName, String boGuid, Collection srcRids) throws KMNodeException {
		final String method =  JARM_REQUEST + ":copyAttachedKMDocuments(String, String, Collection)";
		enter(method, new Object[] {fullBOName, boGuid, srcRids});
		try {
			if (srcRids == null || srcRids.isEmpty()) {
				return Collections.EMPTY_LIST;
			}
			// create target folder to copy files based on BO
			String rootFolder = KMDataAccessHelper.getBORootFolderRid(fullBOName, boGuid);
			// get temp folder name
			String tempFolder = KMDataAccessHelper.getTempFolderRid(); //getTempKMFolderRID();
			// copy files residing under temp folder to target folder, preserving extra path information
			String[] dstRid;
			String srcRidStr, dstRidStr, dstRootFolder;
			DocumentProxyEJBLocal documentProxy = KMDataAccessHelper.getDocumentProxyService();
			List dstRids = new ArrayList(srcRids.size());
			for (Iterator i = srcRids.iterator(); i.hasNext();) {
				srcRidStr = (String) i.next();
				dstRid = RidUtils.splitPathname(tempFolder, srcRidStr);
				if (dstRid == null || dstRid.length == 0) {
					dstRids.add(srcRidStr); // keep it unchanged it does not start with tempFolder
					continue;
				}
				dstRid[0] = rootFolder;
				dstRootFolder = RidUtils.mergePathname(dstRid, 2);
				//dstRidStr = mergePathname(dstRid, 3);
				//checkAndCreateFolder(dstRootFolder);

				//				dstRid[2] = generateUniqueUploadName(dstRootFolder, dstRid[2]);
				//				dstRidStr = mergePathname(dstRid, 3);

				dstRidStr = documentProxy.copyToFolder(srcRidStr, dstRootFolder);

				// delete extra folders if any
				if (dstRid[1] != null) {
					int k = dstRid[1].indexOf(RidUtils.PATH_SEPARATOR);
					cleanupExtraFolders((k == -1 ? dstRid[1] : dstRid[1].substring(0, k)));
				}
				dstRids.add(dstRidStr);
			}
			return dstRids;
		}
		catch (Exception e) {
			//$JL-EXC$ ignore JLin warning
			KMNodeException uploadEx = new KMNodeException(RES_CANT_COPY_ATTACHED_DOCUMENTS, e);
			log(uploadEx, method, null);
			throw uploadEx;
		}
		finally {
			exit(method, null);
		}
	}
	
	
	private void cleanupExtraFolders(String folderRid) throws KMNodeException {
		final String method =  JARM_REQUEST + ":cleanupExtraFolders(String)";
		enter(method, new Object[] {folderRid});
		try {
			if (null != folderRid && folderRid.length()>0) {
				FolderProxyEJBLocal folderProxy = KMDataAccessHelper.getFolderProxyService();

				int i = folderRid.lastIndexOf(STR_DIVIDER);
				String parentRid = folderRid.substring(0, i + 1);
				String name = folderRid.substring(i + 1);

				try {
					folderProxy.deleteFolder(name, parentRid);
				}	
				catch (KMNodeException ignore) {
					// $JL-EXC$ ignore exception when physically deleting the folder
				}
			}
		}
		catch (Exception e) {
			//$JL-EXC$ ignore JLin warning
			KMNodeException uploadEx = new KMNodeException(RES_CANT_CLEAN_FOLDERS, e);
			log(uploadEx, method, null);
			throw uploadEx;
		}
		finally {
			exit(method, null);
		}
	}
	


	private final static Map m_props = new HashMap();
	private final static String CAF_PROPS_CLASS = "CAF_PROPS_CLASS";
	private final static String KM_URL_PREVIEW = "KM_URL_PREVIEW";
	private final static String KM_URL_EDIT = "KM_URL_EDIT";
	private final static String KM_URL_PREVIEW_DEF_VAL =
		"http://km_host:km_port/irj/servlet/prt/portal/prtroot/com.sap.km.cm.docs";
	private final static String KM_URL_EDIT_DEF_VAL =
		"http://km_host:km_port/irj/servlet/prt/portal/prtroot/com.sap.km.cm.service?StartPage=RemoteEditingPage&Uri=";

	private static final String STR_DIVIDER = "/";
}
