package com.sap.caf.km.da;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import com.sap.guid.GUIDGeneratorFactory;

import com.sap.caf.km.ejb.data.document.DocumentProxyEJBLocal;
import com.sap.caf.km.ejb.data.document.DocumentProxyEJBLocalHome;
import com.sap.caf.km.ejb.data.folder.FolderProxyEJBLocal;
import com.sap.caf.km.ejb.data.folder.FolderProxyEJBLocalHome;
//import com.sap.caf.km.ejb.svc.upload.UploadProxyEJBLocal;
//import com.sap.caf.km.ejb.svc.upload.UploadProxyEJBLocalHome;
import com.sap.caf.rt.bol.context.CAFContext;
import com.sap.caf.rt.exception.CAFFindException;

/**
 * @author C5047347
 */
public class KMDataAccessHelper {
	
	public static final String UPLOAD_PROXY_JNDI_NAME = "localejbs/sap.com/caf~com.sap.caf.runtime/UploadProxyEJBBean";
	public static final String FOLDER_PROXY_JNDI_NAME = "localejbs/sap.com/caf~com.sap.caf.runtime/FolderProxyEJBBean";
	public static final String DOCUMENT_PROXY_JNDI_NAME = "localejbs/sap.com/caf~com.sap.caf.runtime/DocumentProxyEJBBean";	
	
	private static Context m_initialContext;
	
	private final static String DEF_TEMP_FOLDER_NAME = "temp";
	private final static String DEF_TEMPLATE_FOLDER_NAME = "templates";
	private static String m_sTempFolderRid;
	private static String m_sTemplateFolderRid;

	/**
	 * Lookup UploadProxy EJB service
	 * 
	 * @return UploadProxy EJB service
	 * @throws ServiceException
	 */
/*
	public static UploadProxyEJBLocal getUploadService() throws CAFFindException {
		try {
				Context initCtx = new InitialContext();
				UploadProxyEJBLocalHome home =
						(UploadProxyEJBLocalHome) getInitialContext().lookup(UPLOAD_PROXY_JNDI_NAME);
						
				return home.create();
			} catch (Exception e) {
				throw new CAFFindException(e);
			}
	}
*/

	public static String getTempFolderRid() 
	{
		return m_sTempFolderRid;
	}
		
	public static String getTemplateFolderRid() 
	{
		return m_sTemplateFolderRid;
	}
	

	public static String getDocRepositoryRid() {
		return CAFContext.KM_TMP_REPOSITORY_FOLDER;
	}
	
	public static String getBORootFolderRid(String fullBOName) {
		return getBORootFolderRid(fullBOName, null);
	}

	public static String getBORootFolderRid(String fullBOName, String boKey) {
		String corrBOName = fullBOName.replace('/', '-');
		String name = fullBOName.substring(fullBOName.lastIndexOf('/') + 1, fullBOName.length());
		String rid = CAFContext.KM_TMP_REPOSITORY_FOLDER + RidUtils.PATH_SEPARATOR + corrBOName;
		if (boKey != null && boKey.length() > 0) {
			rid = rid + RidUtils.PATH_SEPARATOR + name + '-' + boKey;
		}
		return rid;
	}
	
	
	public static String getUniqueTempletFolderRid(String fullBOName) {
		String templetFolder = getTemplateFolderRid();
		String guid = GUIDGeneratorFactory.getInstance().createGUIDGenerator().createGUID().toString();
		String folderName =
			new StringBuffer(templetFolder.length() + fullBOName.length() + guid.length() + 2)
				.append(templetFolder)
				.append(RidUtils.PATH_SEPARATOR)
				.append(fullBOName.replace('/', '-'))
				.append(RidUtils.PATH_SEPARATOR)
				.append(guid)
				.toString();
		return folderName;
	}
	

	static {
		StringBuffer sb = new StringBuffer();
		m_sTempFolderRid = sb
			.append(CAFContext.KM_TMP_REPOSITORY_FOLDER)
			.append(RidUtils.PATH_SEPARATOR)
			.append(DEF_TEMP_FOLDER_NAME).toString();
		sb.setLength(0);

		m_sTemplateFolderRid = sb
			.append(CAFContext.KM_TMP_REPOSITORY_FOLDER)
			.append(RidUtils.PATH_SEPARATOR)
			.append(DEF_TEMPLATE_FOLDER_NAME).toString();
		sb.setLength(0);
	}

	
	/**
	 * Lookup FolderProxy EJB service
	 * 
	 * @return Lookup FolderProxy EJB service
	 * @throws ServiceException
	 */
	public static FolderProxyEJBLocal getFolderProxyService() throws CAFFindException {
		try {
			
			FolderProxyEJBLocalHome home = 
					(FolderProxyEJBLocalHome) getInitialContext().lookup(FOLDER_PROXY_JNDI_NAME);
					
			return home.create();
		} catch (Exception e) {
			throw new CAFFindException(e);
		}
	}		

	/**
	 * Lookup DocumentProxy EJB service
	 * 
	 * @return Lookup FolderProxy EJB service
	 * @throws ServiceException
	 */
	public static DocumentProxyEJBLocal getDocumentProxyService() throws CAFFindException {
		try {
			
			DocumentProxyEJBLocalHome home = 
					(DocumentProxyEJBLocalHome) getInitialContext().lookup(DOCUMENT_PROXY_JNDI_NAME);
					
			return home.create();
		} catch (Exception e) {
			throw new CAFFindException(e);
		}
	}		

	private static Context getInitialContext() throws NamingException {
		if (m_initialContext==null) {
			m_initialContext = new InitialContext();
		}
		return m_initialContext;
	}	
}
