package com.sap.caf.km.da;

import javax.ejb.CreateException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;

import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Severity;

/**
 * @author viachaslau_kudzinau@epam.com
 */
public abstract class KMDataAccessBean implements SessionBean {

	protected SessionContext m_sessionContext;

	public void ejbCreate() throws CreateException {
	}
	
	public void ejbRemove() {
	}

	public void ejbActivate() {
	}

	public void ejbPassivate() {
	}

	public void setSessionContext(SessionContext context) {
		m_sessionContext = context;
	}

	protected void log(KMDataAccessException e, String method, Object[] args) {	
		CAFPublicLogger.logThrowable(Severity.ERROR, CAFPublicLogger.categoryCAF, 
			getLocation(),	method, e.getMessage(), e);
	}

	protected void info(String method, String message, Object[] args) {	
		CAFPublicLogger.LOC_CAF.infoT(method, message, args);
	}
	
	protected void enter(String method, Object[] args) {	
		CAFPublicLogger.entering(getUser(), getJARMRequest(), method, getLocation(), args, CAFPublicLogger.LEVEL_MEDIUM);
	}

	protected void exit(String method, Object result) {	
		CAFPublicLogger.exiting(getUser(), getJARMRequest(), method, getLocation(), result, CAFPublicLogger.LEVEL_MEDIUM);
	}

	protected abstract Location getLocation();
	protected abstract String getJARMRequest();
	
	private String getUser() {
		return null;
	}		
}
