/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id: //kmgmt/bc.rf.global.service/dev/src/_relation/java/api/com/sapportals/wcm/service/relation/RelationServiceFactory.java#3 $
 */

package com.sapportals.wcm.service.scheduler;

import com.sapportals.wcm.WcmException;
import com.sapportals.wcm.service.ServiceFactory;

/**
 * The scheduler service factory.
 */
public final class SchedulerServiceFactory {

  static String version = "$Id: $"; //$NON-NLS-1$
 
  private SchedulerServiceFactory() {
  }

  /**
   * Get an instance of the scheduler service.
   *
   * @return a <code>ISchedulerService</code> -instance.
   * @throws WcmException if there was an internal error
   *      while getting the instance of the <code>ISchedulerService</code> .
   */
  public static ISchedulerService lookup() throws WcmException {
    return (ISchedulerService)ServiceFactory.getInstance().getService(ISchedulerService.SCHEDULER_SERVICE);
  }

  public void release(ISchedulerService service) throws WcmException {
    ServiceFactory.getInstance().releaseService(service);
  }

}