package com.sapportals.wcm.service.scheduler;

import java.util.Comparator;

/**
 * A list of <code>ISchedulerTime</code>s
 * (see <i>java.util.List</i>).
 * <p>
 * <!--COPYRIGHT TAG:-->Copyright 2004 SAP AG<!-- -->
 *
 * @author        paul.goetz@sapportals.com
 * @version       $Id: //kmgmt/bc.sf.service/60NW_SP_COR/src/_scheduler/java/api/com/sapportals/wcm/service/scheduler/ISchedulerTimeList.java#2 $
 * @see           ISchedulerTime
 * @deprecated    since KM6.0SP1. Use ISchedulerTimeTable instead.
 */
public interface ISchedulerTimeList {

  public int size();

  public boolean contains(ISchedulerTime time);

  public boolean add(ISchedulerTime time);

  public boolean remove(ISchedulerTime time);

  public boolean isEmpty();

  public ISchedulerTime get(int index);

  public ISchedulerTime set(int index, ISchedulerTime time);

  public void add(int index, ISchedulerTime time);

  public void addLast(ISchedulerTime time);

  public ISchedulerTime remove(int index);

  public int indexOf(ISchedulerTime time);

  public int lastIndexOf(ISchedulerTime time);

  public ISchedulerTimeListIterator listIterator();

  public ISchedulerTimeListIterator listIterator(int index);

  public ISchedulerTimeList subList(int startIndex, int stopIndex);

  public void sort(Comparator comparator);

}
