package com.sapportals.wcm.service.scheduler;

import java.util.Properties;

/**
 * The task to be run by the scheduler.
 * For life
 * <p>
 * <i>Note</i>: The task must implement a default constructor to have them
 *          created by the scheduler after a system (re)start.
 * <p>
 * <!--COPYRIGHT TAG:-->Copyright 2004 SAP AG<!-- -->
 *
 * @author     paul.goetz@sapportals.com
 * @author     jen.kaiser@sap.com
 * @version    $Id: //kmgmt/bc.sf.service/60NW_SP_COR/src/_scheduler/java/api/com/sapportals/wcm/service/scheduler/ISchedulerTask.java#4 $
 */
public interface ISchedulerTask {

  /**
   * Run the scheduler task. This method is invoked by the scheduler, when the
   * scheduler has to run the task.
   *
   * @param  id          a <code>String</code> with the id of the scheduler entry to this
   *        task.
   * @param  properties  Description of the Parameter
   */
  void run(String id, Properties properties);
}
