package com.sapportals.wcm.service.scheduler;


import com.sapportals.wcm.WcmException;
import com.sapportals.wcm.service.landscape.ISystemList;

import java.util.Properties;


/**
 * Factory interface to create Scheduler entries.
 *
 * @author     jen.kaiser@sap.com
 * @version    $Id: //kmgmt/bc.sf.service/60NW_SP_COR/src/_scheduler/java/api/com/sapportals/wcm/service/scheduler/ISchedulerEntryFactory.java#1 $
 * 
 * @deprecated since KM5.0SP6. No non-persistent scheduler entries are supported.
 */
public interface ISchedulerEntryFactory {
  
  ISchedulerEntry createSchedulerEntry( String entryID, int priority, ISchedulerTask task,
      ISchedulerTimeTable timetable, Properties properties ) throws WcmException;
  
  ISchedulerEntry createSchedulerEntry( String entryID, int priority, ISchedulerTask task,
      ISchedulerTimeTable timetable, ISystemList systemList, Properties properties ) throws WcmException;
  
  ISchedulerEntry createSchedulerEntry( String entryID, int priority, ISchedulerTask task,
      ISchedulerTimeTable timetable, ISystemList systemList, Properties properties, boolean save ) throws WcmException;
 
  ISchedulerEntry createSchedulerEntry( Properties properties ) throws WcmException;
  
  Properties createSchedulerEntryProperties( ISchedulerEntry entry ) throws WcmException;

}
