/*
 * @(#) $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_runtime_repository/java/com/sap/tc/webdynpro/repository/api/IWDVariant.java#1 $
 *
 * Copyright(c) 2003, SAP AG, All Rights Reserved.
 */
package com.sap.tc.webdynpro.repository.api;

import java.util.Iterator;

/**
 * API of a variant.
 *
 * The index of the predecessor positions is zero based.
 *
 * @author SAP
 * @SAPWebDynproPart 2
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_runtime_repository/java/com/sap/tc/webdynpro/repository/api/IWDVariant.java#1 $
 */
public interface IWDVariant { 
  
  /**
   * name of the default base variant
   */
  public final static String BASE_VARIANT_NAME = "base"; 
  
  /**
   * Returns the name of the variant.
   * @return the name of the variant
   */
  public String getName(); 
  
  /**
   * Adds a predecessor to the variant.
   * The predecessor gets the lowest priority of all currently assigned
   * predecessors.
   * @param variant the variant to add as a predecessor
   */
  public void addPredecessor(IWDVariant variant);
    
  /**
   * Adds a predecessor to the variant.
   * @param index position in the predecessor list where the new predecessor is
   * inserted
   * @param variant the variant to add as a predecessor
   */
  public void addPredecessor(int index, IWDVariant variant);
  
  /**
   * Removes a predecessor of the variant.
   * @param variant variant that should be no longer a predecessor
   */
  public void removePredecessor(IWDVariant variant);
  
  /**
   * Returns the position of a predecessor.
   * @param variant the predecessor for which the position will be returned
   * @return the position of the predecessor in the list of predecessors
   */
  public int indexOfPredecessor(IWDVariant variant);

  /**
   * Returns an iterator over the predecessors of the variant.
   * @return an iterator over the predecessors of the variant
   */
  public Iterator iteratePredecessors();
}
