/*
 * @(#) $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_runtime_repository/java/com/sap/tc/webdynpro/repository/api/IWDCustomizingLayer.java#1 $
 *
 * Copyright(c) 2003, SAP AG, All Rights Reserved.
 */
package com.sap.tc.webdynpro.repository.api;

import java.util.Iterator;

/**
 * API of a customizing layer.
 *
 * @author SAP
 * @SAPWebDynproPart 2
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_runtime_repository/java/com/sap/tc/webdynpro/repository/api/IWDCustomizingLayer.java#1 $
 */
public interface IWDCustomizingLayer {

  /**
   * name of the default base customizing layer
   */
  public final static String BASE_CUSTOMIZING_LAYER_NAME = "base";

  /**
   * Returns the name of the of the customizing layer.
   * @return the name of the of the customizing layer
   */
  public String getName();

  /**
   * Adds a predecessor to the customizing layer.
   * Except for the base customizing layer, each customizing layer has exactly 
   * one predecessor.
   * @param customizingLayer customizing layer to add as a predecessor
   */
  public void addPredecessor(IWDCustomizingLayer customizingLayer);

  /**
   * Removes a predecessor of the customizing layer.
   * Except for the base customizing layer, each customizing layer has exactly 
   * one predecessor.
   * @param customizingLayer customizing layer that should no longer be a
   * predecessor
   */
  public void removePredecessor(IWDCustomizingLayer customizingLayer);

  /**
   * Iterator over the predecessors of the customizing layer.
   * @return the iterator over the predecessors of the customizing layer.
   */
  public Iterator iteratePredecessors();
}
