/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.xml.extern.dbaccess;

import com.sap.sdm.util.dbaccess.AbstractSelectionReader;
import com.sap.sdm.util.dbaccess.NameValuePair;
import com.sap.sdm.util.dbaccess.Selection;
import com.sap.sdm.util.dbaccess.TableEntry;
import com.sap.sdm.xml.XMLException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SelectionReader
extends AbstractSelectionReader {
    private ArrayList selectionList = new ArrayList();
    private ArrayList entryList = new ArrayList();
    private SAXParser parser = null;
    private SaxContentHandler contentHandler = null;

    public SelectionReader() throws XMLException {
        try {
            SAXParserFactory parserfactory = SAXParserFactory.newInstance();
            parserfactory.setValidating(false);
            this.parser = parserfactory.newSAXParser();
        }
        catch (ParserConfigurationException pcE) {
            throw new XMLException("Cannot create XML parser.", pcE);
        }
        catch (SAXException saxE) {
            throw new XMLException("Cannot create XML parser.", saxE);
        }
    }

    public void parseSelections() throws Exception {
        this.selectionList = new ArrayList();
        this.entryList = new ArrayList();
        File xmlfile = new File(this.getSelectFileName());
        if (xmlfile.exists() && xmlfile.canRead()) {
            try {
                this.contentHandler = new SaxContentHandler();
                this.parser.parse(xmlfile, (DefaultHandler)this.contentHandler);
            }
            catch (SAXException se) {
                throw new Exception("Syntax error in " + xmlfile.getPath() + ": " + se.getMessage());
            }
            catch (IOException ioe) {
                throw new Exception("Cannot read " + xmlfile.getPath() + ": " + ioe.getMessage());
            }
        } else {
            System.out.println("Cannot access file: " + this.getSelectFileName());
            throw new Exception("Cannot access file: " + this.getSelectFileName());
        }
    }

    public ArrayList getSelectionList() {
        return this.selectionList;
    }

    public ArrayList getEntryList() {
        return this.entryList;
    }

    private class SaxContentHandler
    extends DefaultHandler {
        private SelectionReader reader;
        private Selection selection = null;
        private int counter = 0;
        private boolean selectionstagopen = false;
        private boolean tabletagopen = false;
        private boolean whereclausetagopen = false;
        private boolean entrytagopen = false;
        private boolean entry_scanned = false;
        private boolean unknowntagopen = false;
        private String currentTableName = null;
        private String currentWhereclause = null;
        private TableEntry currentTableEntry = null;

        SaxContentHandler() {
            this.reader = SelectionReader.this;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void startElement(String ns, String localname, String qname, Attributes attributes) throws SAXException {
            String elementname;
            String string = elementname = "".equals(localname) ? qname : localname;
            if (elementname.equalsIgnoreCase("selections")) {
                if (this.selectionstagopen) {
                    throw new SAXException("selections tag is already open");
                }
                this.selectionstagopen = true;
                return;
            } else if (elementname.equalsIgnoreCase("table")) {
                if (this.tabletagopen) {
                    throw new SAXException("table tag is already open");
                }
                this.tabletagopen = true;
                if (attributes.getIndex("name") == -1) throw new SAXException("missing table name");
                this.currentTableName = attributes.getValue(attributes.getIndex("name")).trim();
                this.currentWhereclause = null;
                return;
            } else if (elementname.equalsIgnoreCase("where") || elementname.equalsIgnoreCase("whereclause") || elementname.equalsIgnoreCase("wc")) {
                if (!this.tabletagopen) {
                    throw new SAXException("whereclause without preceeding table element");
                }
                if (this.whereclausetagopen) {
                    this.selection = new Selection(Integer.toString(this.counter), this.currentTableName, this.currentWhereclause);
                    this.reader.selectionList.add(this.selection);
                    ++this.counter;
                }
                this.whereclausetagopen = true;
                if (attributes.getIndex("text") == -1) throw new SAXException("missing whereclause text");
                this.currentWhereclause = attributes.getValue(attributes.getIndex("text")).trim();
                return;
            } else if (elementname.equalsIgnoreCase("entry")) {
                if (!this.tabletagopen) {
                    throw new SAXException("entry without preceeding table element");
                }
                this.entrytagopen = true;
                this.entry_scanned = true;
                this.currentTableEntry = new TableEntry(Integer.toString(this.counter), this.currentTableName);
                ++this.counter;
                return;
            } else {
                if (!elementname.equalsIgnoreCase("field")) throw new SAXException("invalid token " + elementname);
                String current_name = null;
                String current_value = null;
                if (!this.tabletagopen) {
                    throw new SAXException("field without preceeding table element");
                }
                if (!this.entrytagopen) {
                    throw new SAXException("field without preceeding entry element");
                }
                if (attributes.getIndex("name") == -1) {
                    throw new SAXException("missing name in field entry");
                }
                current_name = attributes.getValue(attributes.getIndex("name")).trim();
                if (attributes.getIndex("value") == -1) {
                    throw new SAXException("missing value in field entry");
                }
                current_value = attributes.getValue(attributes.getIndex("value"));
                this.currentTableEntry.addField(new NameValuePair(current_name, current_value));
            }
        }

        public void endElement(String ns, String localname, String qname) throws SAXException {
            String elementname;
            String string = elementname = "".equals(localname) ? qname : localname;
            if (elementname.equalsIgnoreCase("selections")) {
                this.selectionstagopen = false;
            } else if (elementname.equalsIgnoreCase("table")) {
                this.selection = new Selection(Integer.toString(this.counter), this.currentTableName, this.currentWhereclause);
                if (!this.entry_scanned) {
                    this.reader.selectionList.add(this.selection);
                    ++this.counter;
                }
                this.tabletagopen = false;
                this.whereclausetagopen = false;
                this.entry_scanned = false;
            } else if (!(elementname.equalsIgnoreCase("where") || elementname.equalsIgnoreCase("whereclause") || elementname.equalsIgnoreCase("wc"))) {
                if (elementname.equalsIgnoreCase("entry")) {
                    this.entrytagopen = false;
                    if (this.currentTableEntry != null && this.currentTableEntry.getFieldCount() > 0) {
                        this.reader.entryList.add(this.currentTableEntry);
                    }
                } else if (!elementname.equalsIgnoreCase("field")) {
                    if (!this.unknowntagopen) {
                        throw new SAXException("incomplete implementation of " + elementname + " tag");
                    }
                    this.unknowntagopen = false;
                }
            }
        }

        public void startDocument() throws SAXException {
        }

        public void endDocument() throws SAXException {
        }
    }
}

