/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.xml.extern;

import com.sap.sdm.util.log.Trace;
import com.sap.sdm.xml.AbstractXMLElementBuilder;
import com.sap.sdm.xml.XMLConstants;
import com.sap.sdm.xml.XMLElementIF;
import com.sap.sdm.xml.XMLException;
import com.sap.sdm.xml.extern.XMLParseException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XMLElementBuilder
extends AbstractXMLElementBuilder
implements XMLConstants {
    private static final Trace trace = Trace.getTrace(class$com$sap$sdm$xml$extern$XMLElementBuilder == null ? (class$com$sap$sdm$xml$extern$XMLElementBuilder = XMLElementBuilder.class$("com.sap.sdm.xml.extern.XMLElementBuilder")) : class$com$sap$sdm$xml$extern$XMLElementBuilder);
    private SAXParser saxParser;
    private SaxContentHandler contentHandler;
    static /* synthetic */ Class class$com$sap$sdm$xml$extern$XMLElementBuilder;

    public XMLElementBuilder() throws XMLException {
        this.initParser();
        this.contentHandler = new SaxContentHandler();
    }

    private void initParser() throws XMLException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            this.saxParser = factory.newSAXParser();
        }
        catch (ParserConfigurationException pcE) {
            throw new XMLParseException(pcE);
        }
        catch (SAXException saxE) {
            throw new XMLParseException(saxE);
        }
    }

    protected XMLElementIF createXMLElement(String uri) throws XMLException {
        try {
            this.contentHandler.reset();
            XMLReader xmlReader = this.saxParser.getXMLReader();
            xmlReader.setContentHandler(this.contentHandler);
            xmlReader.parse(uri);
            return this.contentHandler.getResult();
        }
        catch (SAXException saxE) {
            throw new XMLParseException(saxE);
        }
        catch (IOException ioE) {
            throw new XMLParseException(ioE);
        }
    }

    protected XMLElementIF createXMLElementFromStream(Reader xmlStream) throws XMLException {
        try {
            this.contentHandler.reset();
            XMLReader xmlReader = this.saxParser.getXMLReader();
            xmlReader.setContentHandler(this.contentHandler);
            xmlReader.parse(new InputSource(xmlStream));
            return this.contentHandler.getResult();
        }
        catch (SAXException saxE) {
            throw new XMLParseException(saxE);
        }
        catch (IOException ioE) {
            throw new XMLParseException(ioE);
        }
    }

    protected XMLElementIF createXMLElementfromString(String xmlString) throws XMLException {
        StringReader xmlStream = new StringReader(xmlString);
        return this.createXMLElementFromStream(xmlStream);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class SaxContentHandler
    extends DefaultHandler {
        private XMLElementBuilder builder;
        private Stack elemStack;
        private XMLElementIF result;

        SaxContentHandler() {
            this.builder = XMLElementBuilder.this;
            this.elemStack = new Stack();
        }

        public void startElement(String uri, String name, String qName, Attributes attrs) throws SAXException {
            trace.entering("startElement(uri " + uri + ",name " + name + ",qName " + qName + ",Attributes 'attrs')");
            try {
                XMLElementIF elem = XMLElementBuilder.super.createEmptyXMLElement();
                elem.setName(qName);
                this.addAttrs(elem, attrs);
                if (!this.elemStack.isEmpty()) {
                    ((XMLElementIF)this.elemStack.peek()).add(elem);
                }
                this.elemStack.push(elem);
                Object var7_6 = null;
                trace.exiting();
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                trace.exiting();
                throw throwable;
            }
        }

        public void endElement(String uri, String name, String qName) throws SAXException {
            trace.entering("endElement(uri " + uri + ",name " + name + ",qName " + qName + ")");
            try {
                XMLElementIF elem = (XMLElementIF)this.elemStack.pop();
                if (elem.getContent() != null) {
                    String content = elem.getContent().trim();
                    if (content.length() > 0) {
                        elem.setContent(content);
                    } else {
                        elem.setContent(null);
                    }
                }
                if (this.elemStack.isEmpty()) {
                    this.result = elem;
                }
                Object var7_6 = null;
                trace.exiting();
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                trace.exiting();
                throw throwable;
            }
        }

        public void characters(char[] ch, int start, int len) throws SAXException {
            String content = new String(ch, start, len);
            if (content.length() > 0) {
                XMLElementIF elem = (XMLElementIF)this.elemStack.peek();
                String oldContent = elem.getContent();
                if (oldContent != null) {
                    content = oldContent + content;
                }
                elem.setContent(content);
            }
        }

        void reset() {
            this.elemStack.removeAllElements();
            this.result = null;
        }

        XMLElementIF getResult() throws XMLParseException {
            if (this.result == null) {
                throw new XMLParseException("SAX Parser returned before end of document.");
            }
            return this.result;
        }

        private void addAttrs(XMLElementIF elem, Attributes attrs) {
            int nAttrs = attrs.getLength();
            int i = 0;
            while (i < nAttrs) {
                elem.addAttr(attrs.getQName(i), attrs.getValue(i));
                ++i;
            }
        }
    }
}

