/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.xml;

import com.sap.sdm.util.xml.XMLFilter;
import com.sap.sdm.xml.XMLElementIF;
import com.sap.sdm.xml.XMLException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class XMLWriter {
    private static final String INDENT = "  ";
    private final XMLElementIF rootElem;
    private final Writer out;
    private final IndentStack indentStack;
    private final boolean writeEOL;

    private XMLWriter(XMLElementIF rootElem, Writer out, boolean writeEOL) {
        this.rootElem = rootElem;
        this.out = out;
        this.indentStack = new IndentStack(INDENT);
        this.writeEOL = writeEOL;
    }

    public static XMLWriter create(XMLElementIF rootElem, Writer out) {
        return XMLWriter.create(rootElem, out, true);
    }

    public static XMLWriter create(XMLElementIF rootElem, Writer out, boolean writeEOL) {
        return new XMLWriter(rootElem, out, writeEOL);
    }

    public static String toXMLString(XMLElementIF elem) throws IOException {
        StringWriter out = new StringWriter();
        XMLWriter.create(elem, out, false).write();
        return out.getBuffer().toString();
    }

    public void write() throws IOException {
        if (this.writeEOL) {
            this.out.write("<?xml version=\"1.0\"?>\n\n");
        } else {
            this.out.write("<?xml version=\"1.0\"?>");
        }
        this.writeXMLElem(this.rootElem, this.writeEOL);
    }

    private void writeXMLElem(XMLElementIF xmlElem, boolean writeEOL) throws IOException {
        if (writeEOL) {
            this.out.write(this.indentStack.getIndent());
        }
        this.out.write("<");
        this.out.write(xmlElem.getName());
        Iterator it = xmlElem.getAttrNames();
        while (it.hasNext()) {
            try {
                String name = (String)it.next();
                this.out.write(" ");
                this.out.write(name);
                this.out.write("=\"");
                String attributeValue = xmlElem.getAttrString(name);
                this.out.write(XMLFilter.checkAndFilterOutput(attributeValue));
                this.out.write("\"");
            }
            catch (XMLException e) {
                // empty catch block
            }
        }
        if (writeEOL) {
            this.out.write(">\n");
        } else {
            this.out.write(">");
        }
        String content = xmlElem.getContent();
        if (content != null) {
            if (writeEOL) {
                this.out.write(this.indentStack.getIndent());
                this.out.write(this.indentStack.getSubElemIndent());
            }
            this.out.write(XMLFilter.checkAndFilterOutput(content));
            if (writeEOL) {
                this.out.write("\n");
            }
        }
        this.indentStack.push();
        Iterator it2 = xmlElem.getSubElements();
        while (it2.hasNext()) {
            this.writeXMLElem((XMLElementIF)it2.next(), writeEOL);
        }
        this.indentStack.pop();
        if (writeEOL) {
            this.out.write(this.indentStack.getIndent());
        }
        this.out.write("</");
        this.out.write(xmlElem.getName());
        if (writeEOL) {
            this.out.write(">\n");
        } else {
            this.out.write(">");
        }
    }

    private class IndentStack {
        private int stackLevel = 0;
        private final String subElemIndent;
        private final List indentList = new ArrayList();

        IndentStack(String subElemIndent) {
            this.fillIndentList();
            this.subElemIndent = subElemIndent;
        }

        void push() {
            ++this.stackLevel;
            this.fillIndentList();
        }

        void pop() {
            --this.stackLevel;
        }

        String getSubElemIndent() {
            return this.subElemIndent;
        }

        String getIndent() {
            return (String)this.indentList.get(this.stackLevel);
        }

        private void fillIndentList() {
            int i = this.indentList.size();
            while (i <= this.stackLevel) {
                this.indentList.add(this.buildIndent(i));
                ++i;
            }
        }

        private String buildIndent(int depth) {
            StringBuffer buff = new StringBuffer();
            int i = 0;
            while (i < depth) {
                buff.append(this.subElemIndent);
                ++i;
            }
            return buff.toString();
        }
    }
}

