/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.xml;

import com.sap.sdm.xml.XMLAttributeNotFoundException;
import com.sap.sdm.xml.XMLElementIF;
import com.sap.sdm.xml.XMLElementIterator;
import com.sap.sdm.xml.XMLElementIteratorIF;
import com.sap.sdm.xml.XMLException;
import com.sap.sdm.xml.XMLIllegalAttributeValueException;
import com.sap.sdm.xml.XMLIllegalContentValueException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

class XMLElement
implements XMLElementIF {
    private String name = null;
    private String content = null;
    Map attrs = null;
    static final String INDENT = "  ";
    private List subElements = null;

    XMLElement() {
    }

    XMLElement(String name) {
        this.setName(name);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public boolean getContentBoolean() throws XMLException {
        if ("true".equalsIgnoreCase(this.getContent())) {
            return true;
        }
        if ("false".equalsIgnoreCase(this.getContent())) {
            return false;
        }
        throw new XMLIllegalContentValueException(this, this.getContent());
    }

    public int getContentInteger() throws XMLException {
        try {
            return Integer.parseInt(this.getContent());
        }
        catch (NumberFormatException nfE) {
            throw new XMLIllegalContentValueException(this, this.getContent());
        }
    }

    public Iterator getAttrNames() {
        if (this.attrs == null) {
            return Collections.EMPTY_SET.iterator();
        }
        return this.attrs.keySet().iterator();
    }

    public void addAttr(String name, String value) {
        if (name != null) {
            if (this.attrs == null) {
                this.attrs = new HashMap();
            }
            if (value == null) {
                this.attrs.put(name, "NULL");
            } else {
                this.attrs.put(name, value);
            }
        }
    }

    public String getAttrString(String name) throws XMLException {
        if (this.attrs == null) {
            throw new XMLAttributeNotFoundException(this, name);
        }
        String value = (String)this.attrs.get(name);
        if (value == null) {
            throw new XMLAttributeNotFoundException(this, name);
        }
        return value;
    }

    public int getAttrInteger(String name) throws XMLException {
        String value = null;
        try {
            value = this.getAttrString(name);
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfE) {
            throw new XMLIllegalAttributeValueException(this, name, value);
        }
    }

    public boolean getAttrBoolean(String name) throws XMLException {
        String value = this.getAttrString(name);
        if ("true".equalsIgnoreCase(value)) {
            return true;
        }
        if ("false".equalsIgnoreCase(value)) {
            return false;
        }
        throw new XMLIllegalAttributeValueException(this, name, value);
    }

    public Iterator getSubElements() {
        if (this.subElements != null) {
            return this.subElements.listIterator();
        }
        return Collections.EMPTY_LIST.iterator();
    }

    public XMLElementIteratorIF getXMLSubElements() {
        if (this.subElements != null) {
            return new XMLElementIterator(this.subElements.toArray(new XMLElementIF[this.subElements.size()]));
        }
        return new XMLElementIterator(new XMLElementIF[0]);
    }

    public void add(XMLElementIF elem) {
        if (null != elem) {
            if (this.subElements == null) {
                this.subElements = new LinkedList();
            }
            this.subElements.add(elem);
        } else {
            new Exception().printStackTrace(System.out);
        }
    }

    public void addWhenNotNull(XMLElementIF elem) {
        if (elem != null) {
            this.add(elem);
        }
    }

    void remove(XMLElementIF elem) {
        if (this.subElements == null) {
            return;
        }
        this.subElements.remove(elem);
    }
}

