/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.util.version;

import com.sap.sdm.util.log.Logger;
import com.sap.sdm.util.version.Version;
import java.math.BigInteger;
import java.util.Arrays;

final class VersionImpl
implements Version {
    private static final Logger log = Logger.getLogger();
    static final String DOT_STRING = ".";
    private final String[] numericalStrings;
    private final BigInteger[] numStringsAsBigInts;
    private final String res;
    static /* synthetic */ Class class$com$sap$sdm$util$version$Version;

    VersionImpl(String[] numericalStrings) {
        this.numericalStrings = new String[numericalStrings.length];
        System.arraycopy(numericalStrings, 0, this.numericalStrings, 0, numericalStrings.length);
        this.numStringsAsBigInts = this.toBigIntegersNoTrailingZeroes(numericalStrings);
        StringBuffer result = null;
        result = new StringBuffer();
        int i = 0;
        while (i < numericalStrings.length - 1) {
            result.append(numericalStrings[i]);
            result.append(DOT_STRING);
            ++i;
        }
        result.append(numericalStrings[numericalStrings.length - 1]);
        this.res = result.toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        VersionImpl otherVersion = (VersionImpl)other;
        return Arrays.equals(this.numericalStrings, otherVersion.numericalStrings);
    }

    public int hashCode() {
        int offset = 17;
        int multiplier = 59;
        int result = 17;
        int i = 0;
        while (i < this.numericalStrings.length) {
            result += 59 * this.numericalStrings[i].hashCode();
            ++i;
        }
        return result;
    }

    public boolean isLower(Version otherVersion) {
        VersionImpl.paramCheck("isLower", otherVersion);
        VersionImpl ovImpl = (VersionImpl)otherVersion;
        int i = 0;
        while (i < Math.min(this.numStringsAsBigInts.length, ovImpl.numStringsAsBigInts.length)) {
            if (this.numStringsAsBigInts[i].compareTo(ovImpl.numStringsAsBigInts[i]) < 0) {
                return true;
            }
            if (this.numStringsAsBigInts[i].compareTo(ovImpl.numStringsAsBigInts[i]) > 0) {
                return false;
            }
            ++i;
        }
        return this.numStringsAsBigInts.length < ovImpl.numStringsAsBigInts.length;
    }

    public boolean isEquivalent(Version otherVersion) {
        VersionImpl.paramCheck("isEquivalent", otherVersion);
        VersionImpl ovImpl = (VersionImpl)otherVersion;
        return Arrays.equals(this.numStringsAsBigInts, ovImpl.numStringsAsBigInts);
    }

    public boolean isLowerOrEquivalent(Version otherVersion) {
        VersionImpl.paramCheck("isLowerOrEquivalent", otherVersion);
        return this.isLower(otherVersion) || this.isEquivalent(otherVersion);
    }

    public String toString() {
        return this.res;
    }

    BigInteger[] toBigIntegers() {
        BigInteger[] result = new BigInteger[this.numStringsAsBigInts.length];
        System.arraycopy(this.numStringsAsBigInts, 0, result, 0, result.length);
        return result;
    }

    private BigInteger[] toBigIntegersNoTrailingZeroes(String[] numStrings) {
        return this.removeTrailingZeroes(this.toBigIntegers(numStrings));
    }

    private BigInteger[] toBigIntegers(String[] numStrings) {
        BigInteger[] result = new BigInteger[numStrings.length];
        int i = 0;
        while (i < numStrings.length) {
            result[i] = new BigInteger(numStrings[i]);
            ++i;
        }
        return result;
    }

    private BigInteger[] removeTrailingZeroes(BigInteger[] bigInts) {
        int lengthNoTrailingZeroes = Math.max(0, this.getIndexLastNonZero(bigInts)) + 1;
        BigInteger[] result = new BigInteger[lengthNoTrailingZeroes];
        System.arraycopy(bigInts, 0, result, 0, lengthNoTrailingZeroes);
        return result;
    }

    private int getIndexLastNonZero(BigInteger[] bigInts) {
        int i = bigInts.length - 1;
        while (i >= 0) {
            if (bigInts[i].compareTo(BigInteger.ZERO) != 0) {
                return i;
            }
            --i;
        }
        return -1;
    }

    private static void paramCheck(String methodName, Object param) {
        if (param != null) {
            return;
        }
        String errText = (class$com$sap$sdm$util$version$Version == null ? (class$com$sap$sdm$util$version$Version = VersionImpl.class$("com.sap.sdm.util.version.Version")) : class$com$sap$sdm$util$version$Version).getName() + DOT_STRING + methodName + ": parameter is null";
        log.fatal(errText);
        throw new NullPointerException(errText);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

