/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.util.sduread.xmlize;

import com.sap.sdm.util.sduread.ScaFile;
import com.sap.sdm.util.sduread.SdaFile;
import com.sap.sdm.util.sduread.SduFile;
import com.sap.sdm.util.sduread.SduFileVisitor;
import com.sap.sdm.util.sduread.xmlize.ScaFileXMLizer;
import com.sap.sdm.util.sduread.xmlize.SdaFileXMLizer;
import com.sap.sdm.xml.AbstractXMLizer;
import com.sap.sdm.xml.XMLElementIF;
import com.sap.sdm.xml.XMLWriter;
import java.io.IOException;
import java.util.HashMap;

public final class SduFileSetXMLizer
extends AbstractXMLizer
implements SduFileVisitor {
    public static final int SDU_XML_VERSION_1 = 1;
    public static final int SDU_XML_VERSION_2 = 2;
    private static final String NAME = "sdus";
    private static HashMap sduXMLizers = new HashMap(1);
    private int version;
    private XMLElementIF result;

    private SduFileSetXMLizer(int version) {
        super(NAME);
        this.version = version;
    }

    public static SduFileSetXMLizer getInstance() {
        return SduFileSetXMLizer.getInstanceByVersion(1);
    }

    public static SduFileSetXMLizer getInstanceByVersion(int xmlVersion) {
        Integer key = new Integer(xmlVersion);
        SduFileSetXMLizer instance = (SduFileSetXMLizer)sduXMLizers.get(key);
        if (instance == null) {
            instance = new SduFileSetXMLizer(xmlVersion);
            sduXMLizers.put(key, instance);
        }
        return instance;
    }

    public XMLElementIF toXML(SduFile[] sduFiles) {
        this.result = this.createRootElem();
        if (sduFiles != null) {
            int i = 0;
            while (i < sduFiles.length) {
                sduFiles[i].accept(this);
                ++i;
            }
        }
        return this.result;
    }

    public String toString(SduFile[] sduFiles) throws IOException {
        return XMLWriter.toXMLString(this.toXML(sduFiles));
    }

    public void visitScaFile(ScaFile scaFile) {
        this.result.add(ScaFileXMLizer.getInstanceByVersion(this.version).toXML(scaFile));
    }

    public void visitSdaFile(SdaFile sdaFile) {
        this.result.add(SdaFileXMLizer.getInstanceByVersion(this.version).toXML(sdaFile));
    }
}

