/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.util.sduread.xmlize;

import com.sap.sdm.util.sduread.ScaFile;
import com.sap.sdm.xml.AbstractXMLizer;
import com.sap.sdm.xml.XMLElementIF;
import java.util.HashMap;

public class ScaFileXMLizer
extends AbstractXMLizer {
    private static final String NAME = "ScaFile";
    private static final String SCA_FILE_NAME = "SdaFileName";
    private static final String SCA_FILE_VENDOR = "SdaFileVendor";
    private static final String SCA_FILE_LOCATION = "SdaFileLocation";
    private static final String SCA_FILE_COUNT = "SdaFileCount";
    private static final String SCA_FILE_PATH_NAME = "PathName";
    private static final String SCA_FILE_COMPONENT_TYPE = "ComponentType";
    private static final String SCA_FILE_NAME_V2 = "ScaFileName";
    private static final String SCA_FILE_VENDOR_V2 = "ScaFileVendor";
    private static final String SCA_FILE_LOCATION_V2 = "ScaFileLocation";
    private static final String SCA_FILE_COUNT_V2 = "ScaFileCount";
    private static final String SCA_FILE_SP_NUMBER = "SPNumber";
    public static final int SCA_XML_VERSION_1 = 1;
    public static final int SCA_XML_VERSION_2 = 2;
    private static HashMap scaXMLizers = new HashMap(1);
    private int version;

    private ScaFileXMLizer(int version) {
        super(NAME);
        this.version = version;
    }

    public static ScaFileXMLizer getInstance() {
        return ScaFileXMLizer.getInstanceByVersion(1);
    }

    public static ScaFileXMLizer getInstanceByVersion(int xmlVersion) {
        Integer key = new Integer(xmlVersion);
        ScaFileXMLizer instance = (ScaFileXMLizer)scaXMLizers.get(key);
        if (instance == null) {
            instance = new ScaFileXMLizer(xmlVersion);
            scaXMLizers.put(key, instance);
        }
        return instance;
    }

    public XMLElementIF toXML(ScaFile scaFile) {
        switch (this.version) {
            case 1: {
                return this.toXML_V1(scaFile);
            }
            case 2: {
                return this.toXML_V2(scaFile);
            }
        }
        return this.toXML_V1(scaFile);
    }

    private XMLElementIF toXML_V1(ScaFile scaFile) {
        XMLElementIF result = this.createRootElem();
        result.add(this.createElemWithNameAndContent(SCA_FILE_NAME, scaFile.getComponentVersion().getName()));
        result.add(this.createElemWithNameAndContent(SCA_FILE_VENDOR, scaFile.getComponentVersion().getVendor()));
        result.add(this.createElemWithNameAndContent(SCA_FILE_LOCATION, scaFile.getComponentVersion().getLocation()));
        result.add(this.createElemWithNameAndContent(SCA_FILE_COUNT, scaFile.getComponentVersion().getCount().toString()));
        result.add(this.createElemWithNameAndContent(SCA_FILE_PATH_NAME, scaFile.getPathName()));
        String compType = scaFile.getComponentElement() == null ? "SC" : scaFile.getComponentElement().getComponentType();
        result.add(this.createElemWithNameAndContent(SCA_FILE_COMPONENT_TYPE, compType));
        return result;
    }

    private XMLElementIF toXML_V2(ScaFile scaFile) {
        XMLElementIF result = this.createRootElem();
        result.add(this.createElemWithNameAndContent(SCA_FILE_NAME_V2, scaFile.getComponentVersion().getName()));
        result.add(this.createElemWithNameAndContent(SCA_FILE_VENDOR_V2, scaFile.getComponentVersion().getVendor()));
        result.add(this.createElemWithNameAndContent(SCA_FILE_LOCATION_V2, scaFile.getComponentVersion().getLocation()));
        result.add(this.createElemWithNameAndContent(SCA_FILE_COUNT_V2, scaFile.getComponentVersion().getCount().toString()));
        result.add(this.createElemWithNameAndContent(SCA_FILE_SP_NUMBER, scaFile.getComponentElement().getServiceLevel()));
        result.add(this.createElemWithNameAndContent(SCA_FILE_PATH_NAME, scaFile.getPathName()));
        String compType = scaFile.getComponentElement() == null ? "SC" : scaFile.getComponentElement().getComponentType();
        result.add(this.createElemWithNameAndContent(SCA_FILE_COMPONENT_TYPE, compType));
        return result;
    }
}

