/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.util.sduread.impl;

import com.sap.sdm.util.Constants;
import com.sap.sdm.util.jarsl.ConstantsIF;
import com.sap.sdm.util.jarsl.JarSL;
import com.sap.sdm.util.sduread.ComponentVersionVisitor;
import com.sap.sdm.util.sduread.IllFormattedSduFileException;
import com.sap.sdm.util.sduread.SoftwareComponentVersion;
import com.sap.sdm.util.version.Version;
import com.sap.sdm.util.version.VersionFactory;

public class SoftwareComponentVersionImpl
implements SoftwareComponentVersion,
ConstantsIF {
    Version count = null;
    String location = null;
    String name = null;
    String vendor = null;

    SoftwareComponentVersionImpl(JarSL jarsl) throws IllFormattedSduFileException {
        this.location = jarsl.readAttribute("", "keylocation");
        this.name = jarsl.readAttribute("", "keyname");
        this.vendor = jarsl.readAttribute("", "keyvendor");
        String countS = jarsl.readAttribute("", "keycounter");
        if (null == this.location || "".equals(this.location) || null == this.name || "".equals(this.name) || null == this.vendor || "".equals(this.vendor) || null == countS || "".equals(countS) || !VersionFactory.isValidVersionString(countS)) {
            StringBuffer error = new StringBuffer("Manifest attributes are missing or have badly formatted value:" + Constants.EOL);
            if (null == this.location) {
                error.append("attribute keylocation is missing" + Constants.EOL);
            } else if ("".equals(this.location)) {
                error.append("attribute keylocation is empty" + Constants.EOL);
            }
            if (null == this.name) {
                error.append("attribute keyname is missing" + Constants.EOL);
            } else if ("".equals(this.name)) {
                error.append("attribute keyname is empty" + Constants.EOL);
            }
            if (null == this.vendor) {
                error.append("attribute keyvendor is missing" + Constants.EOL);
            } else if ("".equals(this.vendor)) {
                error.append("attribute keyvendor is empty" + Constants.EOL);
            }
            if (null == countS) {
                error.append("attribute keycounter is missing" + Constants.EOL);
            } else if (!VersionFactory.isValidVersionString(countS)) {
                error.append("attribute keycounter is badly formatted (" + countS + ")" + Constants.EOL);
            }
            throw new IllFormattedSduFileException("The information about the software component " + Constants.EOL + "found in the SCA " + jarsl.getArchiveName().getPath() + " is either missing or incomplete!" + Constants.EOL + error.toString());
        }
        this.count = VersionFactory.createVersion(countS);
    }

    public Version getCount() {
        return this.count;
    }

    public String getLocation() {
        return this.location;
    }

    public String getName() {
        return this.name;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String toString() {
        return "not implemented";
    }

    public boolean equals(Object other) {
        return other instanceof SoftwareComponentVersion && ((SoftwareComponentVersion)other).getName().equals(this.getName()) && ((SoftwareComponentVersion)other).getCount().equals(this.getCount()) && ((SoftwareComponentVersion)other).getLocation().equals(this.getLocation()) && ((SoftwareComponentVersion)other).getVendor().equals(this.getVendor());
    }

    public int hashCode() {
        return 0;
    }

    public void accept(ComponentVersionVisitor visitor) {
        visitor.visitSCV(this);
    }
}

