/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.util.sduread.impl;

import com.sap.sdm.util.jarsl.ConstantsIF;
import com.sap.sdm.util.jarsl.JarSL;
import com.sap.sdm.util.sduread.IllFormattedSduFileException;
import com.sap.sdm.util.sduread.SduFile;
import com.sap.sdm.util.sduread.SduReader;
import com.sap.sdm.util.sduread.impl.ScaFileImpl;
import com.sap.sdm.util.sduread.impl.SdaFileImpl;
import com.sap.sdm.util.sduread.impl.WrongArchiveFormatException;
import java.io.IOException;

public class SduReaderImpl
extends SduReader
implements ConstantsIF {
    public SduFile readFile(String pathName) throws IllFormattedSduFileException, IOException {
        return this.readFile(pathName, true);
    }

    public SduFile readFile(String pathName, boolean onlydeployable) throws IllFormattedSduFileException, IOException {
        SduFile sdufile = null;
        JarSL jarsl = new JarSL(pathName, "");
        if (!JarSL.checkFileExistence(pathName)) {
            throw new IOException("The file " + pathName + " does not exist on the filesystem.");
        }
        String sda_sdmsdacompvers = jarsl.readAttribute("", "SDM-SDA-Comp-Version");
        String ext_sda_sdmsdacompvers = jarsl.readAttribute("", "Ext-SDM-SDA-Comp-Version");
        if (ext_sda_sdmsdacompvers != null) {
            int ext_sdm_sdmsdacompvers = 1;
            if (new Integer(ext_sda_sdmsdacompvers) > ext_sdm_sdmsdacompvers) {
                String message = "The current SduReader is too old for the SDA. The SDM-SDA compatible version must be " + ext_sda_sdmsdacompvers + " or greater.";
                throw new IllFormattedSduFileException(message);
            }
        }
        try {
            try {
                sdufile = new SdaFileImpl(jarsl, onlydeployable);
            }
            catch (WrongArchiveFormatException e) {
                sdufile = null;
            }
            if (sdufile == null) {
                try {
                    sdufile = new ScaFileImpl(jarsl);
                }
                catch (WrongArchiveFormatException e) {
                    sdufile = null;
                }
            }
            if (sdufile == null) {
                throw new IllFormattedSduFileException("archive is neither a SDA nor a SCA");
            }
        }
        catch (IllFormattedSduFileException e) {
            if (sda_sdmsdacompvers != null && ext_sda_sdmsdacompvers == null) {
                throw new IllFormattedSduFileException("The archive must be deployed with a 6.20 SDM, which has a SDM-SDA compatible version " + sda_sdmsdacompvers + " or greater.");
            }
            throw e;
        }
        return sdufile;
    }
}

