/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.util.sduread.impl;

import com.sap.sdm.util.jarsl.ConstantsIF;
import com.sap.sdm.util.jarsl.JarSL;
import com.sap.sdm.util.sduread.ComponentVersion;
import com.sap.sdm.util.sduread.Dependency;
import com.sap.sdm.util.sduread.DevelopmentComponentVersion;
import com.sap.sdm.util.sduread.IllFormattedSduFileException;
import com.sap.sdm.util.sduread.SdaFile;
import com.sap.sdm.util.sduread.SduFileVisitor;
import com.sap.sdm.util.sduread.impl.ComponentElementDeXMLizer;
import com.sap.sdm.util.sduread.impl.DependencyImpl;
import com.sap.sdm.util.sduread.impl.DevelopmentComponentVersionImpl;
import com.sap.sdm.util.sduread.impl.WrongArchiveFormatException;
import com.sap.sdm.util.slutil.ComponentFactory;
import com.sap.sl.util.components.api.ComponentElementIF;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;

public class SdaFileImpl
implements SdaFile,
ConstantsIF {
    String pathname = null;
    DevelopmentComponentVersion dcv = null;
    String softwaretype = null;
    Dependency[] deps = null;
    String deployfile = null;
    String softwaresubtype = null;
    String debuginfo = null;
    private final ComponentElementIF componentelement;

    SdaFileImpl(JarSL jarsl) throws IllFormattedSduFileException, IOException, WrongArchiveFormatException {
        this(jarsl, true);
    }

    SdaFileImpl(JarSL jarsl, boolean onlydeployable) throws IllFormattedSduFileException, IOException, WrongArchiveFormatException {
        if (jarsl.readAttribute("", "SP-Number") != null || jarsl.readAttribute("", "pr_type") != null) {
            throw new WrongArchiveFormatException();
        }
        this.pathname = jarsl.getArchiveName().getPath();
        this.dcv = new DevelopmentComponentVersionImpl(jarsl);
        String _componentelement = jarsl.readAttribute("", "componentelement");
        this.softwaresubtype = jarsl.readAttribute("", "softwaresubtype");
        if (_componentelement != null) {
            this.componentelement = ComponentElementDeXMLizer.getComponentFromXMLString(_componentelement, "SDA(" + jarsl.getArchiveName().getPath() + ")");
        } else {
            String servertype = null;
            String sourceserver = null;
            String changenumber = null;
            String projectname = jarsl.readAttribute("", "projectname");
            if (jarsl.readAttribute("", "dtr-workspace") != null) {
                servertype = "DTR";
                sourceserver = jarsl.readAttribute("", "dtr-workspace");
                changenumber = jarsl.readAttribute("", "dtr-integration-sequence-no");
            } else if (jarsl.readAttribute("", "perforceserver") != null) {
                servertype = "P4";
                sourceserver = jarsl.readAttribute("", "perforceserver");
                changenumber = jarsl.readAttribute("", "changelistnumber");
            }
            this.componentelement = ComponentFactory.getInstance().createComponentElement(this.dcv.getVendor(), this.dcv.getName(), "DC", "NO_SUBSYS", this.dcv.getLocation(), this.dcv.getCount().toString(), null, null, null, null, null, "F", null, null, null, null, null, null, servertype, sourceserver, changenumber, projectname);
        }
        this.softwaretype = jarsl.readAttribute("", "softwaretype");
        if (this.softwaretype == null && onlydeployable) {
            throw new IllFormattedSduFileException("There is no softwaretype declared in the SDA file: " + jarsl.getArchiveName().getPath());
        }
        this.deps = DependencyImpl.createDependencies(jarsl);
        if (this.deps == null) {
            this.deps = new Dependency[0];
        }
        if (jarsl.readAttribute("", "deployfile") != null && !jarsl.readAttribute("", "deployfile").equalsIgnoreCase("empty")) {
            this.deployfile = jarsl.readAttribute("", "deployfile");
        } else {
            if (onlydeployable) {
                throw new IllFormattedSduFileException("There is no deployment descriptor found in the SDA file: " + jarsl.getArchiveName().getPath());
            }
            this.softwaretype = null;
        }
        this.debuginfo = "";
        if (jarsl.readAttribute("", "changelistnumber") != null) {
            this.debuginfo = this.debuginfo + "changelistnumber=" + jarsl.readAttribute("", "changelistnumber") + ";";
        }
        if (jarsl.readAttribute("", "perforceserver") != null) {
            this.debuginfo = this.debuginfo + "perforceserver=" + jarsl.readAttribute("", "perforceserver") + ";";
        }
        if (jarsl.readAttribute("", "projectname") != null) {
            this.debuginfo = this.debuginfo + "projectname=" + jarsl.readAttribute("", "projectname") + ";";
        }
        if (jarsl.readAttribute("", "dtr-integration-sequence-no") != null) {
            this.debuginfo = this.debuginfo + "dtr-integration-sequence-no=" + jarsl.readAttribute("", "dtr-integration-sequence-no") + ";";
        }
        if (jarsl.readAttribute("", "dtr-workspace") != null) {
            this.debuginfo = this.debuginfo + "dtr-workspace=" + jarsl.readAttribute("", "dtr-workspace") + ";";
        }
        this.debuginfo = this.debuginfo.length() == 0 ? null : this.debuginfo.substring(0, this.debuginfo.length() - 1);
    }

    public Dependency[] getDependencies() {
        return this.deps;
    }

    public InputStream getDeploymentDescriptor() throws IOException {
        ByteArrayInputStream ins;
        ByteArrayInputStream ddes = null;
        Vector error = new Vector();
        JarSL jarsl = new JarSL(this.pathname, "");
        if (this.deployfile != null) {
            ins = jarsl.extractSingleFileAsByteArray("META-INF/" + this.deployfile);
            if (ins == null) {
                StringBuffer tmpB = new StringBuffer();
                if (null != error) {
                    Iterator errIter = ((AbstractList)error).iterator();
                    while (errIter.hasNext()) {
                        tmpB.append((String)errIter.next());
                    }
                }
                throw new IOException(tmpB.toString());
            }
        } else {
            return null;
        }
        ddes = ins;
        return ddes;
    }

    public DevelopmentComponentVersion getDevelopmentComponentVersion() {
        return this.dcv;
    }

    public String getSoftwareType() {
        return this.softwaretype;
    }

    public ComponentVersion getComponentVersion() {
        return this.dcv;
    }

    public ComponentElementIF getComponentElement() {
        return this.componentelement;
    }

    public String getPathName() {
        return this.pathname;
    }

    public String getDebugInfo() {
        return this.debuginfo;
    }

    public String toString() {
        return "not implemented";
    }

    public boolean equals(Object other) {
        boolean depsequal = other instanceof SdaFile && ((SdaFile)other).getDependencies().length == this.getDependencies().length;
        int i = 0;
        while (i < this.deps.length && depsequal) {
            boolean found = false;
            int j = 0;
            while (j < this.deps.length && !found) {
                if (this.deps[i].equals(((SdaFile)other).getDependencies()[j])) {
                    found = true;
                }
                ++j;
            }
            if (!found) {
                depsequal = false;
            }
            ++i;
        }
        return depsequal && ((SdaFile)other).getPathName().equals(this.getPathName()) && ((SdaFile)other).getSoftwareType().equals(this.getSoftwareType()) && ((SdaFile)other).getDevelopmentComponentVersion().equals(this.getDevelopmentComponentVersion());
    }

    public int hashCode() {
        return 0;
    }

    public void accept(SduFileVisitor visitor) {
        visitor.visitSdaFile(this);
    }

    public String getSoftwareSubType() {
        return this.softwaresubtype;
    }
}

