/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.util.sduread.impl;

import com.sap.sdm.util.jarsl.JarSL;
import com.sap.sdm.util.log.Logger;
import com.sap.sdm.util.sduread.ComponentVersion;
import com.sap.sdm.util.sduread.FileExtractionException;
import com.sap.sdm.util.sduread.IllFormattedSduFileException;
import com.sap.sdm.util.sduread.ScaFile;
import com.sap.sdm.util.sduread.SdaFile;
import com.sap.sdm.util.sduread.SduContentMember;
import com.sap.sdm.util.sduread.SduFile;
import com.sap.sdm.util.sduread.SduFileVisitor;
import com.sap.sdm.util.sduread.SduReader;
import com.sap.sdm.util.sduread.SoftwareComponentVersion;
import com.sap.sdm.util.sduread.impl.ComponentElementDeXMLizer;
import com.sap.sdm.util.sduread.impl.DevelopmentComponentVersionImpl;
import com.sap.sdm.util.sduread.impl.SduContentMemberImpl;
import com.sap.sdm.util.sduread.impl.SoftwareComponentVersionImpl;
import com.sap.sdm.util.sduread.impl.WrongArchiveFormatException;
import com.sap.sdm.util.slutil.ComponentFactory;
import com.sap.sl.util.components.api.ComponentElementIF;
import java.io.IOException;
import java.util.AbstractList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

final class ScaFileImpl
implements ScaFile {
    private static final Logger log = Logger.getLogger();
    private final String pathname;
    private final SoftwareComponentVersion scv;
    private final Set memberSet;
    private final ComponentElementIF componentelement;

    ScaFileImpl(JarSL jarsl) throws IllFormattedSduFileException, IOException, WrongArchiveFormatException {
        if (!(jarsl.readAttribute("", "SP-Number") != null || jarsl.readAttribute("", "pr_type") != null && jarsl.readAttribute("", "pr_type").equals("SC"))) {
            throw new WrongArchiveFormatException();
        }
        this.pathname = jarsl.getArchiveName().getPath();
        this.scv = new SoftwareComponentVersionImpl(jarsl);
        String _componentelement = jarsl.readAttribute("", "componentelement");
        if (_componentelement != null) {
            this.componentelement = ComponentElementDeXMLizer.getComponentFromXMLString(_componentelement, "SCA(" + jarsl.getArchiveName().getPath() + ")");
        } else {
            String release = jarsl.readAttribute("", "release");
            String servicelevel = jarsl.readAttribute("", "SP-Number");
            String patchlevel = jarsl.readAttribute("", "SP-Patchlevel");
            String ppmsnumber = jarsl.readAttribute("", "Softwarecomponent-Ppmsnumber");
            this.componentelement = ComponentFactory.getInstance().createComponentElement(this.scv.getVendor(), this.scv.getName(), "SC", "NO_SUBSYS", this.scv.getLocation(), this.scv.getCount().toString(), this.scv.getVendor(), this.scv.getName(), release, servicelevel, patchlevel, "F", null, null, ppmsnumber, null, null, null, null, null, null, null);
        }
        String[] containedDCs = jarsl.getArchiveEntriesFromManifest();
        if (containedDCs == null || containedDCs.length == 0) {
            throw new IllFormattedSduFileException("The SCA file " + jarsl.getArchiveName().getPath() + " contains not one SDA file.");
        }
        HashSet<SduContentMemberImpl> tempMemberSet = new HashSet<SduContentMemberImpl>();
        int i = 0;
        while (i < containedDCs.length) {
            DevelopmentComponentVersionImpl currCV = new DevelopmentComponentVersionImpl(jarsl, containedDCs[i]);
            tempMemberSet.add(new SduContentMemberImpl(currCV, containedDCs[i]));
            ++i;
        }
        this.memberSet = Collections.unmodifiableSet(tempMemberSet);
    }

    public SduFile[] extract(SduContentMember[] members, String[] targetFileNames) throws FileExtractionException, IllFormattedSduFileException {
        if (members == null || targetFileNames == null) {
            String errText = "ScaFileImpl.extract(): param is null";
            log.fatal(errText);
            throw new NullPointerException(errText);
        }
        if (members.length != targetFileNames.length) {
            String errText = "ScaFileImpl.extract(): members and targetFileNames have different lengths";
            log.fatal(errText);
            throw new IllegalArgumentException();
        }
        String[] fileNamesInArchive = new String[members.length];
        int i = 0;
        while (i < members.length) {
            if (!this.memberSet.contains(members[i])) {
                String errText = "Member with index " + i + " not contained in SCA file";
                log.fatal(errText);
                throw new IllegalArgumentException();
            }
            fileNamesInArchive[i] = members[i].getFileNameWithinSdu();
            ++i;
        }
        this.extractFiles(fileNamesInArchive, targetFileNames);
        SduFile[] result = this.readExtractedSduFiles(targetFileNames);
        return result;
    }

    public SdaFile[] extractAll(String targetPathName) throws FileExtractionException, IllFormattedSduFileException {
        if (targetPathName == null) {
            String errText = "ScaFileImpl.extractAll(): targetDirectoryName is null";
            log.fatal(errText);
            throw new NullPointerException(errText);
        }
        SduContentMember[] members = this.memberSet.toArray(new SduContentMember[this.memberSet.size()]);
        String[] fileNamesInArchive = new String[this.memberSet.size()];
        String[] targetFileNames = new String[this.memberSet.size()];
        int i = 0;
        while (i < members.length) {
            fileNamesInArchive[i] = members[i].getFileNameWithinSdu();
            targetFileNames[i] = targetPathName + '/' + members[i].getFileNameWithinSdu();
            ++i;
        }
        this.extractFiles(fileNamesInArchive, targetFileNames);
        SdaFile[] result = this.readExtractedSdaFiles(targetFileNames);
        return result;
    }

    public void accept(SduFileVisitor visitor) {
        visitor.visitScaFile(this);
    }

    private void extractFiles(String[] fileNamesInArchive, String[] targetFileNames) throws FileExtractionException {
        JarSL jarSL = new JarSL(this.pathname, "");
        Vector errorTexts = new Vector();
        if (!jarSL.extractSingleFiles(fileNamesInArchive, targetFileNames, errorTexts)) {
            StringBuffer tmpB = new StringBuffer();
            Iterator errIter = ((AbstractList)errorTexts).iterator();
            while (errIter.hasNext()) {
                tmpB.append((String)errIter.next());
            }
            throw new FileExtractionException(tmpB.toString());
        }
    }

    private SduFile[] readExtractedSduFiles(String[] extractedFileNames) throws IllFormattedSduFileException, FileExtractionException {
        SduFile[] result = new SduFile[extractedFileNames.length];
        int i = 0;
        while (i < result.length) {
            try {
                result[i] = SduReader.getInstance().readFile(extractedFileNames[i]);
            }
            catch (IOException e) {
                throw new FileExtractionException(e.getMessage());
            }
            ++i;
        }
        return result;
    }

    private SdaFile[] readExtractedSdaFiles(String[] extractedFileNames) throws IllFormattedSduFileException, FileExtractionException {
        SdaFile[] result = new SdaFile[extractedFileNames.length];
        int i = 0;
        while (i < result.length) {
            SduFile sdur;
            try {
                sdur = SduReader.getInstance().readFile(extractedFileNames[i]);
            }
            catch (IOException e) {
                throw new FileExtractionException(e.getMessage());
            }
            if (!(sdur instanceof SdaFile)) {
                throw new IllFormattedSduFileException("Extracted file is not an SDA file");
            }
            result[i] = (SdaFile)sdur;
            ++i;
        }
        return result;
    }

    public SduContentMember[] getContents() {
        return this.memberSet.toArray(new SduContentMember[this.memberSet.size()]);
    }

    public SoftwareComponentVersion getSoftwareComponentVersion() {
        return this.scv;
    }

    public ComponentVersion getComponentVersion() {
        return this.scv;
    }

    public ComponentElementIF getComponentElement() {
        return this.componentelement;
    }

    public String getPathName() {
        return this.pathname;
    }

    public String toString() {
        return "not implemented";
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        ScaFileImpl otherScaFile = (ScaFileImpl)other;
        if (!this.getPathName().equals(otherScaFile.getPathName())) {
            return false;
        }
        if (!this.getSoftwareComponentVersion().equals(otherScaFile.getSoftwareComponentVersion())) {
            return false;
        }
        return this.memberSet.equals(otherScaFile.memberSet);
    }

    public int hashCode() {
        return 0;
    }
}

