/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.util.parexp;

import com.sap.sdm.util.parexp.ParExp;
import com.sap.sdm.util.parexp.ParExpFinder;
import com.sap.sdm.util.parexp.ParExpImpl;
import java.util.Vector;

class ParExpFinderImpl
implements ParExpFinder {
    private String openingParenthesis;
    private String closingParenthesis;

    ParExpFinderImpl(String openingParenthesis, String closingParenthesis) {
        this.openingParenthesis = openingParenthesis;
        this.closingParenthesis = closingParenthesis;
    }

    public ParExp[] getParExpsLeftToRight(String searchString) {
        ParExp nextParExp;
        Vector<ParExp> expVector = new Vector<ParExp>();
        int startIndex = 0;
        while ((nextParExp = this.findNextParExp(searchString, startIndex)) != null) {
            expVector.addElement(nextParExp);
            startIndex = nextParExp.getEndIndexWithPar();
        }
        if (expVector.isEmpty()) {
            return null;
        }
        ParExp[] foundExps = new ParExp[expVector.size()];
        int i = 0;
        while (i < expVector.size()) {
            foundExps[i] = (ParExp)expVector.elementAt(i);
            ++i;
        }
        return foundExps;
    }

    private ParExp findNextParExp(String searchString, int startIndex) {
        int startIndexWithPar = searchString.indexOf(this.openingParenthesis, startIndex);
        if (startIndexWithPar < 0) {
            return null;
        }
        int startIndexNoPar = startIndexWithPar + this.openingParenthesis.length();
        int endIndexNoPar = searchString.indexOf(this.closingParenthesis, startIndexNoPar);
        if (endIndexNoPar < 0) {
            return null;
        }
        int endIndexWithPar = endIndexNoPar + this.closingParenthesis.length();
        return new ParExpImpl(searchString, startIndexWithPar, endIndexWithPar, startIndexNoPar, endIndexNoPar);
    }
}

