/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.util.multiindex;

public class MultiIndex {
    int[] multiIndex = null;
    int[] multiMaxIndex = null;

    public static MultiIndex createNewInstance(int[] multiMaxIndex) {
        if (multiMaxIndex == null || multiMaxIndex.length == 0) {
            return null;
        }
        return new MultiIndex(multiMaxIndex);
    }

    private MultiIndex(int[] multiMaxIndex) {
        this.multiIndex = new int[multiMaxIndex.length];
        this.multiMaxIndex = multiMaxIndex;
    }

    public boolean canIncrease() {
        int i = this.multiMaxIndex.length - 1;
        while (i >= 0) {
            if (this.multiIndex[i] < this.multiMaxIndex[i] - 1) {
                return true;
            }
            --i;
        }
        return false;
    }

    public boolean increase() {
        if (!this.canIncrease()) {
            return false;
        }
        int i = 0;
        while (i < this.multiIndex.length) {
            if (this.multiIndex[i] < this.multiMaxIndex[i]) {
                int n = i;
                this.multiIndex[n] = this.multiIndex[n] + 1;
                if (this.multiIndex[i] != this.multiMaxIndex[i]) break;
                this.addCarry(i);
                break;
            }
            ++i;
        }
        return true;
    }

    public int getIndex(int i) {
        if (i >= this.multiIndex.length) {
            return -1;
        }
        return this.multiIndex[i];
    }

    private void addCarry(int i) {
        if (i == this.multiMaxIndex.length - 1) {
            return;
        }
        this.multiIndex[i] = 0;
        int n = i + 1;
        this.multiIndex[n] = this.multiIndex[n] + 1;
        if (this.multiIndex[i + 1] == this.multiMaxIndex[i + 1]) {
            this.addCarry(i + 1);
        }
    }
}

