/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.util.jarsl;

import com.sap.sdm.util.jarsl.ConstantsIF;
import com.sap.sdm.util.jarsl.Conv;
import com.sap.sdm.util.jarsl.ManifestEntry;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipInputStream;

final class ManifestSL
implements ConstantsIF {
    private Vector manifest;
    private String manifestname;

    ManifestSL(String manifestname) {
        this.manifestname = manifestname;
        this.manifest = new Vector();
    }

    boolean removeAllElements() {
        this.manifest.removeAllElements();
        return true;
    }

    ByteArrayInputStream createManifest() {
        return this.createManifest(null, false);
    }

    boolean createManifest(String rootdir) {
        return this.createManifest(rootdir, true) != null;
    }

    /*
     * Loose catch block
     */
    private ByteArrayInputStream createManifest(String rootdir, boolean filewrite) {
        ByteArrayInputStream bais;
        block53: {
            if (this.readAttribute("", "Manifest-Version") == null && !this.writeAttribute("", "Manifest-Version", "1.0")) {
                return null;
            }
            ByteArrayOutputStream baos = null;
            bais = null;
            FilterOutputStream bos = null;
            FilterOutputStream dosf = null;
            DataOutputStream dosa = null;
            if (filewrite) {
                new File(Conv.pathConv(rootdir + "/" + "META-INF" + "/" + this.manifestname)).delete();
                new File(Conv.pathConv(rootdir + "/" + "META-INF")).mkdirs();
                bos = new BufferedOutputStream(new FileOutputStream(Conv.pathConv(rootdir + "/" + "META-INF" + "/" + this.manifestname)));
            }
            baos = new ByteArrayOutputStream();
            dosa = new DataOutputStream(baos);
            if (filewrite) {
                dosf = new DataOutputStream(bos);
            }
            Vector<String> entries = new Vector<String>();
            entries.addElement("");
            int i = 0;
            while (i < this.manifest.size()) {
                if (!entries.contains(((ManifestEntry)this.manifest.elementAt((int)i)).name)) {
                    entries.addElement(((ManifestEntry)this.manifest.elementAt((int)i)).name);
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < entries.size()) {
                String name = (String)entries.elementAt(i2);
                boolean namewritten = false;
                int ii = 0;
                while (ii < this.manifest.size()) {
                    ManifestEntry mfe = (ManifestEntry)this.manifest.elementAt(ii);
                    if (mfe.name.compareTo(name) == 0) {
                        if (!namewritten) {
                            if (name.compareTo("") != 0) {
                                dosa.writeBytes("Name: " + name);
                                dosa.writeByte(10);
                                if (filewrite) {
                                    ((DataOutputStream)dosf).writeBytes("Name: " + name);
                                    ((DataOutputStream)dosf).writeByte(10);
                                }
                            }
                            namewritten = true;
                        }
                        dosa.writeBytes(mfe.attribute + ": " + mfe.getValueToWrite());
                        dosa.writeByte(10);
                        if (filewrite) {
                            ((DataOutputStream)dosf).writeBytes(mfe.attribute + ": " + mfe.getValueToWrite());
                            ((DataOutputStream)dosf).writeByte(10);
                        }
                    }
                    ++ii;
                }
                if (namewritten) {
                    dosa.writeBytes("");
                    dosa.writeByte(10);
                    if (filewrite) {
                        ((DataOutputStream)dosf).writeBytes("");
                        ((DataOutputStream)dosf).writeByte(10);
                    }
                }
                ++i2;
            }
            if (filewrite) {
                dosf.close();
                dosf = null;
                bos.close();
                bos = null;
            }
            dosa.close();
            dosa = null;
            bais = new ByteArrayInputStream(baos.toByteArray());
            baos.close();
            baos = null;
            Object var16_17 = null;
            try {
                if (dosf != null) {
                    dosf.close();
                }
            }
            catch (IOException e2) {
                // empty catch block
            }
            try {
                if (bos != null) {
                    bos.close();
                }
            }
            catch (IOException e2) {
                // empty catch block
            }
            try {
                if (dosa != null) {
                    dosa.close();
                }
            }
            catch (IOException e2) {
                // empty catch block
            }
            try {
                if (baos != null) {
                    baos.close();
                }
                break block53;
            }
            catch (IOException e2) {}
            break block53;
            {
                catch (Exception e) {
                    if (bais != null) {
                        try {
                            bais.close();
                        }
                        catch (IOException e1) {
                            // empty catch block
                        }
                    }
                    bais = null;
                    Object var16_18 = null;
                    try {
                        if (dosf != null) {
                            dosf.close();
                        }
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    try {
                        if (bos != null) {
                            bos.close();
                        }
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    try {
                        if (dosa != null) {
                            dosa.close();
                        }
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    try {
                        if (baos != null) {
                            baos.close();
                        }
                        break block53;
                    }
                    catch (IOException e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var16_19 = null;
                try {
                    if (dosf != null) {
                        dosf.close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                try {
                    if (bos != null) {
                        bos.close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                try {
                    if (dosa != null) {
                        dosa.close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                try {
                    if (baos != null) {
                        baos.close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return bais;
    }

    boolean readAllAttributes(ByteArrayInputStream bais) {
        return this.readAllAttributes(bais, null, null);
    }

    boolean readAllAttributes(String inputname) {
        return this.readAllAttributes(null, inputname, null);
    }

    boolean readAllAttributes(ByteArrayInputStream bais, Vector errorTexts) {
        return this.readAllAttributes(bais, null, errorTexts);
    }

    boolean readAllAttributes(String inputname, Vector errorTexts) {
        return this.readAllAttributes(null, inputname, errorTexts);
    }

    private boolean readAllAttributes(ByteArrayInputStream bais, String inputname) {
        return this.readAllAttributes(bais, inputname, null);
    }

    /*
     * Loose catch block
     */
    private boolean readAllAttributes(ByteArrayInputStream bais, String inputname, Vector errorTexts) {
        Manifest mf;
        block59: {
            BufferedInputStream bis;
            ZipInputStream jis;
            block57: {
                mf = null;
                this.removeAllElements();
                if (bais == null && inputname == null) {
                    return false;
                }
                jis = null;
                bis = null;
                if (bais != null) {
                    if (this.manifestname.compareTo("MANIFEST.MF") == 0) {
                        jis = new JarInputStream(bais);
                        mf = ((JarInputStream)jis).getManifest();
                        if (mf == null) {
                            JarEntry je;
                            while ((je = ((JarInputStream)jis).getNextJarEntry()) != null && je.getName().compareTo("META-INF/" + this.manifestname) != 0) {
                            }
                            if (je != null) {
                                mf = new Manifest(jis);
                                if (mf == null && null != errorTexts) {
                                    errorTexts.add("Could not create java.util.jar.Manifest from JarInputStream (created from ByteArrayInputStream). (debuginfo: manifestname=" + this.manifestname + ",JARSL_METAINF=" + "META-INF" + ")");
                                }
                            } else if (null != errorTexts) {
                                errorTexts.add("No entry \"META-INF/" + this.manifestname + "\" found." + " (debuginfo: manifestname=" + this.manifestname + ",JARSL_METAINF=" + "META-INF" + ")");
                            }
                        }
                        jis.close();
                        jis = null;
                    } else {
                        JarEntry je;
                        jis = new JarInputStream(bais);
                        while ((je = ((JarInputStream)jis).getNextJarEntry()) != null && je.getName().compareTo("META-INF/" + this.manifestname) != 0) {
                        }
                        if (je != null) {
                            mf = new Manifest(jis);
                            if (mf == null && null != errorTexts) {
                                errorTexts.add("Could not create java.util.jar.Manifest from JarInputStream (created from ByteArrayInputStream). (debuginfo: manifestname=" + this.manifestname + ",JARSL_METAINF=" + "META-INF" + ")");
                            }
                        } else if (null != errorTexts) {
                            errorTexts.add("No entry \"META-INF/" + this.manifestname + "\" found." + " (debuginfo: manifestname=" + this.manifestname + ",JARSL_METAINF=" + "META-INF" + ")");
                        }
                        jis.close();
                        jis = null;
                    }
                    break block57;
                }
                boolean archive = false;
                if (!archive) {
                    try {
                        jis = new JarInputStream(new BufferedInputStream(new FileInputStream(Conv.pathConv(inputname))));
                        if (((JarInputStream)jis).getManifest() != null || ((JarInputStream)jis).getNextJarEntry() != null) {
                            archive = true;
                        }
                        jis.close();
                        jis = null;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (archive) {
                    JarEntry je;
                    if (this.manifestname.compareTo("MANIFEST.MF") == 0) {
                        jis = new JarInputStream(new BufferedInputStream(new FileInputStream(Conv.pathConv(inputname))));
                        mf = ((JarInputStream)jis).getManifest();
                        if (mf == null) {
                            while ((je = ((JarInputStream)jis).getNextJarEntry()) != null && je.getName().compareTo("META-INF/" + this.manifestname) != 0) {
                            }
                            if (je != null) {
                                mf = new Manifest(jis);
                                if (mf == null && null != errorTexts) {
                                    errorTexts.add("Could not create java.util.jar.Manifest from file " + inputname + "." + " (debuginfo: manifestname=" + this.manifestname + ",JARSL_METAINF=" + "META-INF" + ")");
                                }
                            } else if (null != errorTexts) {
                                errorTexts.add("No entry \"META-INF/" + this.manifestname + "\" found in file " + inputname + "." + " (debuginfo: manifestname=" + this.manifestname + ",JARSL_METAINF=" + "META-INF" + ")");
                            }
                        }
                        jis.close();
                        jis = null;
                    } else {
                        jis = new JarInputStream(new BufferedInputStream(new FileInputStream(Conv.pathConv(inputname))));
                        while ((je = ((JarInputStream)jis).getNextJarEntry()) != null && je.getName().compareTo("META-INF/" + this.manifestname) != 0) {
                        }
                        if (je != null) {
                            mf = new Manifest(jis);
                            if (mf == null && null != errorTexts) {
                                errorTexts.add("Could not create java.util.jar.Manifest from file " + inputname + "." + " (debuginfo: manifestname=" + this.manifestname + ",JARSL_METAINF=" + "META-INF" + ")");
                            }
                        } else if (null != errorTexts) {
                            errorTexts.add("No entry \"META-INF/" + this.manifestname + "\" found in file " + inputname + "." + " (debuginfo: manifestname=" + this.manifestname + ",JARSL_METAINF=" + "META-INF" + ")");
                        }
                        jis.close();
                        jis = null;
                    }
                    break block57;
                }
                bis = new BufferedInputStream(new FileInputStream(Conv.pathConv(inputname + "/" + "META-INF" + "/" + this.manifestname)));
                mf = new Manifest(bis);
                if (mf == null && errorTexts != null) {
                    errorTexts.add("Could not create java.util.jar.Manifest from file \"" + inputname + "/" + "META-INF" + "/" + this.manifestname + "\"");
                }
                bis.close();
                bis = null;
            }
            Object var14_15 = null;
            try {
                if (jis != null) {
                    jis.close();
                }
            }
            catch (IOException e2) {
                // empty catch block
            }
            try {
                if (bis != null) {
                    bis.close();
                }
                break block59;
            }
            catch (IOException e2) {}
            break block59;
            {
                catch (Exception e) {
                    if (null != errorTexts) {
                        errorTexts.add(e.getMessage());
                    }
                    mf = null;
                    var14_15 = null;
                    try {
                        if (jis != null) {
                            jis.close();
                        }
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    try {
                        if (bis != null) {
                            bis.close();
                        }
                        break block59;
                    }
                    catch (IOException e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var14_16 = null;
                try {
                    if (jis != null) {
                        jis.close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                try {
                    if (bis != null) {
                        bis.close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        if (mf != null) {
            Attributes attr = mf.getMainAttributes();
            Object[] attributes = attr.keySet().toArray();
            int i = 0;
            while (i < attributes.length) {
                this.manifest.addElement(new ManifestEntry(attributes[i].toString(), attr.getValue(attributes[i].toString()), ""));
                ++i;
            }
            Map<String, Attributes> mp = mf.getEntries();
            Object[] entries = mp.keySet().toArray();
            int i2 = 0;
            while (i2 < entries.length) {
                attr = mf.getAttributes(entries[i2].toString());
                attributes = attr.keySet().toArray();
                int ii = 0;
                while (ii < attributes.length) {
                    this.manifest.addElement(new ManifestEntry(attributes[ii].toString(), attr.getValue(attributes[ii].toString()), Conv.pathConvJar(entries[i2].toString())));
                    ++ii;
                }
                ++i2;
            }
            return true;
        }
        return false;
    }

    String readAttribute(String entry, String attribute) {
        String returnvalue = null;
        entry = Conv.pathConvJar(entry);
        int i = 0;
        while (i < this.manifest.size() && returnvalue == null) {
            ManifestEntry mfe = (ManifestEntry)this.manifest.elementAt(i);
            if (mfe.attribute.compareTo(attribute) == 0 && mfe.name.compareTo(entry) == 0) {
                returnvalue = mfe.value;
            }
            ++i;
        }
        return returnvalue;
    }

    boolean writeAttribute(String entry, String attribute, String value) {
        boolean archiveentry = false;
        if (entry.endsWith("/")) {
            archiveentry = true;
        }
        return this.writeAttribute(entry, attribute, value, archiveentry);
    }

    boolean writeAttribute(String entry, String attribute, String value, boolean archiveentry) {
        boolean found = false;
        entry = Conv.pathConvJar(entry);
        int i = 0;
        while (i < this.manifest.size() && !found) {
            ManifestEntry mfe = (ManifestEntry)this.manifest.elementAt(i);
            if (mfe.attribute.compareTo(attribute) == 0 && mfe.name.compareTo(entry) == 0) {
                found = true;
                if (mfe.value.compareTo(value) != 0 || mfe.archiveentry != archiveentry) {
                    mfe.value = value;
                    mfe.archiveentry = archiveentry;
                }
            }
            ++i;
        }
        if (!found) {
            if (attribute.compareTo("Manifest-Version") == 0) {
                this.manifest.insertElementAt(new ManifestEntry(attribute, value, entry, archiveentry), 0);
            } else {
                this.manifest.addElement(new ManifestEntry(attribute, value, entry, archiveentry));
            }
        }
        return true;
    }

    boolean deleteAttribute(String entry, String attribute) {
        boolean found = false;
        entry = Conv.pathConvJar(entry);
        int i = 0;
        while (i < this.manifest.size() && !found) {
            ManifestEntry mfe = (ManifestEntry)this.manifest.elementAt(i);
            if (mfe.attribute.compareTo(attribute) == 0 && mfe.name.compareTo(entry) == 0) {
                found = true;
                this.manifest.removeElementAt(i);
            }
            ++i;
        }
        return found;
    }

    boolean addManifest(ManifestSL mf, String prefix) {
        boolean rc = true;
        int i = 0;
        while (i < mf.manifest.size()) {
            ManifestEntry mfe = (ManifestEntry)mf.manifest.elementAt(i);
            rc &= this.writeAttribute(prefix + mfe.name, mfe.attribute, mfe.value, true);
            ++i;
        }
        return rc;
    }

    String[] getEntryListOfGivenAttributeValuePair(String attribute, String value) {
        Vector<String> entry = new Vector<String>();
        String[] entrylist = this.getEntryListFromManifest(true);
        int i = 0;
        while (i < entrylist.length) {
            String rv = this.readAttribute(entrylist[i], attribute);
            if (rv != null && rv.compareTo(value) == 0) {
                entry.addElement(entrylist[i]);
            }
            ++i;
        }
        String[] list = new String[entry.size()];
        int i2 = 0;
        while (i2 < entry.size()) {
            list[i2] = (String)entry.elementAt(i2);
            ++i2;
        }
        return list;
    }

    String[] getEntryListFromManifest() {
        return this.getEntryListFromManifest(false);
    }

    String[] getEntryListFromManifest(boolean wholelist) {
        Vector<String> entry = new Vector<String>();
        int i = 0;
        while (i < this.manifest.size()) {
            boolean archive = false;
            if (((ManifestEntry)this.manifest.elementAt((int)i)).name.endsWith("/")) {
                archive = true;
            }
            if (!(!wholelist && archive || !wholelist && ((ManifestEntry)this.manifest.elementAt((int)i)).name.compareTo("") == 0 || entry.contains(((ManifestEntry)this.manifest.elementAt((int)i)).name))) {
                entry.addElement(((ManifestEntry)this.manifest.elementAt((int)i)).name);
            }
            ++i;
        }
        String[] list = new String[entry.size()];
        int i2 = 0;
        while (i2 < entry.size()) {
            list[i2] = (String)entry.elementAt(i2);
            ++i2;
        }
        return list;
    }

    String[] getArchiveEntryListFromManifest() {
        Vector<String> entry = new Vector<String>();
        int i = 0;
        while (i < this.manifest.size()) {
            boolean archive = false;
            if (((ManifestEntry)this.manifest.elementAt((int)i)).name.endsWith("/")) {
                archive = true;
            }
            if (archive && ((ManifestEntry)this.manifest.elementAt((int)i)).name.compareTo("") != 0 && !entry.contains(((ManifestEntry)this.manifest.elementAt((int)i)).name)) {
                entry.addElement(((ManifestEntry)this.manifest.elementAt((int)i)).name);
            }
            ++i;
        }
        String[] list = new String[entry.size()];
        int i2 = 0;
        while (i2 < entry.size()) {
            list[i2] = ((String)entry.elementAt(i2)).substring(0, ((String)entry.elementAt(i2)).length() - 1);
            ++i2;
        }
        return list;
    }

    static boolean isStandardAttribute(String attribute) {
        boolean rc = true;
        int i = 0;
        while (i < ConstantsIF.exattributes.length && rc) {
            if (ConstantsIF.exattributes[i].compareTo(attribute) == 0) {
                rc = false;
            }
            ++i;
        }
        return rc;
    }

    static boolean isBothAttribute(String attribute) {
        boolean rc = false;
        int i = 0;
        while (i < ConstantsIF.bothattributes.length && !rc) {
            if (ConstantsIF.bothattributes[i].compareTo(attribute) == 0) {
                rc = true;
            }
            ++i;
        }
        return rc;
    }

    /*
     * Loose catch block
     */
    public static void main(String[] args) {
        Manifest mf;
        block16: {
            System.out.println("Reading Manifest of \"" + args[0] + "\"...");
            mf = null;
            ZipInputStream jis = null;
            jis = new JarInputStream(new BufferedInputStream(new FileInputStream(Conv.pathConv(args[0]))));
            mf = ((JarInputStream)jis).getManifest();
            jis.close();
            jis = null;
            Object var5_3 = null;
            try {
                if (jis != null) {
                    jis.close();
                }
            }
            catch (IOException e2) {
                // empty catch block
            }
            System.out.println("...ready");
            {
                break block16;
                catch (Exception e) {
                    System.out.println("Caught Exception: " + e.getMessage());
                    Object var5_4 = null;
                    try {
                        if (jis != null) {
                            jis.close();
                        }
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    System.out.println("...ready");
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                try {
                    if (jis != null) {
                        jis.close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                System.out.println("...ready");
                throw throwable;
            }
        }
        if (null == mf) {
            System.out.println("No Manifest found.");
        } else {
            System.out.println("Found Manifest:");
            try {
                mf.write(System.out);
            }
            catch (IOException ioe) {
                System.out.println("Could not print out Manifest: " + ioe.getMessage());
            }
        }
    }
}

