/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.util.jarsl;

import com.sap.sdm.util.jarsl.ConstantsIF;
import com.sap.sdm.util.jarsl.Conv;
import com.sap.sdm.util.jarsl.FileLoc;
import com.sap.sdm.util.jarsl.FingerPrint;
import com.sap.sdm.util.jarsl.ManifestSL;
import com.sap.sdm.util.jarsl.VersionInfo;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.CRC32;
import java.util.zip.ZipInputStream;

public final class JarSL
implements ConstantsIF {
    public static String DEF_jarslversion = "20041217.1600";
    private Vector filelist;
    private String jarfilename;
    private String rootdir;
    private boolean changed;
    private boolean filelistread;
    private boolean manifestread;
    private ManifestSL manifestsd;
    private ManifestSL manifestex;
    private ObjectOutputStream oossf = null;
    private String oossffilename = null;
    private String oossfarchname = null;
    private ObjectInputStream oissf = null;

    public static void main(String[] arg) {
        if (arg.length == 0) {
            System.out.println("This is JarSL version " + DEF_jarslversion);
        } else if (arg.length == 1 && arg[0].toLowerCase().equals("versioninfos")) {
            System.out.println("This is JarSL version " + DEF_jarslversion);
            VersionInfo.writeVersionInformation(VersionInfo.JARSL, System.out);
        } else {
            System.out.println("JarSL without arguments        -> the current JarSL version is printed");
            System.out.println("JarSL versioninfos             -> a list a fixed bugs is pronted");
        }
    }

    public JarSL(String jarfilename, String rootdir) {
        this.jarfilename = Conv.pathConvJar(jarfilename);
        this.rootdir = Conv.pathConvJar(rootdir);
        this.filelist = new Vector();
        this.manifestsd = new ManifestSL("MANIFEST.MF");
        this.manifestex = new ManifestSL("SAP_MANIFEST.MF");
        this.changed = false;
        this.filelistread = false;
        this.manifestread = false;
    }

    public File getArchiveName() {
        return new File(this.jarfilename);
    }

    public String calcFingerprintFromArchive() {
        return new FingerPrint(Conv.pathConv(this.jarfilename)).calcMD5();
    }

    public String[] getEntryListOfGivenAttributeValuePair(String attribute, String value) {
        if (!this.manifestread) {
            this.manifestsd.readAllAttributes(this.jarfilename);
            this.manifestex.readAllAttributes(this.jarfilename);
            this.manifestread = true;
        }
        return this.manifestex.getEntryListOfGivenAttributeValuePair(attribute, value);
    }

    public String[] getFilelistFromManifest() {
        if (!this.manifestread) {
            this.manifestsd.readAllAttributes(this.jarfilename);
            this.manifestex.readAllAttributes(this.jarfilename);
            this.manifestread = true;
        }
        return this.manifestex.getEntryListFromManifest();
    }

    public String[] getArchiveEntriesFromManifest() {
        if (!this.manifestread) {
            this.manifestsd.readAllAttributes(this.jarfilename);
            this.manifestex.readAllAttributes(this.jarfilename);
            this.manifestread = true;
        }
        return this.manifestex.getArchiveEntryListFromManifest();
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    public ByteArrayInputStream extractSingleFileAsByteArray(String sfname) {
        ByteArrayInputStream bais;
        block26: {
            JarEntry je;
            byte[] buff = new byte[65536];
            ZipInputStream jis = null;
            ByteArrayOutputStream baos = null;
            bais = null;
            boolean rc = false;
            jis = new JarInputStream(new BufferedInputStream(new FileInputStream(Conv.pathConv(this.jarfilename))));
            while ((je = ((JarInputStream)jis).getNextJarEntry()) != null && !rc) {
                void var4_8;
                if (Conv.pathConvJar(var4_8.getName()).compareTo(Conv.pathConvJar(sfname)) != 0) continue;
                if (!Conv.pathConvJar(sfname).endsWith("/")) {
                    int len;
                    baos = new ByteArrayOutputStream();
                    while ((len = jis.read(buff)) >= 0) {
                        void var3_7;
                        baos.write(buff, 0, (int)var3_7);
                    }
                    bais = new ByteArrayInputStream(baos.toByteArray());
                    baos.close();
                    baos = null;
                }
                rc = true;
            }
            if (!rc && Conv.pathConvJar(sfname).compareTo("META-INF/MANIFEST.MF") == 0 && ((JarInputStream)jis).getManifest() != null) {
                baos = new ByteArrayOutputStream();
                ((JarInputStream)jis).getManifest().write(baos);
                bais = new ByteArrayInputStream(baos.toByteArray());
                baos.close();
                baos = null;
                rc = true;
            }
            jis.close();
            jis = null;
            Object var12_9 = null;
            try {
                if (baos != null) {
                    baos.close();
                }
            }
            catch (IOException e2) {
                // empty catch block
            }
            try {
                if (jis != null) {
                    jis.close();
                }
                break block26;
            }
            catch (IOException e2) {}
            break block26;
            {
                catch (Exception e) {
                    if (bais != null) {
                        try {
                            bais.close();
                        }
                        catch (IOException e1) {
                            // empty catch block
                        }
                        bais = null;
                    }
                    Object var12_10 = null;
                    try {
                        if (baos != null) {
                            baos.close();
                        }
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    try {
                        if (jis != null) {
                            jis.close();
                        }
                        break block26;
                    }
                    catch (IOException e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var12_11 = null;
                try {
                    if (baos != null) {
                        baos.close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                try {
                    if (jis != null) {
                        jis.close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return bais;
    }

    public boolean extractSingleFile(String sfname, Vector errorTexts) {
        String[] sfnames = new String[]{sfname};
        return this.extractSingleFiles(sfnames, null, errorTexts);
    }

    public boolean extractSingleFile(String sfname, String targetname, Vector errorTexts) {
        String[] sfnames = new String[1];
        String[] targetnames = new String[1];
        sfnames[0] = sfname;
        targetnames[0] = targetname;
        return this.extractSingleFiles(sfnames, targetnames, errorTexts);
    }

    public boolean extractSingleFiles(String[] sfnames, Vector errorTexts) {
        return this.extractSingleFiles(sfnames, null, errorTexts);
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    public boolean extractSingleFiles(String[] sfnames, String[] targetnames, Vector errorTexts) {
        boolean rc;
        block38: {
            String path;
            FileLoc name;
            JarEntry je;
            byte[] buff = new byte[65536];
            ZipInputStream jis = null;
            FilterOutputStream bos = null;
            rc = true;
            boolean finished = false;
            boolean[] extracted = new boolean[sfnames.length];
            int i = 0;
            while (i < sfnames.length) {
                extracted[i] = false;
                ++i;
            }
            if (targetnames != null && sfnames.length != targetnames.length) {
                if (null != errorTexts) {
                    errorTexts.add("Wrong call of method 'extractSingleFiles'.");
                }
                return false;
            }
            jis = new JarInputStream(new BufferedInputStream(new FileInputStream(Conv.pathConv(this.jarfilename))));
            while ((je = ((JarInputStream)jis).getNextJarEntry()) != null && !finished) {
                void var6_12;
                int place = -1;
                int i2 = 0;
                while (i2 < sfnames.length && place == -1) {
                    if (!extracted[i2] && Conv.pathConvJar(var6_12.getName()).compareTo(Conv.pathConvJar(sfnames[i2])) == 0) {
                        place = i2;
                        extracted[i2] = true;
                        finished = true;
                        int j = 0;
                        while (j < extracted.length) {
                            finished &= extracted[j];
                            ++j;
                        }
                    }
                    ++i2;
                }
                if (place == -1) continue;
                name = targetnames == null ? new FileLoc(this.rootdir, Conv.pathConvJar(var6_12.getName())) : new FileLoc("", Conv.pathConvJar(targetnames[place]));
                path = new File(Conv.pathConv(name.pathname())).getParent();
                if (path != null) {
                    new File(path).mkdirs();
                }
                if (!name.pathname().endsWith("/")) {
                    int len;
                    bos = new BufferedOutputStream(new FileOutputStream(Conv.pathConv(name.pathname())));
                    while ((len = jis.read(buff)) >= 0) {
                        void var5_11;
                        ((BufferedOutputStream)bos).write(buff, 0, (int)var5_11);
                    }
                    bos.close();
                    bos = null;
                } else {
                    new File(Conv.pathConv(name.pathname())).mkdirs();
                }
                new File(Conv.pathConv(name.pathname())).setLastModified(var6_12.getTime());
                if (targetnames != null) continue;
                this.addFile(name.base(), name.fname(), errorTexts);
            }
            if (!finished) {
                int i3 = 0;
                while (i3 < extracted.length) {
                    if (!extracted[i3]) {
                        if (Conv.pathConvJar(sfnames[i3]).compareTo("META-INF/MANIFEST.MF") == 0 && ((JarInputStream)jis).getManifest() != null) {
                            name = targetnames == null ? new FileLoc(this.rootdir, "META-INF/MANIFEST.MF") : new FileLoc("", Conv.pathConvJar(targetnames[i3]));
                            path = new File(Conv.pathConv(name.pathname())).getParent();
                            if (path != null) {
                                new File(path).mkdirs();
                            }
                            bos = new BufferedOutputStream(new FileOutputStream(Conv.pathConv(name.pathname())));
                            ((JarInputStream)jis).getManifest().write(bos);
                            bos.close();
                            bos = null;
                        } else {
                            rc = false;
                            if (null != errorTexts) {
                                errorTexts.add("Cannot find the file " + Conv.pathConvJar(sfnames[i3]) + " in the archive.");
                            }
                        }
                    }
                    ++i3;
                }
            }
            jis.close();
            jis = null;
            Object var19_19 = null;
            try {
                if (bos != null) {
                    bos.close();
                }
            }
            catch (IOException e2) {
                // empty catch block
            }
            try {
                if (jis != null) {
                    jis.close();
                }
                break block38;
            }
            catch (IOException e2) {}
            break block38;
            {
                catch (Exception e) {
                    if (null != errorTexts) {
                        errorTexts.add("Exception occured during extractSingleFile: " + e.getMessage());
                    }
                    rc = false;
                    Object var19_20 = null;
                    try {
                        if (bos != null) {
                            bos.close();
                        }
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    try {
                        if (jis != null) {
                            jis.close();
                        }
                        break block38;
                    }
                    catch (IOException e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var19_21 = null;
                try {
                    if (bos != null) {
                        bos.close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                try {
                    if (jis != null) {
                        jis.close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return rc;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean copyArchive(String targetname) {
        block28: {
            block24: {
                block27: {
                    block23: {
                        rc = false;
                        buff = new byte[65536];
                        bis = null;
                        bos = null;
                        try {
                            try {
                                bis = new BufferedInputStream(new FileInputStream(Conv.pathConv(this.jarfilename)));
                                name = new FileLoc("", Conv.pathConvJar(targetname));
                                if (name.pathname().toLowerCase().equals(this.jarfilename.toLowerCase())) {
                                    var9_8 = false;
                                    var11_9 = null;
                                    break block23;
                                }
                                path = new File(Conv.pathConv(name.pathname())).getParent();
                                if (path != null) {
                                    new File(path).mkdirs();
                                }
                                bos = new BufferedOutputStream(new FileOutputStream(Conv.pathConv(name.pathname())));
                                while (true) {
                                    if ((len = bis.read(buff)) < 0) {
                                        bos.close();
                                        bos = null;
                                        bis.close();
                                        bis = null;
                                        rc = true;
                                        break block24;
                                    }
                                    bos.write(buff, 0, (int)var5_18);
                                }
                            }
                            catch (Exception e) {
                                rc = false;
                                var11_11 = null;
                                try {
                                    if (bos != null) {
                                        bos.close();
                                    }
                                }
                                catch (IOException e) {
                                    // empty catch block
                                }
                                try {
                                    if (bis == null) return rc;
                                    bis.close();
                                    return rc;
                                }
                                catch (IOException e) {
                                    return rc;
                                }
                            }
                        }
                        catch (Throwable var10_19) {
                            block26: {
                                var11_12 = null;
                                ** try [egrp 2[TRYBLOCK] [2 : 211->224)] { 
lbl50:
                                // 1 sources

                                if (bos != null) {
                                    bos.close();
                                }
                                break block26;
lbl53:
                                // 1 sources

                                catch (IOException e) {
                                    // empty catch block
                                }
                            }
                            ** try [egrp 3[TRYBLOCK] [3 : 226->239)] { 
lbl57:
                            // 1 sources

                            if (bis == null) throw var10_19;
                            bis.close();
                            throw var10_19;
lbl60:
                            // 1 sources

                            catch (IOException e) {
                                // empty catch block
                            }
                            throw var10_19;
                        }
                    }
                    ** try [egrp 2[TRYBLOCK] [2 : 211->224)] { 
lbl65:
                    // 1 sources

                    if (bos != null) {
                        bos.close();
                    }
                    break block27;
lbl68:
                    // 1 sources

                    catch (IOException e) {
                        // empty catch block
                    }
                }
                ** try [egrp 3[TRYBLOCK] [3 : 226->239)] { 
lbl72:
                // 1 sources

                if (bis == null) return var9_8;
                bis.close();
                return var9_8;
lbl75:
                // 1 sources

                catch (IOException e) {
                    // empty catch block
                }
                return var9_8;
            }
            var11_10 = null;
            ** try [egrp 2[TRYBLOCK] [2 : 211->224)] { 
lbl81:
            // 1 sources

            if (bos != null) {
                bos.close();
            }
            break block28;
lbl84:
            // 1 sources

            catch (IOException e) {
                // empty catch block
            }
        }
        try {}
        catch (IOException e) {}
        if (bis == null) return rc;
        bis.close();
        return rc;
        return rc;
    }

    public boolean extract() {
        return this.extract(null);
    }

    public boolean extract(Vector errTexts) {
        return this.extract(errTexts, false);
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    public boolean extract(Vector errTexts, boolean deleterootdirectory) {
        boolean rc;
        block30: {
            JarEntry je;
            byte[] buff = new byte[65536];
            FileLoc name = null;
            ZipInputStream jis = null;
            FilterOutputStream bos = null;
            rc = true;
            this.filelist.removeAllElements();
            if (deleterootdirectory && this.rootdir != null && !this.rootdir.equals("") && !this.rootdir.equals(" ")) {
                this.deleteFile(new File(this.rootdir));
            }
            jis = new JarInputStream(new BufferedInputStream(new FileInputStream(Conv.pathConv(this.jarfilename))));
            while ((je = ((JarInputStream)jis).getNextJarEntry()) != null) {
                void var5_9;
                name = new FileLoc(this.rootdir, Conv.pathConvJar(var5_9.getName()));
                this.filelist.addElement(name);
                String path = new File(Conv.pathConv(name.pathname())).getParent();
                if (path != null) {
                    new File(path).mkdirs();
                }
                if (!name.pathname().endsWith("/")) {
                    int len;
                    bos = new BufferedOutputStream(new FileOutputStream(Conv.pathConv(name.pathname())));
                    while ((len = jis.read(buff)) >= 0) {
                        void var4_8;
                        ((BufferedOutputStream)bos).write(buff, 0, (int)var4_8);
                    }
                    bos.close();
                    bos = null;
                } else {
                    new File(Conv.pathConv(name.pathname())).mkdirs();
                }
                new File(Conv.pathConv(name.pathname())).setLastModified(var5_9.getTime());
            }
            if (((JarInputStream)jis).getManifest() != null) {
                new File(Conv.pathConv(this.rootdir + "/" + "META-INF")).mkdirs();
                bos = new BufferedOutputStream(new FileOutputStream(Conv.pathConv(this.rootdir + "/" + "META-INF/MANIFEST.MF")));
                ((JarInputStream)jis).getManifest().write(bos);
                bos.close();
                bos = null;
                if (!this.filelist.contains(new FileLoc(this.rootdir, "META-INF/MANIFEST.MF"))) {
                    this.filelist.addElement(new FileLoc(this.rootdir, "META-INF/MANIFEST.MF"));
                }
            }
            jis.close();
            jis = null;
            this.manifestsd.readAllAttributes(this.rootdir);
            this.manifestex.readAllAttributes(this.rootdir);
            this.filelistread = true;
            this.manifestread = true;
            Object var13_11 = null;
            try {
                if (bos != null) {
                    bos.close();
                }
            }
            catch (IOException e2) {
                // empty catch block
            }
            try {
                if (jis != null) {
                    jis.close();
                }
                break block30;
            }
            catch (IOException e2) {}
            break block30;
            {
                catch (Exception e) {
                    if (errTexts != null) {
                        if (name != null) {
                            errTexts.add("Error: Could not extract file " + name.fname() + " from archive " + this.jarfilename);
                        } else {
                            errTexts.add("Error: Could not extract all files from archive " + this.jarfilename);
                        }
                        errTexts.add("Additional error message is:");
                        errTexts.add(e.getMessage());
                    }
                    this.filelist.removeAllElements();
                    this.manifestsd.removeAllElements();
                    this.manifestex.removeAllElements();
                    this.filelistread = false;
                    this.manifestread = false;
                    this.changed = false;
                    rc = false;
                    Object var13_12 = null;
                    try {
                        if (bos != null) {
                            bos.close();
                        }
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    try {
                        if (jis != null) {
                            jis.close();
                        }
                        break block30;
                    }
                    catch (IOException e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var13_13 = null;
                try {
                    if (bos != null) {
                        bos.close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                try {
                    if (jis != null) {
                        jis.close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return rc;
    }

    public boolean addAllFiles() {
        this.filelist.removeAllElements();
        this.getFileList(this.rootdir);
        this.changed = true;
        this.manifestsd.readAllAttributes(this.rootdir);
        this.manifestex.readAllAttributes(this.rootdir);
        this.filelistread = true;
        this.manifestread = true;
        return true;
    }

    public boolean create(Vector errorTexts) {
        return this.create(true, true, true, errorTexts);
    }

    public boolean create(boolean compress, Vector errorTexts) {
        return this.create(compress, true, true, errorTexts);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean create(boolean compress, boolean writemftodisk, boolean writesapmanifest, Vector errorTexts) {
        block88: {
            block87: {
                block75: {
                    block86: {
                        block85: {
                            block78: {
                                block84: {
                                    block83: {
                                        rc = true;
                                        if (this.changed == false) return rc;
                                        buff = new byte[65536];
                                        if (!(!writemftodisk || this.manifestsd.createManifest(this.rootdir) && this.manifestex.createManifest(this.rootdir))) {
                                            if (errorTexts == null) return false;
                                            errorTexts.add("Could not write manifests to file system.");
                                            return false;
                                        }
                                        this.removeDir("/");
                                        this.removeDir("META-INF");
                                        this.removeFile("META-INF/SAP_MANIFEST.MF");
                                        this.addFile("META-INF/SAP_MANIFEST.MF", 0, null);
                                        this.addDir("META-INF", 0, errorTexts);
                                        if (!this.writeAttribute("", "JarSL-Version", JarSL.DEF_jarslversion)) {
                                            if (errorTexts == null) return false;
                                            errorTexts.add("Could not write attribute (,JarSL-Version," + JarSL.DEF_jarslversion + ")");
                                            return false;
                                        }
                                        this.writeAttribute("", "compress", compress != false ? "true" : "false");
                                        bais = null;
                                        jos = null;
                                        is = null;
                                        try {
                                            try {
                                                bais = this.manifestsd.createManifest();
                                                mf = null;
                                                try {
                                                    if (bais == null) throw new Exception("jump");
                                                    mf = new Manifest(bais);
                                                    if (mf == null) {
                                                        throw new Exception("jump");
                                                    }
                                                }
                                                catch (Exception e) {
                                                    if (errorTexts != null) {
                                                        errorTexts.add("Could not create Manifest from ByteArrayInputStream (1).");
                                                    }
                                                    var14_14 = false;
                                                    var23_16 = null;
                                                    try {
                                                        if (bais != null) {
                                                            bais.close();
                                                        }
                                                    }
                                                    catch (IOException e) {
                                                        // empty catch block
                                                    }
                                                    try {
                                                        if (is != null) {
                                                            is.close();
                                                        }
                                                    }
                                                    catch (IOException e) {
                                                        // empty catch block
                                                    }
                                                    try {
                                                        if (jos == null) return var14_14;
                                                        jos.close();
                                                        return var14_14;
                                                    }
                                                    catch (IOException e) {
                                                        // empty catch block
                                                    }
                                                    return var14_14;
                                                }
                                                bais.close();
                                                bais = null;
                                                path = new File(Conv.pathConv(this.jarfilename)).getParent();
                                                if (path != null) {
                                                    new File(path).mkdirs();
                                                }
                                                jos = new JarOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(Conv.pathConv(this.jarfilename))), mf);
                                                if (compress) {
                                                    jos.setMethod(8);
                                                } else {
                                                    jos.setMethod(0);
                                                }
                                                emptycrc = new CRC32().getValue();
                                                if (!writesapmanifest) {
                                                    this.removeFile("META-INF/SAP_MANIFEST.MF");
                                                }
                                                i = 0;
                                                while (true) {
                                                    if (i >= this.filelist.size()) {
                                                        jos.close();
                                                        jos = null;
                                                        this.addFile("META-INF/SAP_MANIFEST.MF", errorTexts);
                                                        this.changed = false;
                                                        break block75;
                                                    }
                                                    nextfile = (FileLoc)this.filelist.elementAt(i);
                                                    if (nextfile.fname().compareTo("META-INF/MANIFEST.MF") != 0) {
                                                        je = nextfile.archfilename() != null ? new JarEntry(nextfile.archfilename()) : new JarEntry(nextfile.fname());
                                                        if (nextfile.pathname().endsWith("/")) {
                                                            je.setSize(0L);
                                                            je.setMethod(0);
                                                            je.setCrc(emptycrc);
                                                            try {
                                                                fod = new File(Conv.pathConv(nextfile.pathname()));
                                                                if (fod.isDirectory()) {
                                                                    je.setTime(fod.lastModified());
                                                                }
                                                            }
                                                            catch (Exception e) {}
                                                        } else if (!compress) {
                                                            size = 0L;
                                                            crc = new CRC32();
                                                            if (writemftodisk || nextfile.fname().compareTo("META-INF/SAP_MANIFEST.MF") != 0) {
                                                                is = new BufferedInputStream(new FileInputStream(Conv.pathConv(nextfile.pathname())));
                                                            } else {
                                                                is = this.manifestex.createManifest();
                                                                if (is == null) {
                                                                    if (errorTexts != null) {
                                                                        errorTexts.add("Could not create Manifest from ByteArrayInputStream (2).");
                                                                    }
                                                                    var21_38 = false;
                                                                    var23_17 = null;
                                                                    break;
                                                                }
                                                            }
                                                            while (true) {
                                                                if ((len = is.read(buff)) <= 0) {
                                                                    is.close();
                                                                    is = null;
                                                                    je.setSize(size);
                                                                    je.setCrc(crc.getValue());
                                                                    break;
                                                                }
                                                                size += (long)var7_31;
                                                                crc.update(buff, 0, (int)var7_31);
                                                            }
                                                        }
                                                        if (writemftodisk || nextfile.fname().compareTo("META-INF/SAP_MANIFEST.MF") != 0) {
                                                            je.setTime(new File(Conv.pathConv(nextfile.pathname())).lastModified());
                                                        }
                                                        jos.putNextEntry(je);
                                                        if (!nextfile.pathname().endsWith("/")) {
                                                            if (writemftodisk || nextfile.fname().compareTo("META-INF/SAP_MANIFEST.MF") != 0) {
                                                                is = new BufferedInputStream(new FileInputStream(Conv.pathConv(nextfile.pathname())));
                                                            } else {
                                                                is = this.manifestex.createManifest();
                                                                if (is == null) {
                                                                    if (errorTexts != null) {
                                                                        errorTexts.add("Could not create Manifest from ByteArrayInputStream (3).");
                                                                    }
                                                                    size = false;
                                                                    break block78;
                                                                }
                                                            }
                                                            while (true) {
                                                                if ((len = is.read(buff)) < 0) {
                                                                    is.close();
                                                                    is = null;
                                                                    break;
                                                                }
                                                                jos.write(buff, 0, len);
                                                            }
                                                        }
                                                    }
                                                    if (nextfile.deleteIt()) {
                                                        file = new File(Conv.pathConv(nextfile.pathname()));
                                                        file.delete();
                                                    }
                                                    ++i;
                                                }
                                            }
                                            catch (Exception e) {
                                                block80: {
                                                    block79: {
                                                        if (errorTexts != null) {
                                                            errorTexts.add("(create): Caught and ignored exception: " + e.getMessage());
                                                        }
                                                        rc = false;
                                                        var23_20 = null;
                                                        ** try [egrp 4[TRYBLOCK] [4 : 973->986)] { 
lbl168:
                                                        // 1 sources

                                                        if (bais != null) {
                                                            bais.close();
                                                        }
                                                        break block79;
lbl171:
                                                        // 1 sources

                                                        catch (IOException e) {
                                                            // empty catch block
                                                        }
                                                    }
                                                    ** try [egrp 5[TRYBLOCK] [5 : 988->1001)] { 
lbl175:
                                                    // 1 sources

                                                    if (is != null) {
                                                        is.close();
                                                    }
                                                    break block80;
lbl178:
                                                    // 1 sources

                                                    catch (IOException e) {
                                                        // empty catch block
                                                    }
                                                }
                                                try {}
                                                catch (IOException e) {
                                                    return rc;
                                                }
                                                if (jos == null) return rc;
                                                jos.close();
                                                return rc;
                                            }
                                        }
                                        catch (Throwable var22_39) {
                                            block82: {
                                                block81: {
                                                    var23_21 = null;
                                                    ** try [egrp 4[TRYBLOCK] [4 : 973->986)] { 
lbl191:
                                                    // 1 sources

                                                    if (bais != null) {
                                                        bais.close();
                                                    }
                                                    break block81;
lbl194:
                                                    // 1 sources

                                                    catch (IOException e) {
                                                        // empty catch block
                                                    }
                                                }
                                                ** try [egrp 5[TRYBLOCK] [5 : 988->1001)] { 
lbl198:
                                                // 1 sources

                                                if (is != null) {
                                                    is.close();
                                                }
                                                break block82;
lbl201:
                                                // 1 sources

                                                catch (IOException e) {
                                                    // empty catch block
                                                }
                                            }
                                            ** try [egrp 6[TRYBLOCK] [6 : 1003->1016)] { 
lbl205:
                                            // 1 sources

                                            if (jos == null) throw var22_39;
                                            jos.close();
                                            throw var22_39;
lbl208:
                                            // 1 sources

                                            catch (IOException e) {
                                                // empty catch block
                                            }
                                            throw var22_39;
                                        }
                                        ** try [egrp 4[TRYBLOCK] [4 : 973->986)] { 
lbl213:
                                        // 1 sources

                                        if (bais != null) {
                                            bais.close();
                                        }
                                        break block83;
lbl216:
                                        // 1 sources

                                        catch (IOException e) {
                                            // empty catch block
                                        }
                                    }
                                    ** try [egrp 5[TRYBLOCK] [5 : 988->1001)] { 
lbl220:
                                    // 1 sources

                                    if (is != null) {
                                        is.close();
                                    }
                                    break block84;
lbl223:
                                    // 1 sources

                                    catch (IOException e) {
                                        // empty catch block
                                    }
                                }
                                ** try [egrp 6[TRYBLOCK] [6 : 1003->1016)] { 
lbl227:
                                // 1 sources

                                if (jos == null) return var21_38;
                                jos.close();
                                return var21_38;
lbl230:
                                // 1 sources

                                catch (IOException e) {
                                    // empty catch block
                                }
                                return var21_38;
                            }
                            var23_18 = null;
                            ** try [egrp 4[TRYBLOCK] [4 : 973->986)] { 
lbl236:
                            // 1 sources

                            if (bais != null) {
                                bais.close();
                            }
                            break block85;
lbl239:
                            // 1 sources

                            catch (IOException e) {
                                // empty catch block
                            }
                        }
                        ** try [egrp 5[TRYBLOCK] [5 : 988->1001)] { 
lbl243:
                        // 1 sources

                        if (is != null) {
                            is.close();
                        }
                        break block86;
lbl246:
                        // 1 sources

                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    ** try [egrp 6[TRYBLOCK] [6 : 1003->1016)] { 
lbl250:
                    // 1 sources

                    if (jos == null) return size;
                    jos.close();
                    return size;
lbl253:
                    // 1 sources

                    catch (IOException e) {
                        // empty catch block
                    }
                    return size;
                }
                var23_19 = null;
                ** try [egrp 4[TRYBLOCK] [4 : 973->986)] { 
lbl259:
                // 1 sources

                if (bais != null) {
                    bais.close();
                }
                break block87;
lbl262:
                // 1 sources

                catch (IOException e) {
                    // empty catch block
                }
            }
            ** try [egrp 5[TRYBLOCK] [5 : 988->1001)] { 
lbl266:
            // 1 sources

            if (is != null) {
                is.close();
            }
            break block88;
lbl269:
            // 1 sources

            catch (IOException e) {
                // empty catch block
            }
        }
        try {}
        catch (IOException e) {}
        if (jos == null) return rc;
        jos.close();
        return rc;
        return rc;
    }

    public boolean removeFile(String filename) {
        return this.removeFile(this.rootdir, filename);
    }

    public boolean removeFile(String lroot, String filename) {
        FileLoc fl = new FileLoc(Conv.pathConvJar(lroot), Conv.pathConvJar(filename));
        if (this.filelistread && this.filelist.contains(fl)) {
            FileLoc fl2 = (FileLoc)this.filelist.elementAt(this.filelist.indexOf(fl));
            if (fl2.deleteIt()) {
                new File(fl2.pathname()).delete();
            }
            this.filelist.removeElementAt(this.filelist.indexOf(fl));
            this.changed = true;
            return true;
        }
        return false;
    }

    public boolean removeDir(String dirname) {
        return this.removeDir(this.rootdir, dirname);
    }

    public boolean removeDir(String lroot, String dirname) {
        lroot = Conv.pathConvJar(lroot);
        if (!(dirname = Conv.pathConvJar(dirname)).endsWith("/")) {
            dirname = dirname + "/";
        }
        FileLoc fl = new FileLoc(lroot, dirname);
        if (this.filelistread && this.filelist.contains(fl)) {
            FileLoc fl2 = (FileLoc)this.filelist.elementAt(this.filelist.indexOf(fl));
            if (fl2.deleteIt()) {
                new File(fl2.pathname()).delete();
            }
            this.filelist.removeElementAt(this.filelist.indexOf(fl));
            this.changed = true;
            return true;
        }
        return false;
    }

    public boolean openSingleArchiveFile(String entryname, Vector errorTexts) {
        if (this.oissf == null) {
            if (!this.extractSingleFile(entryname, errorTexts)) {
                errorTexts.add("Error during extraction of " + entryname + " from the archive " + this.jarfilename);
                return false;
            }
            FileLoc name = new FileLoc(this.rootdir, Conv.pathConvJar(new File(entryname).getName()));
            try {
                this.oissf = new ObjectInputStream(new FileInputStream(Conv.pathConv(name.pathname())));
                return true;
            }
            catch (Exception e) {
                if (null != errorTexts) {
                    errorTexts.add("Error during extraction of " + entryname + ". Stream is corrupted");
                }
                if (this.oissf != null) {
                    try {
                        this.oissf.close();
                    }
                    catch (IOException e1) {
                        // empty catch block
                    }
                    this.oissf = null;
                }
                return false;
            }
        }
        if (null != errorTexts) {
            errorTexts.add("Error during extraction of " + entryname + ". Stream already open");
        }
        return false;
    }

    public boolean closeSingleArchiveFile(Vector errorTexts) {
        if (this.oissf == null) {
            if (null != errorTexts) {
                errorTexts.add("Error during closing the file. Stream is not open");
            }
            return false;
        }
        try {
            this.oissf.close();
            this.oissf = null;
            return true;
        }
        catch (Exception e) {
            if (null != errorTexts) {
                errorTexts.add("Error during closing the file. Cannot close it");
            }
            this.oissf = null;
            return false;
        }
    }

    public int getIntData() throws IOException {
        if (this.oissf == null) {
            throw new IOException();
        }
        return this.oissf.readInt();
    }

    public boolean getBooleanData() throws IOException {
        if (this.oissf == null) {
            throw new IOException();
        }
        return this.oissf.readBoolean();
    }

    public long getLongData() throws IOException {
        if (this.oissf == null) {
            throw new IOException();
        }
        return this.oissf.readLong();
    }

    public double getDoubleData() throws IOException {
        if (this.oissf == null) {
            throw new IOException();
        }
        return this.oissf.readDouble();
    }

    public float getFloatData() throws IOException {
        if (this.oissf == null) {
            throw new IOException();
        }
        return this.oissf.readFloat();
    }

    public short getShortData() throws IOException {
        if (this.oissf == null) {
            throw new IOException();
        }
        return this.oissf.readShort();
    }

    public char getCharData() throws IOException {
        if (this.oissf == null) {
            throw new IOException();
        }
        return this.oissf.readChar();
    }

    public byte getByteData() throws IOException {
        if (this.oissf == null) {
            throw new IOException();
        }
        return this.oissf.readByte();
    }

    public int getData(byte[] data, int off, int len) throws IOException {
        if (this.oissf == null) {
            throw new IOException();
        }
        int readbytes = 0;
        while (readbytes < len) {
            readbytes += this.oissf.read(data, readbytes + off, len - readbytes);
        }
        return readbytes;
    }

    public int getData(byte[] data) throws IOException {
        if (this.oissf == null) {
            throw new IOException();
        }
        return this.getData(data, 0, data.length);
    }

    public Object getObjectData() throws ClassNotFoundException, IOException {
        if (this.oissf == null) {
            throw new IOException();
        }
        return this.oissf.readObject();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean createFile(String filename, String archname, Vector errorTexts) {
        if (this.oossf == null) {
            this.oossffilename = filename;
            this.oossfarchname = archname;
            filename = Conv.pathConv(filename);
            try {
                if (new File(filename).getParentFile() != null) {
                    new File(filename).getParentFile().mkdirs();
                }
                new File(filename).delete();
                this.oossf = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(Conv.pathConv(filename))));
                return true;
            }
            catch (Exception e) {
                if (null != errorTexts) {
                    errorTexts.add("Error during creation of the file " + filename + ". Cannot create it.");
                }
                if (this.oossf == null) return false;
                try {
                    this.oossf.close();
                }
                catch (IOException e1) {
                    // empty catch block
                }
                this.oossf = null;
                return false;
            }
        }
        if (null == errorTexts) return false;
        errorTexts.add("Error during creation of the file " + filename + ". Stream already open");
        return false;
    }

    public boolean putIntData(int in) {
        if (this.oossf == null) {
            return false;
        }
        try {
            this.oossf.writeInt(in);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean putBooleanData(boolean in) {
        if (this.oossf == null) {
            return false;
        }
        try {
            this.oossf.writeBoolean(in);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean putLongData(long in) {
        if (this.oossf == null) {
            return false;
        }
        try {
            this.oossf.writeLong(in);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean putDoubleData(double in) {
        if (this.oossf == null) {
            return false;
        }
        try {
            this.oossf.writeDouble(in);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean putFloatData(float in) {
        if (this.oossf == null) {
            return false;
        }
        try {
            this.oossf.writeFloat(in);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean putShortData(short in) {
        if (this.oossf == null) {
            return false;
        }
        try {
            this.oossf.writeShort(in);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean putCharsData(String in) {
        if (this.oossf == null) {
            return false;
        }
        try {
            this.oossf.writeChars(in);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean putCharData(int in) {
        if (this.oossf == null) {
            return false;
        }
        try {
            this.oossf.writeChar(in);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean putByteData(int in) {
        if (this.oossf == null) {
            return false;
        }
        try {
            this.oossf.writeByte(in);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean putBytesData(String in) {
        if (this.oossf == null) {
            return false;
        }
        try {
            this.oossf.writeBytes(in);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean putData(byte[] data, int off, int len) {
        if (this.oossf == null) {
            return false;
        }
        try {
            this.oossf.write(data, off, len);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean putObjectData(Object in) {
        if (this.oossf == null) {
            return false;
        }
        try {
            this.oossf.writeObject(in);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean closeFile(boolean deleteit, Vector errorTexts) {
        if (this.oossf == null) {
            if (null != errorTexts) {
                errorTexts.add("Error during closing the file. Stream is not open");
            }
            return false;
        }
        try {
            this.oossf.close();
            this.oossf = null;
            return this.addFile("", this.oossffilename, this.oossfarchname, errorTexts, deleteit);
        }
        catch (Exception e) {
            if (null != errorTexts) {
                errorTexts.add("Error during closing the file. Cannot close it");
            }
            this.oossf = null;
            return false;
        }
    }

    public boolean addFile(String filename, int place, Vector errorTexts) {
        return this.addFile(this.rootdir, filename, null, place, errorTexts, false);
    }

    public boolean addFile(String filename, Vector errorTexts) {
        return this.addFile(this.rootdir, filename, null, errorTexts, false);
    }

    public boolean addFile(String filename, Vector errorTexts, boolean deleteit) {
        return this.addFile(this.rootdir, filename, null, errorTexts, deleteit);
    }

    public boolean addFile(String lroot, String filename, Vector errorTexts) {
        return this.addFile(lroot, filename, null, errorTexts, false);
    }

    public boolean addFile(String lroot, String filename, String archname, Vector errorTexts) {
        return this.addFile(lroot, filename, archname, errorTexts, false);
    }

    public boolean addFile(String lroot, String filename, String archname, Vector errorTexts, boolean deleteit) {
        return this.addFile(lroot, filename, archname, -1, errorTexts, deleteit);
    }

    public boolean addFile(String lroot, String filename, String archname, int place, Vector errorTexts, boolean deleteit) {
        FileLoc name = new FileLoc(Conv.pathConvJar(lroot), Conv.pathConvJar(filename), Conv.pathConvJar(archname), deleteit);
        if (!this.filelist.contains(name)) {
            if (place != -1) {
                this.filelist.insertElementAt(name, place);
            } else {
                this.filelist.addElement(name);
            }
        } else {
            if (null != errorTexts) {
                errorTexts.add("Error adding file to archive. File already exists: " + name.fname());
            }
            return false;
        }
        this.changed = true;
        this.filelistread = true;
        this.manifestread = true;
        File file = new File(Conv.pathConv(name.pathname()));
        if (!file.canRead()) {
            if (null != errorTexts) {
                errorTexts.add("Error adding file to archive. Can't read file: " + file.getAbsolutePath());
            }
            return false;
        }
        return true;
    }

    public boolean addDir(String dirname, int place, Vector errorTexts) {
        return this.addDir(this.rootdir, dirname, place, errorTexts);
    }

    public boolean addDir(String dirname, Vector errorTexts) {
        return this.addDir(this.rootdir, dirname, -1, errorTexts);
    }

    public boolean addDir(String lroot, String dirname, Vector errorTexts) {
        return this.addDir(lroot, dirname, -1, errorTexts);
    }

    public boolean addDir(String lroot, String dirname, int place, Vector errorTexts) {
        FileLoc dir;
        lroot = Conv.pathConvJar(lroot);
        if (!(dirname = Conv.pathConvJar(dirname)).endsWith("/")) {
            dirname = dirname + "/";
        }
        if (!this.filelist.contains(dir = new FileLoc(lroot, dirname))) {
            if (place != -1) {
                this.filelist.insertElementAt(dir, place);
            } else {
                this.filelist.addElement(dir);
            }
            this.changed = true;
            this.filelistread = true;
            this.manifestread = true;
            return true;
        }
        if (null != errorTexts) {
            errorTexts.add("Error adding directory to archive. Directory already exists: " + dir);
        }
        return false;
    }

    public String readAttribute(String entry, String attribute) {
        boolean found = false;
        if (!this.manifestread) {
            this.manifestsd.readAllAttributes(this.jarfilename);
            this.manifestex.readAllAttributes(this.jarfilename);
            this.manifestread = true;
        }
        if (entry.endsWith("/")) {
            found = true;
        }
        if (!found && ManifestSL.isBothAttribute(attribute)) {
            String value = null;
            value = this.manifestex.readAttribute(entry, attribute);
            if (value == null) {
                value = this.manifestsd.readAttribute(entry, attribute);
            }
            return value;
        }
        if (!found && ManifestSL.isStandardAttribute(attribute)) {
            return this.manifestsd.readAttribute(entry, attribute);
        }
        return this.manifestex.readAttribute(entry, attribute);
    }

    public boolean writeAttribute(String entry, String attribute, String value, boolean archiveentry) {
        boolean rv;
        boolean found = false;
        if (entry.endsWith("/")) {
            found = true;
        }
        if (rv = !found && ManifestSL.isStandardAttribute(attribute) ? this.manifestsd.writeAttribute(entry, attribute, value, archiveentry) : this.manifestex.writeAttribute(entry, attribute, value, archiveentry)) {
            this.filelistread = true;
            this.manifestread = true;
            this.changed = true;
        }
        return rv;
    }

    public boolean writeAttribute(String entry, String attribute, String value) {
        boolean rv;
        boolean found = false;
        if (entry.endsWith("/")) {
            found = true;
        }
        if (rv = !found && ManifestSL.isStandardAttribute(attribute) ? this.manifestsd.writeAttribute(entry, attribute, value) : this.manifestex.writeAttribute(entry, attribute, value)) {
            this.filelistread = true;
            this.manifestread = true;
            this.changed = true;
        }
        return rv;
    }

    public boolean deleteAttribute(String entry, String attribute) {
        boolean rv;
        boolean found = false;
        if (!this.filelistread) {
            return false;
        }
        if (entry.endsWith("/")) {
            found = true;
        }
        if (rv = !found && ManifestSL.isStandardAttribute(attribute) ? this.manifestsd.deleteAttribute(entry, attribute) : this.manifestex.deleteAttribute(entry, attribute)) {
            this.changed = true;
        }
        return rv;
    }

    public boolean createFingerPrintAttribute() {
        if (!this.filelistread) {
            return false;
        }
        int i = 0;
        while (i < this.filelist.size()) {
            FileLoc nextfile = (FileLoc)this.filelist.elementAt(i);
            if (!nextfile.pathname().endsWith("/")) {
                String fingerprint = new FingerPrint(Conv.pathConv(nextfile.pathname())).calcMD5();
                String entryname = nextfile.archfilename() != null ? nextfile.archfilename() : nextfile.fname();
                if (fingerprint == null || !this.writeAttribute(entryname, "sap_md5fingerprint", fingerprint)) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public boolean isCurrentArchiveUpToDate(long mintime) {
        boolean makenew = false;
        File oldjarsl = this.getArchiveName();
        long lastmodified = oldjarsl.lastModified();
        JarSL tmpjarsl = new JarSL(oldjarsl.getPath(), "");
        String[] content = tmpjarsl.getJarFileList();
        Vector<String> contentv = new Vector<String>();
        int jump = 0;
        if (content == null) {
            return false;
        }
        int i = 0;
        while (i < content.length) {
            if (!(content[i].equals("META-INF/") || content[i].equals("META-INF\\") || content[i].equals("META-INF/MANIFEST.MF") || content[i].equals("META-INF/SAP_MANIFEST.MF"))) {
                contentv.addElement(content[i]);
            }
            ++i;
        }
        if (lastmodified < mintime) {
            makenew = true;
        }
        int i2 = 0;
        while (i2 < this.filelist.size() && !makenew) {
            String name = ((FileLoc)this.filelist.elementAt(i2)).fname();
            if (((FileLoc)this.filelist.elementAt(i2)).archfilename() != null) {
                name = ((FileLoc)this.filelist.elementAt(i2)).archfilename();
            }
            if (name.equals("META-INF/") || name.equals("META-INF\\") || name.equals("META-INF/MANIFEST.MF") || name.equals("META-INF/SAP_MANIFEST.MF")) {
                ++jump;
            } else if (!contentv.contains(name)) {
                makenew = true;
            } else if (new File(((FileLoc)this.filelist.elementAt(i2)).pathname()).lastModified() > lastmodified) {
                makenew = true;
            }
            ++i2;
        }
        if (contentv.size() != this.filelist.size() - jump) {
            makenew = true;
        }
        return !makenew;
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    public String[] getJarFileList() {
        String[] files;
        block17: {
            Vector<FileLoc> filesv;
            block15: {
                JarEntry je;
                block16: {
                    files = null;
                    if (!this.filelistread) break block16;
                    files = new String[this.filelist.size()];
                    int i = 0;
                    while (i < this.filelist.size()) {
                        files[i] = new String(((FileLoc)this.filelist.elementAt(i)).fname());
                        ++i;
                    }
                    break block17;
                }
                filesv = new Vector<FileLoc>();
                ZipInputStream jis = null;
                jis = new JarInputStream(new BufferedInputStream(new FileInputStream(Conv.pathConv(this.jarfilename))));
                while ((je = ((JarInputStream)jis).getNextJarEntry()) != null) {
                    void var4_5;
                    FileLoc name = new FileLoc(this.rootdir, var4_5.getName());
                    filesv.addElement(name);
                }
                if (((JarInputStream)jis).getManifest() != null && !filesv.contains(new FileLoc(this.rootdir, "META-INF/MANIFEST.MF"))) {
                    filesv.addElement(new FileLoc(this.rootdir, "META-INF/MANIFEST.MF"));
                }
                jis.close();
                jis = null;
                Object var8_7 = null;
                try {
                    if (jis != null) {
                        jis.close();
                    }
                    break block15;
                }
                catch (IOException e2) {}
                break block15;
                {
                    catch (Exception e) {
                        filesv.removeAllElements();
                        var8_7 = null;
                        try {
                            if (jis != null) {
                                jis.close();
                            }
                            break block15;
                        }
                        catch (IOException e2) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    try {
                        if (jis != null) {
                            jis.close();
                        }
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            if (filesv.size() <= 0) break block17;
            files = new String[filesv.size()];
            int i = 0;
            while (i < filesv.size()) {
                files[i] = new String(((FileLoc)filesv.elementAt(i)).fname());
                ++i;
            }
        }
        return files;
    }

    private void getFileList(String files) {
        this.getFileList(files, files);
    }

    private void getFileList(String files, String basedir) {
        File df = new File(Conv.pathConv(files));
        if (files.endsWith("/")) {
            files = files.substring(0, files.length() - 1);
        }
        if (basedir.endsWith("/")) {
            basedir = basedir.substring(0, basedir.length() - 1);
        }
        if (df.isDirectory()) {
            if (files.compareTo(basedir) != 0) {
                this.filelist.add(new FileLoc(basedir, files.substring(basedir.length() + 1) + "/"));
            }
            String[] dflist = df.list();
            int i = 0;
            while (dflist != null && i < dflist.length) {
                dflist[i] = df.getPath().endsWith(File.separator) ? Conv.pathConvJar(df.getPath() + dflist[i]) : Conv.pathConvJar(df.getPath() + File.separator + dflist[i]);
                if (new File(Conv.pathConv(dflist[i])).isDirectory()) {
                    this.getFileList(dflist[i], basedir);
                } else {
                    this.filelist.add(new FileLoc(basedir, dflist[i].substring(basedir.length() + 1)));
                }
                ++i;
            }
        } else if (df.canRead()) {
            this.filelist.add(new FileLoc(basedir, files.substring(basedir.length() + 1)));
        }
    }

    private void deleteFile(File file) {
        if (file != null && file.exists()) {
            File[] subFiles;
            if (file.isDirectory() && null != (subFiles = file.listFiles())) {
                try {
                    int i = 0;
                    while (true) {
                        this.deleteFile(subFiles[i]);
                        ++i;
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
            file.delete();
        }
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    public static boolean writeFileFromInputStream(InputStream in, String filename, Vector errorTexts) {
        boolean rc;
        block21: {
            int len;
            FilterOutputStream buffout = null;
            rc = true;
            filename = Conv.pathConv(filename);
            if (new File(filename).getParentFile() != null) {
                new File(filename).getParentFile().mkdirs();
            }
            new File(filename).delete();
            buffout = new BufferedOutputStream(new FileOutputStream(filename));
            byte[] buff = new byte[65536];
            while ((len = in.read(buff)) >= 0) {
                void var5_6;
                ((BufferedOutputStream)buffout).write(buff, 0, (int)var5_6);
            }
            buffout.close();
            buffout = null;
            Object var8_8 = null;
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e2) {
                // empty catch block
            }
            try {
                if (buffout != null) {
                    buffout.close();
                }
                break block21;
            }
            catch (IOException e2) {}
            break block21;
            {
                catch (Exception e) {
                    errorTexts.add("Error creating file " + filename + " from InputStream: " + e.getMessage());
                    rc = false;
                    Object var8_9 = null;
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    try {
                        if (buffout != null) {
                            buffout.close();
                        }
                        break block21;
                    }
                    catch (IOException e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                try {
                    if (buffout != null) {
                        buffout.close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return rc;
    }

    public static OutputStream writeFile(String filename, Vector errorTexts) {
        FileOutputStream os = null;
        try {
            filename = Conv.pathConv(filename);
            if (new File(filename).getParentFile() != null) {
                new File(filename).getParentFile().mkdirs();
            }
            new File(filename).delete();
            os = new FileOutputStream(filename);
        }
        catch (Exception e) {
            errorTexts.add("Error creating file " + filename + ": " + e.getMessage());
            try {
                if (os != null) {
                    ((OutputStream)os).close();
                }
            }
            catch (Exception e1) {
                // empty catch block
            }
            os = null;
        }
        return os;
    }

    public static InputStream readFileAsInputStream(String filename, Vector errorTexts) {
        try {
            return new FileInputStream(Conv.pathConv(filename));
        }
        catch (Exception e) {
            errorTexts.add("Error reading file " + filename + ": " + e.getMessage());
            return null;
        }
    }

    public static long getFileLength(String filename, Vector errorTexts) {
        try {
            return new File(Conv.pathConv(filename)).length();
        }
        catch (Exception e) {
            errorTexts.add("Cannot get file-length from file " + filename + ": " + e.getMessage());
            return -1L;
        }
    }

    public static void createDirectory(String directory) {
        new File(Conv.pathConv(directory)).mkdirs();
    }

    public static boolean checkFileExistence(String filename) {
        return new File(Conv.pathConv(filename)).exists();
    }

    public static void deleteFileOrDirectory(String filedirname) {
        JarSL jarsl = new JarSL("", "");
        jarsl.deleteFile(new File(filedirname));
    }

    /*
     * Loose catch block
     */
    public static String[] getArchivesFromDirectory(String directory) {
        Vector<String> temp = new Vector<String>();
        File df = new File(Conv.pathConv(directory));
        if (!df.isDirectory()) {
            return null;
        }
        String[] dflist = df.list();
        int i = 0;
        while (i < dflist.length) {
            block18: {
                boolean isarchive;
                block17: {
                    dflist[i] = Conv.pathConvJar(df.getPath() + File.separator + dflist[i]);
                    if (new File(Conv.pathConv(dflist[i])).isDirectory()) break block18;
                    isarchive = false;
                    ZipInputStream jis = null;
                    jis = new JarInputStream(new BufferedInputStream(new FileInputStream(Conv.pathConv(dflist[i]))));
                    if (((JarInputStream)jis).getManifest() != null || ((JarInputStream)jis).getNextJarEntry() != null) {
                        isarchive = true;
                    }
                    jis.close();
                    jis = null;
                    Object var9_10 = null;
                    try {
                        if (jis != null) {
                            jis.close();
                        }
                        break block17;
                    }
                    catch (IOException e2) {}
                    break block17;
                    {
                        catch (Exception e) {
                            var9_10 = null;
                            try {
                                if (jis != null) {
                                    jis.close();
                                }
                                break block17;
                            }
                            catch (IOException e2) {}
                        }
                    }
                    catch (Throwable throwable) {
                        var9_10 = null;
                        try {
                            if (jis != null) {
                                jis.close();
                            }
                        }
                        catch (IOException e2) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
                if (isarchive) {
                    temp.addElement(dflist[i]);
                }
            }
            ++i;
        }
        if (temp.size() > 0) {
            String[] result = new String[temp.size()];
            int i2 = 0;
            while (i2 < temp.size()) {
                result[i2] = (String)temp.elementAt(i2);
                ++i2;
            }
            return result;
        }
        return null;
    }
}

