/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.util.events;

import com.sap.sdm.util.events.AbstractEvent;
import com.sap.sdm.util.events.EventExtendedObservable;
import com.sap.sdm.util.events.EventObserverIF;
import java.util.Observable;
import java.util.Observer;

final class ObserverWrapper
implements Observer {
    private EventObserverIF myObserver = null;

    private ObserverWrapper() {
    }

    ObserverWrapper(EventObserverIF observer) {
        if (observer == null) {
            throw new NullPointerException("Cannot create observer wrapper. Observer is null.");
        }
        this.myObserver = observer;
    }

    public void update(Observable o, Object arg) {
        if (!(o instanceof EventExtendedObservable)) {
            throw new IllegalArgumentException("Internal error: Observable is not an instance of EventExtendedObservable.");
        }
        AbstractEvent event = ((EventExtendedObservable)o).getEvent();
        this.myObserver.notifyEvent(event);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ObserverWrapper)) {
            return false;
        }
        ObserverWrapper other = (ObserverWrapper)obj;
        return this.myObserver.equals(other.myObserver);
    }

    public int hashCode() {
        return this.myObserver.hashCode();
    }
}

