/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.util.dbaccess;

import com.sap.sdm.util.dbaccess.NameValuePair;
import java.util.ArrayList;

public class TableEntry {
    private String id;
    private String name;
    private ArrayList fields = new ArrayList();

    public TableEntry(String id, String name) {
        this.id = id;
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    public String getTableName() {
        return this.name;
    }

    public String getTableNameQuoted() {
        return "\"" + this.name.toUpperCase() + "\"";
    }

    public int getFieldCount() {
        return this.fields.size();
    }

    public void addField(NameValuePair pair) {
        this.fields.add(pair);
    }

    public void setValue(NameValuePair pair) {
        int i = 0;
        while (i < this.fields.size()) {
            if (((NameValuePair)this.fields.get(i)).getName().equals(pair.getName())) {
                this.fields.set(i, pair);
            }
            ++i;
        }
    }

    public String getFieldName(int index) throws IndexOutOfBoundsException {
        return ((NameValuePair)this.fields.get(index)).getName();
    }

    public String getFieldNameQuoted(int index) throws IndexOutOfBoundsException {
        return "\"" + this.getFieldName(index).toUpperCase() + "\"";
    }

    public String getFieldValue(int index) throws IndexOutOfBoundsException {
        return ((NameValuePair)this.fields.get(index)).getValue();
    }

    public String getValueQuoted(int index) throws IndexOutOfBoundsException {
        return "'" + this.getFieldValue(index) + "'";
    }
}

