/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.util.dbaccess;

import com.sap.sdm.util.dbaccess.ArrayHandler;
import com.sap.sdm.util.dbaccess.BigIntHandler;
import com.sap.sdm.util.dbaccess.BigIntHandlerNumeric;
import com.sap.sdm.util.dbaccess.BinaryHandler;
import com.sap.sdm.util.dbaccess.BitHandler;
import com.sap.sdm.util.dbaccess.BlobHandler;
import com.sap.sdm.util.dbaccess.CharHandler;
import com.sap.sdm.util.dbaccess.ClobHandler;
import com.sap.sdm.util.dbaccess.DBTaskLogger;
import com.sap.sdm.util.dbaccess.DateHandler;
import com.sap.sdm.util.dbaccess.DecimalHandler;
import com.sap.sdm.util.dbaccess.DecimalHandlerBigInt;
import com.sap.sdm.util.dbaccess.DecimalHandlerDouble;
import com.sap.sdm.util.dbaccess.DecimalHandlerFloat;
import com.sap.sdm.util.dbaccess.DecimalHandlerInteger;
import com.sap.sdm.util.dbaccess.DecimalHandlerSmallInt;
import com.sap.sdm.util.dbaccess.DoubleHandler;
import com.sap.sdm.util.dbaccess.FieldHandler;
import com.sap.sdm.util.dbaccess.FloatHandler;
import com.sap.sdm.util.dbaccess.IntegerHandler;
import com.sap.sdm.util.dbaccess.IntegerHandlerNumeric;
import com.sap.sdm.util.dbaccess.JavaObjectHandler;
import com.sap.sdm.util.dbaccess.LongvarbinaryHandler;
import com.sap.sdm.util.dbaccess.LongvarcharHandler;
import com.sap.sdm.util.dbaccess.NameValuePair;
import com.sap.sdm.util.dbaccess.NullHandler;
import com.sap.sdm.util.dbaccess.NumericHandler;
import com.sap.sdm.util.dbaccess.NumericHandlerBigInt;
import com.sap.sdm.util.dbaccess.NumericHandlerDouble;
import com.sap.sdm.util.dbaccess.NumericHandlerFloat;
import com.sap.sdm.util.dbaccess.NumericHandlerInteger;
import com.sap.sdm.util.dbaccess.NumericHandlerSmallInt;
import com.sap.sdm.util.dbaccess.RealHandler;
import com.sap.sdm.util.dbaccess.Selection;
import com.sap.sdm.util.dbaccess.SmallIntHandler;
import com.sap.sdm.util.dbaccess.SmallIntHandlerNumeric;
import com.sap.sdm.util.dbaccess.StructHandler;
import com.sap.sdm.util.dbaccess.TableDescription;
import com.sap.sdm.util.dbaccess.TableDescriptionFactory;
import com.sap.sdm.util.dbaccess.TableEntry;
import com.sap.sdm.util.dbaccess.TimeHandler;
import com.sap.sdm.util.dbaccess.TimestampHandler;
import com.sap.sdm.util.dbaccess.TinyIntHandler;
import com.sap.sdm.util.dbaccess.VarbinaryHandler;
import com.sap.sdm.util.dbaccess.VarcharHandler;
import com.sap.sdm.util.jarsl.JarSL;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

public class TableAccess {
    private PreparedStatement stmt = null;
    private Connection con = null;
    private DBTaskLogger logging = null;
    private FieldHandler[] FieldList;
    private int commitCount = 1;
    private boolean testmode = false;
    private boolean allow_update = true;
    private int duplicate_cnt = 0;

    public TableAccess(Connection con, DBTaskLogger logging) {
        this.con = con;
        this.logging = logging;
    }

    public TableAccess(Connection con) {
        this(con, null);
    }

    public TableAccess() {
        this(null, null);
    }

    public void setCommitCount(int commitCount) {
        this.commitCount = 1;
    }

    public void setTestmode(boolean testmode) {
        this.testmode = testmode;
    }

    public void setUpdateMode(boolean allow_update) {
        this.allow_update = allow_update;
    }

    public int getDupCount() {
        return this.duplicate_cnt;
    }

    private void buildSelectStatement(Selection selection) throws SQLException {
        StringBuffer stmtText = new StringBuffer(256);
        stmtText.append("SELECT ");
        if (selection.getFieldCount() == 0) {
            stmtText.append(" * FROM ");
        } else {
            int i = 0;
            while (i < selection.getFieldCount() - 1) {
                stmtText.append(selection.getFieldName(i)).append(" ,  ");
                ++i;
            }
            stmtText.append(selection.getFieldName(selection.getFieldCount() - 1)).append(" FROM ").append(selection.getTableNameQuoted());
            String where = selection.getWhereCond();
        }
        stmtText.append(selection.getTableNameQuoted());
        if (selection.getWhereCond() != null) {
            stmtText.append(" WHERE ").append(selection.getWhereCond());
        }
        this.stmt = this.con.prepareStatement(stmtText.toString());
    }

    private void buildInsertStatement(String tablename) throws SQLException {
        StringBuffer stmtText = new StringBuffer(1000);
        stmtText.append("INSERT INTO ").append(tablename).append("( ");
        TableDescription tabledescription = TableDescriptionFactory.getInstance().getTableDescription(this.con, tablename);
        int i = 0;
        while (i < tabledescription.getFieldCount() - 1) {
            stmtText.append(tabledescription.getFieldDescription(i).getNameQuoted()).append(" ,  ");
            ++i;
        }
        stmtText.append(tabledescription.getFieldDescription(i).getNameQuoted()).append(" ) VALUES (");
        i = 0;
        while (i < tabledescription.getFieldCount() - 1) {
            stmtText.append(" ? ,");
            ++i;
        }
        stmtText.append(" ? )");
        this.stmt = this.con.prepareStatement(stmtText.toString());
    }

    private void buildDeleteStatement(Selection selection) throws SQLException {
        StringBuffer stmtText = new StringBuffer(1000);
        stmtText.append("DELETE FROM ").append(selection.getTableNameQuoted());
        String where = selection.getWhereCond();
        if (where != null) {
            stmtText.append(" WHERE ").append(where);
        }
        this.stmt = this.con.prepareStatement(stmtText.toString());
    }

    private void buildDeleteStatement(TableEntry tableentry) throws SQLException {
        TableDescription tabledescription = TableDescriptionFactory.getInstance().getTableDescription(this.con, tableentry.getTableNameQuoted());
        if (tabledescription != null) {
            String and = " WHERE ";
            StringBuffer stmtText = new StringBuffer(1000);
            stmtText.append("DELETE FROM ").append(tableentry.getTableNameQuoted());
            int i = 0;
            while (i < tableentry.getFieldCount()) {
                int fieldindex = tabledescription.getFieldIndex(tableentry.getFieldName(i));
                if (fieldindex >= 0) {
                    stmtText.append(and).append(tableentry.getFieldNameQuoted(i)).append(" = ? ");
                    and = " AND ";
                }
                ++i;
            }
            this.stmt = this.con.prepareStatement(stmtText.toString());
        }
    }

    public int t_export(Selection selection, JarSL jarsl, String archivedirname) throws IOException, SQLException {
        int entry_cnt = 0;
        this.buildSelectStatement(selection);
        ResultSet rs = this.stmt.executeQuery();
        ResultSetMetaData rsmd = rs.getMetaData();
        int numberOfColumns = rsmd.getColumnCount();
        String tabdescstring = selection.getTableName() + " " + numberOfColumns;
        selection.resetFields();
        int i = 1;
        while (i <= numberOfColumns) {
            int jdbcType = rsmd.getColumnType(i);
            String name = rsmd.getColumnName(i);
            tabdescstring = tabdescstring.concat(" " + name + " " + jdbcType);
            selection.addField(name, jdbcType);
            ++i;
        }
        if (!jarsl.createFile(archivedirname + File.separator + selection.getJarEntryName(false), selection.getJarEntryName(false), null)) {
            throw new IOException("Error during the creation of " + selection.getJarEntryName(false) + " in " + archivedirname + ".");
        }
        jarsl.putIntData(tabdescstring.getBytes().length);
        jarsl.putData(tabdescstring.getBytes(), 0, tabdescstring.getBytes().length);
        if (!jarsl.closeFile(true, null)) {
            throw new IOException("Error during the finalization of " + selection.getJarEntryName(false) + ".");
        }
        if (!jarsl.createFile(archivedirname + File.separator + selection.getJarEntryName(true), selection.getJarEntryName(true), null)) {
            throw new IOException("Error during the creation of " + selection.getJarEntryName(true) + " in " + archivedirname + ".");
        }
        this.setFieldHandler(selection);
        while (rs.next()) {
            int i2 = 0;
            while (i2 < numberOfColumns) {
                this.FieldList[i2].writeValue(rs, i2 + 1, jarsl);
                ++i2;
            }
            ++entry_cnt;
        }
        if (!jarsl.closeFile(true, null)) {
            throw new IOException("Error during the finalization of " + selection.getJarEntryName(true) + ".");
        }
        return entry_cnt;
    }

    public int t_import(Selection selection, JarSL jarsl) throws IOException, SQLException {
        Vector errortexts = new Vector(0);
        if (!jarsl.openSingleArchiveFile(selection.getJarEntryName(false), errortexts)) {
            throw new IOException("Error during reading table description " + selection.getJarEntryName(false) + ": " + this.concatenate_texts(errortexts) + ".");
        }
        int ll = jarsl.getIntData();
        byte[] line = new byte[ll];
        jarsl.getData(line, 0, ll);
        StringTokenizer st = new StringTokenizer(new String(line));
        if (0 != st.nextToken().compareTo(selection.getTableName())) {
            throw new IOException();
        }
        int fieldcount = new Integer(st.nextToken());
        int i = 0;
        while (i < fieldcount) {
            selection.addField(st.nextToken(), new Integer(st.nextToken()));
            ++i;
        }
        jarsl.closeSingleArchiveFile(null);
        if (!jarsl.openSingleArchiveFile(selection.getJarEntryName(true), errortexts)) {
            throw new IOException("Error during reading table data " + selection.getJarEntryName(true) + ": " + this.concatenate_texts(errortexts) + ".");
        }
        this.buildInsertStatement(selection.getTableNameQuoted());
        if (this.setFieldHandler(selection)) {
            this.commitCount = 1;
        }
        int insertCount = 0;
        int entry_cnt = 0;
        boolean skip_this_entry = false;
        try {
            while (true) {
                skip_this_entry = false;
                TableDescription tabledescription = TableDescriptionFactory.getInstance().getTableDescription(this.con, selection.getTableNameQuoted());
                i = 0;
                while (i < selection.getFieldCount()) {
                    int fieldindex = tabledescription.getFieldIndex(selection.getFieldName(i));
                    if (fieldindex < 0) {
                        throw new SQLException("field " + selection.getTableName() + "." + selection.getFieldName(i) + " doesn't exist in DB, but SAPtrans is not able to handle that");
                    }
                    try {
                        this.FieldList[fieldindex].setValue(this.stmt, fieldindex + 1, jarsl);
                    }
                    catch (EOFException e) {
                        throw e;
                    }
                    catch (SQLException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        this.FieldList[fieldindex].initialize(this.stmt, fieldindex + 1);
                        if (this.logging != null) {
                            this.logging.message(e);
                            this.logging.message("can't set value for " + tabledescription.getName() + "." + this.FieldList[fieldindex].name);
                        }
                        skip_this_entry = true;
                    }
                    ++i;
                }
                i = 0;
                while (i < tabledescription.getFieldCount()) {
                    if (this.FieldList[i].getClass().getName().equalsIgnoreCase("com.sap.sdm.util.dbaccess.NullHandler")) {
                        this.FieldList[i].setValue(this.stmt, i + 1, "");
                    }
                    ++i;
                }
                if (this.commitCount != 1) {
                    this.stmt.addBatch();
                }
                if (++insertCount % this.commitCount != 0) continue;
                entry_cnt += this.executeBatchInserts(selection.getTableName(), insertCount, this.commitCount != 1);
                insertCount = 0;
            }
        }
        catch (EOFException e) {
            if (insertCount != 0) {
                entry_cnt += this.executeBatchInserts(selection.getTableName(), insertCount, this.commitCount != 1);
            }
            if (i != 0) {
                this.logging.message("error: unexpected EOFException " + e.getMessage() + " at field " + selection.getFieldName(i));
            }
            jarsl.closeSingleArchiveFile(null);
            this.stmt.close();
            return entry_cnt;
        }
    }

    public int t_delete(Selection selection) throws SQLException {
        this.buildDeleteStatement(selection);
        int retval = this.stmt.executeUpdate();
        this.stmt.close();
        return retval;
    }

    public int t_create(TableEntry tableentry) throws SQLException {
        this.buildInsertStatement(tableentry.getTableNameQuoted());
        this.setFieldHandler(tableentry);
        int insertCount = 0;
        int entry_cnt = 0;
        try {
            TableDescription tabledescription = TableDescriptionFactory.getInstance().getTableDescription(this.con, tableentry.getTableNameQuoted());
            int i = 0;
            while (i < tabledescription.getFieldCount()) {
                try {
                    this.FieldList[i].initialize(this.stmt, i + 1);
                }
                catch (SQLException e) {
                    // empty catch block
                }
                ++i;
            }
            i = 0;
            while (i < tableentry.getFieldCount()) {
                int fieldindex = tabledescription.getFieldIndex(tableentry.getFieldName(i));
                if (fieldindex >= 0) {
                    String newvalue = tableentry.getFieldValue(i);
                    if (tabledescription.getFieldDescription(fieldindex).getType() == 12 && newvalue.length() > tabledescription.getFieldDescription(fieldindex).getLength()) {
                        newvalue = newvalue.substring(0, tabledescription.getFieldDescription(fieldindex).getLength());
                    }
                    this.FieldList[fieldindex].setValue(this.stmt, fieldindex + 1, newvalue);
                }
                ++i;
            }
            entry_cnt += this.executeBatchInserts(tableentry.getTableName(), ++insertCount, false);
            insertCount = 0;
        }
        catch (SQLException e) {
            if (insertCount != 0) {
                entry_cnt += this.executeBatchInserts(tableentry.getTableName(), insertCount, false);
            }
            throw e;
        }
        this.stmt.close();
        return entry_cnt;
    }

    public int t_delete(TableEntry tableentry) throws SQLException {
        int retval = 0;
        this.buildDeleteStatement(tableentry);
        if (this.stmt != null) {
            int fieldindex = 0;
            this.setFieldHandler2(tableentry);
            TableDescription tabledescription = TableDescriptionFactory.getInstance().getTableDescription(this.con, tableentry.getTableNameQuoted());
            int i = 0;
            while (i < tableentry.getFieldCount()) {
                if (tabledescription.getFieldIndex(tableentry.getFieldName(i)) >= 0) {
                    this.FieldList[fieldindex].setValue(this.stmt, fieldindex + 1, tableentry.getFieldValue(i));
                    ++fieldindex;
                }
                ++i;
            }
            retval = this.stmt.executeUpdate();
            this.stmt.close();
        }
        return retval;
    }

    public int t_display(Selection selection, JarSL jarsl) throws IOException {
        Vector errortexts = new Vector(0);
        if (!jarsl.openSingleArchiveFile(selection.getJarEntryName(false), errortexts)) {
            throw new IOException("Error during reading table description " + selection.getJarEntryName(false) + ": " + this.concatenate_texts(errortexts) + ".");
        }
        int ll = jarsl.getIntData();
        byte[] line = new byte[ll];
        jarsl.getData(line, 0, ll);
        StringTokenizer st = new StringTokenizer(new String(line));
        if (0 != st.nextToken().compareTo(selection.getTableName())) {
            throw new IOException();
        }
        int fieldcount = new Integer(st.nextToken());
        int i = 0;
        while (i < fieldcount) {
            selection.addField(st.nextToken(), new Integer(st.nextToken()));
            ++i;
        }
        jarsl.closeSingleArchiveFile(null);
        if (!jarsl.openSingleArchiveFile(selection.getJarEntryName(true), errortexts)) {
            throw new IOException("Error during reading table data " + selection.getJarEntryName(true) + ": " + this.concatenate_texts(errortexts) + ".");
        }
        int entry_cnt = 0;
        try {
            try {
                this.setFieldHandler2(selection);
                while (true) {
                    i = 0;
                    while (i < selection.getFieldCount()) {
                        String value = this.FieldList[i].readValue(jarsl);
                        this.logging.message(selection.getTableName() + "." + this.FieldList[i].name + " (type=" + this.FieldList[i].type + ")" + ": '" + value + "'");
                        ++i;
                    }
                    this.logging.message("");
                    ++entry_cnt;
                }
            }
            catch (EOFException e) {
                if (i != 0) {
                    this.logging.message("error: unexpected EOFException " + e.getMessage() + " at field " + selection.getFieldName(i));
                }
                Object var13_12 = null;
                jarsl.closeSingleArchiveFile(null);
            }
            catch (Exception e) {
                this.logging.message("error: unexpected Exception " + e.getMessage());
                Object var13_13 = null;
                jarsl.closeSingleArchiveFile(null);
            }
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            jarsl.closeSingleArchiveFile(null);
            throw throwable;
        }
        return entry_cnt;
    }

    public String commit(boolean really) throws SQLException {
        if (this.testmode) {
            if (really) {
                this.con.rollback();
                return "rollback executed";
            }
            return "rollback suppressed";
        }
        this.con.commit();
        return "commit executed";
    }

    private boolean setFieldHandler(Selection selection) throws SQLException {
        boolean batchinsert_is_possible = true;
        TableDescription tabledescription = TableDescriptionFactory.getInstance().getTableDescription(this.con, selection.getTableNameQuoted());
        this.FieldList = new FieldHandler[tabledescription.getFieldCount()];
        int i = 0;
        while (i < tabledescription.getFieldCount()) {
            this.FieldList[i] = new NullHandler(tabledescription.getFieldDescription(i).getName(), tabledescription.getFieldDescription(i).getType());
            ++i;
        }
        int i2 = 0;
        while (i2 < selection.getFieldCount()) {
            int fieldindex = tabledescription.getFieldIndex(selection.getFieldName(i2));
            if (fieldindex < 0) {
                this.logging.message("missing field " + selection.getTableName() + "." + selection.getFieldName(i2));
            } else {
                int fieldtype = selection.getFieldType(i2);
                int fieldtype2 = tabledescription.getFieldDescription(fieldindex).getType();
                boolean already_assigned = false;
                boolean bereadyforoldfile = false;
                if (fieldtype == 2004 || fieldtype == 2005) {
                    bereadyforoldfile = true;
                }
                if (fieldtype != fieldtype2) {
                    switch (fieldtype) {
                        case 2: 
                        case 3: {
                            if (fieldtype2 == -5) {
                                this.FieldList[fieldindex] = new BigIntHandlerNumeric(selection.getFieldName(i2));
                                already_assigned = true;
                            }
                            if (fieldtype2 == 4) {
                                this.FieldList[fieldindex] = new IntegerHandlerNumeric(selection.getFieldName(i2));
                                already_assigned = true;
                            }
                            if (fieldtype2 == 5) {
                                this.FieldList[fieldindex] = new SmallIntHandlerNumeric(selection.getFieldName(i2));
                                already_assigned = true;
                            }
                            if (fieldtype2 != 3 && fieldtype2 != 2) break;
                            fieldtype = fieldtype2;
                            break;
                        }
                        case -5: {
                            if (fieldtype2 == 3) {
                                this.FieldList[fieldindex] = new DecimalHandlerBigInt(selection.getFieldName(i2));
                                already_assigned = true;
                            }
                            if (fieldtype2 != 2) break;
                            this.FieldList[fieldindex] = new NumericHandlerBigInt(selection.getFieldName(i2));
                            already_assigned = true;
                            break;
                        }
                        case 4: {
                            if (fieldtype2 == 3) {
                                this.FieldList[fieldindex] = new DecimalHandlerInteger(selection.getFieldName(i2));
                                already_assigned = true;
                            }
                            if (fieldtype2 != 2) break;
                            this.FieldList[fieldindex] = new NumericHandlerInteger(selection.getFieldName(i2));
                            already_assigned = true;
                            break;
                        }
                        case 5: {
                            if (fieldtype2 == 3) {
                                this.FieldList[fieldindex] = new DecimalHandlerSmallInt(selection.getFieldName(i2));
                                already_assigned = true;
                            }
                            if (fieldtype2 != 2) break;
                            this.FieldList[fieldindex] = new NumericHandlerSmallInt(selection.getFieldName(i2));
                            already_assigned = true;
                            break;
                        }
                        case 8: {
                            if (fieldtype2 == 3) {
                                this.FieldList[fieldindex] = new DecimalHandlerDouble(selection.getFieldName(i2));
                                already_assigned = true;
                            }
                            if (fieldtype2 == 2) {
                                this.FieldList[fieldindex] = new NumericHandlerDouble(selection.getFieldName(i2));
                                already_assigned = true;
                            }
                            if (fieldtype2 != 6) break;
                            fieldtype = fieldtype2;
                            break;
                        }
                        case 6: {
                            if (fieldtype2 == 3) {
                                this.FieldList[fieldindex] = new DecimalHandlerFloat(selection.getFieldName(i2));
                                already_assigned = true;
                            }
                            if (fieldtype2 == 2) {
                                this.FieldList[fieldindex] = new NumericHandlerFloat(selection.getFieldName(i2));
                                already_assigned = true;
                            }
                            if (fieldtype2 != 8) break;
                            fieldtype = fieldtype2;
                            break;
                        }
                        case -1: 
                        case 12: 
                        case 2005: {
                            if (fieldtype2 != 2005 && fieldtype2 != 12 && fieldtype2 != -1) break;
                            fieldtype = fieldtype2;
                            break;
                        }
                        case -4: 
                        case -3: 
                        case -2: 
                        case 2004: {
                            if (fieldtype2 != 2004 && fieldtype2 != -2 && fieldtype2 != -3 && fieldtype2 != -4) break;
                            fieldtype = fieldtype2;
                            break;
                        }
                        case 91: 
                        case 92: 
                        case 93: {
                            if (fieldtype2 != 93 && fieldtype2 != 91 && fieldtype2 != 92) break;
                            fieldtype = fieldtype2;
                            break;
                        }
                    }
                    if (fieldtype != fieldtype2 && !already_assigned) {
                        throw new SQLException("SQL type " + fieldtype + " can not be casted to SQL type " + fieldtype2 + " (table " + selection.getTableName() + ", column " + selection.getFieldName(i2) + ")");
                    }
                }
                if (!already_assigned) {
                    switch (fieldtype) {
                        case 1: {
                            this.FieldList[fieldindex] = new CharHandler(selection.getFieldName(i2));
                            break;
                        }
                        case 12: {
                            this.FieldList[fieldindex] = new VarcharHandler(selection.getFieldName(i2));
                            break;
                        }
                        case -1: {
                            this.FieldList[fieldindex] = new LongvarcharHandler(selection.getFieldName(i2));
                            break;
                        }
                        case -6: {
                            this.FieldList[fieldindex] = new TinyIntHandler(selection.getFieldName(i2));
                            break;
                        }
                        case 5: {
                            this.FieldList[fieldindex] = new SmallIntHandler(selection.getFieldName(i2));
                            break;
                        }
                        case 4: {
                            this.FieldList[fieldindex] = new IntegerHandler(selection.getFieldName(i2));
                            break;
                        }
                        case -5: {
                            this.FieldList[fieldindex] = new BigIntHandler(selection.getFieldName(i2));
                            break;
                        }
                        case 7: {
                            this.FieldList[fieldindex] = new RealHandler(selection.getFieldName(i2));
                            break;
                        }
                        case 6: {
                            this.FieldList[fieldindex] = new FloatHandler(selection.getFieldName(i2));
                            break;
                        }
                        case 8: {
                            this.FieldList[fieldindex] = new DoubleHandler(selection.getFieldName(i2));
                            break;
                        }
                        case 3: {
                            this.FieldList[fieldindex] = new DecimalHandler(selection.getFieldName(i2));
                            break;
                        }
                        case 2: {
                            this.FieldList[fieldindex] = new NumericHandler(selection.getFieldName(i2));
                            break;
                        }
                        case -7: {
                            this.FieldList[fieldindex] = new BitHandler(selection.getFieldName(i2));
                            break;
                        }
                        case -2: {
                            this.FieldList[fieldindex] = new BinaryHandler(selection.getFieldName(i2), tabledescription.getFieldDescription(fieldindex).getLength());
                            break;
                        }
                        case -3: {
                            this.FieldList[fieldindex] = new VarbinaryHandler(selection.getFieldName(i2));
                            break;
                        }
                        case -4: {
                            this.FieldList[fieldindex] = new LongvarbinaryHandler(selection.getFieldName(i2));
                            break;
                        }
                        case 91: {
                            this.FieldList[fieldindex] = new DateHandler(selection.getFieldName(i2));
                            break;
                        }
                        case 92: {
                            this.FieldList[fieldindex] = new TimeHandler(selection.getFieldName(i2));
                            break;
                        }
                        case 93: {
                            this.FieldList[fieldindex] = new TimestampHandler(selection.getFieldName(i2));
                            break;
                        }
                        case 2004: {
                            this.FieldList[fieldindex] = new BlobHandler(selection.getFieldName(i2));
                            batchinsert_is_possible = false;
                            break;
                        }
                        case 2005: {
                            this.FieldList[fieldindex] = new ClobHandler(selection.getFieldName(i2));
                            batchinsert_is_possible = false;
                            break;
                        }
                        case 2003: {
                            this.FieldList[fieldindex] = new ArrayHandler(selection.getFieldName(i2));
                            break;
                        }
                        case 2002: {
                            this.FieldList[fieldindex] = new StructHandler(selection.getFieldName(i2));
                            break;
                        }
                        case 2000: {
                            this.FieldList[fieldindex] = new JavaObjectHandler(selection.getFieldName(i2));
                            break;
                        }
                        default: {
                            throw new SQLException("SQL type " + selection.getFieldType(i2) + " not supported\n" + "(table " + selection.getTableName() + ", column " + selection.getFieldName(i2) + ")");
                        }
                    }
                }
                if (bereadyforoldfile) {
                    this.FieldList[fieldindex].set_bereadyforoldfile();
                }
            }
            ++i2;
        }
        return !batchinsert_is_possible;
    }

    private void setFieldHandler2(Selection selection) throws Exception {
        this.FieldList = new FieldHandler[selection.getFieldCount()];
        int i = 0;
        while (i < selection.getFieldCount()) {
            switch (selection.getFieldType(i)) {
                case 1: {
                    this.FieldList[i] = new CharHandler(selection.getFieldName(i));
                    break;
                }
                case 12: {
                    this.FieldList[i] = new VarcharHandler(selection.getFieldName(i));
                    break;
                }
                case -1: {
                    this.FieldList[i] = new LongvarcharHandler(selection.getFieldName(i));
                    break;
                }
                case -6: {
                    this.FieldList[i] = new TinyIntHandler(selection.getFieldName(i));
                    break;
                }
                case 5: {
                    this.FieldList[i] = new SmallIntHandler(selection.getFieldName(i));
                    break;
                }
                case 4: {
                    this.FieldList[i] = new IntegerHandler(selection.getFieldName(i));
                    break;
                }
                case -5: {
                    this.FieldList[i] = new BigIntHandler(selection.getFieldName(i));
                    break;
                }
                case 7: {
                    this.FieldList[i] = new RealHandler(selection.getFieldName(i));
                    break;
                }
                case 6: {
                    this.FieldList[i] = new FloatHandler(selection.getFieldName(i));
                    break;
                }
                case 8: {
                    this.FieldList[i] = new DoubleHandler(selection.getFieldName(i));
                    break;
                }
                case 3: {
                    this.FieldList[i] = new DecimalHandler(selection.getFieldName(i));
                    break;
                }
                case 2: {
                    this.FieldList[i] = new NumericHandler(selection.getFieldName(i));
                    break;
                }
                case -7: {
                    this.FieldList[i] = new BitHandler(selection.getFieldName(i));
                    break;
                }
                case -2: {
                    this.FieldList[i] = new BinaryHandler(selection.getFieldName(i));
                    break;
                }
                case -3: {
                    this.FieldList[i] = new VarbinaryHandler(selection.getFieldName(i));
                    break;
                }
                case -4: {
                    this.FieldList[i] = new LongvarbinaryHandler(selection.getFieldName(i));
                    break;
                }
                case 91: {
                    this.FieldList[i] = new DateHandler(selection.getFieldName(i));
                    break;
                }
                case 92: {
                    this.FieldList[i] = new TimeHandler(selection.getFieldName(i));
                    break;
                }
                case 93: {
                    this.FieldList[i] = new TimestampHandler(selection.getFieldName(i));
                    break;
                }
                case 2004: {
                    this.FieldList[i] = new BlobHandler(selection.getFieldName(i));
                    break;
                }
                case 2005: {
                    this.FieldList[i] = new ClobHandler(selection.getFieldName(i));
                    break;
                }
                case 2003: {
                    this.FieldList[i] = new ArrayHandler(selection.getFieldName(i));
                    break;
                }
                case 2002: {
                    this.FieldList[i] = new StructHandler(selection.getFieldName(i));
                    break;
                }
                case 2000: {
                    this.FieldList[i] = new JavaObjectHandler(selection.getFieldName(i));
                    break;
                }
                default: {
                    throw new Exception("SQL type " + selection.getFieldType(i) + " not supported\n" + "(table " + selection.getTableName() + ", column " + selection.getFieldName(i) + ")");
                }
            }
            if (selection.getFieldType(i) == 2004 || selection.getFieldType(i) == 2005) {
                this.FieldList[i].set_bereadyforoldfile();
            }
            ++i;
        }
    }

    private boolean setFieldHandler(TableEntry tableentry) throws SQLException {
        return this.setFieldHandler(TableDescriptionFactory.getInstance().getTableDescription(this.con, tableentry.getTableNameQuoted()));
    }

    private boolean setFieldHandler(TableDescription tabledescription) throws SQLException {
        boolean batchinsert_is_possible = true;
        this.FieldList = new FieldHandler[tabledescription.getFieldCount()];
        int i = 0;
        while (i < tabledescription.getFieldCount()) {
            switch (tabledescription.getFieldDescription(i).getType()) {
                case 1: {
                    this.FieldList[i] = new CharHandler(tabledescription.getFieldDescription(i).getName());
                    break;
                }
                case 12: {
                    this.FieldList[i] = new VarcharHandler(tabledescription.getFieldDescription(i).getName());
                    break;
                }
                case -1: {
                    this.FieldList[i] = new LongvarcharHandler(tabledescription.getFieldDescription(i).getName());
                    break;
                }
                case -6: {
                    this.FieldList[i] = new TinyIntHandler(tabledescription.getFieldDescription(i).getName());
                    break;
                }
                case 5: {
                    this.FieldList[i] = new SmallIntHandler(tabledescription.getFieldDescription(i).getName());
                    break;
                }
                case 4: {
                    this.FieldList[i] = new IntegerHandler(tabledescription.getFieldDescription(i).getName());
                    break;
                }
                case -5: {
                    this.FieldList[i] = new BigIntHandler(tabledescription.getFieldDescription(i).getName());
                    break;
                }
                case 7: {
                    this.FieldList[i] = new RealHandler(tabledescription.getFieldDescription(i).getName());
                    break;
                }
                case 6: {
                    this.FieldList[i] = new FloatHandler(tabledescription.getFieldDescription(i).getName());
                    break;
                }
                case 8: {
                    this.FieldList[i] = new DoubleHandler(tabledescription.getFieldDescription(i).getName());
                    break;
                }
                case 3: {
                    this.FieldList[i] = new DecimalHandler(tabledescription.getFieldDescription(i).getName());
                    break;
                }
                case 2: {
                    this.FieldList[i] = new NumericHandler(tabledescription.getFieldDescription(i).getName());
                    break;
                }
                case -7: {
                    this.FieldList[i] = new BitHandler(tabledescription.getFieldDescription(i).getName());
                    break;
                }
                case -2: {
                    this.FieldList[i] = new BinaryHandler(tabledescription.getFieldDescription(i).getName(), tabledescription.getFieldDescription(i).getLength());
                    break;
                }
                case -3: {
                    this.FieldList[i] = new VarbinaryHandler(tabledescription.getFieldDescription(i).getName());
                    break;
                }
                case -4: {
                    this.FieldList[i] = new LongvarbinaryHandler(tabledescription.getFieldDescription(i).getName());
                    break;
                }
                case 91: {
                    this.FieldList[i] = new DateHandler(tabledescription.getFieldDescription(i).getName());
                    break;
                }
                case 92: {
                    this.FieldList[i] = new TimeHandler(tabledescription.getFieldDescription(i).getName());
                    break;
                }
                case 93: {
                    this.FieldList[i] = new TimestampHandler(tabledescription.getFieldDescription(i).getName());
                    break;
                }
                case 2004: {
                    this.FieldList[i] = new BlobHandler(tabledescription.getFieldDescription(i).getName());
                    batchinsert_is_possible = false;
                    break;
                }
                case 2005: {
                    this.FieldList[i] = new ClobHandler(tabledescription.getFieldDescription(i).getName());
                    batchinsert_is_possible = false;
                    break;
                }
                case 2003: {
                    this.FieldList[i] = new ArrayHandler(tabledescription.getFieldDescription(i).getName());
                    break;
                }
                case 2002: {
                    this.FieldList[i] = new StructHandler(tabledescription.getFieldDescription(i).getName());
                    break;
                }
                case 2000: {
                    this.FieldList[i] = new JavaObjectHandler(tabledescription.getFieldDescription(i).getName());
                    break;
                }
                default: {
                    throw new SQLException("SQL type " + tabledescription.getFieldDescription(i).getType() + " not supported\n" + "(table " + tabledescription.getName() + ", column " + tabledescription.getFieldDescription(i).getName() + ")");
                }
            }
            ++i;
        }
        return !batchinsert_is_possible;
    }

    private void setFieldHandler2(TableEntry tableentry) throws SQLException {
        TableDescription tabledescription = TableDescriptionFactory.getInstance().getTableDescription(this.con, tableentry.getTableNameQuoted());
        this.FieldList = new FieldHandler[tableentry.getFieldCount()];
        int i = 0;
        while (i < tableentry.getFieldCount()) {
            int fieldindex = tabledescription.getFieldIndex(tableentry.getFieldName(i));
            if (fieldindex >= 0) {
                switch (tabledescription.getFieldDescription(fieldindex).getType()) {
                    case 1: {
                        this.FieldList[i] = new CharHandler(tabledescription.getFieldDescription(fieldindex).getName());
                        break;
                    }
                    case 12: {
                        this.FieldList[i] = new VarcharHandler(tabledescription.getFieldDescription(fieldindex).getName());
                        break;
                    }
                    case -1: {
                        this.FieldList[i] = new LongvarcharHandler(tabledescription.getFieldDescription(fieldindex).getName());
                        break;
                    }
                    case -6: {
                        this.FieldList[i] = new TinyIntHandler(tabledescription.getFieldDescription(fieldindex).getName());
                        break;
                    }
                    case 5: {
                        this.FieldList[i] = new SmallIntHandler(tabledescription.getFieldDescription(fieldindex).getName());
                        break;
                    }
                    case 4: {
                        this.FieldList[i] = new IntegerHandler(tabledescription.getFieldDescription(fieldindex).getName());
                        break;
                    }
                    case -5: {
                        this.FieldList[i] = new BigIntHandler(tabledescription.getFieldDescription(fieldindex).getName());
                        break;
                    }
                    case 7: {
                        this.FieldList[i] = new RealHandler(tabledescription.getFieldDescription(fieldindex).getName());
                        break;
                    }
                    case 6: {
                        this.FieldList[i] = new FloatHandler(tabledescription.getFieldDescription(fieldindex).getName());
                        break;
                    }
                    case 8: {
                        this.FieldList[i] = new DoubleHandler(tabledescription.getFieldDescription(fieldindex).getName());
                        break;
                    }
                    case 3: {
                        this.FieldList[i] = new DecimalHandler(tabledescription.getFieldDescription(fieldindex).getName());
                        break;
                    }
                    case 2: {
                        this.FieldList[i] = new NumericHandler(tabledescription.getFieldDescription(fieldindex).getName());
                        break;
                    }
                    case -7: {
                        this.FieldList[i] = new BitHandler(tabledescription.getFieldDescription(fieldindex).getName());
                        break;
                    }
                    case -2: {
                        this.FieldList[i] = new BinaryHandler(tabledescription.getFieldDescription(fieldindex).getName());
                        break;
                    }
                    case -3: {
                        this.FieldList[i] = new VarbinaryHandler(tabledescription.getFieldDescription(fieldindex).getName());
                        break;
                    }
                    case -4: {
                        this.FieldList[i] = new LongvarbinaryHandler(tabledescription.getFieldDescription(fieldindex).getName());
                        break;
                    }
                    case 91: {
                        this.FieldList[i] = new DateHandler(tabledescription.getFieldDescription(fieldindex).getName());
                        break;
                    }
                    case 92: {
                        this.FieldList[i] = new TimeHandler(tabledescription.getFieldDescription(fieldindex).getName());
                        break;
                    }
                    case 93: {
                        this.FieldList[i] = new TimestampHandler(tabledescription.getFieldDescription(fieldindex).getName());
                        break;
                    }
                    case 2004: {
                        this.FieldList[i] = new BlobHandler(tabledescription.getFieldDescription(fieldindex).getName());
                        break;
                    }
                    case 2005: {
                        this.FieldList[i] = new ClobHandler(tabledescription.getFieldDescription(fieldindex).getName());
                        break;
                    }
                    case 2003: {
                        this.FieldList[i] = new ArrayHandler(tabledescription.getFieldDescription(fieldindex).getName());
                        break;
                    }
                    case 2002: {
                        this.FieldList[i] = new StructHandler(tabledescription.getFieldDescription(fieldindex).getName());
                        break;
                    }
                    case 2000: {
                        this.FieldList[i] = new JavaObjectHandler(tabledescription.getFieldDescription(fieldindex).getName());
                        break;
                    }
                    default: {
                        throw new SQLException("SQL type " + tabledescription.getFieldDescription(fieldindex).getType() + " not supported\n" + "(table " + tabledescription.getName() + ", column " + tabledescription.getFieldDescription(fieldindex).getName() + ")");
                    }
                }
                if (tabledescription.getFieldDescription(fieldindex).getLength() > 0 && tabledescription.getFieldDescription(fieldindex).getLength() < tableentry.getFieldValue(i).length()) {
                    String newval = tableentry.getFieldValue(i).substring(0, tabledescription.getFieldDescription(fieldindex).getLength());
                    tableentry.setValue(new NameValuePair(tableentry.getFieldName(i), newval));
                }
            }
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int executeBatchInserts(String tabname, int insertCount, boolean batch_it) throws SQLException {
        counters = new int[insertCount];
        retval = 0;
        try {
            if (!batch_it) {
                counters[0] = this.stmt.executeUpdate();
            } else {
                counters = this.stmt.executeBatch();
            }
            if (this.testmode != false) return insertCount;
            this.commit(false);
            return insertCount;
        }
        catch (SQLException e) {
            if (e.getErrorCode() != 1 && e.getErrorCode() != 200 && e.getErrorCode() != 2627) {
                if (e.getErrorCode() != -803) throw e;
            }
            if (this.allow_update == false) return retval;
            i = 0;
            ** while (i < insertCount)
        }
lbl-1000:
        // 1 sources

        {
            if (counters[i] != 1) {
                ++this.duplicate_cnt;
            } else {
                ++retval;
            }
            ++i;
            continue;
        }
lbl24:
        // 1 sources

        return retval;
    }

    private String concatenate_texts(Vector textvector) {
        String resulttext = "";
        Iterator it = ((AbstractList)textvector).iterator();
        while (it.hasNext()) {
            resulttext = resulttext + " " + (String)it.next();
        }
        return resulttext;
    }
}

