/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.util.dbaccess;

import java.util.ArrayList;

public class Selection {
    private String id;
    private String name;
    private ArrayList field = new ArrayList();
    private String where = null;

    public Selection(String id, String name) {
        this.id = id;
        this.name = name;
    }

    public Selection(String id, String name, String where) {
        this.id = id;
        this.name = name;
        this.where = where;
    }

    public String getId() {
        return this.id;
    }

    public String getTableName() {
        return this.name;
    }

    public String getTableNameQuoted() {
        return "\"" + this.name.toUpperCase() + "\"";
    }

    public String getWhereCond() {
        return this.where;
    }

    public int getFieldCount() {
        return this.field.size();
    }

    public void resetFields() {
        this.field.clear();
    }

    public void addField(String name) {
        this.field.add(new jdbcField(name));
    }

    public void addField(String name, int type) {
        this.field.add(new jdbcField(name, type));
    }

    public String getFieldName(int index) throws IndexOutOfBoundsException {
        jdbcField jf = (jdbcField)this.field.get(index);
        return jf.name;
    }

    public String getFieldNameQuoted(int index) throws IndexOutOfBoundsException {
        jdbcField jf = (jdbcField)this.field.get(index);
        return "\"" + jf.name.toUpperCase() + "\"";
    }

    public int getFieldType(int index) throws IndexOutOfBoundsException {
        jdbcField jf = (jdbcField)this.field.get(index);
        return jf.type;
    }

    public String getJarEntryName(boolean dataentry) {
        if (dataentry) {
            return this.getId() + "_" + this.getTableName() + ".dat";
        }
        return this.getId() + "_" + this.getTableName() + ".txt";
    }

    private class jdbcField {
        String name;
        int type;

        jdbcField(String name) {
            this.name = name;
            this.type = 0;
        }

        jdbcField(String name, int type) {
            this.name = name;
            this.type = type;
        }
    }
}

