/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.util.dbaccess;

import com.sap.sdm.util.dbaccess.DBTask;
import com.sap.sdm.util.dbaccess.DBTaskLogger;
import com.sap.sdm.util.dbaccess.SapTransVersion;
import com.sap.sdm.util.init.UtilInitializer;
import com.sap.sdm.util.jarsl.JarSL;
import java.io.FileReader;
import java.io.IOException;
import java.sql.SQLException;
import java.util.StringTokenizer;

public class SapTransTask {
    private String command = "unknown";
    private String logfile = "trans.log";
    private String datafile = "transdat.zip";
    private String selectfile = "select.xml";
    private String connectstring = "";
    private String dbdriver = null;
    private String dburl = null;
    private String dbuser = null;
    private String dbpassword = null;
    private String classpath = null;
    private boolean testmode = false;
    private String rootdir = "c:\\temp";

    public SapTransTask(String[] args) {
        String errortext = this.analyze_arguments(args);
        if (errortext != null) {
            this.print_usage(errortext);
            System.exit(8);
        }
    }

    public void execute() {
        if (this.command.equalsIgnoreCase("export")) {
            this.perform_export();
        } else if (this.command.equalsIgnoreCase("import")) {
            this.perform_import();
        } else if (this.command.equalsIgnoreCase("display")) {
            this.perform_display();
        } else {
            this.print_usage("unknown command");
        }
    }

    private String analyze_arguments(String[] args) {
        if (args.length < 1) {
            return "call without parameters";
        }
        if (!(args[0].equalsIgnoreCase("export") || args[0].equalsIgnoreCase("import") || args[0].equalsIgnoreCase("display"))) {
            if (args[0].equalsIgnoreCase("help")) {
                return "";
            }
            return "illegal command";
        }
        this.command = args[0];
        int i = 1;
        while (i < args.length) {
            if (args[i].toLowerCase().startsWith("logfile=")) {
                this.logfile = args[i].substring("logfile=".length());
            } else if (args[i].toLowerCase().startsWith("datafile=")) {
                this.datafile = args[i].substring("datafile=".length());
            } else if (args[i].toLowerCase().startsWith("selectfile=")) {
                this.selectfile = args[i].substring("selectfile=".length());
            } else if (args[i].toLowerCase().startsWith("connectstring=")) {
                this.connectstring = args[i].substring("connectstring=".length());
            } else if (args[i].toLowerCase().startsWith("testmode=")) {
                this.testmode = args[i].substring("testmode=".length()).toLowerCase().startsWith("true") || args[i].substring("testmode=".length()).toLowerCase().startsWith("yes");
            } else {
                return "unknown commandline option '" + args[i] + "'";
            }
            ++i;
        }
        if (this.connectstring != null) {
            StringTokenizer st = new StringTokenizer(this.connectstring, ";");
            if (st.hasMoreTokens()) {
                this.dbdriver = st.nextToken();
            }
            if (st.hasMoreTokens()) {
                this.dburl = st.nextToken();
            }
            if (st.hasMoreTokens()) {
                this.dbuser = st.nextToken();
            }
            if (st.hasMoreTokens()) {
                this.dbpassword = st.nextToken();
            }
            if (st.hasMoreTokens()) {
                this.classpath = st.nextToken();
            }
        }
        return null;
    }

    private void print_usage(String message) {
        if (message != null) {
            System.out.println(message);
        }
        System.out.println("usage: SapTrans export|import|display (options)");
        System.out.println("possible options are:");
        System.out.println("  logfile=<filename>     (optional, default = '" + this.logfile + "')");
        System.out.println("  datafile=<filename>    (optional, default = '" + this.datafile + "')");
        System.out.println("  selectfile=<filename>  (optional, default = '" + this.selectfile + "')");
        System.out.println("  connectstring=<string> (mandatory: <dbdriver>;<dburl>;<dbuser>;<dbuserpassword>[;<driverpath>])");
        System.out.println("  testmode=true|false");
        System.exit(0);
    }

    private void perform_export() {
        int rc = 12;
        String rc_text = "";
        DBTask dbtask = null;
        try {
            UtilInitializer.initializeWithSimpleLog();
        }
        catch (Exception e) {
            rc_text = "Error when initializing the SAP logging";
            rc = 12;
            e.printStackTrace();
        }
        try {
            dbtask = this.createConnection();
        }
        catch (SQLException e) {
            rc_text = this.connectstring.equals("") ? "no database connection possible - no connectstring specified" : "SQLException when creating the database connection to " + this.connectstring + ": " + e.getMessage();
            rc = 12;
            e.printStackTrace();
        }
        catch (RuntimeException e) {
            rc_text = this.connectstring.equals("") ? "no database connection possible - no connectstring specified" : "RuntimeException when creating the database connection to " + this.connectstring + ": " + e.getMessage();
            rc = 12;
            e.printStackTrace();
        }
        catch (Exception e) {
            rc_text = this.connectstring.equals("") ? "no database connection possible - no connectstring specified" : "Exception when creating the database connection to " + this.connectstring + ": " + e.getMessage();
            rc = 12;
            e.printStackTrace();
        }
        try {
            FileReader s = new FileReader(this.selectfile);
        }
        catch (Exception e) {
            rc_text = "can't open selectfile " + this.selectfile;
            rc = 12;
            dbtask = null;
            e.printStackTrace();
        }
        if (dbtask != null) {
            JarSL jarsl = new JarSL(this.datafile, this.rootdir);
            try {
                dbtask.useLogger(this.logfile);
                if (dbtask.dbExport(this.selectfile, jarsl)) {
                    rc = 0;
                    rc_text = "export finished successfully";
                    if (!jarsl.create(true, false, true, null)) {
                        rc = 12;
                        rc_text = "export failed - archive " + this.datafile + " couldn't be created";
                    }
                } else {
                    rc = 8;
                    rc_text = "export finished with errors";
                }
            }
            catch (Exception e) {
                rc = 12;
                rc_text = "export aborted " + e.getMessage();
                e.printStackTrace();
            }
        }
        this.closelogandexit(rc_text, rc);
    }

    private void perform_import() {
        int rc = 12;
        String rc_text = "";
        DBTask dbtask = null;
        try {
            UtilInitializer.initializeWithSimpleLog();
        }
        catch (Exception e) {
            rc_text = "Error when initializing the SAP logging";
            rc = 12;
        }
        try {
            dbtask = this.createConnection();
        }
        catch (SQLException e) {
            rc_text = this.connectstring.equals("") ? "no database connection possible - no connectstring specified" : "SQLException when creating the database connection to " + this.connectstring + ": " + e.getMessage();
            rc = 12;
            e.printStackTrace();
        }
        catch (RuntimeException e) {
            rc_text = this.connectstring.equals("") ? "no database connection possible - no connectstring specified" : "RuntimeException when creating the database connection to " + this.connectstring + ": " + e.getMessage();
            rc = 12;
            e.printStackTrace();
        }
        catch (Exception e) {
            rc_text = "Exception when creating the database connection: ";
            rc = 12;
            e.printStackTrace();
        }
        if (dbtask != null) {
            try {
                dbtask.useLogger(this.logfile);
                dbtask.setImportMode(0);
                dbtask.setTestMode(this.testmode);
                if (dbtask.dbImport(this.datafile)) {
                    rc = 0;
                    rc_text = "import finished successfully";
                } else {
                    rc = 12;
                    rc_text = "import finished with errors";
                }
            }
            catch (Exception e) {
                rc = 12;
                rc_text = "import aborted with " + e.getClass().getName() + ": " + e.getMessage();
                e.printStackTrace();
            }
        }
        this.closelogandexit(rc_text, rc);
    }

    private void perform_display() {
        int rc = 12;
        String rc_text = "";
        DBTask dbtask = null;
        try {
            UtilInitializer.initializeWithSimpleLog();
        }
        catch (Exception e) {
            rc_text = "Error when initializing the SAP logging";
            rc = 12;
        }
        try {
            dbtask = this.createDisplayTask();
        }
        catch (IOException e) {
            rc = 12;
            rc_text = "display aborted with " + e.getClass().getName() + ": " + e.getMessage();
            e.printStackTrace();
        }
        if (dbtask != null) {
            try {
                dbtask.useLogger(this.logfile);
                if (dbtask.display(this.datafile)) {
                    rc = 0;
                    rc_text = "display finished successfully";
                } else {
                    rc = 12;
                    rc_text = "display finished with errors";
                }
            }
            catch (Exception e) {
                rc = 12;
                rc_text = "display aborted with " + e.getClass().getName() + ": " + e.getMessage();
                e.printStackTrace();
            }
        }
        this.closelogandexit(rc_text, rc);
    }

    private DBTask createConnection() throws Exception {
        DBTask dbtask = null;
        DBTaskLogger mylogger = new DBTaskLogger(this.logfile, false);
        mylogger.message(new SapTransVersion().getSapTransVersion());
        mylogger.message(new SapTransVersion().getSourceId());
        mylogger.message("connecting to database:");
        if (this.dbdriver != null) {
            mylogger.message("dbdriver   = " + this.dbdriver);
        } else {
            mylogger.message("dbdriver   = null");
        }
        if (this.dburl != null) {
            mylogger.message("dburl      = " + this.dburl);
        } else {
            mylogger.message("dburl      = null");
        }
        if (this.dbuser != null) {
            mylogger.message("dbuser     = " + this.dbuser);
        } else {
            mylogger.message("dbuser     = null");
        }
        if (this.dbpassword != null) {
            mylogger.message("dbpassword = " + "********************".substring(0, this.dbpassword.length()));
        } else {
            mylogger.message("dbpassword = null");
        }
        if (this.classpath != null) {
            mylogger.message("classpath  = " + this.classpath);
        } else {
            mylogger.message("classpath  = null");
        }
        mylogger.close();
        dbtask = new DBTask(this.dbdriver, this.dburl, this.dbuser, this.dbpassword);
        dbtask.useLogger(false);
        return dbtask;
    }

    private DBTask createDisplayTask() throws IOException {
        DBTask dbtask = null;
        DBTaskLogger mylogger = new DBTaskLogger(this.logfile, false);
        mylogger.message(new SapTransVersion().getSapTransVersion());
        mylogger.message(new SapTransVersion().getSourceId());
        dbtask = new DBTask(null);
        dbtask.useLogger(false);
        return dbtask;
    }

    private void closelogandexit(String rc_text, int rc) {
        try {
            DBTaskLogger mylogger = new DBTaskLogger(this.logfile, true);
            if (rc == 12) {
                mylogger.message("ERROR: " + rc_text);
            } else {
                mylogger.message(rc_text);
            }
            mylogger.message("exit code " + rc);
            mylogger.close();
        }
        catch (IOException e) {
            rc = 12;
            rc_text = "can't write to " + this.logfile;
        }
        System.out.println(rc_text);
        System.exit(rc);
    }
}

