/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.util.dbaccess;

import com.sap.sdm.util.dbaccess.FieldHandler;
import com.sap.sdm.util.jarsl.JarSL;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

class NumericHandler
extends FieldHandler {
    NumericHandler(String name) {
        super(name, 2);
    }

    NumericHandler(String name, int type) {
        super(name, type);
    }

    void setValue(PreparedStatement stmt, int columnNumber, JarSL jarsl) throws IOException, SQLException {
        int len = jarsl.getIntData();
        if (len <= 0) {
            this.initialize(stmt, columnNumber);
        } else {
            char[] buffer = new char[len];
            int i = 0;
            while (i < len) {
                buffer[i] = jarsl.getCharData();
                ++i;
            }
            try {
                stmt.setBigDecimal(columnNumber, new BigDecimal(new String(buffer)));
            }
            catch (RuntimeException e) {
                System.out.println(new String(buffer).toString() + "can't be converted to BigDecimal");
                stmt.setBigDecimal(columnNumber, new BigDecimal(0.0));
            }
        }
    }

    String readValue(JarSL jarsl) throws IOException {
        int len = jarsl.getIntData();
        if (len < 0) {
            return "<NULL>";
        }
        char[] buffer = new char[len];
        int i = 0;
        while (i < len) {
            buffer[i] = jarsl.getCharData();
            ++i;
        }
        return new BigDecimal(new String(buffer)).toString();
    }

    void setValue(PreparedStatement stmt, int columnNumber, String value) throws SQLException {
        stmt.setBigDecimal(columnNumber, new BigDecimal(value));
    }

    void initialize(PreparedStatement stmt, int columnNumber) throws SQLException {
        stmt.setNull(columnNumber, this.type);
    }

    String getValue(ResultSet rs, int columnNumber) throws SQLException {
        return rs.getBigDecimal(columnNumber).toString();
    }

    void writeValue(ResultSet rs, int columnNumber, JarSL jarsl) throws IOException, SQLException {
        BigDecimal big = rs.getBigDecimal(columnNumber);
        if (big == null) {
            jarsl.putIntData(-1);
        } else {
            String s = big.toString();
            if (s.length() == 0) {
                s = "0";
            }
            jarsl.putIntData(s.length());
            jarsl.putCharsData(s);
        }
    }

    void set_bereadyforoldfile() {
        this.bereadyforoldfile = true;
    }
}

