/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.util.dbaccess;

import com.sap.sdm.util.dbaccess.FieldHandler;
import com.sap.sdm.util.jarsl.JarSL;
import java.io.IOException;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.TimeZone;

class DateHandler
extends FieldHandler {
    DateHandler(String name) {
        super(name, 91);
    }

    void setValue(PreparedStatement stmt, int columnNumber, JarSL jarsl) throws IOException, SQLException {
        long l = jarsl.getLongData();
        if (l == -1L) {
            this.initialize(stmt, columnNumber);
        } else {
            stmt.setDate(columnNumber, this.createDate(l));
        }
    }

    String readValue(JarSL jarsl) throws IOException {
        long l = jarsl.getLongData();
        if (l == -1L) {
            return "<NULL>";
        }
        return new Long(l).toString() + " (" + this.createDate(l).toString() + ")";
    }

    void setValue(PreparedStatement stmt, int columnNumber, String value) throws SQLException {
        long l = new Long(value);
        if (l == -1L) {
            this.initialize(stmt, columnNumber);
        } else {
            stmt.setDate(columnNumber, this.createDate(l));
        }
    }

    void initialize(PreparedStatement stmt, int columnNumber) throws SQLException {
        stmt.setNull(columnNumber, this.type);
    }

    long getValue(ResultSet rs, int columnNumber) throws SQLException {
        return rs.getDate(columnNumber).getTime();
    }

    void writeValue(ResultSet rs, int columnNumber, JarSL jarsl) throws IOException, SQLException {
        Date date = rs.getDate(columnNumber, Calendar.getInstance(TimeZone.getTimeZone("GMT")));
        if (date != null) {
            jarsl.putLongData(date.getTime());
        } else {
            jarsl.putLongData(-1L);
        }
    }

    void set_bereadyforoldfile() {
        this.bereadyforoldfile = true;
    }

    private Date createDate(long l) {
        long timezoneoffset = new Date(l).getTimezoneOffset() * 60 * 1000;
        return new Date(l + timezoneoffset);
    }
}

