/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.util.dbaccess;

import com.sap.sdm.util.log.Logger;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

public class DBTaskLogger {
    private boolean useLogger = false;
    private static final Logger logger = Logger.getLogger();
    private PrintWriter logFile = null;

    public DBTaskLogger() {
        this.useLogger = true;
    }

    public DBTaskLogger(String logFileName, boolean append) throws IOException {
        try {
            if (new File(logFileName).getParentFile() != null) {
                new File(logFileName).getParentFile().mkdirs();
            }
            this.logFile = new PrintWriter(new BufferedWriter(new FileWriter(logFileName, append)));
        }
        catch (IOException e) {
            System.err.println("ERROR: Cannot open logfile " + logFileName);
            throw e;
        }
    }

    public void message(String string) {
        if (this.useLogger) {
            if (string.toUpperCase().startsWith("ERROR")) {
                logger.error(string.substring(5));
            } else {
                logger.info(string);
            }
        } else if (this.logFile != null) {
            this.logFile.println(string);
            this.logFile.flush();
        }
    }

    public void message(Exception e) {
        if (this.useLogger) {
            logger.fatal("exception", e);
        } else if (this.logFile != null) {
            e.printStackTrace(this.logFile);
            this.logFile.flush();
        }
    }

    public void close() {
        if (this.logFile != null) {
            this.logFile.flush();
        }
    }
}

