/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.util.dbaccess;

import com.sap.sdm.util.dbaccess.FieldHandler;
import com.sap.sdm.util.dbaccess.FileLengthReader;
import com.sap.sdm.util.jarsl.JarSL;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

class BlobHandler
extends FieldHandler {
    BlobHandler(String name) {
        super(name, 2004);
    }

    void setValue(PreparedStatement stmt, int columnNumber, JarSL jarsl) throws IOException, SQLException {
        int len = this.read_length(jarsl);
        byte[] buffer = new byte[len];
        jarsl.getData(buffer);
        try {
            stmt.setBinaryStream(columnNumber, (InputStream)new ByteArrayInputStream(buffer), buffer.length);
        }
        catch (SQLException e) {
            if (len == 0) {
                this.initialize(stmt, columnNumber);
            }
            throw e;
        }
    }

    String readValue(JarSL jarsl) throws IOException {
        int len = this.read_length(jarsl);
        byte[] buffer = new byte[len];
        jarsl.getData(buffer);
        return "<" + len + " Bytes>";
    }

    void setValue(PreparedStatement stmt, int columnNumber, String value) throws SQLException {
        stmt.setNull(columnNumber, this.type);
        throw new RuntimeException("BlobHandler.setValue() is not implemented");
    }

    void initialize(PreparedStatement stmt, int columnNumber) throws SQLException {
        stmt.setNull(columnNumber, this.type);
    }

    Blob getValue(ResultSet rs, int columnNumber) throws SQLException {
        return rs.getBlob(columnNumber);
    }

    void writeValue(ResultSet rs, int columnNumber, JarSL jarsl) throws IOException, SQLException {
        Blob blob = rs.getBlob(columnNumber);
        long len = blob.length();
        if (len > Integer.MAX_VALUE) {
            throw new IOException("Length " + len + " too large, field " + this.name);
        }
        byte[] buffer = blob.getBytes(1L, (int)len);
        jarsl.putIntData((int)len);
        jarsl.putData(buffer, 0, buffer.length);
    }

    private int read_length(JarSL jarsl) throws IOException {
        return FileLengthReader.getInstance().read_length(jarsl, this.bereadyforoldfile);
    }

    void set_bereadyforoldfile() {
        this.bereadyforoldfile = true;
    }
}

