/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.util.classloaders;

import com.sap.sdm.util.classloaders.ClassLoaderManager;
import com.sap.sdm.util.classloaders.ComponentId;
import com.sap.sdm.util.classloaders.DefaultLibDirFinder;
import com.sap.sdm.util.classloaders.SDMClassLoaderException;
import com.sap.sdm.util.classloaders.impl.ComponentIdImpl;
import com.sap.sdm.util.classloaders.impl.DefaultClassLoadingSystemFactory;

public abstract class ClassLoadingSystemFactory {
    private static ClassLoadingSystemFactory instance = null;

    public static ClassLoadingSystemFactory getInstance() {
        if (instance == null) {
            instance = new DefaultClassLoadingSystemFactory();
        }
        return instance;
    }

    public static ComponentId createComponentId(String descr) {
        return new ComponentIdImpl(descr);
    }

    protected ClassLoadingSystemFactory() {
    }

    public final void registerConfiguration(ComponentId id, ComponentId parentId, String[] localJars) throws SDMClassLoaderException {
        this.registerConfiguration(id, parentId, null, null, null, null, localJars);
    }

    public final void registerConfiguration(ComponentId id, ComponentId parentId, String propName, String libDir, String[] localJars) throws SDMClassLoaderException {
        this.registerConfiguration(id, parentId, null, null, propName, libDir, localJars);
    }

    public abstract ClassLoaderManager getClassLoaderManager();

    public abstract void registerConfiguration(ComponentId var1, ComponentId var2, ComponentId[] var3, ComponentId[] var4, String var5, String var6, String[] var7) throws SDMClassLoaderException;

    public abstract void registerDefaultLibDirFinder(DefaultLibDirFinder var1) throws SDMClassLoaderException;

    protected final void register() {
        if (instance != null) {
            throw new IllegalStateException("Cannot register factory instance twice: Cannot register \"" + this.toString() + "\", since \"" + instance.toString() + "\" is already registered.");
        }
        instance = this;
    }
}

